/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;

public class LongObjectHashMap {
    private static TraceComponent tc = Tr.register(LongObjectHashMap.class, null, null);
    private static final Object DELETED = new Object();
    private Object[] _values;
    private long[] _keys;
    private int _loadFactor;
    private int _mapSize;
    private int _currentLoad;
    private static final int DEFAULT_INITIAL_MAP_SIZE = 256;
    private static final int DEFAULT_LOAD_FACTOR = 60;
    private int _resizeThreshold;

    public LongObjectHashMap() {
        this(256, 60);
    }

    public LongObjectHashMap(int n) throws IllegalArgumentException {
        this(n, 60);
    }

    public LongObjectHashMap(int n, int n2) throws IllegalArgumentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "LongObjectHashMap", new Object[]{new Integer(n), new Integer(n2)});
        }
        if (n2 <= 0 || n2 > 100) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "LongObjectHashMap", "IllegalArgumentException");
            }
            throw new IllegalArgumentException("loadFactor must lie in the range 0 < loadFactor <= 100");
        }
        if (n < 0 || (n & n - 1) != 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "LongObjectHashMap", "IllegalArgumentException");
            }
            throw new IllegalArgumentException("initialSize must be a power of two and greater than zero");
        }
        this._loadFactor = n2;
        this._mapSize = n;
        this._values = new Object[this._mapSize];
        this._keys = new long[this._mapSize];
        this._currentLoad = 0;
        this._resizeThreshold = (int)((float)this._mapSize * (float)this._loadFactor / 100.0f);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "resizeThreshold = " + this._resizeThreshold);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "LongObjectHashMap", this);
        }
    }

    public Object put(long l, Object object) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "put", new Object[]{new Long(l), object, this});
        }
        if (object == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "put", "IllegalArgumentException");
            }
            throw new IllegalArgumentException("Null is not a permitted value.");
        }
        int n = this.getHashForNewEntry(l);
        Object object2 = this._values[n] == DELETED ? null : this._values[n];
        this._values[n] = object;
        this._keys[n] = l;
        if (object2 == null) {
            ++this._currentLoad;
            if (this._currentLoad == this._resizeThreshold) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.entry(tc, "put", new Object[]{new Long(l), object, this});
                }
                long[] lArray = new long[this._mapSize];
                Object[] objectArray = new Object[this._mapSize];
                System.arraycopy(this._keys, 0, lArray, 0, lArray.length);
                System.arraycopy(this._values, 0, objectArray, 0, objectArray.length);
                this._mapSize *= 2;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "mapSize = " + this._mapSize);
                }
                this._resizeThreshold = (int)((float)this._mapSize * (float)this._loadFactor / 100.0f);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "resizeThreshold = " + this._resizeThreshold);
                }
                this._values = new Object[this._mapSize];
                this._keys = new long[this._mapSize];
                this._currentLoad = 0;
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object3 = objectArray[i];
                    if (object3 == null || object3 == DELETED) continue;
                    this.put(lArray[i], object3);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "put", object2);
        }
        return object2;
    }

    public Object remove(long l) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "remove", new Object[]{new Long(l), this});
        }
        int n = this.getHashForExistingEntry(l);
        Object object = null;
        if (n >= 0) {
            object = this._values[n];
        }
        if (object != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Entry found in map - removing");
            }
            this._values[n] = DELETED;
            --this._currentLoad;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "remove", object);
        }
        return object;
    }

    public Object get(long l) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "get", new Object[]{new Long(l), this});
        }
        int n = this.getHashForExistingEntry(l);
        Object object = null;
        if (n >= 0) {
            object = this._values[n];
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "get", object);
        }
        return object;
    }

    public Object[] values() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "values", this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Current load = " + this._currentLoad);
        }
        Object[] objectArray = new Object[this._currentLoad];
        int n = 0;
        for (int i = 0; i < this._mapSize; ++i) {
            Object object = this._values[i];
            if (object == null || object == DELETED) continue;
            objectArray[n++] = object;
        }
        return objectArray;
    }

    private int getHashForExistingEntry(long l) {
        int n;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getHashForExistingEntry", new Object[]{new Long(l), this});
        }
        int n2 = this.getHashForKey(l);
        for (n = 1; n < this._mapSize && (this._values[n2] == DELETED || this._values[n2] != null && this._keys[n2] != l); ++n) {
            n2 = (n2 + n) % this._mapSize;
        }
        if (n == this._mapSize) {
            n2 = -1;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getHashForExistingEntry", new Integer(n2));
        }
        return n2;
    }

    private int getHashForNewEntry(long l) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getHashForNewEntry", new Object[]{new Long(l), this});
        }
        int n = this.getHashForKey(l);
        int n2 = 1;
        while (this._values[n] != null && this._values[n] != DELETED && this._keys[n] != l) {
            n = (n + n2) % this._mapSize;
            ++n2;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getHashForNewEntry", new Integer(n));
        }
        return n;
    }

    private int getHashForKey(long l) {
        int n;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getHashForKey", new Object[]{new Long(l), this});
        }
        if ((n = (int)(l % (long)this._mapSize)) < 0) {
            n = -n;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getHashForKey", new Integer(n));
        }
        return n;
    }
}

