/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ws.util.CapturedSocket;
import com.ibm.ws.util.ReplayOutputStream;
import com.ibm.ws.util.ReplayServerSocket;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImplFactory;

class ReplaySocket
extends Socket
implements Serializable {
    private ReplayServerSocket rss;
    private CapturedSocket cs;
    private ByteArrayInputStream inputStream = null;
    private ReplayOutputStream outputStream = null;
    private int iteration;
    private boolean isClosed = false;
    private static final long serialVersionUID = 6066342224555707914L;

    public ReplaySocket(ReplayServerSocket replayServerSocket, CapturedSocket capturedSocket, int n) throws SocketException {
        this.rss = replayServerSocket;
        this.cs = capturedSocket;
        this.iteration = n;
    }

    public int getIdx() {
        return this.cs.getIdx();
    }

    public int getIteration() {
        return this.iteration;
    }

    public InputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new ByteArrayInputStream(this.cs.getCapturedInput());
        }
        return this.inputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new ReplayOutputStream(this.cs.getCapturedOutput());
        }
        return this.outputStream;
    }

    public void shutdownInput() {
        this.inputStream.skip(this.inputStream.available());
    }

    public void shutdownOutput() {
        this.outputStream.shutdown();
    }

    public void close() throws IOException {
        if (!this.isClosed) {
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
            if (this.outputStream != null) {
                this.outputStream.close();
                this.outputStream = null;
            }
            this.rss.replayComplete(this);
            this.rss = null;
            this.cs = null;
            this.isClosed = true;
        }
    }

    public boolean getKeepAlive() {
        return this.cs.getKeepAlive();
    }

    public InetAddress getLocalAddress() {
        return this.cs.getLocalAddress();
    }

    public int getLocalPort() {
        return this.rss.getLocalPort();
    }

    public InetAddress getInetAddress() {
        return this.cs.getInetAddress();
    }

    public int getPort() {
        return this.cs.getPort();
    }

    public int getReceiveBufferSize() {
        return this.cs.getReceiveBufferSize();
    }

    public int getSendBufferSize() {
        return this.cs.getSendBufferSize();
    }

    public int getSoLinger() {
        return this.cs.getSoLinger();
    }

    public int getSoTimeout() {
        return this.cs.getSoTimeout();
    }

    public boolean getTcpNoDelay() {
        return this.cs.getTcpNoDelay();
    }

    public void setKeepAlive(boolean bl) {
    }

    public void setReceiveBufferSize(int n) {
    }

    public void setSendBufferSize(int n) {
    }

    public static void setSocketImplFactory(SocketImplFactory socketImplFactory) {
    }

    public void setSoLinger(boolean bl, int n) {
    }

    public void setSoTimeout(int n) {
    }

    public void setTcpNoDelay(boolean bl) {
    }

    public String toString() {
        return new Integer(this.cs.getIdx()).toString();
    }
}

