/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ws.util.ClauseNode;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class URIMatcher {
    protected ClauseNode root;
    protected HashMap extensions = new HashMap();
    protected final String starString = "*";
    protected ClauseNode defaultNode;
    private boolean scalable;
    protected static int range = 91;
    private boolean useStringKeys;

    public static int computeHash(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            n = n * range + string.charAt(i);
        }
        return n;
    }

    public URIMatcher() {
        this(false, false);
    }

    public URIMatcher(boolean bl) {
        this(bl, false);
    }

    public URIMatcher(boolean bl, boolean bl2) {
        this.scalable = bl;
        this.useStringKeys = bl && bl2;
        this.init();
    }

    public URIMatcher(boolean bl, int n) {
        this.scalable = bl;
        this.useStringKeys = false;
        range = n;
        this.init();
    }

    URIMatcher(String string) throws Exception {
        this();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            if (string2.equals("")) {
                string2 = bufferedReader.readLine();
                continue;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            this.put(string3, string4);
            string2 = bufferedReader.readLine();
        }
        bufferedReader.close();
    }

    private void init() {
        if (this.root == null) {
            this.root = new ClauseNode("/", null, this.scalable, this.useStringKeys);
        }
    }

    public void put(String string, Object object) throws Exception {
        if (string.startsWith("*.")) {
            this.extensions.put(string.substring(2), object);
            return;
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        ClauseNode clauseNode = this.root;
        int n = string.length();
        for (int i = 1; i < n; ++i) {
            if (string.charAt(i) == '/') {
                clauseNode = clauseNode.add(new ClauseNode(stringBuilder.toString(), null, this.scalable, this.useStringKeys));
                stringBuilder.delete(0, stringBuilder.length());
                continue;
            }
            if (i == n - 1) {
                stringBuilder.append(string.charAt(i));
                clauseNode = clauseNode.add(new ClauseNode(stringBuilder.toString(), object, this.scalable, this.useStringKeys));
                continue;
            }
            stringBuilder.append(string.charAt(i));
        }
        this.defaultNode = this.root.traverse("*");
    }

    public Iterator iterator() {
        List list = this.root.targets();
        list.addAll(this.extensions.values());
        return list.listIterator();
    }

    public Object match(String string) {
        ClauseNode clauseNode = this.root;
        ClauseNode clauseNode2 = this.root;
        ClauseNode clauseNode3 = null;
        ClauseNode clauseNode4 = null;
        boolean bl = true;
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 1; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '/') {
                if ((clauseNode = clauseNode.traverse(stringBuilder.toString())) == null) {
                    bl = false;
                    break;
                }
                clauseNode4 = clauseNode2.traverse("*");
                if (clauseNode4 != null) {
                    clauseNode3 = clauseNode4;
                }
                clauseNode2 = clauseNode;
                stringBuilder.delete(0, stringBuilder.length());
                continue;
            }
            if (i == n - 1) {
                stringBuilder.append(c);
                clauseNode = clauseNode.traverse(stringBuilder.toString());
                if (clauseNode != null) continue;
                bl = false;
                continue;
            }
            stringBuilder.append(c);
        }
        Object object = null;
        if (bl) {
            object = clauseNode.getTarget();
            if (object != null) {
                return object;
            }
            clauseNode4 = clauseNode.traverse("*");
            if (clauseNode4 != null && (object = clauseNode4.getTarget()) != null) {
                return object;
            }
        }
        if ((clauseNode4 = clauseNode2.traverse("*")) != null) {
            clauseNode3 = clauseNode4;
        }
        if (clauseNode3 != null && clauseNode3 != this.defaultNode) {
            return clauseNode3.getTarget();
        }
        int n2 = string.lastIndexOf(".");
        if (n2 != -1 && (object = this.extensions.get(string.substring(n2 + 1))) != null) {
            return object;
        }
        if (clauseNode3 != null) {
            return clauseNode3.getTarget();
        }
        return null;
    }

    public List matchAll(String string) {
        Object v;
        ClauseNode clauseNode = this.root;
        ClauseNode clauseNode2 = this.root;
        ClauseNode clauseNode3 = null;
        ClauseNode clauseNode4 = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = string.lastIndexOf(".");
        if (n != -1 && (v = this.extensions.get(string.substring(n + 1))) != null) {
            arrayList.add(v);
        }
        boolean bl = true;
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 1; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == '/') {
                if ((clauseNode = clauseNode.traverse(stringBuilder.toString())) == null) {
                    bl = false;
                    break;
                }
                clauseNode4 = clauseNode2.traverse("*");
                if (clauseNode4 != null) {
                    if (clauseNode4.getTarget() != null) {
                        arrayList.add(clauseNode4.getTarget());
                    }
                    clauseNode3 = clauseNode4;
                }
                clauseNode2 = clauseNode;
                stringBuilder.delete(0, stringBuilder.length());
                continue;
            }
            if (i == n2 - 1) {
                stringBuilder.append(c);
                clauseNode = clauseNode.traverse(stringBuilder.toString());
                if (clauseNode != null) continue;
                bl = false;
                continue;
            }
            stringBuilder.append(c);
        }
        Object object = null;
        if (bl) {
            object = clauseNode.getTarget();
            if (object != null) {
                arrayList.add(object);
                return arrayList;
            }
            clauseNode4 = clauseNode.traverse("*");
            if (clauseNode4 != null && (object = clauseNode4.getTarget()) != null) {
                arrayList.add(object);
                return arrayList;
            }
        }
        if ((clauseNode4 = clauseNode2.traverse("*")) != null && clauseNode4.getTarget() != null) {
            arrayList.add(clauseNode4.getTarget());
        }
        return arrayList;
    }

    public void remove(String string) {
        if (string.startsWith("*.")) {
            this.extensions.remove(string.substring(2));
        }
        this.root.remove(string);
    }

    public static void main(String[] stringArray) {
        try {
            URIMatcher uRIMatcher = new URIMatcher();
            uRIMatcher.put("/portal/*", new String("/portal/* target"));
            uRIMatcher.put("/portal/abc", new String("/portal/abc target1"));
            System.out.println("out:" + uRIMatcher.match("/portal/abc"));
            uRIMatcher.replace("/portal/abc", new String("/portal/abd new target"));
            System.out.println("out:" + uRIMatcher.match("/portal/abc"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Object replace(String string, Object object) throws Exception {
        ClauseNode clauseNode = this.root;
        ClauseNode clauseNode2 = this.root;
        ClauseNode clauseNode3 = null;
        ClauseNode clauseNode4 = null;
        boolean bl = true;
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 1; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '/') {
                if ((clauseNode = clauseNode.traverse(stringBuilder.toString())) == null) {
                    bl = false;
                    break;
                }
                clauseNode4 = clauseNode2.traverse("*");
                if (clauseNode4 != null) {
                    clauseNode3 = clauseNode4;
                }
                clauseNode2 = clauseNode;
                stringBuilder.delete(0, stringBuilder.length());
                continue;
            }
            if (i == n - 1) {
                stringBuilder.append(c);
                clauseNode = clauseNode.traverse(stringBuilder.toString());
                if (clauseNode != null) continue;
                bl = false;
                continue;
            }
            stringBuilder.append(c);
        }
        Object object2 = null;
        if (bl) {
            object2 = clauseNode.getTarget();
            if (object2 != null) {
                clauseNode.setTarget(object);
                return object2;
            }
            throw new Exception("No target to replace at given node");
        }
        int n2 = string.lastIndexOf(".");
        if (n2 != -1 && (object2 = this.extensions.get(string.substring(n2 + 1))) != null) {
            this.extensions.put(string.substring(n2 + 1), object);
            return object2;
        }
        throw new Exception("No exact matching path found to replace");
    }

    public boolean exists(String string) {
        ClauseNode clauseNode = this.root;
        ClauseNode clauseNode2 = this.root;
        ClauseNode clauseNode3 = null;
        ClauseNode clauseNode4 = null;
        boolean bl = true;
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 1; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '/') {
                if ((clauseNode = clauseNode.traverse(stringBuilder.toString())) == null) {
                    bl = false;
                    break;
                }
                clauseNode4 = clauseNode2.traverse("*");
                if (clauseNode4 != null) {
                    clauseNode3 = clauseNode4;
                }
                clauseNode2 = clauseNode;
                stringBuilder.delete(0, stringBuilder.length());
                continue;
            }
            if (i == n - 1) {
                stringBuilder.append(c);
                clauseNode = clauseNode.traverse(stringBuilder.toString());
                if (clauseNode != null) continue;
                bl = false;
                continue;
            }
            stringBuilder.append(c);
        }
        Object var10_10 = null;
        if (bl) {
            return true;
        }
        return this.extensions.get(string) != null;
    }
}

