/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;

public class WsObjectInputStream
extends ObjectInputStream {
    private static final HashMap primClasses = new HashMap(8, 1.0f);
    protected static ClassResolver resolver;
    protected ClassLoader classloader;
    protected String name;
    PrivilegedExceptionAction loadAction = new PrivilegedExceptionAction(){

        public Object run() throws Exception {
            try {
                Class clazz = null;
                if (resolver != null) {
                    clazz = resolver.resolveClass(WsObjectInputStream.this.name);
                }
                if (clazz == null) {
                    clazz = WsObjectInputStream.this.loadClass(WsObjectInputStream.this.name, WsObjectInputStream.this.classloader);
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Class clazz = (Class)primClasses.get(WsObjectInputStream.this.name);
                if (clazz != null) {
                    return clazz;
                }
                throw classNotFoundException;
            }
        }
    };
    private Class proxyClass;
    PrivilegedAction proxyClassLoaderAction = new PrivilegedAction(){

        public Object run() {
            return WsObjectInputStream.this.proxyClass.getClassLoader();
        }
    };

    public WsObjectInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        this.classloader = (ClassLoader)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    public WsObjectInputStream(InputStream inputStream, ClassLoader classLoader) throws IOException {
        super(inputStream);
        this.classloader = classLoader;
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        return this.resolveClass(objectStreamClass.getName());
    }

    private Class resolveClass(String string) throws IOException, ClassNotFoundException {
        try {
            this.name = string;
            return (Class)AccessController.doPrivileged((PrivilegedExceptionAction)this.loadAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)exception;
            }
            throw new ClassNotFoundException(string);
        }
    }

    private Class loadClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            return Class.forName(string, true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Class.forName(string);
        }
    }

    protected Class resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
        if (stringArray.length == 0) {
            throw new ClassNotFoundException("zero-length interfaces array");
        }
        Class clazz = null;
        Class[] classArray = new Class[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            classArray[i] = this.resolveClass(stringArray[i]);
            if ((classArray[i].getModifiers() & 1) != 0) continue;
            if (clazz != null) {
                throw new IllegalAccessError(clazz + " and " + classArray[i] + " both declared non-public");
            }
            clazz = classArray[i];
        }
        this.proxyClass = clazz != null ? clazz : classArray[0];
        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged((PrivilegedAction)this.proxyClassLoaderAction);
        try {
            return Proxy.getProxyClass(classLoader, classArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ClassNotFoundException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    static {
        primClasses.put("boolean", Boolean.TYPE);
        primClasses.put("byte", Byte.TYPE);
        primClasses.put("char", Character.TYPE);
        primClasses.put("short", Short.TYPE);
        primClasses.put("int", Integer.TYPE);
        primClasses.put("long", Long.TYPE);
        primClasses.put("float", Float.TYPE);
        primClasses.put("double", Double.TYPE);
        primClasses.put("void", Void.TYPE);
        boolean bl = true;
        try {
            Class.forName("org.eclipse.core.runtime.IExtensionRegistry");
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        if (bl) {
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.util.ClassResolverImpl");
                resolver = (ClassResolver)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException(classNotFoundException, "com.ibm.ws.util.WsObjectInputStream.<clinit>", "93");
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.util.WsObjectInputStream.<clinit>", "97");
            }
        }
    }

    public static interface ClassResolver {
        public Class resolveClass(String var1);
    }
}

