/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wccm.services.pme;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.Repository;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class PMECheckServerConfigService
extends ComponentImpl {
    static final TraceComponent tc = Tr.register(PMECheckServerConfigService.class, "PMESERVERCONFIG", "com.ibm.ws.wccm.PMEWccmMessages");

    public void initialize(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
            Tr.exit(tc, "initialize");
        }
    }

    public void start() {
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "start");
            }
            try {
                Repository repository2 = (Repository)this.getService(Repository.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Repository root URI = " + repository2.getRootURI());
                }
                String string = repository2.getServerName();
                Resource resource = repository2.getConfigRoot().getResource(3, "serverindex.xml");
                ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
                EList eList = serverIndex.getServerEntries();
                for (int i = 0; i < eList.size(); ++i) {
                    ServerEntry serverEntry = (ServerEntry)eList.get(i);
                    String string2 = serverEntry.getServerName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server name = " + string2);
                    }
                    if (!string2.equals(string)) continue;
                    String string3 = serverEntry.getServerType();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server type = " + string3);
                    }
                    if (string3.equals("NODE_AGENT")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "This server is a nodeagent");
                        }
                        break;
                    }
                    if (string3.equals("MESSAGE_BROKER")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "This server is a jmsserver");
                        }
                        break;
                    }
                    try {
                        Resource resource2 = repository2.getConfigRoot().getResource(4, "server-pme.xml");
                        if (resource2 != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "The PME server config file exists");
                            }
                            break;
                        }
                        Tr.warning(tc, "MSG_KEY_01");
                    }
                    catch (Exception exception) {
                        Tr.warning(tc, "MSG_KEY_01", new Object[]{exception});
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.wccm.services.pme", "1", this);
                    }
                    break;
                }
            }
            catch (Exception exception) {
                Tr.warning(tc, "MSG_KEY_UNEX_EXCEPT", new Object[]{exception});
                if (!tc.isDebugEnabled()) break block16;
                Tr.debug(tc, "Check aborted due to unexpected exception", new Object[]{exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }
}

