/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class WCCByteBufferInputStream
extends InputStream {
    private static TraceComponent tc = Tr.register(WCCByteBufferInputStream.class, "WCCByteBufferInputStream", "com.ibm.ws.webcontainer.channel");
    private HttpInboundServiceContext isc;
    private WsByteBuffer curBuffer;
    private IOException ioe = null;
    private ArrayList postData;
    private boolean reReadPostData = false;
    private boolean readComplete = false;
    private int postDataIndex = 0;
    private static boolean enableMultiReadOfPostData = new Boolean(WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.enablemultireadofpostdata", "false"));

    public void init(HttpInboundServiceContext httpInboundServiceContext) {
        block7: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.entry(tc, "init");
            }
            this.isc = httpInboundServiceContext;
            this.curBuffer = null;
            this.ioe = null;
            if (enableMultiReadOfPostData) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "init", "create postData arrayList");
                }
                this.postData = new ArrayList();
                this.reReadPostData = false;
                this.readComplete = false;
            }
            if (!this.isc.getRequest().getContentEncoding()[0].equals(HttpConstants.CONTENT_ENCODING_NOTSET)) {
                try {
                    this.bufferIsGood();
                }
                catch (IOException iOException) {
                    this.ioe = iOException;
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "read exception on init, allow future read to handle exception");
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void finish() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.entry(tc, "finish");
        }
        this.releaseCurBuffer();
        if (enableMultiReadOfPostData) {
            this.reReadPostData = false;
            this.readComplete = false;
            if (this.postData != null) {
                Iterator iterator = this.postData.iterator();
                while (iterator.hasNext()) {
                    WsByteBuffer wsByteBuffer = (WsByteBuffer)iterator.next();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "finish", "release buffer " + wsByteBuffer + " from saved postData.");
                    }
                    wsByteBuffer.release();
                }
                this.postData = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.exit(tc, "finish");
        }
    }

    public int available() throws IOException {
        if (!this.bufferIsGood()) {
            return -1;
        }
        return this.curBuffer.remaining();
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (!this.bufferIsGood()) {
            return -1;
        }
        return this.curBuffer.getInt();
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (!this.bufferIsGood()) {
            return -1;
        }
        if (n2 > this.curBuffer.remaining()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Reset requested len --> " + n2 + " to size remaining in current buffer --> " + this.curBuffer.remaining());
            }
            n2 = this.curBuffer.remaining();
        }
        this.curBuffer.get(byArray, n, n2);
        return n2;
    }

    public void releaseCurBuffer() {
        WsByteBuffer wsByteBuffer = this.curBuffer;
        this.curBuffer = null;
        if (wsByteBuffer != null) {
            if (enableMultiReadOfPostData) {
                if (!this.reReadPostData) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "releaseCurBuffer", "add buffer " + wsByteBuffer + " to saved post data at index " + this.postData.size());
                    }
                    this.postData.add(wsByteBuffer);
                }
            } else {
                wsByteBuffer.release();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean bufferIsGood() throws IOException {
        if (this.ioe != null) {
            var1_1 = this.ioe;
            this.ioe = null;
            throw var1_1;
        }
        if (this.curBuffer == null || !this.curBuffer.hasRemaining()) {
            if (this.reReadPostData) {
                if (this.postDataIndex < this.postData.size()) {
                    this.curBuffer = (WsByteBuffer)this.postData.get(this.postDataIndex);
                    this.curBuffer.rewind();
                    if (TraceComponent.isAnyTracingEnabled() && WCCByteBufferInputStream.tc.isDebugEnabled()) {
                        Tr.debug(WCCByteBufferInputStream.tc, "bufferIsGood", "Get buffer " + this.curBuffer + " from saved postData index=" + this.postDataIndex);
                    }
                    ++this.postDataIndex;
                } else {
                    this.curBuffer = null;
                    if (TraceComponent.isAnyTracingEnabled() && WCCByteBufferInputStream.tc.isDebugEnabled()) {
                        Tr.debug(WCCByteBufferInputStream.tc, "bufferIsGood", "Failed to get next buffer from saved postData - index =" + this.postDataIndex);
                    }
                    if (!this.readComplete) {
                        if (TraceComponent.isAnyTracingEnabled() && WCCByteBufferInputStream.tc.isDebugEnabled()) {
                            Tr.debug(WCCByteBufferInputStream.tc, "bufferIsGood", "Try another read from the inbound service context");
                        }
                        try {
                            this.curBuffer = this.isc.getRequestBodyBuffer();
                            if (this.curBuffer == null) ** GOTO lbl41
                            this.reReadPostData = false;
                        }
                        catch (IOException var1_2) {
                            FFDCFilter.processException((Throwable)var1_2, "com.ibm.ws.webcontainer.channel.WCCByteBufferInputStream", "102", this);
                            if (TraceComponent.isAnyTracingEnabled() && WCCByteBufferInputStream.tc.isDebugEnabled()) {
                                Tr.debug(WCCByteBufferInputStream.tc, "bufferIsGood", "Failed to get next body buffer");
                            }
                            throw var1_2;
                        }
                    }
                }
            } else {
                this.releaseCurBuffer();
                try {
                    this.curBuffer = this.isc.getRequestBodyBuffer();
                }
                catch (IOException var1_3) {
                    FFDCFilter.processException((Throwable)var1_3, "com.ibm.ws.webcontainer.channel.WCCByteBufferInputStream", "102", this);
                    if (WCCByteBufferInputStream.tc.isDebugEnabled()) {
                        Tr.debug(WCCByteBufferInputStream.tc, "Failed to get next body buffer");
                    }
                    throw var1_3;
                }
            }
        }
lbl41:
        // 7 sources

        if (this.curBuffer == null) {
            Tr.debug(WCCByteBufferInputStream.tc, "Next body buffer was null");
            this.readComplete = true;
            return false;
        }
        if (WCCByteBufferInputStream.tc.isDebugEnabled()) {
            Tr.debug(WCCByteBufferInputStream.tc, "buffer is good remaining --> " + this.curBuffer.remaining());
        }
        return true;
    }

    public void close() throws IOException {
        if (enableMultiReadOfPostData) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Close", "Next read will re-read data");
            }
            this.releaseCurBuffer();
            this.reReadPostData = true;
            this.postDataIndex = 0;
        } else {
            super.close();
        }
    }
}

