/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.webcontainer.channel.WCChannelLink;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.webcontainer.ClosedConnectionException;
import java.io.IOException;
import java.io.OutputStream;

public class WCCByteBufferOutputStream
extends OutputStream {
    private static TraceComponent tc = Tr.register(WCCByteBufferOutputStream.class, "WCCByteBufferOutputStream", "com.ibm.ws.webcontainer.channel");
    private HttpInboundServiceContext isc;
    private WCChannelLink link;
    private boolean flushToWire;
    private WsByteBuffer[] buffersToWrite;
    private int arrayPos;
    private int arraySize;
    private int expectedRemaining;
    private boolean hadCorruptionError = false;
    private static final int useBufferSize = 8192;
    private boolean writeLastBuffer = false;
    private boolean hadException = false;

    public WCCByteBufferOutputStream(HttpInboundServiceContext httpInboundServiceContext, WCChannelLink wCChannelLink) {
        this.isc = httpInboundServiceContext;
        this.link = wCChannelLink;
        this.flushToWire = true;
        this.writeLastBuffer = false;
        this.hadException = false;
        this.arraySize = this.link.getChannel().getBufferSize() / 8192;
        if (this.link.getChannel().getBufferSize() % 8192 != 0) {
            ++this.arraySize;
        }
        this.resetWriteArray();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "WCCByteBufferOutputStrean created :" + this);
        }
    }

    public void write(int n) throws IOException {
        if (this.linkHandledError()) {
            Exception exception = this.link.getCloseException();
            throw new ClosedConnectionException("OutputStream encountered error during write", (Throwable)exception);
        }
        if (!this.checkWriteArray()) {
            throw new IOException("Response buffer corruption detected : response terminated");
        }
        this.buffersToWrite[this.arrayPos].put((byte)n);
        --this.expectedRemaining;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "OutputStream: write(int) new reamining = " + this.expectedRemaining + ", buffer : " + this.buffersToWrite[this.arrayPos]);
        }
        if (this.flushToWire) {
            this.flushWriteBuffer();
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "OutputStream: write, This = : " + this);
        }
        while (n4 != n2) {
            if (this.linkHandledError()) {
                Exception exception = this.link.getCloseException();
                throw new ClosedConnectionException("OutputStream encountered error during write", (Throwable)exception);
            }
            if (!this.checkWriteArray()) {
                throw new IOException("Response buffer corruption detected : response terminated");
            }
            n3 = n2 - n4;
            n5 = this.buffersToWrite[this.arrayPos].remaining();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "OutputStream:  To write len = " + n3 + ", remaining = " + n5 + ", buffer : " + this.buffersToWrite[this.arrayPos]);
            }
            if (n3 <= n5) {
                this.buffersToWrite[this.arrayPos].put(byArray, n + n4, n3);
                n4 += n3;
                this.expectedRemaining -= n3;
                continue;
            }
            this.buffersToWrite[this.arrayPos].put(byArray, n + n4, n5);
            n4 += n5;
            this.expectedRemaining -= n5;
        }
        if (this.flushToWire) {
            this.flushWriteBuffer();
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public final void print(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n4 != n2) {
            if (this.linkHandledError()) {
                Exception exception = this.link.getCloseException();
                throw new ClosedConnectionException("OutputStream encountered error during write", (Throwable)exception);
            }
            if (!this.checkWriteArray()) {
                throw new IOException("Response buffer corruption detected : response terminated");
            }
            n3 = n2 - n4;
            n5 = this.buffersToWrite[this.arrayPos].remaining();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "OutputStream: To write len = " + n3 + ", remaining = " + n5 + ", buffer : " + this.buffersToWrite[this.arrayPos]);
            }
            if (n3 <= n5) {
                this.buffersToWrite[this.arrayPos].putChar(cArray, n + n4, n3);
                n4 += n3;
                this.expectedRemaining -= n3;
                continue;
            }
            this.buffersToWrite[this.arrayPos].putChar(cArray, n + n4, n5);
            n4 += n5;
            this.expectedRemaining -= n5;
        }
        if (this.flushToWire) {
            this.flushWriteBuffer();
        }
    }

    public final void print(char c) throws IOException {
        this.write(c);
    }

    public final void print(char[] cArray) throws IOException {
        this.print(cArray, 0, cArray.length);
    }

    public final void print(String string) throws IOException {
        this.print(string, 0, string.length());
    }

    public final void print(String string, int n, int n2) throws IOException {
        byte[] byArray = string.getBytes();
        this.write(byArray, n, n2);
    }

    public final void print(boolean bl) throws IOException {
        this.print(String.valueOf(bl));
    }

    public final void print(int n) throws IOException {
        String string = Integer.toString(n);
        this.print(string);
    }

    public final void print(long l) throws IOException {
        String string = Long.toString(l);
        this.print(string);
    }

    public final void print(float f) throws IOException {
        String string = Float.toString(f);
        this.print(string);
    }

    public final void print(double d) throws IOException {
        this.print(String.valueOf(d));
    }

    public final void print(Object object) throws IOException {
        this.print(object.toString());
    }

    public void setFlushMode(boolean bl) {
        this.flushToWire = bl;
    }

    public boolean getFlushMode() {
        return this.flushToWire;
    }

    public void setLastBuffer(boolean bl) {
        this.writeLastBuffer = bl;
    }

    public boolean getLastBuffer() {
        return this.writeLastBuffer;
    }

    public void writeHeaders() {
        this.link.writeHeaders();
    }

    public boolean hasContentBuffered() {
        return this.buffersToWrite[0] != null;
    }

    private boolean checkWriteArray() {
        if (this.hadCorruptionError) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "CheckWriteArray returning false - response buffer corruption previously detected");
            }
            return false;
        }
        if (this.buffersToWrite[0] == null) {
            this.buffersToWrite[0] = this.getNewByteBuffer();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "OutputStream: First New buffer obtained : " + this.buffersToWrite[0]);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "OutputStream: Buffer remaining: Expected=" + this.expectedRemaining + ", actual=" + this.buffersToWrite[this.arrayPos].remaining() + ", arrayPos = " + this.arrayPos + ", buffer : " + this.buffersToWrite[this.arrayPos]);
            }
            if (this.buffersToWrite[this.arrayPos].remaining() != this.expectedRemaining) {
                this.hadCorruptionError = true;
                Tr.error(tc, "Response buffer corruption detected. Expected remaining=" + this.expectedRemaining + ", actual=" + this.buffersToWrite[this.arrayPos].remaining());
                for (int i = 0; i <= this.arrayPos; ++i) {
                    if (this.buffersToWrite[i] == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "clearing buffer :" + this.buffersToWrite[i]);
                    }
                    this.buffersToWrite[i].clear();
                    this.buffersToWrite[i].removeFromLeakDetection();
                    this.buffersToWrite[i] = null;
                }
                return false;
            }
            if (this.buffersToWrite[this.arrayPos].hasRemaining()) {
                return true;
            }
            if (this.arrayPos + 1 == this.buffersToWrite.length) {
                this.flushWriteBuffer();
                this.buffersToWrite[0] = this.getNewByteBuffer();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "OutputStream: Buffers flushed. New first buffer obtained : " + this.buffersToWrite[0]);
                }
            } else {
                this.buffersToWrite[this.arrayPos].flip();
                ++this.arrayPos;
                this.buffersToWrite[this.arrayPos] = this.getNewByteBuffer();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "OutputStream: array pos = " + this.arrayPos + ", New buffer obtained : " + this.buffersToWrite[this.arrayPos]);
                }
            }
        }
        return true;
    }

    public void flushWriteBuffer() {
        if (this.buffersToWrite[0] != null && !this.linkHandledError() && !this.hadCorruptionError) {
            if (this.buffersToWrite[this.arrayPos] != null) {
                this.buffersToWrite[this.arrayPos].flip();
            }
            WsByteBuffer[] wsByteBufferArray = this.buffersToWrite;
            this.resetWriteArray();
            this.link.writeBuffer(wsByteBufferArray);
        }
    }

    private void resetWriteArray() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "OutputStream: ResetWriteArray");
        }
        this.buffersToWrite = new WsByteBuffer[this.arraySize];
        this.arrayPos = 0;
    }

    private WsByteBuffer getNewByteBuffer() {
        this.expectedRemaining = 8192;
        return WsByteBufferPoolManagerImpl.getRef().allocateDirect(8192);
    }

    public boolean linkHandledError() {
        return this.link.handledError();
    }

    public void setHadException(boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "OutputStream: setHadException ->" + bl);
        }
        this.hadException = bl;
    }

    public boolean getHadException() {
        return this.hadException;
    }
}

