/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.channel.WCCByteBufferInputStream;
import com.ibm.ws.webcontainer.channel.WCCResponseImpl;
import com.ibm.ws.webcontainer.channel.WCChannelLink;
import com.ibm.ws.webcontainer.util.ArrayEnumeration;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.webcontainer.IPoolable;
import com.ibm.wsspi.webcontainer.IRequest;
import com.ibm.wsspi.webcontainer.IResponse;
import com.ibm.wsspi.webcontainer.WebContainer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.CertificateFactory;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;
import javax.servlet.http.Cookie;

public class WCCRequestImpl
implements IRequest,
IPoolable {
    private static TraceComponent tc = Tr.register(WCCRequestImpl.class, "WCCRequestImpl", "com.ibm.ws.webcontainer.channel");
    private HttpInboundServiceContext isc = null;
    private WCChannelLink link = null;
    private WCCResponseImpl response = null;
    private HttpRequestMessage request = null;
    private String serverName = null;
    private int serverPort = -1;
    private WCCByteBufferInputStream bbIS = new WCCByteBufferInputStream();
    private String httpsIndicatorHeaderName = (String)WebContainer.getWebContainerProperties().get("httpsindicatorheader");
    private boolean isServerPortSet;
    private boolean isHttpsIndicatorSecure;
    private boolean isHttpsIndicatorSecureSet;
    private String normalizedURI;
    private boolean discard = false;
    private static String encoding = WebContainer.getWebContainer().getURIEncoding();
    private static boolean extractHostHeaderPort = new Boolean(WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.extracthostheaderport", "false"));
    private static boolean normalizeRequestURI = new Boolean(WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.normalizerequesturi", "false"));

    public void init(WCChannelLink wCChannelLink, HttpInboundServiceContext httpInboundServiceContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "init");
        }
        this.isc = httpInboundServiceContext;
        this.link = wCChannelLink;
        this.response = this.link.getResponse();
        this.request = this.isc.getRequest();
        this.bbIS.init(httpInboundServiceContext);
        this.serverName = null;
        this.serverPort = -1;
        this.isHttpsIndicatorSecureSet = false;
        this.isServerPortSet = false;
        this.normalizedURI = null;
    }

    public void finish() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.entry(tc, "finish");
        }
        this.bbIS.finish();
        if (this.discard) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "discard state");
            }
            this.bbIS = null;
            this.isc = null;
            this.request = null;
            this.response = null;
            this.link = null;
            this.normalizedURI = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.exit(tc, "finish");
        }
    }

    public String getQueryString() {
        String string = this.request.getQueryString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getQueryString queryString --> " + string);
        }
        return string;
    }

    public String getMethod() {
        String string = this.request.getMethod();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getMethod method --> " + string);
        }
        return string;
    }

    public String getRequestURI() {
        String string = null;
        if (this.normalizedURI != null) {
            string = this.normalizedURI;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.debug(tc, "Use previously normalized request uri");
            }
        } else {
            try {
                string = new String(this.request.getRequestURIAsByteArray(), encoding);
            }
            catch (Exception exception) {
                string = this.request.getRequestURI();
            }
            if (normalizeRequestURI) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.debug(tc, "normalize request uri : " + string);
                }
                this.normalizedURI = string = this.normalize(string);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getRequestURI uri --> " + string);
        }
        return string;
    }

    public String normalize(String string) {
        int n;
        String string2 = string;
        String string3 = "";
        int n2 = string2.indexOf("?");
        if (n2 != -1) {
            string3 = string2.substring(n2);
            string2 = string2.substring(0, n2);
        }
        if ((n2 = string2.indexOf(";")) != -1) {
            string3 = string2.substring(n2);
            string2 = string2.substring(0, n2);
        }
        while ((n = string2.indexOf("/./")) >= 0) {
            string2 = string2.substring(0, n) + string2.substring(n + 2);
        }
        while ((n = string2.indexOf("/../")) >= 0) {
            if (n == 0) {
                return null;
            }
            int n3 = string2.lastIndexOf(47, n - 1);
            string2 = string2.substring(0, n3) + string2.substring(n + 3);
        }
        return string2 + string3;
    }

    public String getRemoteUser() {
        String string = this.request.getHeaderAsString(HttpConstants.HDR_$WSRU);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getRemoteUser user --> " + string);
        }
        return string;
    }

    public String getAuthType() {
        String string = this.request.getHeaderAsString(HttpConstants.HDR_$WSAT);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getAuthType authType --> " + string);
        }
        return string;
    }

    public String getHeader(String string) {
        String string2 = this.request.getHeaderAsString(string);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeader header --> " + string2);
        }
        return string2;
    }

    public int getContentLength() {
        int n = this.request.getContentLength();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getContentLength length --> " + String.valueOf(n));
        }
        return n;
    }

    public String getContentType() {
        String string = this.request.getHeaderAsString(HttpConstants.HDR_CONTENT_TYPE);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getContentType type --> " + string);
        }
        return string;
    }

    public String getProtocol() {
        String string = null;
        if (this.isTrusted() && this.request.containsHeader(HttpConstants.HDR_$WSPR)) {
            string = this.request.getHeaderAsString(HttpConstants.HDR_$WSPR);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getProtocol isTrusted --> true protocol --> " + string);
            }
            return string;
        }
        string = this.request.getVersion();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getProtocol protocol --> " + string);
        }
        return string;
    }

    public String getServerName() {
        if (this.serverName == null) {
            if (this.isTrusted() && this.request.containsHeader(HttpConstants.HDR_$WSSN)) {
                this.serverName = this.request.getHeaderAsString(HttpConstants.HDR_$WSSN);
                if (this.serverName != null && this.serverName.length() > 0) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getServerName isTrusted --> true name --> " + this.serverName);
                    }
                    return this.serverName;
                }
            }
            this.serverName = this.request.getVirtualHost();
            if (this.serverName == null) {
                this.serverName = new String("localhost");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getServerName name --> " + this.serverName);
        }
        return this.serverName;
    }

    private int getProxiedServerPort() {
        if (!this.isServerPortSet) {
            this.serverPort = this.request.getHeaderAsInteger(HttpConstants.HDR_$WSSP);
            this.isServerPortSet = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getProxiedServerPort port --> " + this.serverPort);
        }
        return this.serverPort;
    }

    public int getServerPort() {
        if (this.serverPort == -1) {
            if (this.isTrusted()) {
                if (this.isHttpsIndicatorSecure()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getServerPort isTrusted --> true isHttpsIndicatorSecure --> true port --> " + this.serverPort);
                    }
                    return this.serverPort;
                }
                if (this.request.containsHeader(HttpConstants.HDR_$WSSP)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getServerPort isTrusted --> true");
                    }
                    return this.getProxiedServerPort();
                }
            }
            if (this.link.isTrustedHostHeaderPort()) {
                if (!extractHostHeaderPort) {
                    this.serverPort = this.request.getVirtualPort();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getServerPort virtual port --> " + this.serverPort);
                    }
                    if (this.serverPort != -1) {
                        return this.serverPort;
                    }
                } else {
                    this.serverPort = this.getHostHeaderPort();
                    if (this.serverPort != -1) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "getServerPort: Host Header port --> " + this.serverPort);
                        }
                        return this.serverPort;
                    }
                    this.serverPort = this.request.getURLPort();
                    if (this.serverPort != -1) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "getServerPort: URL port --> " + this.serverPort);
                        }
                        return this.serverPort;
                    }
                }
            }
            this.serverPort = this.isc.getLocalPort();
            if (this.serverPort == -1) {
                this.serverPort = 80;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getServerPort: Local or Default port --> " + this.serverPort);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getServerPort port --> " + this.serverPort);
        }
        return this.serverPort;
    }

    public String getRemoteHost() {
        String string = null;
        if (this.isTrusted() && this.request.containsHeader(HttpConstants.HDR_$WSRH)) {
            string = this.request.getHeaderAsString(HttpConstants.HDR_$WSRH);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getRemoteHost isTrusted --> true host --> " + string);
            }
            return string;
        }
        string = this.isc.getRemoteAddr().getCanonicalHostName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getRemoteHost host --> " + string);
        }
        return string;
    }

    public String getRemoteAddr() {
        String string = null;
        if (this.isTrusted() && this.request.containsHeader(HttpConstants.HDR_$WSRA)) {
            string = this.request.getHeaderAsString(HttpConstants.HDR_$WSRA);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getRemoteAddr isTrusted --> true addr --> " + string);
            }
            return string;
        }
        string = this.isc.getRemoteAddr().getHostAddress();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getRemoteAddr addr --> " + string);
        }
        return string;
    }

    public int getRemotePort() {
        int n = this.isc.getRemotePort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getRemotePort port --> " + String.valueOf(n));
        }
        return n;
    }

    private boolean isHttpsIndicatorSecure() {
        if (!this.isHttpsIndicatorSecureSet) {
            if (this.httpsIndicatorHeaderName != null && this.getHeader(this.httpsIndicatorHeaderName) != null) {
                this.isHttpsIndicatorSecure = true;
                String string = this.getHeader("Host");
                if (string != null) {
                    int n = string.indexOf(58);
                    if (n != -1) {
                        int n2 = string.length();
                        int n3 = 0;
                        for (int i = n + 1; i < n2; ++i) {
                            n3 = n3 * 10 + string.charAt(i) - 48;
                        }
                        this.serverPort = n3;
                    } else {
                        this.serverPort = 443;
                    }
                    this.isServerPortSet = true;
                }
            } else {
                this.isHttpsIndicatorSecure = false;
            }
            this.isHttpsIndicatorSecureSet = true;
        }
        return this.isHttpsIndicatorSecure;
    }

    public String getScheme() {
        String string = null;
        if (this.isTrusted()) {
            if (this.isHttpsIndicatorSecure()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getScheme trusted --> true isHttpsIndicatorSecure --> true scheme --> https");
                }
                return "https";
            }
            if (this.request.containsHeader(HttpConstants.HDR_$WSSC)) {
                string = this.request.getHeaderAsString(HttpConstants.HDR_$WSSC);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getScheme isTrusted --> true containsHeader --> " + HttpConstants.HDR_$WSSC + "scheme --> " + string);
                }
                return string;
            }
            if (this.request.containsHeader(HttpConstants.HDR_$WSIS)) {
                if (this.request.getHeaderAsString(HttpConstants.HDR_$WSIS).equalsIgnoreCase("true")) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getScheme isTrusted --> true containsHeader --> " + HttpConstants.HDR_$WSIS + "scheme --> https");
                    }
                    return "https";
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getScheme isTrusted --> true containsHeader --> " + HttpConstants.HDR_$WSIS + "scheme --> http");
                }
                return "http";
            }
        }
        string = this.request.getScheme();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getScheme scheme --> " + string);
        }
        return string;
    }

    public InputStream getInputStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getInputStream");
        }
        return this.bbIS;
    }

    public String getLocalAddr() {
        String string = this.isc.getLocalAddr().getHostAddress();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getLocalAddr addr --> " + string);
        }
        return string;
    }

    public String getLocalName() {
        String string = this.isc.getLocalAddr().getCanonicalHostName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getLocalName name --> " + string);
        }
        return string;
    }

    public int getLocalPort() {
        int n = this.isc.getLocalPort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getLocalPort port --> " + String.valueOf(n));
        }
        return n;
    }

    public boolean isSSL() {
        boolean bl = false;
        if (this.isTrusted()) {
            if (this.isHttpsIndicatorSecure()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "isSSL isTrusted --> true isHttpsIndicatorSecure --> true ssl --> true");
                }
                return true;
            }
            String string = this.request.getHeaderAsString(HttpConstants.HDR_$WSIS);
            if (string != null) {
                bl = string.equalsIgnoreCase("true");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "isSSL isTrusted --> true ssl --> " + bl);
                }
                return bl;
            }
        }
        bl = this.isc.isSecure();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "isSSL ssl --> " + bl);
        }
        return bl;
    }

    public byte[] getSSLSessionID() {
        byte[] byArray;
        if (this.isTrusted() && (byArray = this.request.getHeaderAsByteArray(HttpConstants.HDR_$WSSI)) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getSSLSessionID isTrusted --> true id --> " + (byArray != null ? new String(byArray) : ""));
            }
            return byArray;
        }
        if (this.isc.isSecure()) {
            byArray = this.isc.getSSLContext().getSession().getId();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getSSLSessionID isSecure --> true id --> " + (byArray != null ? new String(byArray) : ""));
            }
            return byArray;
        }
        return null;
    }

    public String getSessionID() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getSessionID id --> null");
        }
        return null;
    }

    public boolean isProxied() {
        return false;
    }

    public String getCipherSuite() {
        String string;
        if (this.isTrusted() && (string = this.request.getHeaderAsString(HttpConstants.HDR_$WSCS)) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getCipherSuite isTrusted --> true suite --> " + string);
            }
            return string;
        }
        if (this.isc.isSecure()) {
            string = this.isc.getSSLContext().getSession().getCipherSuite();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getCipherSuite isSecure --> true suite --> " + string);
            }
            return string;
        }
        return null;
    }

    public HttpRequestMessage getHttpRequest() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHttpRequest");
        }
        return this.request;
    }

    public IResponse getWCCResponse() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getWCCResponse");
        }
        return this.response;
    }

    public Cookie[] getCookies() {
        List list;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getCookies");
        }
        if ((list = this.request.getAllCookies()) == null || list.isEmpty()) {
            return null;
        }
        Cookie[] cookieArray = new Cookie[list.size()];
        list.toArray(cookieArray);
        return cookieArray;
    }

    public byte[] getCookieValue(String string) {
        return this.request.getCookieValue(string);
    }

    public List getAllCookieValues(String string) {
        return this.request.getAllCookieValues(string);
    }

    public Enumeration getHeaders(String string) {
        Vector vector = this.request.getHeaderStringValues(string);
        if (vector == null || vector.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getHeaders --> no headers");
            }
            return new ArrayEnumeration(null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaders");
        }
        return vector.elements();
    }

    public long getDateHeader(String string) {
        try {
            Date date = this.request.getHeaderAsDate(string);
            if (date == null) {
                return -1L;
            }
            long l = date.getTime();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getDateHeader name --> " + string + " time --> " + l);
            }
            return l;
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(string);
        }
    }

    public int getIntHeader(String string) {
        Integer n = this.request.getHeaderAsInteger(string);
        if (n == null) {
            return -1;
        }
        int n2 = n;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getIntHeader name --> " + string + " header --> " + n2);
        }
        return n2;
    }

    public Enumeration getHeaderNames() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderNames");
        }
        return this.request.getAllHeaders().elements();
    }

    public void clearHeaders() {
    }

    public boolean isTrusted() {
        return this.link.isTrusted();
    }

    private String armor(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-----BEGIN CERTIFICATE-----\r\n");
        for (int i = 0; i < string.length(); i += 76) {
            int n = Math.min(i + 76, string.length());
            stringBuffer.append(string.substring(i, n) + "\r\n");
        }
        stringBuffer.append("-----END CERTIFICATE-----\r\n");
        String string2 = stringBuffer.toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "armor " + string2);
        }
        return string2;
    }

    private java.security.cert.X509Certificate[] convertCertToChain(java.security.cert.X509Certificate x509Certificate) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "convertCertToChain");
        }
        java.security.cert.X509Certificate[] x509CertificateArray = null;
        if (x509Certificate != null) {
            x509CertificateArray = new java.security.cert.X509Certificate[]{x509Certificate};
        }
        return x509CertificateArray;
    }

    public java.security.cert.X509Certificate[] getPeerCertificates() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getPeerCertificate");
        }
        try {
            Object[] objectArray;
            java.security.cert.X509Certificate[] x509CertificateArray = null;
            if (this.isTrusted() && (objectArray = this.request.getHeaderAsString(HttpConstants.HDR_$WSCC)) != null) {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.armor((String)objectArray).getBytes());
                java.security.cert.X509Certificate x509Certificate = (java.security.cert.X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                x509CertificateArray = this.convertCertToChain(x509Certificate);
                return x509CertificateArray;
            }
            if (this.isc.isSecure() && (this.isc.getSSLContext().getNeedClientAuth() || this.isc.getSSLContext().getWantClientAuth())) {
                objectArray = null;
                try {
                    objectArray = this.isc.getSSLContext().getSession().getPeerCertificateChain();
                    if (objectArray != null) {
                        x509CertificateArray = this.convertCertificateChain((X509Certificate[])objectArray);
                    } else {
                        objectArray = this.isc.getSSLContext().getSession().getPeerCertificates();
                        if (objectArray != null) {
                            x509CertificateArray = (java.security.cert.X509Certificate[])objectArray;
                        }
                    }
                }
                catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                    Tr.error(tc, "unverified client certificate", sSLPeerUnverifiedException);
                }
            }
            return x509CertificateArray;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webcontainer.channel.WCCRequestImpl.getPeerCertificates", "544", this);
            Tr.error(tc, "invalid peer certificate: " + exception.getMessage());
            return null;
        }
    }

    private java.security.cert.X509Certificate[] convertCertificateChain(X509Certificate[] x509CertificateArray) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "convertCertificateChain");
        }
        java.security.cert.X509Certificate[] x509CertificateArray2 = new java.security.cert.X509Certificate[x509CertificateArray.length];
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            x509CertificateArray2[i] = (java.security.cert.X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(x509CertificateArray[i].getEncoded()));
        }
        return x509CertificateArray2;
    }

    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "destroy");
        }
        this.discard = true;
    }

    public boolean shouldDiscard() {
        return this.discard;
    }

    public int getHostHeaderPort() {
        int n;
        String string = this.request.getHeaderAsString(HttpConstants.HDR_HOST);
        if (string == null || string.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getHostHeaderPort: No host header");
            }
            return -1;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getHostHeaderPort: Host Header -> " + string);
        }
        int n2 = string.length();
        int n3 = -1;
        int n4 = -1;
        if (string.charAt(0) == '[') {
            n4 = string.indexOf(93, 0);
            if (n4 == -1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getHostHeaderPort: Invalid IPv6 address in host header");
                }
                return -1;
            }
            ++n4;
        } else {
            n4 = string.indexOf(58, 0);
        }
        if (n4 == -1 || n2 <= n4 || string.charAt(n4) != ':') {
            if (n4 != -1 && n2 > n4 && string.charAt(n4) != ':') {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getHostHeaderPort: No port in host header");
                }
                return -1;
            }
            if (HttpConstants.SCHEME_HTTP.equals(this.request.getSchemeValue())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getHostHeaderPort: No port in host header.  Using HTTP Scheme.");
                }
                n3 = 80;
            } else if (HttpConstants.SCHEME_HTTPS.equals(this.request.getSchemeValue())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getHostHeaderPort: No port in host header.  Using HTTPS Scheme.");
                }
                n3 = 443;
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getHostHeaderPort: can not set default port");
            }
            return n3;
        }
        if ((n = n2 - ++n4) <= 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getHostHeaderPort: No port after colon");
            }
            return -1;
        }
        try {
            n3 = Integer.parseInt(string.substring(n4));
            if (n3 < 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getHostHeaderPort: Invalid port value.");
                }
                return -1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getHostHeaderPort: Invalid port value. " + numberFormatException);
            }
            return -1;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getHostHeaderPort: Invalid port value. " + indexOutOfBoundsException);
            }
            return -1;
        }
        return n3;
    }
}

