/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.channel.WCCByteBufferOutputStream;
import com.ibm.ws.webcontainer.channel.WCChannelLink;
import com.ibm.ws.webcontainer.srt.http.HttpDate;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.webcontainer.IPoolable;
import com.ibm.wsspi.webcontainer.IRequest;
import com.ibm.wsspi.webcontainer.IResponse;
import com.ibm.wsspi.webcontainer.WebContainer;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.Cookie;

public class WCCResponseImpl
implements IResponse,
IPoolable {
    private static TraceComponent tc = Tr.register(WCCResponseImpl.class, "WCCResponseImpl", "com.ibm.ws.webcontainer.channel");
    private HttpResponseMessage response = null;
    private IRequest request = null;
    private WCCByteBufferOutputStream bbOS = null;
    private static String httpOnlyCookies = WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.httponlycookies");
    static HashSet httpOnlyCookiesList;
    static boolean httpOnly;
    static boolean allCookies;

    public void init(WCChannelLink wCChannelLink, HttpInboundServiceContext httpInboundServiceContext) {
        this.request = wCChannelLink.getRequest();
        this.response = httpInboundServiceContext.getResponse();
        this.bbOS = new WCCByteBufferOutputStream(httpInboundServiceContext, wCChannelLink);
    }

    public boolean finish() {
        if (this.hasContentBuffered()) {
            this.flushBufferedContent();
            return true;
        }
        return false;
    }

    public void setStatusCode(int n) {
        try {
            this.response.setStatusCode(n);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webcontainer.channel.WCCResponseImpl", "61", this);
            Tr.error(tc, "Exception setting status code: " + exception.getMessage());
        }
    }

    public void setReason(String string) {
        this.response.setReasonPhrase(string);
    }

    public void setReason(byte[] byArray) {
        this.response.setReasonPhrase(byArray);
    }

    public void addCookie(Cookie cookie) {
        if (httpOnly && (allCookies || httpOnlyCookiesList.contains(cookie.getName().toUpperCase()))) {
            cookie.setValue(cookie.getValue() + "; HTTPOnly");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "addCookie added HTTPOnly to cookie name ->[" + cookie.getName() + "]");
            }
        }
        if (cookie.getVersion() == 1) {
            this.response.setCookie(cookie, HttpConstants.HDR_SET_COOKIE2);
        }
        this.response.setCookie(cookie, HttpConstants.HDR_SET_COOKIE);
    }

    public OutputStream getOutputStream() {
        return this.bbOS;
    }

    public boolean isCommitted() {
        return false;
    }

    public HttpResponseMessage getHttpResponse() {
        return this.response;
    }

    public IRequest getWCCRequest() {
        return this.request;
    }

    public void flushBufferedContent() {
        this.bbOS.flushWriteBuffer();
    }

    public boolean hasContentBuffered() {
        return this.bbOS.hasContentBuffered();
    }

    public void setFlushMode(boolean bl) {
        this.bbOS.setFlushMode(bl);
    }

    public boolean getFlushMode() {
        return this.bbOS.getFlushMode();
    }

    public void setLastBuffer(boolean bl) {
        this.bbOS.setLastBuffer(bl);
    }

    public boolean getLastBuffer() {
        return this.bbOS.getLastBuffer();
    }

    public Cookie[] getCookies() {
        List list = this.response.getAllCookies();
        if (list == null || list.isEmpty()) {
            return null;
        }
        Cookie[] cookieArray = new Cookie[list.size()];
        list.toArray(cookieArray);
        return cookieArray;
    }

    public void addHeader(String string, String string2) {
        this.response.appendHeader(string, string2);
    }

    public void addHeader(byte[] byArray, byte[] byArray2) {
        this.response.appendHeader(byArray, byArray2);
    }

    public void addDateHeader(String string, long l) {
        this.addHeader(string, Long.toString(l));
    }

    public void addIntHeader(String string, int n) {
        this.addHeader(string, Integer.toString(n));
    }

    public void setHeader(String string, String string2) {
        this.response.setHeader(string, string2);
    }

    public void setDateHeader(String string, long l) {
        HttpDate httpDate = new HttpDate(l);
        this.setHeader(string, httpDate.toString());
    }

    public void setIntHeader(String string, int n) {
        this.setHeader(string, Integer.toString(n));
    }

    public String getHeader(String string) {
        return this.response.getHeaderAsString(string);
    }

    public Vector[] getHeaderTable() {
        Vector vector = this.response.getAllHeaders();
        Vector[] vectorArray = new Vector[]{new Vector(vector.size()), new Vector(vector.size())};
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            Vector vector2 = this.response.getHeaderStringValues(string);
            for (int j = 0; j < vector2.size(); ++j) {
                String string2 = (String)vector2.elementAt(j);
                vectorArray[0].add(string);
                vectorArray[1].add(string2);
            }
        }
        return vectorArray;
    }

    public String getHeader(byte[] byArray) {
        return this.response.getHeaderAsString(byArray);
    }

    public boolean containsHeader(String string) {
        return this.response.containsHeader(string);
    }

    public boolean containsHeader(byte[] byArray) {
        return this.response.containsHeader(byArray);
    }

    public void removeHeader(String string) {
        this.response.removeHeader(string);
    }

    public void removeHeader(byte[] byArray) {
        this.response.removeHeader(byArray);
    }

    public void prepareHeadersForWrite() {
    }

    public void writeHeaders() {
        this.bbOS.writeHeaders();
    }

    public void clearHeaders() {
        this.response.removeAllHeaders();
    }

    public void setHeader(byte[] byArray, byte[] byArray2) {
        this.response.setHeader(byArray, byArray2);
    }

    public void setContentType(String string) {
        this.response.setHeader((HeaderKeys)HttpConstants.HDR_CONTENT_TYPE, string);
    }

    public void setContentType(byte[] byArray) {
        this.response.setHeader((HeaderKeys)HttpConstants.HDR_CONTENT_TYPE, byArray);
    }

    public void setContentLanguage(String string) {
        this.response.setHeader((HeaderKeys)HttpConstants.HDR_CONTENT_LANGUAGE, string);
    }

    public void setContentLanguage(byte[] byArray) {
        this.response.setHeader((HeaderKeys)HttpConstants.HDR_CONTENT_LANGUAGE, byArray);
    }

    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "destroy");
        }
        this.bbOS = null;
        this.request = null;
        this.response = null;
    }

    public void setHadException(boolean bl) {
        this.bbOS.setHadException(bl);
    }

    public boolean getHadException() {
        return this.bbOS.getHadException();
    }

    static {
        httpOnly = false;
        allCookies = false;
        if (httpOnlyCookies != null) {
            httpOnly = true;
            if (httpOnlyCookies.equals("*")) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "httpOnly set for all cookies.");
                }
                allCookies = true;
            } else {
                String string = httpOnlyCookies;
                StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t\n\r");
                httpOnlyCookiesList = new HashSet(stringTokenizer.countTokens());
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    httpOnlyCookiesList.add(string2.toUpperCase());
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "httpOnly, added " + string2 + " to cookies list.");
                }
            }
        }
    }
}

