/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.util.ObjectPool;
import com.ibm.ws.webcontainer.channel.WCChannelLink;
import com.ibm.ws.webcontainer.channel.WCDiscriminator;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.Discriminator;
import com.ibm.wsspi.channel.base.InboundApplicationChannel;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.webcontainer.WebContainer;

public class WCChannel
extends InboundApplicationChannel {
    private static TraceComponent tc = Tr.register(WCChannel.class, "WCChannel", "com.ibm.ws.webcontainer.channel");
    private Class devSideInterface = null;
    private Discriminator disc = null;
    private ObjectPool linkPool = null;
    private int bufferSize = 32768;
    private boolean trusted = true;
    private static final String LINK_KEY = "WCChannelLink";
    private boolean trustedHostHeaderPort = false;
    private boolean writeTypeSynch = false;

    public WCChannel(ChannelData channelData) {
        super(channelData);
        this.disc = new WCDiscriminator(this, channelData.getDiscriminatorWeight());
        this.devSideInterface = HttpInboundServiceContext.class;
        this.linkPool = new ObjectPool("WCC Channel Links", 100);
        String string = WebContainer.getWebContainerProperties().getProperty("responsebuffersize");
        if (string != null) {
            try {
                this.bufferSize = Integer.parseInt(string);
            }
            catch (Exception exception) {
                Tr.error(tc, "Illegal value for ResponseBuffer: " + string);
            }
        } else {
            Integer n = (Integer)channelData.getPropertyBag().get("buffersize");
            if (n != null) {
                this.bufferSize = n;
            }
        }
        this.writeTypeSynch = (string = WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.channelwritetype")) != null && string.equalsIgnoreCase("SYNC");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Webcontainer channel created. responsebuffersize =" + this.bufferSize + ", com.ibm.ws.webcontainer.channelwritetype =" + (this.writeTypeSynch ? "Sync" : "Async"));
        }
        if ((string = (String)channelData.getPropertyBag().get("trusted")) == null) {
            string = (String)WebContainer.getWebContainerProperties().get("trusted");
        }
        this.trusted = string == null || !string.equalsIgnoreCase("false");
        string = (String)WebContainer.getWebContainerProperties().get("trusthostheaderport");
        this.trustedHostHeaderPort = string != null && string.equalsIgnoreCase("true");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WebContainer channel buffer size is " + this.bufferSize);
            Tr.debug(tc, "WebContainer channel is trusted " + this.trusted);
        }
    }

    public Discriminator getDiscriminator() {
        return this.disc;
    }

    public ConnectionLink getConnectionLink(VirtualConnection virtualConnection) {
        WCChannelLink wCChannelLink = (WCChannelLink)((Object)virtualConnection.getStateMap().get(LINK_KEY));
        if (wCChannelLink == null) {
            wCChannelLink = (WCChannelLink)((Object)this.linkPool.remove());
            if (wCChannelLink == null) {
                wCChannelLink = new WCChannelLink(virtualConnection, this);
            }
            virtualConnection.getStateMap().put(LINK_KEY, wCChannelLink);
        }
        return wCChannelLink;
    }

    public void addLinkToPool(WCChannelLink wCChannelLink) {
        this.linkPool.add((Object)wCChannelLink);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    public Class getDeviceInterface() {
        return this.devSideInterface;
    }

    public void start() throws ChannelException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WCChannel , start() issued ");
        }
    }

    public void stop(long l) throws ChannelException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WCChannel , stop() issued ");
        }
    }

    public void init() throws ChannelException {
    }

    public void destroy() throws ChannelException {
    }

    public void update(ChannelData channelData) {
    }

    public boolean isTrustedHostHeaderPort() {
        return this.trustedHostHeaderPort;
    }

    public boolean isWriteTypeSynch() {
        return this.writeTypeSynch;
    }
}

