/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.ws.webcontainer.channel.WCCRequestImpl;
import com.ibm.ws.webcontainer.channel.WCCResponseImpl;
import com.ibm.ws.webcontainer.channel.WCChannel;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.InterChannelCallback;
import com.ibm.wsspi.channel.base.InboundApplicationLink;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.webcontainer.IRequest;
import com.ibm.wsspi.webcontainer.IResponse;
import java.io.IOException;
import java.util.ArrayList;

public class WCChannelLink
extends InboundApplicationLink
implements InterChannelCallback {
    private static TraceComponent tc = Tr.register(WCChannelLink.class, "WCChannelLink", "com.ibm.ws.webcontainer.channel");
    private WCChannel channel = null;
    private WCCRequestImpl request = new WCCRequestImpl();
    private WCCResponseImpl response = new WCCResponseImpl();
    private HttpInboundServiceContext isc = null;
    private ArrayList writeQueue = new ArrayList();
    private boolean writing = false;
    private boolean writingHeaders = false;
    private boolean doClose = false;
    private boolean doFinishBuffer = false;
    private boolean doneFinishBuffer = false;
    private boolean hadError = false;
    private boolean handledError = false;
    private Exception closeException = null;
    private boolean writeTypeSynch = false;
    private int counter = 0;
    private byte writeMethod = 0;
    private boolean writeLastBuffer = false;
    private boolean allowMoreWrites = true;
    private WsByteBuffer[] lastBuffer = null;
    private static boolean suppressLastZeroBytePackage = new Boolean(WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.suppresslastzerobytepackage", "false"));
    private static boolean completeResponseEarly = new Boolean(WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.completeresponseearly", "false"));

    public WCChannelLink(VirtualConnection virtualConnection, WCChannel wCChannel) {
        this.channel = wCChannel;
    }

    public void init(VirtualConnection virtualConnection) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WCChannelLink Init vc --> " + virtualConnection.toString() + " link --> " + (Object)((Object)this));
        }
        this.isc = (HttpInboundServiceContext)this.getDeviceLink().getChannelAccessor();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "WCChannelLink Init request --> " + this.request + " response --> " + this.response);
        }
        super.init(virtualConnection);
        this.request.init(this, this.isc);
        this.response.init(this, this.isc);
        this.doClose = false;
        this.doFinishBuffer = false;
        this.doneFinishBuffer = false;
        this.lastBuffer = null;
        this.hadError = false;
        this.handledError = false;
        this.closeException = null;
        this.writing = false;
        this.writingHeaders = false;
        this.writeQueue.clear();
        this.counter = 0;
        this.writeLastBuffer = false;
        this.allowMoreWrites = true;
        this.writeTypeSynch = this.channel.isWriteTypeSynch();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WCChannelLink Init buffersize,writeType --> " + this.channel.getBufferSize() + "," + (this.writeTypeSynch ? "sync" : "async"));
        }
    }

    public void destroy(Exception exception) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "destroy --> " + exception);
        }
        super.destroy(exception);
        this.isc = null;
        this.channel.addLinkToPool(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void ready(VirtualConnection virtualConnection) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "Ready --> " + virtualConnection.toString() + " this --> " + (Object)((Object)this));
        }
        this.init(virtualConnection);
        try {
            boolean bl;
            block57: {
                block63: {
                    block64: {
                        block56: {
                            try {
                                WebContainer.getWebContainer().handleRequest((IRequest)this.request, (IResponse)this.response);
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block56;
                                Tr.debug(tc, "Ready --> handleRequest complete --> " + virtualConnection.toString() + " this --> " + (Object)((Object)this));
                            }
                            catch (IOException iOException) {
                                boolean bl3;
                                block59: {
                                    block61: {
                                        block62: {
                                            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.webcontainer.channel.WCChannelLink", "91", (Object)this);
                                            Tr.error(tc, "handleRequest threw IOException");
                                            Object var4_3 = null;
                                            bl3 = false;
                                            ArrayList arrayList3 = this.writeQueue;
                                            // MONITORENTER : arrayList3
                                            this.doFinishBuffer = true;
                                            this.request.finish();
                                            if (this.writeLastBuffer) break block61;
                                            this.response.finish();
                                            if (!this.writeQueue.isEmpty()) break block62;
                                            if (this.doFinishBuffer) {
                                                this.finishBufferResponse(null);
                                                if (this.writing) {
                                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                        Tr.debug(tc, "ready--> finishBufferAsynch went async, set doClose to true");
                                                    }
                                                    this.doClose = true;
                                                    break block59;
                                                } else {
                                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                        Tr.debug(tc, "ready--> finishBufferAsynch went sync, set doClose_now to true");
                                                    }
                                                    bl3 = true;
                                                }
                                                break block59;
                                            } else {
                                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "ready--> dofinishBuffer = false, set doClose_now to true");
                                                }
                                                bl3 = true;
                                            }
                                            break block59;
                                        }
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Buffers not empty, setting doClose to true");
                                        }
                                        this.doClose = true;
                                        break block59;
                                    }
                                    if (!this.doneFinishBuffer) {
                                        this.finishBufferResponse(this.lastBuffer);
                                    }
                                    if (this.writing) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "WCChannelLink ready writeLastBuffer is true but still writing, setting doClose to true");
                                        }
                                        this.doClose = true;
                                    } else {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "WCChannelLink ready writeLastBuffer is true, setting doClose_now to true");
                                        }
                                        bl3 = true;
                                    }
                                }
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "WCChannelLink ready request --> " + this.request + " response --> " + this.response + " this --> " + (Object)((Object)this));
                                }
                                // MONITOREXIT : arrayList3
                                if (bl3) {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Closing in ready outside lock --> " + this.vc.toString());
                                    }
                                    this.close(this.vc, this.closeException);
                                }
                            }
                        }
                        Object var4_2 = null;
                        bl = false;
                        ArrayList arrayList = this.writeQueue;
                        // MONITORENTER : arrayList
                        this.doFinishBuffer = true;
                        this.request.finish();
                        if (this.writeLastBuffer) break block63;
                        this.response.finish();
                        if (!this.writeQueue.isEmpty()) break block64;
                        if (this.doFinishBuffer) {
                            this.finishBufferResponse(null);
                            if (this.writing) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "ready--> finishBufferAsynch went async, set doClose to true");
                                }
                                this.doClose = true;
                                break block57;
                            } else {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "ready--> finishBufferAsynch went sync, set doClose_now to true");
                                }
                                bl = true;
                            }
                            break block57;
                        } else {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "ready--> dofinishBuffer = false, set doClose_now to true");
                            }
                            bl = true;
                        }
                        break block57;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Buffers not empty, setting doClose to true");
                    }
                    this.doClose = true;
                    break block57;
                }
                if (!this.doneFinishBuffer) {
                    this.finishBufferResponse(this.lastBuffer);
                }
                if (this.writing) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WCChannelLink ready writeLastBuffer is true but still writing, setting doClose to true");
                    }
                    this.doClose = true;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WCChannelLink ready writeLastBuffer is true, setting doClose_now to true");
                    }
                    bl = true;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "WCChannelLink ready request --> " + this.request + " response --> " + this.response + " this --> " + (Object)((Object)this));
            }
            // MONITOREXIT : arrayList
            if (bl) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Closing in ready outside lock --> " + this.vc.toString());
                }
                this.close(this.vc, this.closeException);
            }
        }
        catch (Throwable throwable) {
            boolean bl2;
            block60: {
                block65: {
                    block66: {
                        Object var4_4 = null;
                        bl2 = false;
                        ArrayList arrayList2 = this.writeQueue;
                        // MONITORENTER : arrayList2
                        this.doFinishBuffer = true;
                        this.request.finish();
                        if (this.writeLastBuffer) break block65;
                        this.response.finish();
                        if (!this.writeQueue.isEmpty()) break block66;
                        if (this.doFinishBuffer) {
                            this.finishBufferResponse(null);
                            if (this.writing) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "ready--> finishBufferAsynch went async, set doClose to true");
                                }
                                this.doClose = true;
                                break block60;
                            } else {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "ready--> finishBufferAsynch went sync, set doClose_now to true");
                                }
                                bl2 = true;
                            }
                            break block60;
                        } else {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "ready--> dofinishBuffer = false, set doClose_now to true");
                            }
                            bl2 = true;
                        }
                        break block60;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Buffers not empty, setting doClose to true");
                    }
                    this.doClose = true;
                    break block60;
                }
                if (!this.doneFinishBuffer) {
                    this.finishBufferResponse(this.lastBuffer);
                }
                if (this.writing) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WCChannelLink ready writeLastBuffer is true but still writing, setting doClose to true");
                    }
                    this.doClose = true;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WCChannelLink ready writeLastBuffer is true, setting doClose_now to true");
                    }
                    bl2 = true;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "WCChannelLink ready request --> " + this.request + " response --> " + this.response + " this --> " + (Object)((Object)this));
            }
            // MONITOREXIT : arrayList2
            if (!bl2) throw throwable;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Closing in ready outside lock --> " + this.vc.toString());
            }
            this.close(this.vc, this.closeException);
            throw throwable;
        }
        if (!TraceComponent.isAnyTracingEnabled()) return;
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "Ready");
    }

    public void writeHeaders() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "writeHeaders");
        }
        this.writeLastBuffer = this.response.getLastBuffer();
        if (this.writeLastBuffer) {
            if (tc.isDebugEnabled() && this.writeLastBuffer) {
                Tr.debug(tc, "writeBuffer | writeLastBuffer -> " + this.writeLastBuffer);
            }
            if (completeResponseEarly) {
                this.finishBufferResponse(null);
            } else {
                this.allowMoreWrites = false;
            }
        } else {
            this.writing = true;
            this.writingHeaders = true;
            try {
                VirtualConnection virtualConnection = this.isc.sendResponseHeaders(this, false);
                if (virtualConnection != null) {
                    this.complete(virtualConnection);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webcontainer.channel.WCChannelLink", "148", (Object)this);
                Tr.error(tc, "Exception in writeBufferAsynch: " + exception.getMessage());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "writeHeaders");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBuffer(WsByteBuffer[] wsByteBufferArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "writeBuffer");
        }
        ArrayList arrayList = this.writeQueue;
        synchronized (arrayList) {
            if (!this.allowMoreWrites) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.exit(tc, "writeBuffer: response already completed, ignore subsequent output");
                }
                this.releaseByteBuffers(wsByteBufferArray);
                return;
            }
            if (this.hadError) {
                if (this.handledError) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.exit(tc, "writeBuffer: already handled error");
                    }
                    return;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error state, ignoring servlet write buffers");
                }
                this.releaseByteBuffers(wsByteBufferArray);
                this.handledError = true;
                this.complete(this.getVirtualConnection());
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "writeBuffer");
                }
                return;
            }
            if (this.writeQueue.isEmpty() && !this.writing) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Direct write");
                }
                this.writeQueue.add(wsByteBufferArray);
                this.writeLastBuffer = this.response.getLastBuffer();
                if (tc.isDebugEnabled() && this.writeLastBuffer) {
                    Tr.debug(tc, "writeBuffer | writeLastBuffer -> " + this.writeLastBuffer);
                }
                if (this.doFinishBuffer) {
                    this.finishBufferResponse(wsByteBufferArray);
                } else if (this.writeLastBuffer) {
                    if (completeResponseEarly) {
                        this.finishBufferResponse(wsByteBufferArray);
                    } else {
                        this.allowMoreWrites = false;
                        this.lastBuffer = wsByteBufferArray;
                    }
                } else {
                    this.writeBufferResponse(wsByteBufferArray);
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "writeBuffer, Adding to queue, writeQueue size->" + this.writeQueue.size());
                }
                this.writeQueue.add(wsByteBufferArray);
                this.writeLastBuffer = false;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "writeBuffer");
        }
    }

    private void writeBufferResponse(WsByteBuffer[] wsByteBufferArray) {
        if (this.writeTypeSynch) {
            this.writeBufferSynch(wsByteBufferArray);
        } else {
            this.writeBufferAsynch(wsByteBufferArray);
        }
    }

    private void writeBufferAsynch(WsByteBuffer[] wsByteBufferArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "writeBufferAsynch");
        }
        this.writing = true;
        boolean bl = false;
        try {
            VirtualConnection virtualConnection;
            if (this.counter >= 10) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Now at 10 nested calls to writeBufferAsynch  - force an asynch write");
                }
                bl = true;
            }
            if ((virtualConnection = this.isc.sendResponseBody(wsByteBufferArray, this, bl)) != null) {
                ++this.counter;
                this.complete(virtualConnection);
            }
            this.counter = 0;
        }
        catch (Exception exception) {
            this.error(this.getVirtualConnection(), exception);
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webcontainer.channel.WCChannelLink", "148", (Object)this);
            Tr.error(tc, "Exception in writeBufferAsynch: " + exception.getMessage());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "writeBufferAsynch");
        }
    }

    private void writeBufferSynch(WsByteBuffer[] wsByteBufferArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeBufferSynch");
        }
        this.writing = true;
        try {
            this.isc.sendResponseBody(wsByteBufferArray);
            this.complete(null);
        }
        catch (IOException iOException) {
            this.error(this.getVirtualConnection(), iOException);
        }
        catch (Exception exception) {
            this.error(this.getVirtualConnection(), exception);
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webcontainer.channel.WCChannelLink", "148", (Object)this);
            Tr.error(tc, "Exception in writeBufferSynch: " + exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeBufferSynch");
        }
    }

    private void finishBufferResponse(WsByteBuffer[] wsByteBufferArray) {
        if (suppressLastZeroBytePackage && this.response.getHadException() && this.response.getHttpResponse().isChunkedEncodingSet()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "finishBufferResponse, suppressing last zero byte package");
            }
            Exception exception = new Exception("Artificial exception to suppress the last 0-byte");
            this.error(this.getVirtualConnection(), exception);
        } else {
            this.allowMoreWrites = false;
            this.doneFinishBuffer = true;
            if (this.writeTypeSynch) {
                this.finishBufferSynch(wsByteBufferArray);
            } else {
                this.finishBufferAsynch(wsByteBufferArray);
            }
        }
        this.doFinishBuffer = false;
    }

    private void finishBufferAsynch(WsByteBuffer[] wsByteBufferArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finishBufferAsync");
        }
        this.writing = true;
        try {
            VirtualConnection virtualConnection = null;
            virtualConnection = this.isc.finishResponseMessage(wsByteBufferArray, this, false);
            if (virtualConnection != null) {
                this.complete(virtualConnection);
            }
        }
        catch (Exception exception) {
            this.error(this.getVirtualConnection(), exception);
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webcontainer.channel.WCChannelLink", "166", (Object)this);
            Tr.error(tc, "Exception in finishBufferAsynch: " + exception.getMessage());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "finishBufferAsynch");
        }
    }

    private void finishBufferSynch(WsByteBuffer[] wsByteBufferArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "finishBufferSynch");
        }
        this.writing = true;
        try {
            this.isc.finishResponseMessage(wsByteBufferArray);
            this.complete(null);
        }
        catch (IOException iOException) {
            this.error(this.getVirtualConnection(), iOException);
        }
        catch (Exception exception) {
            this.error(this.getVirtualConnection(), exception);
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webcontainer.channel.WCChannelLink", "166", (Object)this);
            Tr.error(tc, "Exception in finishBufferSynch: " + exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "finishBufferSynch");
        }
    }

    public WCChannel getChannel() {
        return this.channel;
    }

    public WCCResponseImpl getResponse() {
        return this.response;
    }

    public WCCRequestImpl getRequest() {
        return this.request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(VirtualConnection virtualConnection) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "Complete callback --> " + (virtualConnection == null ? "null" : virtualConnection.toString()));
        }
        boolean bl = false;
        ArrayList arrayList = this.writeQueue;
        synchronized (arrayList) {
            WsByteBuffer[] wsByteBufferArray;
            if (this.writingHeaders) {
                this.writingHeaders = false;
            } else if (!this.writeQueue.isEmpty()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Complete, remove the old byte buffer");
                }
                wsByteBufferArray = (WsByteBuffer[])this.writeQueue.remove(0);
                this.releaseByteBuffers(wsByteBufferArray);
            }
            if (this.writeQueue.isEmpty()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Complete, write queue is empty");
                }
                this.writing = false;
                if (this.doClose) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Indicate close to be called --> " + (virtualConnection == null ? "null" : virtualConnection.toString()));
                    }
                    bl = true;
                    this.doClose = false;
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Complete, write queue is not empty, do another write");
                }
                wsByteBufferArray = (WsByteBuffer[])this.writeQueue.get(0);
                if (this.doFinishBuffer && this.writeQueue.size() == 1) {
                    this.finishBufferResponse(wsByteBufferArray);
                } else {
                    this.writeBufferResponse(wsByteBufferArray);
                }
            }
        }
        if (bl) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Closing in complete outside lock --> " + (virtualConnection == null ? "null" : virtualConnection.toString()));
            }
            bl = false;
            this.close(virtualConnection, this.closeException);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "Complete callback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(VirtualConnection virtualConnection, Throwable throwable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "Error callback --> " + virtualConnection.toString() + " exception --> " + throwable.getMessage());
        }
        boolean bl = false;
        ArrayList arrayList = this.writeQueue;
        synchronized (arrayList) {
            this.hadError = true;
            this.writing = false;
            while (!this.writeQueue.isEmpty()) {
                WsByteBuffer[] wsByteBufferArray = (WsByteBuffer[])this.writeQueue.remove(0);
                this.releaseByteBuffers(wsByteBufferArray);
            }
            this.closeException = (Exception)throwable;
            if (this.doClose) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Closing in error --> " + virtualConnection.toString());
                }
                bl = true;
                this.doClose = false;
            }
        }
        if (bl) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Closing in error --> " + virtualConnection.toString());
            }
            bl = false;
            this.close(virtualConnection, this.closeException);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "Error callback");
        }
    }

    private void releaseByteBuffers(WsByteBuffer[] wsByteBufferArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "releaseByteBuffers, buffer array length->" + wsByteBufferArray.length);
        }
        for (int i = 0; i < wsByteBufferArray.length; ++i) {
            if (wsByteBufferArray[i] != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "releaseByteBuffers, releasing" + wsByteBufferArray[i]);
                }
            } else {
                return;
            }
            wsByteBufferArray[i].clear();
            wsByteBufferArray[i].release();
        }
    }

    public void close(VirtualConnection virtualConnection, Exception exception) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "close ");
        }
        if (this.request.shouldDiscard()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "discarding WCCRequestImpl");
            }
            this.request = null;
            this.request = new WCCRequestImpl();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "discarding WCCResponseImpl");
            }
            this.response = null;
            this.response = new WCCResponseImpl();
        }
        super.close(virtualConnection, exception);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "Close");
        }
    }

    public boolean isTrusted() {
        return this.channel.isTrusted();
    }

    public boolean handledError() {
        return this.handledError;
    }

    public Exception getCloseException() {
        return this.closeException;
    }

    public boolean isTrustedHostHeaderPort() {
        return this.channel.isTrustedHostHeaderPort();
    }

    public void setWriteMethod(byte by) {
        this.writeMethod = by;
    }
}

