/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscbnd.ClientBinding;
import com.ibm.etools.webservice.wscbnd.ComponentScopedRefs;
import com.ibm.etools.webservice.wscbnd.ServiceRef;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.websphere.management.application.client.AppDeploymentTaskValidate;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.webservices.deploy.ClientBindDeployedWSDL;
import com.ibm.ws.webservices.deploy.WSBindingsFileAccessor;
import com.ibm.ws.webservices.deploy.WSDeploymentDescriptorAccessor;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class ClientBindDeployedWSDLTaskHelper
implements AppDeploymentTaskHelper,
AppDeploymentTaskValidate {
    private static TraceComponent tc = Tr.register(ClientBindDeployedWSDLTaskHelper.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");
    protected String[] taskValidateErrorMessages = null;

    public AppDeploymentTask createTask(AppDeploymentController appDeploymentController, String string) {
        return new ClientBindDeployedWSDL(appDeploymentController);
    }

    public void prepareTask(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask");
        }
        if (appDeploymentTask.getTaskData() != null) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        String[] stringArray = appDeploymentTask.getColumnNames();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.addElement(stringArray[i]);
        }
        Vector vector2 = appDeploymentInfo.getModuleConfig("JAR_DD");
        Vector vector3 = appDeploymentInfo.getModuleConfig("WAR_DD");
        Vector vector4 = new Vector();
        vector4.addAll(vector2);
        vector4.addAll(vector3);
        boolean bl = false;
        boolean bl2 = false;
        String[][] stringArray2 = vector4.iterator();
        while (stringArray2.hasNext()) {
            WSDeploymentDescriptorAccessor wSDeploymentDescriptorAccessor;
            EObject eObject = (EObject)stringArray2.next();
            String string = util.formUriString(appDeploymentInfo, eObject);
            String[] stringArray3 = util.separateUriString(string);
            String string2 = stringArray3[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "prepareTask: working on module " + string);
            }
            if ((wSDeploymentDescriptorAccessor = new WSDeploymentDescriptorAccessor(eObject, appDeploymentInfo, appDeploymentTask)).isModuleWebServiceEnabledClient()) {
                EList eList;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "prepareTask: module " + string + " is Web Service enabled");
                }
                bl = true;
                WSBindingsFileAccessor wSBindingsFileAccessor = new WSBindingsFileAccessor(eObject, string, appDeploymentTask, appDeploymentInfo);
                ClientBinding clientBinding = wSBindingsFileAccessor.getClientBinding();
                if (clientBinding == null) continue;
                String string3 = "";
                if (wSBindingsFileAccessor.isWebType(null)) {
                    eList = clientBinding.getServiceRefs();
                    if (eList == null || eList.isEmpty()) continue;
                    bl2 = this.fillServicesRows(vector, string2, string3, eList);
                    continue;
                }
                eList = clientBinding.getComponentScopedRefs();
                if (eList == null || eList.isEmpty()) continue;
                int n = eList.size();
                for (int i = 0; i < n; ++i) {
                    ComponentScopedRefs componentScopedRefs = (ComponentScopedRefs)eList.get(i);
                    string3 = componentScopedRefs.getComponentNameLink();
                    EList eList2 = componentScopedRefs.getServiceRefs();
                    if (eList2 == null || eList2.isEmpty()) continue;
                    bl2 = this.fillServicesRows(vector, string2, string3, eList2);
                }
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "prepareTask: module " + string + " is NOT Web Service enabled");
        }
        if (bl) {
            if (!bl2) {
                for (int i = 0; i < stringArray.length; ++i) {
                    vector.addElement("");
                }
            }
            stringArray2 = util.buildTaskData(vector, stringArray.length);
            appDeploymentTask.setTaskData(stringArray2);
        } else {
            stringArray2 = null;
            appDeploymentTask.setTaskData(stringArray2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    private boolean fillServicesRows(Vector vector, String string, String string2, EList eList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fillServicesRows", new Object[]{string, string2});
        }
        int n = eList.size();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            ServiceRef serviceRef = (ServiceRef)eList.get(i);
            String string3 = serviceRef.getServiceRefLink();
            String string4 = serviceRef.getDeployedWSDLFile();
            if (string4 == null) {
                string4 = "";
            }
            vector.addElement(string);
            vector.addElement(string2);
            vector.addElement(string3);
            vector.addElement(string4);
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fillServicesRows", new Boolean(bl));
        }
        return bl;
    }

    public void completeTask(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask");
        }
        if (!appDeploymentTask.isTaskEmpty() && !appDeploymentTask.isTaskDisabled()) {
            Hashtable hashtable = appDeploymentInfo.getAppOptions();
            String[][] stringArray = appDeploymentTask.getTaskData();
            Vector vector = appDeploymentInfo.getModuleConfig("JAR_DD");
            Vector vector2 = appDeploymentInfo.getModuleConfig("WAR_DD");
            Vector vector3 = new Vector();
            vector3.addAll(vector);
            vector3.addAll(vector2);
            Iterator iterator = vector3.iterator();
            while (iterator.hasNext()) {
                EList eList;
                WSBindingsFileAccessor wSBindingsFileAccessor;
                ClientBinding clientBinding;
                WSDeploymentDescriptorAccessor wSDeploymentDescriptorAccessor;
                EObject eObject = (EObject)iterator.next();
                String string = util.formUriString(appDeploymentInfo, eObject);
                String[] stringArray2 = util.separateUriString(string);
                String string2 = stringArray2[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "completeTask: working on module " + string);
                }
                if (!(wSDeploymentDescriptorAccessor = new WSDeploymentDescriptorAccessor(eObject, appDeploymentInfo, appDeploymentTask)).isModuleWebServiceEnabledClient()) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "completeTask: module " + string + " is Web Service enabled");
                }
                if ((clientBinding = (wSBindingsFileAccessor = new WSBindingsFileAccessor(eObject, string, appDeploymentTask, appDeploymentInfo)).getClientBinding()) == null) continue;
                String string3 = "";
                if (wSBindingsFileAccessor.isWebType(null)) {
                    eList = clientBinding.getServiceRefs();
                    if (eList == null || eList.isEmpty()) continue;
                    this.searchServicesAndSetDeployedWsdl(string2, string3, eList, stringArray);
                    continue;
                }
                eList = clientBinding.getComponentScopedRefs();
                if (eList == null || eList.isEmpty()) continue;
                int n = eList.size();
                for (int i = 0; i < n; ++i) {
                    ComponentScopedRefs componentScopedRefs = (ComponentScopedRefs)eList.get(i);
                    string3 = componentScopedRefs.getComponentNameLink();
                    EList eList2 = componentScopedRefs.getServiceRefs();
                    if (eList2 == null || eList2.isEmpty()) continue;
                    this.searchServicesAndSetDeployedWsdl(string2, string3, eList2, stringArray);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }

    private void searchServicesAndSetDeployedWsdl(String string, String string2, EList eList, String[][] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "searchServicesAndSetDeployedWsdl", new Object[]{string, string2});
        }
        int n = eList.size();
        int n2 = stringArray.length - 1;
        block0: for (int i = 0; i < n; ++i) {
            ServiceRef serviceRef = (ServiceRef)eList.get(i);
            String string3 = serviceRef.getServiceRefLink();
            String string4 = serviceRef.getDeployedWSDLFile();
            if (string4 == null) {
                string4 = "";
            }
            for (int j = 1; j < stringArray.length; ++j) {
                String string5;
                String[] stringArray2 = stringArray[j];
                if (!string.equals(stringArray2[0]) || !string2.equals(stringArray2[1]) || !string3.equals(stringArray2[2]) || (string5 = stringArray2[3]) == null && string5.equals("")) continue;
                if (string5.equals(" ")) {
                    serviceRef.eUnset(serviceRef.eClass().getEStructuralFeature("deployedWSDLFile"));
                    continue block0;
                }
                if (string4.equals(string5)) continue;
                serviceRef.setDeployedWSDLFile(string5);
                continue block0;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "searchServicesAndSetDeployedWsdl");
        }
    }

    public String[] validate(AppDeploymentTask appDeploymentTask, AppDeploymentInfo appDeploymentInfo) throws AppDeploymentException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        Vector<String> vector = new Vector<String>();
        String[][] stringArray = appDeploymentTask.getTaskData();
        for (n = 1; stringArray != null && n < stringArray.length; ++n) {
            InputStream inputStream = null;
            String string = stringArray[n][3];
            if (string == null || string.equals("") || string.equals(" ")) continue;
            try {
                inputStream = appDeploymentInfo.getInputStream(stringArray[n][0], stringArray[n][3]);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.deploy.ClientBindDeployedWSDLTaskHelper.validate", "429", this);
            }
            if (inputStream == null) {
                Object[] objectArray = new Object[]{string, stringArray[n][0]};
                String string2 = MessageFormat.format(util.getMessage(appDeploymentTask, "WSWS0058E"), objectArray);
                vector.addElement(string2);
                continue;
            }
            try {
                inputStream.close();
                continue;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.deploy.ClientBindDeployedWSDLTaskHelper.validate", "451", this);
            }
        }
        this.buildErrorMessages(vector);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ClientBindDeployedWSDLTaskHelper validate taskValidateErrorMessages");
            if (this.taskValidateErrorMessages != null && this.taskValidateErrorMessages.length > 0) {
                for (n = 0; n < this.taskValidateErrorMessages.length; ++n) {
                    Tr.exit(tc, "errors[" + n + "]=" + this.taskValidateErrorMessages[n]);
                }
            }
        }
        return this.taskValidateErrorMessages;
    }

    private void buildErrorMessages(Vector vector) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ClientBindDeployedWSDLTaskHelper buildErrorMessages");
        }
        this.taskValidateErrorMessages = null;
        if (vector != null && vector.size() > 0) {
            this.taskValidateErrorMessages = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                this.taskValidateErrorMessages[i] = (String)vector.elementAt(i);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ClientBindDeployedWSDLTaskHelper buildErrorMessages");
        }
    }
}

