/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscbnd.ClientBinding;
import com.ibm.etools.webservice.wscbnd.ComponentScopedRefs;
import com.ibm.etools.webservice.wscbnd.DefaultMapping;
import com.ibm.etools.webservice.wscbnd.ServiceRef;
import com.ibm.etools.webservice.wscbnd.WscbndPackage;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.webservices.deploy.ClientBindPreferredPort;
import com.ibm.ws.webservices.deploy.WSBindingsFileAccessor;
import com.ibm.ws.webservices.deploy.WSDeploymentDescriptorAccessor;
import com.ibm.ws.webservices.modutils.ClientBndUtil;
import com.ibm.ws.webservices.modutils.ModuleServiceRefAccessor;
import com.ibm.ws.webservices.modutils.ModuleServiceRefAccessorFactory;
import com.ibm.ws.webservices.modutils.PreferredPortDescriptor;
import com.ibm.ws.webservices.modutils.WSDLPPMapper;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;

public class ClientBindPreferredPortTaskHelper
implements AppDeploymentTaskHelper {
    private static TraceComponent tc = Tr.register(ClientBindPreferredPortTaskHelper.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");
    private AppDeploymentTask task = null;
    private AppDeploymentInfo appDeploymentInfo = null;

    public AppDeploymentTask createTask(AppDeploymentController appDeploymentController, String string) {
        return new ClientBindPreferredPort(appDeploymentController);
    }

    public void prepareTask(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        this.appDeploymentInfo = appDeploymentInfo;
        this.task = appDeploymentTask;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask");
        }
        if (appDeploymentTask.getTaskData() != null) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        String[] stringArray = appDeploymentTask.getColumnNames();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.addElement(stringArray[i]);
        }
        Vector vector2 = appDeploymentInfo.getModuleConfig("JAR_DD");
        Vector vector3 = appDeploymentInfo.getModuleConfig("WAR_DD");
        Vector vector4 = new Vector();
        vector4.addAll(vector2);
        vector4.addAll(vector3);
        boolean bl = false;
        boolean bl2 = false;
        String[][] stringArray2 = vector4.iterator();
        while (stringArray2.hasNext()) {
            EObject eObject = (EObject)stringArray2.next();
            String string = util.formUriString(appDeploymentInfo, eObject);
            WSDeploymentDescriptorAccessor wSDeploymentDescriptorAccessor = new WSDeploymentDescriptorAccessor(eObject, appDeploymentInfo, appDeploymentTask);
            if (wSDeploymentDescriptorAccessor.isModuleWebServiceEnabledClient()) {
                EList eList;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "prepareTask: module " + string + " is Web Service enabled");
                }
                bl = true;
                WSBindingsFileAccessor wSBindingsFileAccessor = new WSBindingsFileAccessor(eObject, string, appDeploymentTask, appDeploymentInfo);
                ClientBinding clientBinding = wSBindingsFileAccessor.getClientBinding();
                if (clientBinding == null) continue;
                String string2 = null;
                if (wSBindingsFileAccessor.isWebType(null)) {
                    eList = clientBinding.getServiceRefs();
                    if (eList == null || eList.isEmpty()) continue;
                    bl2 = this.fillServicesRows(vector, eObject, clientBinding, string2, eList);
                    continue;
                }
                eList = clientBinding.getComponentScopedRefs();
                if (eList == null || eList.isEmpty()) continue;
                int n = eList.size();
                for (int i = 0; i < n; ++i) {
                    ComponentScopedRefs componentScopedRefs = (ComponentScopedRefs)eList.get(i);
                    string2 = componentScopedRefs.getComponentNameLink();
                    EList eList2 = componentScopedRefs.getServiceRefs();
                    if (eList2 == null || eList2.isEmpty()) continue;
                    bl2 = this.fillServicesRows(vector, eObject, clientBinding, string2, eList2);
                }
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "prepareTask: module " + string + " is NOT Web Service enabled");
        }
        if (bl) {
            if (!bl2) {
                for (int i = 0; i < stringArray.length; ++i) {
                    vector.addElement("");
                }
            }
            stringArray2 = util.buildTaskData(vector, stringArray.length);
            appDeploymentTask.setTaskData(stringArray2);
        } else {
            stringArray2 = null;
            appDeploymentTask.setTaskData(stringArray2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    private boolean fillServicesRows(Vector vector, EObject eObject, ClientBinding clientBinding, String string, EList eList) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fillServicesRows");
        }
        int n = eList.size();
        boolean bl = false;
        String string2 = util.formUriString(this.appDeploymentInfo, eObject);
        String[] stringArray = util.separateUriString(string2);
        String string3 = stringArray[0];
        ModuleFile moduleFile = this.appDeploymentInfo.getModuleFileForDD(eObject);
        for (int i = 0; i < n; ++i) {
            Object object;
            Object[] objectArray;
            ServiceRef serviceRef = (ServiceRef)eList.get(i);
            String string4 = serviceRef.getServiceRefLink();
            HashMap hashMap = this.generatePreferredPortMapping(moduleFile, clientBinding, string4, string);
            if (hashMap.isEmpty()) {
                objectArray = new Object[]{string3, string4};
                object = MessageFormat.format(util.getMessage(this.task, "WSWS0052E"), objectArray);
                if (tc.isEntryEnabled()) {
                    Tr.error(tc, "WSWS0052E", objectArray);
                }
            }
            objectArray = serviceRef.getDefaultMappings();
            object = objectArray.iterator();
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string5 = (String)iterator.next();
                PreferredPortDescriptor preferredPortDescriptor = (PreferredPortDescriptor)hashMap.get(string5);
                String string6 = preferredPortDescriptor.getPortPreferred();
                if (string6 == null) {
                    string6 = "";
                }
                vector.addElement(string3);
                if (string == null) {
                    vector.addElement("");
                } else {
                    vector.addElement(string);
                }
                vector.addElement(string4);
                vector.addElement(string5);
                vector.addElement(string6);
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fillServicesRows");
        }
        return bl;
    }

    public void completeTask(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask");
        }
        this.task = appDeploymentTask;
        this.appDeploymentInfo = appDeploymentInfo;
        if (!appDeploymentTask.isTaskEmpty() && !appDeploymentTask.isTaskDisabled()) {
            Hashtable hashtable = appDeploymentInfo.getAppOptions();
            String[][] stringArray = appDeploymentTask.getTaskData();
            Vector vector = appDeploymentInfo.getModuleConfig("JAR_DD");
            Vector vector2 = appDeploymentInfo.getModuleConfig("WAR_DD");
            Vector vector3 = new Vector();
            vector3.addAll(vector);
            vector3.addAll(vector2);
            Iterator iterator = vector3.iterator();
            while (iterator.hasNext()) {
                EList eList;
                WSDeploymentDescriptorAccessor wSDeploymentDescriptorAccessor;
                EObject eObject = (EObject)iterator.next();
                String string = util.formUriString(appDeploymentInfo, eObject);
                String[] stringArray2 = util.separateUriString(string);
                String string2 = stringArray2[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "completeTask: working on module " + string);
                }
                if (!(wSDeploymentDescriptorAccessor = new WSDeploymentDescriptorAccessor(eObject, appDeploymentInfo, appDeploymentTask)).isModuleWebServiceEnabledClient()) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "completeTask: module " + string + " is Web Service enabled");
                }
                WSBindingsFileAccessor wSBindingsFileAccessor = new WSBindingsFileAccessor(eObject, string, appDeploymentTask, appDeploymentInfo);
                ClientBinding clientBinding = wSBindingsFileAccessor.getClientBinding();
                ModuleFile moduleFile = appDeploymentInfo.getModuleFileForDD(eObject);
                if (clientBinding == null) continue;
                String string3 = "";
                if (wSBindingsFileAccessor.isWebType(null)) {
                    eList = clientBinding.getServiceRefs();
                    if (eList == null || eList.isEmpty()) continue;
                    this.searchServicesAndSetPreferredPort(string2, moduleFile, clientBinding, string3, eList, stringArray);
                    continue;
                }
                eList = clientBinding.getComponentScopedRefs();
                if (eList == null || eList.isEmpty()) continue;
                int n = eList.size();
                for (int i = 0; i < n; ++i) {
                    ComponentScopedRefs componentScopedRefs = (ComponentScopedRefs)eList.get(i);
                    string3 = componentScopedRefs.getComponentNameLink();
                    EList eList2 = componentScopedRefs.getServiceRefs();
                    if (eList2 == null || eList2.isEmpty()) continue;
                    this.searchServicesAndSetPreferredPort(string2, moduleFile, clientBinding, string3, eList2, stringArray);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }

    private void searchServicesAndSetPreferredPort(String string, ModuleFile moduleFile, ClientBinding clientBinding, String string2, EList eList, String[][] stringArray) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "searchServicesAndSetPreferredPort for module " + string);
        }
        int n = eList.size();
        for (int i = 0; i < n; ++i) {
            ServiceRef serviceRef = (ServiceRef)eList.get(i);
            String string3 = serviceRef.getServiceRefLink();
            HashMap hashMap = new HashMap();
            for (int j = 1; j < stringArray.length; ++j) {
                Object object;
                QName qName;
                String string4;
                String string5;
                Object object2;
                String[] stringArray2 = stringArray[j];
                if (!string.equals(stringArray2[0]) || !string2.equals(stringArray2[1]) || !string3.equals(stringArray2[2])) continue;
                boolean bl = false;
                String string6 = stringArray2[3];
                String string7 = stringArray2[4];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating QName, QName.valueOf(" + string7 + ");");
                }
                if (string7 == null || string7.equals("")) continue;
                QName qName2 = QName.valueOf(string7);
                EList eList2 = serviceRef.getDefaultMappings();
                Iterator iterator = eList2.iterator();
                if (iterator != null) {
                    while (iterator.hasNext()) {
                        object2 = (DefaultMapping)iterator.next();
                        string5 = object2.getPortTypeLocalName();
                        string4 = object2.getPortTypeNamespace();
                        qName = new QName(string4, string5);
                        if (!qName.toString().equals(string6)) continue;
                        if (string7.equals(" ")) {
                            eList2.remove(object2);
                        } else {
                            if (hashMap.isEmpty()) {
                                hashMap = this.generatePreferredPortMapping(moduleFile, clientBinding, string3, string2);
                            }
                            if (WSDLPPMapper.validPreferredPort(hashMap, string6, string7)) {
                                object2.setPortNamespace(qName2.getNamespaceURI());
                                object2.setPortLocalName(qName2.getLocalPart());
                            } else {
                                object = "";
                                if (!string2.equals("")) {
                                    object = ", ejb " + string2;
                                }
                                Object[] objectArray = new Object[]{string7, string6, string3, string, object};
                                String string8 = MessageFormat.format(util.getMessage(this.task, "WSWS0053E"), objectArray);
                                if (tc.isEntryEnabled()) {
                                    Tr.error(tc, "WSWS0053E", objectArray);
                                }
                                throw new AppDeploymentException(string8, null);
                            }
                        }
                        bl = true;
                        break;
                    }
                }
                if (bl || string7.equals(" ")) continue;
                object2 = "http://www.ibm.com/websphere/appserver/schemas/5.0.2/wscbnd.xmi";
                string5 = (WscbndPackage)EPackage.Registry.INSTANCE.getEPackage((String)object2);
                string4 = string5.getWscbndFactory();
                qName = string4.createDefaultMapping();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating QName, QName.valueOf(" + string6 + ");");
                }
                object = QName.valueOf(string6);
                qName.setPortTypeNamespace(((QName)object).getNamespaceURI());
                qName.setPortTypeLocalName(((QName)object).getLocalPart());
                qName.setPortNamespace(qName2.getNamespaceURI());
                qName.setPortLocalName(qName2.getLocalPart());
                if (eList2.isEmpty()) {
                    eList2.add((Object)qName);
                    continue;
                }
                eList2.set(0, (Object)qName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "searchServicesAndSetPreferredPort");
        }
    }

    private HashMap generatePreferredPortMapping(ModuleFile moduleFile, ClientBinding clientBinding, String string, String string2) throws AppDeploymentException {
        HashMap hashMap = new HashMap();
        ModuleServiceRefAccessor moduleServiceRefAccessor = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generatePreferredPortMapping for " + string);
        }
        String string3 = null;
        ClientBndUtil clientBndUtil = new ClientBndUtil(clientBinding);
        if (clientBndUtil != null) {
            Object object;
            string3 = clientBndUtil.getDeployedWSDL(string, string2);
            if (string3 == null) {
                object = moduleFile.getLoadStrategy().getResourceSet();
                moduleServiceRefAccessor = string2 != null && !string2.equals("") ? ModuleServiceRefAccessorFactory.createModuleServiceRefAccessorEJB(object, null, string2) : ModuleServiceRefAccessorFactory.createModuleServiceRefAccessorWeb(object, null);
                if (moduleServiceRefAccessor != null) {
                    string3 = moduleServiceRefAccessor.getWsdlFilename(string);
                }
            }
            if (string3 != null) {
                LoadStrategy loadStrategy;
                WSDLPPMapper wSDLPPMapper;
                object = null;
                try {
                    object = this.appDeploymentInfo.getInputStream(moduleFile.getOriginalURI(), string3);
                }
                catch (AppDeploymentException appDeploymentException) {
                    // empty catch block
                }
                if (object != null && (wSDLPPMapper = new WSDLPPMapper(string3, (InputStream)object, loadStrategy = moduleFile.getLoadStrategy())) != null) {
                    wSDLPPMapper.setNoneValue("");
                    hashMap = wSDLPPMapper.getPreferredPortMap(string);
                    if (clientBndUtil != null) {
                        clientBndUtil.setupPreferredPortMappings(hashMap, string, string2);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generatePreferredPortMapping");
        }
        return hashMap;
    }
}

