/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.dispatchers.ejb;

import com.ibm.ejs.container.EJSDeployedSupport;
import com.ibm.ejs.container.EJSLocalWrapper;
import com.ibm.ejs.container.util.DeploymentUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.ejb.EnterpriseBean;

public class WSEJBWrapper
extends EJSLocalWrapper {
    private static final TraceComponent _tc = Tr.register(WSEJBWrapper.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.webservices.resources.webservicesMessages");
    private static final String D_OPERATION_OPTION_EJB_METHODIDX = "operation.ejbMethodIdx";
    public static final String D_MSGCONTEXT_OPTION_EJS = "context.ejs";
    private static final String noTtoWebServicesFault00 = "Mapping Exception to WebServicesFault: ";
    private static final String WSEJBWRAPPER_MESSAGEINDEX = "wsejbwrapper.messageIndex";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnterpriseBean preInvoke(MessageContext messageContext) throws Throwable {
        OperationDesc operationDesc = messageContext.getOperation();
        if (operationDesc == null) {
            Tr.error(_tc, "WSEJBWrapper::preInvoke did not find an OperationDesc!");
            throw WebServicesFault.makeFault(new Throwable("An OperationDesc was not found"));
        }
        int n = this.getMethodIdx(operationDesc);
        messageContext.setProperty(WSEJBWRAPPER_MESSAGEINDEX, new Integer(n));
        EnterpriseBean enterpriseBean = null;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "WSEJBWrapper::invoke : methodIdx for method " + operationDesc.getName() + " == " + n + ".");
        }
        EJSDeployedSupport eJSDeployedSupport = this.container.getEJSDeployedSupport(this);
        try {
            enterpriseBean = this.container.preInvoke(this, n, eJSDeployedSupport);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "WSEJBWrapper::setupEnvironment beanRef (" + enterpriseBean.toString() + ")");
            }
            messageContext.setProperty(D_MSGCONTEXT_OPTION_EJS, eJSDeployedSupport);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.webservices.dispatchers.ejb.WSEJBWrapper.preInvoke", "105", this);
            eJSDeployedSupport.setUncheckedException(throwable);
            try {
                this.container.postInvoke(this, n, eJSDeployedSupport);
            }
            finally {
                this.container.putEJSDeployedSupport(eJSDeployedSupport);
            }
            throw throwable;
        }
        return enterpriseBean;
    }

    public void postInvoke(MessageContext messageContext) throws Throwable {
        OperationDesc operationDesc = messageContext.getOperation();
        EJSDeployedSupport eJSDeployedSupport = (EJSDeployedSupport)messageContext.getProperty(D_MSGCONTEXT_OPTION_EJS);
        if (eJSDeployedSupport == null) {
            throw new WebServicesFault(nls.getFormattedMessage("ejbdispatcher.expected.ejs", null, null));
        }
        Integer n = (Integer)messageContext.getProperty(WSEJBWRAPPER_MESSAGEINDEX);
        if (n == null) {
            throw WebServicesFault.makeFault(new Throwable("methodIdx of OperationDesc not found"));
        }
        int n2 = n;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Found methodIdx " + n2);
        }
        try {
            this.container.postInvoke(this, n2, eJSDeployedSupport);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.webservices.dispatchers.ejb.WSEJBWrapper.postInvoke", "132", this);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, noTtoWebServicesFault00 + throwable);
            }
            throw WebServicesFault.makeFault(throwable);
        }
        finally {
            this.container.putEJSDeployedSupport(eJSDeployedSupport);
        }
    }

    public void setEJSException(MessageContext messageContext, Throwable throwable, boolean bl) {
        block5: {
            EJSDeployedSupport eJSDeployedSupport = (EJSDeployedSupport)messageContext.getProperty(D_MSGCONTEXT_OPTION_EJS);
            if (eJSDeployedSupport != null) {
                try {
                    if (bl) {
                        eJSDeployedSupport.setCheckedException((Exception)throwable);
                    } else {
                        eJSDeployedSupport.setUncheckedException(throwable);
                    }
                }
                catch (RemoteException remoteException) {
                    if (!_tc.isDebugEnabled()) break block5;
                    Tr.debug(_tc, "WSEJBWrapper::setUncheckedException received RemoteException " + remoteException.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMethodIdx(OperationDesc operationDesc) throws RuntimeError {
        Integer n;
        OperationDesc operationDesc2 = operationDesc;
        synchronized (operationDesc2) {
            n = (Integer)operationDesc.getOption(D_OPERATION_OPTION_EJB_METHODIDX);
            if (n == null) {
                n = new Integer(this.getMethodIdx(operationDesc.getMethod()));
                operationDesc.setOption(D_OPERATION_OPTION_EJB_METHODIDX, n);
            }
        }
        return n;
    }

    private int getMethodIdx(Method method2) throws RuntimeError {
        Class clazz = this.bmd.webserviceEndpointInterfaceClass;
        Method[] methodArray = DeploymentUtil.getMethods(clazz);
        for (int i = 0; i < methodArray.length; ++i) {
            if (!this.isEquivalentMethod(methodArray[i], method2)) continue;
            return i;
        }
        String string = "wsejbwrapper.expected.method";
        Object[] objectArray = new String[]{method2.toString(), clazz.getName()};
        String string2 = nls.getFormattedMessage(string, objectArray, null);
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, string2);
        }
        throw new RuntimeError(string2);
    }

    private boolean isEquivalentMethod(Method method2, Method method3) {
        if (method2 != null && method3 != null && method2.getName().equals(method3.getName()) && method2.getReturnType() != null && method3.getReturnType() != null && method2.getReturnType().equals(method3.getReturnType())) {
            Class<?>[] classArray;
            Class<?>[] classArray2 = method2.getParameterTypes();
            if (classArray2.length != (classArray = method3.getParameterTypes()).length) {
                return false;
            }
            for (int i = 0; i < classArray2.length; ++i) {
                if (classArray2[i].equals(classArray[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

