/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.custom.CustomPropertyProviderFactory;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.WebServicesEngine;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.WebServicesProperties;
import com.ibm.ws.webservices.engine.attachments.Attachments;
import com.ibm.ws.webservices.engine.client.Stub;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.description.ParameterDesc;
import com.ibm.ws.webservices.engine.description.PortDesc;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistry;
import com.ibm.ws.webservices.engine.enumtype.Style;
import com.ibm.ws.webservices.engine.enumtype.Use;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.schema.SchemaVersion;
import com.ibm.ws.webservices.engine.session.Session;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.LockableHashtable;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.ext.RequestResponse;
import com.ibm.ws.webservices.metadata.ClientModuleMetaData;
import com.ibm.wsspi.webservices.rpc.handler.RPCContext;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;

public class MessageContext
implements SOAPMessageContext,
RPCContext,
Cloneable {
    protected static Log log = LogFactory.getLog(MessageContext.class.getName());
    private static final Boolean disableSOAPElementLazyParseValue = (Boolean)CustomPropertyProviderFactory.getProvider().getValue("com.ibm.ws.webservices.disableSOAPElementLazyParse");
    private static ThreadLocal currentThreadMessageContext = new ThreadLocal();
    private Message requestMessage;
    private Message responseMessage;
    private String targetPortName;
    private String transportName;
    private WebServicesEngine engine;
    private Session session;
    private boolean havePassedPivot = false;
    private boolean highFidelity = false;
    private boolean disableSOAPElementLazyParse = disableSOAPElementLazyParseValue;
    private List cachedProtectedHeaderQNames = null;
    public static final int MESSAGE_PATH_PREINVOKE = 0;
    public static final int MESSAGE_PATH_REQUEST = 1;
    public static final int MESSAGE_PATH_RESPONSE = 2;
    public static final int MESSAGE_PATH_FALSE = 3;
    public static final int MESSAGE_PATH_FAULT = 4;
    public static final int MESSAGE_PATH_CLOSURE = 5;
    private int messagePath = 1;
    private static final Set beenDir = new HashSet();
    private static String systemTempDirName = null;
    public static final String PARAM_MINOCCURS_0 = "PARAM_MINOCCURS_0";
    public static final String PARAM_MAXOCCURS_NOT1 = "PARAM_MAXOCCURS_NOT1";
    public static final String DOUBLE_QUOTES = "\"";
    public static final String PRP_IGNORE_SOAPBODY_ELEMENT = "IGNORE_SOAPBODY";
    private TypeMappingRegistry mappingRegistry = null;
    private LockableHashtable bag = new LockableHashtable();
    private static final String LHT_PORTOPTIONS = "PORT_OPTIONS";
    private static final String LHT_PROTECT = "PROTECT";
    private SOAPConstants soapConstants = Constants.DEFAULT_SOAP_VERSION;
    private SchemaVersion schemaVersion = SchemaVersion.SCHEMA_2001;
    private SOAPPort _port;
    private OperationDesc currentOperation = null;
    private String characterEncoding = null;
    private boolean invokingTarget = false;
    public static String TRANS_URL;
    public static String TRANS_URL_HTTP_REDIRECTED;
    public static String QUIT_REQUESTED;
    public static String AUTHUSER;
    public static String ATTACHMENTS_DIR;
    public static String HTTP_TRANSPORT_VERSION;
    public static String SAAJ_TRANSFORMATION;
    public static String FAULT_ON_SAAJ_TRANSFORMATION;
    private BagCache bagCache = new BagCache();
    private List oneWayListeners = null;

    public MessageContext(WebServicesEngine webServicesEngine) {
        this.engine = webServicesEngine;
        if (null != webServicesEngine) {
            String string;
            Map map = webServicesEngine.getOptions();
            String string2 = null;
            if (null != map) {
                string2 = (String)map.get("attachments.Directory");
            }
            if (null != string2) {
                MessageContext.createDir(string2);
            } else {
                string2 = systemTempDirName;
            }
            if (string2 != null) {
                this.setProperty(ATTACHMENTS_DIR, string2);
            }
            if ((string = (String)map.get("defaultSOAPVersion")) != null && "1.2".equals(string)) {
                this.setSOAPConstants(SOAPConstants.SOAP12_CONSTANTS);
            }
        }
    }

    public static void setCurrentThreadsContext(MessageContext messageContext) {
        currentThreadMessageContext.set(messageContext);
    }

    public static MessageContext getCurrentThreadsContext() {
        return (MessageContext)currentThreadMessageContext.get();
    }

    public Message getRequestMessage() {
        return this.requestMessage;
    }

    public void setRequestMessage(Message message) {
        this.requestMessage = message;
        if (this.requestMessage != null) {
            this.requestMessage.setMessageContext(this);
        }
    }

    public Message getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(Message message) {
        this.responseMessage = message;
        if (this.responseMessage != null) {
            this.responseMessage.setMessageContext(this);
            Message message2 = this.getRequestMessage();
            if (null != message2) {
                Attachments attachments = message2.getAttachmentsImpl();
                Attachments attachments2 = message.getAttachmentsImpl();
                if (null != attachments && null != attachments2 && attachments2.getSendType() == 1) {
                    attachments2.setSendType(attachments.getSendType());
                }
            }
        }
    }

    public void setOperation(OperationDesc operationDesc) {
        this.currentOperation = operationDesc;
    }

    public OperationDesc getOperation() {
        return this.currentOperation;
    }

    public OperationDesc resolveOperation() {
        OperationDesc operationDesc = this.getOperation();
        if (operationDesc == null) {
            SOAPEnvelope sOAPEnvelope = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug("MessageContext:resolveOperation: Get the SOAPEnvelope");
                }
                sOAPEnvelope = this.getCurrentMessage().getSOAPEnvelope();
            }
            catch (WebServicesFault webServicesFault) {
                FFDCFilter.processException((Throwable)webServicesFault, "com.ibm.ws.webservices.engine.MessageContext.resolveOperation", "420", this);
                throw new RuntimeException(webServicesFault);
            }
            operationDesc = this.getOperation();
            if (operationDesc == null && sOAPEnvelope != null) {
                RequestResponse requestResponse = null;
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("MessageContext:resolveOperation: Get the RequestResponse object");
                    }
                    requestResponse = ((SOAPBody)sOAPEnvelope.getBody()).getRequestResponse();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.MessageContext.resolveOperation", "449", this);
                }
                if (requestResponse != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("MessageContext:resolveOperation: Invoke RequestResponse.resolveOperation ");
                    }
                    if ((operationDesc = requestResponse.resolveOperation(this, this.getRequestMessage())) != null) {
                        this.setOperation(operationDesc);
                    }
                }
            }
        }
        return operationDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTypeMappingRegistry(TypeMappingRegistry typeMappingRegistry) {
        if (this.getPortDesc() != null) {
            PortDesc portDesc = this.getPortDesc();
            synchronized (portDesc) {
                this.getPortDesc().setTypeMappingRegistry(typeMappingRegistry);
                this.mappingRegistry = null;
            }
        } else {
            this.mappingRegistry = typeMappingRegistry;
        }
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        if (this.getPortDesc() != null) {
            return this.getPortDesc().getTypeMappingRegistry();
        }
        if (this.mappingRegistry == null) {
            this.mappingRegistry = this.engine.getTypeMappingRegistry();
        }
        return this.mappingRegistry;
    }

    public TypeMapping getTypeMapping() {
        TypeMapping typeMapping = (TypeMapping)this.getTypeMappingRegistry().getTypeMapping(this.getEncodingStyle());
        return typeMapping;
    }

    public SOAPConstants getSOAPConstants() {
        return this.soapConstants;
    }

    public void setSOAPConstants(SOAPConstants sOAPConstants) {
        if (this.soapConstants.getEncodingURI().equals(this.getEncodingStyle())) {
            this.setEncodingStyle(sOAPConstants.getEncodingURI());
        }
        this.soapConstants = sOAPConstants;
    }

    public SchemaVersion getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(SchemaVersion schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public boolean isEncoded() {
        return this.getOperationUse().getName().equals("encoded");
    }

    public Message getCurrentMessage() {
        return this.havePassedPivot ? this.responseMessage : this.requestMessage;
    }

    public SOAPMessage getMessage() {
        return this.getCurrentMessage();
    }

    public void setCurrentMessage(Message message) {
        message.setMessageContext(this);
        if (this.havePassedPivot) {
            this.responseMessage = message;
        } else {
            this.requestMessage = message;
        }
    }

    public void setMessage(SOAPMessage sOAPMessage) {
        this.setCurrentMessage((Message)sOAPMessage);
    }

    public boolean getPastPivot() {
        return this.havePassedPivot;
    }

    public void setPastPivot(boolean bl) {
        this.havePassedPivot = bl;
    }

    public boolean isRequestPath() {
        return !this.havePassedPivot;
    }

    public boolean isReponsePath() {
        return this.isResponsePath();
    }

    public boolean isResponsePath() {
        return this.havePassedPivot;
    }

    public String getTargetPortName() {
        return this.targetPortName;
    }

    public WebServicesEngine getEngine() {
        return this.engine;
    }

    public void setTargetPort(String string) throws WebServicesFault {
        block5: {
            if (log.isDebugEnabled()) {
                log.debug("MessageContext: setTargetPort(" + string + ")");
            }
            if (string == null) {
                this.setPort(null);
            } else {
                try {
                    this.setPort(this.getEngine().getPort(string));
                }
                catch (WebServicesFault webServicesFault) {
                    FFDCFilter.processException((Throwable)webServicesFault, "com.ibm.ws.webservices.engine.MessageContext.setTargetPort", "626", this);
                    this.setPort(null);
                    if (this.isClient()) break block5;
                    throw webServicesFault;
                }
            }
        }
        this.targetPortName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPort(SOAPPort sOAPPort) throws WebServicesFault {
        if (log.isDebugEnabled()) {
            log.debug("MessageContext: setPort(" + sOAPPort + ")");
        }
        TypeMappingRegistry typeMappingRegistry = this.getTypeMappingRegistry();
        this._port = sOAPPort;
        if (this._port != null) {
            Object object;
            this.targetPortName = this._port.getName();
            if (this.getOperation() != null) {
                if (this.isClient() && !this._port.getPortDesc().getOperations().contains(this.getOperation())) {
                    object = this.getPortDesc();
                    synchronized (object) {
                        this.getPortDesc().addOperationDesc(this.getOperation());
                        this.getPortDesc().setTypeMappingRegistry(typeMappingRegistry);
                    }
                } else {
                    this.setOperationStyle(this.getOperation().getStyle());
                    this.setOperationUse(this.getOperation().getUse());
                    this.setEncodingStyle(this.getOperation().getUse().getEncoding());
                }
            }
            MessageContext.removePortOptions(this.bag);
            object = sOAPPort.getOptions();
            if (object instanceof LockableHashtable) {
                LockableHashtable lockableHashtable = (LockableHashtable)object;
                lockableHashtable.setKind(LHT_PORTOPTIONS);
            }
            this.setParent(this.bag, (Map)object);
            if (this.getPortDesc().needsHighFidelityRecording()) {
                this.highFidelity = true;
            }
            sOAPPort.getInitializedPortDesc(this);
        }
        this.patchProperties();
    }

    private static void removePortOptions(LockableHashtable lockableHashtable) {
        if (log.isDebugEnabled()) {
            log.debug(lockableHashtable.dumpChain());
        }
        Map map = lockableHashtable;
        while (map != null && map instanceof LockableHashtable) {
            LockableHashtable lockableHashtable2 = map;
            if (lockableHashtable2.getParent() != null && lockableHashtable2.getParent() instanceof LockableHashtable) {
                LockableHashtable lockableHashtable3 = (LockableHashtable)lockableHashtable2.getParent();
                if (LHT_PORTOPTIONS.equals(lockableHashtable3.getKind())) {
                    lockableHashtable2.setParent(null);
                    if (log.isDebugEnabled()) {
                        log.debug("Detaching " + JavaUtils.getObjectIdentity(lockableHashtable3));
                    }
                    map = null;
                    continue;
                }
                map = lockableHashtable2.getParent();
                continue;
            }
            map = null;
        }
    }

    private void setParent(LockableHashtable lockableHashtable, Map map) {
        Map map2 = lockableHashtable.getParent();
        if (map2 instanceof LockableHashtable && map2 != map) {
            this.setParent((LockableHashtable)map2, map);
        } else {
            lockableHashtable.setParent(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void patchProperties() {
        ParameterDesc parameterDesc;
        QName qName;
        Iterator iterator;
        OperationDesc operationDesc;
        Object object = this.getProperty(PARAM_MINOCCURS_0);
        if (object != null && this.currentOperation != null) {
            operationDesc = this.currentOperation;
            synchronized (operationDesc) {
                iterator = ((Set)object).iterator();
                while (iterator.hasNext()) {
                    qName = (QName)iterator.next();
                    parameterDesc = this.currentOperation.getParamByQName(qName);
                    if (parameterDesc != null) {
                        parameterDesc.setMinOccursIs0(true);
                    }
                    if ((parameterDesc = this.currentOperation.getReturnParamDesc()) == null || !qName.equals(parameterDesc.getQName())) continue;
                    parameterDesc.setMinOccursIs0(true);
                }
            }
        }
        if ((object = this.getProperty(PARAM_MAXOCCURS_NOT1)) != null && this.currentOperation != null) {
            operationDesc = this.currentOperation;
            synchronized (operationDesc) {
                iterator = ((Set)object).iterator();
                while (iterator.hasNext()) {
                    qName = (QName)iterator.next();
                    parameterDesc = this.currentOperation.getParamByQName(qName);
                    if (parameterDesc != null) {
                        parameterDesc.setMaxOccursIs1(false);
                    }
                    if ((parameterDesc = this.currentOperation.getReturnParamDesc()) == null || !qName.equals(parameterDesc.getQName())) continue;
                    parameterDesc.setMaxOccursIs1(false);
                }
            }
        }
        if ((object = this.getProperty("com.ibm.ws.webservices.disableSOAPElementLazyParse")) != null) {
            if (log.isDebugEnabled()) {
                log.debug("disableSOAPElementLazyParse MC property: " + object);
            }
            if (JavaUtils.isTrueExplicitly((String)object)) {
                this.disableSOAPElementLazyParse = true;
            } else if (JavaUtils.isFalseExplicitly((String)object)) {
                this.disableSOAPElementLazyParse = false;
            }
            if (log.isDebugEnabled()) {
                log.debug("disableSOAPElementLazyParse using MC property: " + this.disableSOAPElementLazyParse);
            }
        }
    }

    public SOAPPort getPort() {
        return this._port;
    }

    public PortDesc getPortDesc() {
        return this.getPort() == null ? null : this.getPort().getPortDesc();
    }

    public boolean isClient() {
        return !this.isServer();
    }

    public boolean isServer() {
        return this.getEngine().isServer();
    }

    public Object getPortProperty(String string) {
        if (this._port != null) {
            return this._port.getOption(string);
        }
        return null;
    }

    public String getStrProp(String string) {
        return (String)this.getProperty(string);
    }

    public boolean isPropertyTrue(String string) {
        return this.isPropertyTrue(string, false);
    }

    public boolean isPropertyTrue(String string, boolean bl) {
        return JavaUtils.isTrue(this.getProperty(string), bl);
    }

    public void setProperty(String string, Object threadLocal) {
        ThreadLocal threadLocal2;
        Object object;
        Object object2;
        if (string == null || threadLocal == null) {
            throw new JAXRPCException(Messages.getMessage(string == null ? "badProp03" : "badProp04"));
        }
        if (log.isDebugEnabled() && string.equals("javax.xml.rpc.soap.http.soapaction.uri")) {
            log.debug("setProperty SOAPAction called with " + threadLocal);
            object2 = this.getProperty("javax.xml.rpc.soap.http.soapaction.uri");
            log.debug(" oldValue is " + object2);
            if (object2 instanceof String && threadLocal instanceof String) {
                object = (String)object2;
                threadLocal2 = (String)((Object)threadLocal);
                if (object != null && ((String)object).length() > 0 && threadLocal2 != null && ((String)((Object)threadLocal2)).length() > 0 && !((String)object).equals(threadLocal2)) {
                    log.debug("Call Stack is: " + JavaUtils.stackToString(new RuntimeException()));
                }
            }
        }
        if (string.equals("javax.xml.rpc.security.auth.username") || string.equals("javax.xml.rpc.security.auth.password") || string.equals("http.proxyHost") || string.equals("http.proxyPort") || string.equals("http.proxyUser") || string.equals("http.proxyPassword") || string.equals("https.proxyHost") || string.equals("https.proxyPort") || string.equals("https.proxyUser") || string.equals("https.proxyPassword") || string.equals("ssl.configName") || string.equals("javax.xml.rpc.soap.http.soapaction.uri") || string.equals("jaxrpcMappingFile") || string.equals("transport_name")) {
            if (!(threadLocal instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.String", threadLocal.getClass().getName()}));
            }
        } else if (string.equals("javax.xml.rpc.session.maintain") || string.equals("http.redirect.enabled") || string.equals("noDataBinding") || string.equals("javax.xml.rpc.soap.http.soapaction.use")) {
            if (!(threadLocal instanceof Boolean)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.Boolean", threadLocal.getClass().getName()}));
            }
        } else if (string.equals("javax.xml.rpc.soap.operation.style")) {
            if (!(threadLocal instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.String", threadLocal.getClass().getName()}));
            }
            threadLocal = Style.getStyle((String)((Object)threadLocal), Style.DEFAULT);
            if (this.currentOperation != null) {
                this.currentOperation.setStyle((Style)((Object)threadLocal));
            }
            if (threadLocal == Style.DOCUMENT || threadLocal == Style.WRAPPED) {
                this.setProperty("operation_use", "literal");
            } else if (threadLocal == Style.RPC) {
                this.setProperty("operation_use", "encoded");
            }
        } else if (string.equals("operation_use")) {
            if (!(threadLocal instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.String", threadLocal.getClass().getName()}));
            }
            threadLocal = Use.getUse((String)((Object)threadLocal), Use.DEFAULT);
        } else if (string.equals("javax.xml.rpc.encodingstyle.namespace.uri")) {
            if (!(threadLocal instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.String", threadLocal.getClass().getName()}));
            }
            if (Constants.isSOAP_ENC((String)((Object)threadLocal))) {
                threadLocal = this.soapConstants.getEncodingURI();
            }
        } else if (string.equals("javax.xml.rpc.service.endpoint.address") || string.equals(TRANS_URL)) {
            if (!(threadLocal instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.String", threadLocal.getClass().getName()}));
            }
            if (string.equals(TRANS_URL)) {
                if (log.isDebugEnabled()) {
                    log.debug("Deprecated MessageContext property TRANS_URL used. The property javax.xml.rpc.Stub.ENDPOINT_ADDRESS_PROPERTY will be set on the MessageContext instead.  Call stack: ", new Exception("Call stack for deprecated MessageContext.TRANS_URL usage"));
                }
                string = "javax.xml.rpc.service.endpoint.address";
            }
            try {
                threadLocal = new URL((String)((Object)threadLocal));
            }
            catch (MalformedURLException malformedURLException) {
                FFDCFilter.processException((Throwable)malformedURLException, "com.ibm.ws.webservices.engine.MessageContext.setProperty", "874", this);
                throw new JAXRPCException((Throwable)malformedURLException);
            }
            if (!this.validateEndpointAddress((URL)((Object)threadLocal))) {
                throw new JAXRPCException("Attempt to set property " + string + " to an invalid target endpoint address: " + threadLocal);
            }
        } else if (string.equals("attachment_encapsulation_format")) {
            if (!(threadLocal instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.String", threadLocal.getClass().getName()}));
            }
            if (!threadLocal.equals("webservices.attachment.style.mime") && !threadLocal.equals("webservices.attachment.style.dime")) {
                throw new JAXRPCException(Messages.getMessage("badattachmenttypeerr", new String[]{(String)((Object)threadLocal), "webservices.attachment.style.mime webservices.attachment.style.dime"}));
            }
        } else if (string.equals(SAAJ_TRANSFORMATION)) {
            if (!(threadLocal instanceof RuntimeException)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.RuntimeException", threadLocal.getClass().getName()}));
            }
        } else if (string.equals("com.ibm.ws.webservices.engine.session.context") || string.equals("com.ibm.websphere.webservices.requestTransportProperties") || string.equals("com.ibm.websphere.webservices.responseTransportProperties")) {
            boolean bl = false;
            object = this.getProperty("enableMultiThreadedSession");
            if (object != null) {
                bl = (Boolean)object;
            }
            if (!(threadLocal instanceof ThreadLocal) && !bl) {
                if (string.equals("com.ibm.websphere.webservices.requestTransportProperties") || string.equals("com.ibm.websphere.webservices.responseTransportProperties")) {
                    Stub.validateTransportPropertiesHashMap(threadLocal, string);
                }
                if ((threadLocal2 = (ThreadLocal)this.bag.get(string)) == null) {
                    threadLocal2 = new ThreadLocal();
                }
                threadLocal2.set(threadLocal);
                threadLocal = threadLocal2;
            }
        } else if (string.equals("com.ibm.websphere.webservices.requestSoapHeaders") || string.equals("com.ibm.websphere.webservices.responseSoapHeaders")) {
            object2 = null;
            if (!(threadLocal instanceof ThreadLocal)) {
                Stub.validateSoapHeadersHashMap(threadLocal, string);
                object2 = (HashMap)((Object)threadLocal);
                object = (ThreadLocal)this.bag.get(string);
                if (object == null) {
                    object = new ThreadLocal();
                }
                ((ThreadLocal)object).set(threadLocal);
                threadLocal = object;
            } else {
                object2 = (HashMap)((ThreadLocal)threadLocal).get();
            }
            this.checkForProtectedSOAPHeaders((HashMap)object2, string);
        } else if (string.equals("enableTransactionalOneWay")) {
            if (!(threadLocal instanceof Boolean)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.Boolean", threadLocal.getClass().getName()}));
            }
        } else if (string.equals("com.ibm.ws.webservices.wlmselectioncriteria")) {
            if (!(threadLocal instanceof Map)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.util.Map", threadLocal.getClass().getName()}));
            }
        } else if (string.startsWith("java.") || string.startsWith("javax.")) {
            throw new JAXRPCException(Messages.getMessage("badProp05", string));
        }
        if (string.equals("message.character-set-encoding")) {
            this.characterEncoding = (String)((Object)threadLocal);
        } else {
            this.bag.put(string, threadLocal);
        }
    }

    public boolean containsProperty(String string) {
        Object object = this.getProperty(string);
        return object != null;
    }

    public Iterator getPropertyNames() {
        return this.bag.keySet().iterator();
    }

    public Object getProperty(String string) {
        Object object = null;
        if (string != null) {
            if (string.equals(TRANS_URL)) {
                if (log.isDebugEnabled()) {
                    log.debug("Deprecated MessageContext property TRANS_URL used. The property javax.xml.rpc.Stub.ENDPOINT_ADDRESS_PROPERTY will be set on the MessageContext instead.  Call stack: ", new Exception("Call stack for deprecated MessageContext.TRANS_URL usage"));
                }
                string = "javax.xml.rpc.service.endpoint.address";
            }
            try {
                object = this.bag.get(string);
            }
            catch (StackOverflowError stackOverflowError) {
                String string2 = this.bag.dumpChain();
                if (log.isDebugEnabled()) {
                    log.debug(string2);
                }
                throw new StackOverflowError(string2);
            }
            if (object != null) {
                if (string.equals("javax.xml.rpc.soap.operation.style")) {
                    object = ((Style)object).getName();
                } else if (string.equals("operation_use")) {
                    object = ((Use)object).getName();
                } else if (string.equals("javax.xml.rpc.service.endpoint.address")) {
                    object = ((URL)object).toString();
                } else if (string.equals("com.ibm.ws.webservices.engine.session.context") || string.equals("com.ibm.websphere.webservices.requestTransportProperties") || string.equals("com.ibm.websphere.webservices.responseTransportProperties") || string.equals("com.ibm.websphere.webservices.requestSoapHeaders") || string.equals("com.ibm.websphere.webservices.responseSoapHeaders")) {
                    boolean bl = false;
                    Object object2 = this.getProperty("enableMultiThreadedSession");
                    if (object2 != null) {
                        bl = (Boolean)object2;
                    }
                    if (!bl) {
                        object = ((ThreadLocal)object).get();
                    }
                }
            } else if (string.equals("message.character-set-encoding")) {
                object = this.characterEncoding;
            }
        }
        return object;
    }

    public void setUsername(String string) {
        if (string != null) {
            this.setProperty("javax.xml.rpc.security.auth.username", string);
        }
    }

    public String getUsername() {
        return (String)this.getProperty("javax.xml.rpc.security.auth.username");
    }

    public void setPassword(String string) {
        if (string != null) {
            this.setProperty("javax.xml.rpc.security.auth.password", string);
        }
    }

    public String getPassword() {
        return (String)this.getProperty("javax.xml.rpc.security.auth.password");
    }

    public void setMaintainSession(boolean bl) {
        this.setProperty("javax.xml.rpc.session.maintain", new Boolean(bl));
    }

    public boolean getMaintainSession() {
        Boolean bl = (Boolean)this.getProperty("javax.xml.rpc.session.maintain");
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public void setOperationStyle(String string) {
        if (string != null) {
            this.setProperty("javax.xml.rpc.soap.operation.style", string);
            if (this.currentOperation != null) {
                this.currentOperation.setStyle(this.getOperationStyle());
            }
        }
    }

    public void setOperationStyle(Style style) {
        if (style != null) {
            this.bag.put("javax.xml.rpc.soap.operation.style", style);
            if (this.currentOperation != null) {
                this.currentOperation.setStyle(style);
            }
        }
    }

    public void setOperationStyle(com.ibm.ws.webservices.engine.enum.Style style) {
        if (style != null) {
            this.bag.put("javax.xml.rpc.soap.operation.style", style);
            if (this.currentOperation != null) {
                this.currentOperation.setStyle(style);
            }
        }
    }

    public com.ibm.ws.webservices.engine.enum.Style getOperationStyle() {
        Style style = null;
        if (this.bag.get("javax.xml.rpc.soap.operation.style") != null) {
            style = Style.getStyle(this.bag.get("javax.xml.rpc.soap.operation.style").toString());
        }
        Style style2 = null;
        if (this.currentOperation != null) {
            style2 = this.currentOperation.getStyle();
        }
        if (style == null && style2 == null) {
            return com.ibm.ws.webservices.engine.enum.Style.DEFAULT;
        }
        if (style != null && style2 != null) {
            if (!style.equals(style2)) {
                // empty if block
            }
            return com.ibm.ws.webservices.engine.enum.Style.getStyle(style.toString());
        }
        return style2 == null ? com.ibm.ws.webservices.engine.enum.Style.getStyle(style.toString()) : com.ibm.ws.webservices.engine.enum.Style.getStyle(style2.toString());
    }

    public String getOperationStyleString() {
        Style style = null;
        if (this.bag.get("javax.xml.rpc.soap.operation.style") != null) {
            style = Style.getStyle(this.bag.get("javax.xml.rpc.soap.operation.style").toString());
        }
        Style style2 = null;
        if (this.currentOperation != null) {
            style2 = this.currentOperation.getStyle();
        }
        if (style == null && style2 == null) {
            return Style.DEFAULT.toString();
        }
        if (style != null && style2 != null) {
            if (!style.equals(style2)) {
                // empty if block
            }
            return style.toString();
        }
        return style2 == null ? style.toString() : style2.toString();
    }

    public void setOperationUse(String string) {
        if (string != null) {
            this.setProperty("operation_use", string);
            if (this.currentOperation != null) {
                this.currentOperation.setUse(this.getOperationUse());
            }
        }
    }

    public void setOperationUse(Use use) {
        if (use != null) {
            this.bag.put("operation_use", use);
            if (this.currentOperation != null) {
                this.currentOperation.setUse(use);
            }
        }
    }

    public void setOperationUse(com.ibm.ws.webservices.engine.enum.Use use) {
        if (use != null) {
            this.bag.put("operation_use", use);
            if (this.currentOperation != null) {
                this.currentOperation.setUse(use);
            }
        }
    }

    public com.ibm.ws.webservices.engine.enum.Use getOperationUse() {
        Use use = null;
        if (this.bag.get("operation_use") != null) {
            use = Use.getUse(this.bag.get("operation_use").toString());
        }
        Use use2 = null;
        if (this.currentOperation != null) {
            use2 = this.currentOperation.getUse();
        }
        if (use == null && use2 == null) {
            return com.ibm.ws.webservices.engine.enum.Use.DEFAULT;
        }
        if (use != null && use2 != null) {
            if (!use.equals(use2)) {
                // empty if block
            }
            return com.ibm.ws.webservices.engine.enum.Use.getUse(use.toString());
        }
        return use2 == null ? com.ibm.ws.webservices.engine.enum.Use.getUse(use.toString()) : com.ibm.ws.webservices.engine.enum.Use.getUse(use2.toString());
    }

    public String getOperationUseString() {
        Use use = null;
        if (this.bag.get("operation_use") != null) {
            use = Use.getUse(this.bag.get("operation_use").toString());
        }
        Use use2 = null;
        if (this.currentOperation != null) {
            use2 = this.currentOperation.getUse();
        }
        if (use == null && use2 == null) {
            return Use.DEFAULT.toString();
        }
        if (use != null && use2 != null) {
            if (!use.equals(use2)) {
                // empty if block
            }
            return use.toString();
        }
        return use2 == null ? use.toString() : use2.toString();
    }

    public void setUseSOAPAction(boolean bl) {
        this.setProperty("javax.xml.rpc.soap.http.soapaction.use", new Boolean(bl));
    }

    public boolean useSOAPAction() {
        Boolean bl = this.useSOAPActionMimeHeader();
        if (!bl.booleanValue()) {
            bl = (Boolean)this.getProperty("javax.xml.rpc.soap.http.soapaction.use");
        }
        return bl != null && bl != false;
    }

    private Boolean useSOAPActionMimeHeader() {
        String[] stringArray;
        Boolean bl = new Boolean(false);
        if (this.getRequestMessage() != null && (stringArray = this.getRequestMessage().getMimeHeaders().getHeader("SOAPAction")) != null) {
            bl = true;
        }
        return bl;
    }

    public void setSOAPActionURI(String string) {
        if (log.isDebugEnabled()) {
            log.debug("setSOAPActionURI for " + JavaUtils.getObjectIdentity(this) + " with " + string);
            log.debug("  Old SOAPActionURI is " + this.getSOAPActionURI());
        }
        if (string != null) {
            this.setProperty("javax.xml.rpc.soap.http.soapaction.uri", string);
        } else {
            this.removeProperty("javax.xml.rpc.soap.http.soapaction.uri");
            if (log.isDebugEnabled()) {
                log.debug("setSOAPActionURI after removal is " + this.getSOAPActionURI());
            }
        }
    }

    public String getSOAPActionURI() {
        String string;
        if (log.isDebugEnabled()) {
            log.debug("Enter getSOAPActionURI for " + JavaUtils.getObjectIdentity(this));
        }
        String[] stringArray = null;
        if (this.getRequestMessage() != null && this.getRequestMessage().getMimeHeaders() != null) {
            stringArray = this.getRequestMessage().getMimeHeaders().getHeader("SOAPAction");
        }
        if (stringArray != null) {
            if (log.isDebugEnabled()) {
                log.debug("Action comes from request message mime headers.  RequestMessage is " + JavaUtils.getObjectIdentity(this.getRequestMessage()));
            }
            string = stringArray[0];
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Action comes from a property ");
            }
            string = (String)this.getProperty("javax.xml.rpc.soap.http.soapaction.uri");
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit getSOAPActionURI with " + string);
        }
        return string;
    }

    public Boolean usingAddressing() {
        OperationDesc operationDesc = this.resolveOperation();
        if (operationDesc != null) {
            String string = (String)operationDesc.getOption(OperationDesc.USING_ADDRESSING_ELEMENT);
            if (string == null) {
                return null;
            }
            return new Boolean(string);
        }
        return null;
    }

    public void setEncodingStyle(String string) {
        if (string == null) {
            string = "";
        } else if (Constants.isSOAP_ENC(string)) {
            string = this.soapConstants.getEncodingURI();
        }
        if (this.currentOperation != null) {
            this.currentOperation.setOption(OperationDesc.OUTPUT_ENCODING_STYLE, string);
            this.currentOperation.setOption(OperationDesc.INPUT_ENCODING_STYLE, string);
        }
        this.setProperty("javax.xml.rpc.encodingstyle.namespace.uri", string);
    }

    public String getEncodingStyle() {
        String string = null;
        if (this.currentOperation != null) {
            string = this.havePassedPivot ? (String)this.currentOperation.getOption(OperationDesc.OUTPUT_ENCODING_STYLE) : (String)this.currentOperation.getOption(OperationDesc.INPUT_ENCODING_STYLE);
        }
        if (string == null) {
            string = (String)this.getProperty("javax.xml.rpc.encodingstyle.namespace.uri");
        }
        if (string == null) {
            string = this.getOperationUse().getEncoding();
        }
        if (string == null) {
            if (log.isDebugEnabled()) {
                log.debug("MessageContext: getEncodingStyle: encoding is null");
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("MessageContext: getEncodingStyle: encoding is [" + string + "].");
            }
            if (string != "" && !string.equals("http://schemas.xmlsoap.org/soap/encoding/") && log.isDebugEnabled()) {
                log.debug("MessageContext: getEncodingStyle: encoding not supported[" + string + "].");
            }
        }
        return string;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public String getCharacterEncoding(String string) {
        String string2 = this.characterEncoding;
        if (string2 == null || string2.length() == 0) {
            string2 = string;
        }
        return string2;
    }

    public void setCharacterEncoding(String string) {
        this.characterEncoding = string;
    }

    public void setTimeout(Integer n) {
        if (n != null) {
            this.setProperty("timeout", n);
        }
    }

    public void setTimeout(int n) {
        this.setProperty("timeout", new Integer(n));
    }

    public void setReadTimeout(Integer n) {
        if (n != null) {
            this.setProperty("read_timeout", n);
        }
    }

    public void setReadTimeout(int n) {
        this.setProperty("read_timeout", new Integer(n));
    }

    public void setWriteTimeout(Integer n) {
        if (n != null) {
            this.setProperty("write_timeout", n);
        }
    }

    public void setWriteTimeout(int n) {
        this.setProperty("write_timeout", new Integer(n));
    }

    public int getTimeout() {
        return this.getTimeoutProperty("timeout", 0);
    }

    public int getWriteTimeout() {
        return this.getTimeoutProperty("write_timeout", 0);
    }

    private int getTimeoutProperty(String string, int n) {
        Object object;
        if (log.isDebugEnabled()) {
            log.debug("getTimeoutProperty: propName[" + string + "]  defaultValue[" + n + "]");
        }
        if ((object = this.getProperty(string)) == null) {
            if (log.isDebugEnabled()) {
                log.debug("getProperty returned null for " + string);
            }
            return n;
        }
        if (log.isDebugEnabled()) {
            log.debug("getTimeoutProperty: " + string + " = " + object);
        }
        if (object instanceof String) {
            int n2 = JavaUtils.convertStringToInt((String)object, n);
            this.setProperty(string, new Integer(n2));
            if (log.isDebugEnabled()) {
                log.debug("getTimeoutProperty: replaced String with Integer in MessageContext for " + string + ", retValue = " + n2);
            }
            return n2;
        }
        if (object instanceof Integer) {
            if (log.isDebugEnabled()) {
                log.debug("getTimeoutProperty: Integer type: " + object);
            }
            return (Integer)object;
        }
        if (log.isDebugEnabled()) {
            log.debug("getTimeoutProperty: invalid class in MessageContext");
        }
        return n;
    }

    public QName getPortName() {
        return (QName)this.getProperty("wsdl.portName");
    }

    public void setPortName(QName qName) {
        if (qName != null) {
            this.setProperty("wsdl.portName", qName);
        }
    }

    public String getTransportName() {
        return (String)this.getProperty("transport_name");
    }

    public void setTransportName(String string) {
        if (string != null) {
            this.setProperty("transport_name", string);
        }
    }

    public void setTargetEndpointAddress(String string) {
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            FFDCFilter.processException((Throwable)malformedURLException, "com.ibm.ws.webservices.engine.MessageContext.setTargetEndpointAddress", "1364", this);
            throw new JAXRPCException((Throwable)malformedURLException);
        }
        this.setTargetEndpointAddress(uRL);
    }

    public void setTargetEndpointAddress(URL uRL) {
        if (uRL != null) {
            this.bag.put("javax.xml.rpc.service.endpoint.address", uRL);
        }
    }

    public String getTargetEndpointAddress() {
        return (String)this.getProperty("javax.xml.rpc.service.endpoint.address");
    }

    public URL getTargetEndpointAddressAsURL() {
        return (URL)this.bag.get("javax.xml.rpc.service.endpoint.address");
    }

    public void removeProperty(String string) {
        if (this.bag != null) {
            if ("com.ibm.ws.webservices.engine.session.context".equals(string) || "com.ibm.websphere.webservices.requestTransportProperties".equals(string) || "com.ibm.websphere.webservices.responseTransportProperties".equals(string) || "com.ibm.websphere.webservices.requestSoapHeaders".equals(string) || "com.ibm.websphere.webservices.responseSoapHeaders".equals(string)) {
                ThreadLocal threadLocal = (ThreadLocal)this.bag.get(string);
                if (threadLocal != null) {
                    threadLocal.set(null);
                }
            } else {
                this.bag.remove(string);
            }
        }
    }

    public synchronized void protectProperties() {
        LockableHashtable lockableHashtable = this.bagCache.getBag();
        lockableHashtable.setKind(LHT_PROTECT);
        lockableHashtable.setParent(this.bag);
        this.bag = lockableHashtable;
        if (log.isDebugEnabled()) {
            log.debug("Push property map " + JavaUtils.getObjectIdentity(lockableHashtable));
        }
    }

    public synchronized void resetProperties() {
        Map map = this.bag.getParent();
        if (map != null && map instanceof LockableHashtable) {
            this.bagCache.storeBag(this.bag);
            if (LHT_PROTECT.equals(this.bag.getKind())) {
                if (log.isDebugEnabled()) {
                    log.debug("Pop property map " + JavaUtils.getObjectIdentity(this.bag));
                }
                this.bag = (LockableHashtable)map;
            } else if (log.isDebugEnabled()) {
                log.debug("Possible error..bag is a LockableHashTable but is the wrong kind " + JavaUtils.getObjectIdentity(this.bag) + " kind=" + this.bag.getKind());
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Possible error...bag is not a LockableHashTable...the bag is cleared: " + JavaUtils.getObjectIdentity(this.bag));
            }
            this.bag.clear();
        }
    }

    public boolean isClientFlow() {
        return !this.isServer();
    }

    public boolean isServerFlow() {
        return this.isServer();
    }

    public boolean isHighFidelity() {
        return this.highFidelity;
    }

    public void setHighFidelity(boolean bl) {
        this.highFidelity = bl;
    }

    public boolean isDisableSOAPElementLazyParse() {
        return this.disableSOAPElementLazyParse;
    }

    public void setDisableSOAPElementLazyParse(boolean bl) {
        this.disableSOAPElementLazyParse = bl;
    }

    public String[] getRoles() {
        Collection collection;
        String[] stringArray = null;
        if (this.getPort() != null && this.getPort().getHandlerChain() != null && (collection = this.getPort().getHandlerChain().getRoles()) != null) {
            stringArray = new String[collection.size()];
            stringArray = collection.toArray(stringArray);
        }
        return stringArray;
    }

    public Object clone() throws CloneNotSupportedException {
        MessageContext messageContext = (MessageContext)super.clone();
        messageContext.bag = (LockableHashtable)this.bag.clone();
        return messageContext;
    }

    public boolean isOneWay() {
        return this.getOperation() == null ? false : this.getOperation().isOneway();
    }

    public void addOneWayListener(OneWayListener oneWayListener) {
        if (this.oneWayListeners == null) {
            this.oneWayListeners = new ArrayList();
        }
        this.oneWayListeners.add(oneWayListener);
    }

    public void removeOneWayListener(OneWayListener oneWayListener) {
        if (this.oneWayListeners != null) {
            this.oneWayListeners.remove(oneWayListener);
        }
    }

    public void oneWayEvent() {
        if (this.oneWayListeners != null) {
            for (int i = 0; i < this.oneWayListeners.size(); ++i) {
                ((OneWayListener)this.oneWayListeners.get(i)).oneWay(this);
            }
        }
    }

    public int getMessagePath() {
        return this.messagePath;
    }

    public void setMessagePath(int n) {
        this.messagePath = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void createDir(final String string) {
        Set set = beenDir;
        synchronized (set) {
            if (string != null && !beenDir.contains(string)) {
                beenDir.add(string);
                AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                    public Object run() {
                        try {
                            File file = new File(string);
                            if (!file.isDirectory()) {
                                file.mkdirs();
                            }
                            return string;
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, "com.ibm.ws.webservices.engine.MessageContext", "318");
                            return null;
                        }
                    }
                });
            }
        }
    }

    public RPCContext getRPCContext() {
        return this;
    }

    public QName[] getWSDLParameters() {
        OperationDesc operationDesc = this.resolveOperation();
        if (operationDesc == null) {
            return null;
        }
        ArrayList arrayList = operationDesc.getParameters();
        QName[] qNameArray = new QName[arrayList.size()];
        for (int i = 0; i < qNameArray.length; ++i) {
            qNameArray[i] = ((ParameterDesc)arrayList.get(i)).getQName();
        }
        return qNameArray;
    }

    public QName getWSDLPort() {
        QName qName;
        QName qName2 = null;
        if (this.getPort() != null) {
            qName2 = this.getPort().getPortDesc().getWSDLPort();
        }
        if (qName2 == null && (qName = this.getPortName()) != null) {
            qName2 = QNameTable.createQName(qName.getNamespaceURI(), ClientModuleMetaData.unravelPortName(qName.getLocalPart()));
        }
        return qName2;
    }

    public QName getWSDLService() {
        QName qName = null;
        OperationDesc operationDesc = this.resolveOperation();
        if (operationDesc != null) {
            qName = (QName)operationDesc.getOption(OperationDesc.SERVICE_QNAME);
            if (log.isDebugEnabled()) {
                log.debug("Service name from OperationDesc = " + qName);
            }
        }
        return qName;
    }

    public Boolean getWSDLUnavailable() {
        Boolean bl = Boolean.FALSE;
        OperationDesc operationDesc = this.resolveOperation();
        if (operationDesc != null) {
            String string = (String)operationDesc.getOption(OperationDesc.WSDL_UNAVAILABLE);
            if (log.isDebugEnabled()) {
                log.debug("WSDL_UNAVAILABLE from OperationDesc = " + string);
            }
            if (string != null && string.equals("true")) {
                bl = Boolean.TRUE;
            }
        }
        return bl;
    }

    public String getWSDLOperation() {
        OperationDesc operationDesc = this.resolveOperation();
        return operationDesc != null ? operationDesc.getElementQName().getLocalPart() : null;
    }

    public QName getWSDLPortType() {
        OperationDesc operationDesc = this.resolveOperation();
        if (operationDesc != null) {
            return (QName)operationDesc.getOption(OperationDesc.PORT_TYPE_QNAME);
        }
        return null;
    }

    public String getWSDLTargetNamespace() {
        OperationDesc operationDesc = this.resolveOperation();
        if (operationDesc != null) {
            return (String)operationDesc.getOption(OperationDesc.TARGET_NAMESPACE);
        }
        return null;
    }

    public String getWSDLInputName() {
        OperationDesc operationDesc = this.resolveOperation();
        if (operationDesc != null) {
            return (String)operationDesc.getOption(OperationDesc.INPUT_NAME);
        }
        return null;
    }

    public String getWSDLOutputName() {
        OperationDesc operationDesc = this.resolveOperation();
        if (operationDesc != null) {
            return (String)operationDesc.getOption(OperationDesc.OUTPUT_NAME);
        }
        return null;
    }

    public String getWSDLFaultName() {
        return (String)this.getProperty(OperationDesc.FAULT_NAME);
    }

    public QName getWSDLInputMessageName() {
        OperationDesc operationDesc = this.resolveOperation();
        if (operationDesc != null) {
            return (QName)operationDesc.getOption(OperationDesc.INPUT_MESSAGE_QNAME);
        }
        return null;
    }

    public QName getWSDLOutputMessageName() {
        OperationDesc operationDesc = this.resolveOperation();
        if (operationDesc != null) {
            return (QName)operationDesc.getOption(OperationDesc.OUTPUT_MESSAGE_QNAME);
        }
        return null;
    }

    public String getWSDLLocation() {
        return this.getPort() != null ? this.getPort().getPortDesc().getWSDLFile() : null;
    }

    public String getPortPath() {
        return this.getTargetPortName();
    }

    public String getServiceRefName() {
        QName qName;
        if (this.isClient() && (qName = this.getPortName()) != null) {
            return ClientModuleMetaData.unravelServiceRefName(qName.getLocalPart());
        }
        return null;
    }

    public String getInputWSAAction() {
        OperationDesc operationDesc = this.resolveOperation();
        if (operationDesc != null) {
            return (String)operationDesc.getOption(OperationDesc.INPUT_WSA_ACTION);
        }
        return null;
    }

    public String getOutputWSAAction() {
        OperationDesc operationDesc = this.resolveOperation();
        if (operationDesc != null) {
            return (String)operationDesc.getOption(OperationDesc.OUTPUT_WSA_ACTION);
        }
        return null;
    }

    public String getFaultWSAAction() {
        return (String)this.getProperty(OperationDesc.FAULT_WSA_ACTION);
    }

    private boolean validateEndpointAddress(URL uRL) {
        boolean bl = true;
        URL uRL2 = this.getTargetEndpointAddressAsURL();
        if (uRL == null) {
            if (log.isDebugEnabled()) {
                log.debug("Invalid endpoint address specified.  URL is null");
            }
            bl = false;
        } else if (uRL2 != null && !uRL2.getProtocol().equals(uRL.getProtocol())) {
            if (this.isHTTP(uRL.getProtocol()) && this.isHTTP(uRL2.getProtocol())) {
                if (log.isDebugEnabled()) {
                    log.debug("New protocol [" + uRL.getProtocol() + "] is different than existing protocol [" + uRL2.getProtocol() + "].  Both are http.  Processing continues.");
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Invalid endpoint address specified.  New protocol [" + uRL.getProtocol() + "] is different than existing protocol [" + uRL2.getProtocol() + "]");
                }
                bl = false;
            }
        }
        return bl;
    }

    private boolean isHTTP(String string) {
        String string2 = string.toLowerCase();
        return "http".equals(string2) || "https".equals(string2);
    }

    public void addImplicitSOAPHeadersToRequest() throws WebServicesFault {
        HashMap hashMap = (HashMap)this.getProperty("com.ibm.websphere.webservices.requestSoapHeaders");
        if (hashMap == null) {
            return;
        }
        this.checkForProtectedSOAPHeaders(hashMap, "com.ibm.websphere.webservices.requestSoapHeaders");
        try {
            Message message = this.getRequestMessage();
            SOAPEnvelope sOAPEnvelope = message.getSOAPEnvelope();
            SOAPHeader sOAPHeader = sOAPEnvelope.getHeader();
            if (sOAPHeader == null) {
                sOAPHeader = sOAPEnvelope.addHeader();
            }
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                QName qName = (QName)entry.getKey();
                Object v = entry.getValue();
                SOAPElement sOAPElement = null;
                if (v instanceof String) {
                    sOAPElement = ((SOAPFactory)SOAPFactory.newInstance()).createElementFromXMLString((String)v);
                } else if (v instanceof SOAPElement) {
                    sOAPElement = (SOAPElement)v;
                } else {
                    WebServicesFault webServicesFault = new WebServicesFault(Messages.getMessage("hashMapValidationError"));
                    FFDCFilter.processException((Throwable)webServicesFault, "com.ibm.ws.webservices.engine.MessageContext.addImplicitSOAPHeadersToRequest", "2209", this);
                    throw webServicesFault;
                }
                sOAPHeader.addChildElement(sOAPElement);
            }
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.webservices.engine.MessageContext.addImplicitSOAPHeadersToRequest", "2218", this);
            throw WebServicesFault.makeFault(sOAPException);
        }
    }

    public void getImplicitSOAPHeadersFromResponse() throws WebServicesFault {
        HashMap hashMap = (HashMap)this.getProperty("com.ibm.websphere.webservices.responseSoapHeaders");
        if (hashMap == null) {
            return;
        }
        try {
            Message message = this.getResponseMessage();
            if (message == null) {
                return;
            }
            SOAPEnvelope sOAPEnvelope = message.getSOAPEnvelope();
            SOAPHeader sOAPHeader = sOAPEnvelope.getHeader();
            if (sOAPHeader == null) {
                return;
            }
            if (hashMap.isEmpty()) {
                Iterator iterator = sOAPHeader.examineAllHeaderElements();
                while (iterator.hasNext()) {
                    SOAPHeaderElement sOAPHeaderElement = (SOAPHeaderElement)iterator.next();
                    Name name2 = sOAPHeaderElement.getElementName();
                    boolean bl = false;
                    Iterator iterator2 = this.getProtectedSOAPHeaderQNames();
                    while (iterator2.hasNext() && !bl) {
                        QName qName = (QName)iterator2.next();
                        if (!qName.getLocalPart().equals(name2.getLocalName()) || !qName.getNamespaceURI().equals(name2.getURI())) continue;
                        bl = true;
                    }
                    if (bl) continue;
                    hashMap.put(new QName(name2.getURI(), name2.getLocalName()), sOAPHeaderElement);
                }
            } else {
                Iterator iterator = sOAPHeader.examineAllHeaderElements();
                while (iterator.hasNext()) {
                    SOAPHeaderElement sOAPHeaderElement = (SOAPHeaderElement)iterator.next();
                    Name name3 = sOAPHeaderElement.getElementName();
                    QName qName = new QName(name3.getURI(), name3.getLocalName());
                    if (!hashMap.containsKey(qName)) continue;
                    hashMap.put(qName, sOAPHeaderElement);
                }
            }
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.webservices.engine.MessageContext.addImplicitSOAPHeadersToRequest", "2267", this);
            throw WebServicesFault.makeFault(sOAPException);
        }
    }

    private Iterator getProtectedSOAPHeaderQNames() {
        if (this.cachedProtectedHeaderQNames == null) {
            this.cachedProtectedHeaderQNames = this.engine.getProtectedHeaders();
            if (this.cachedProtectedHeaderQNames == null) {
                this.cachedProtectedHeaderQNames = new ArrayList();
            }
            if (log.isDebugEnabled()) {
                log.debug("MessageContext.getProtectedSOAPHeaderQNames: Contents of 'cachedProtectedHeaderQNames':\n" + this.cachedProtectedHeaderQNames.toString());
            }
        }
        return this.cachedProtectedHeaderQNames.iterator();
    }

    private void checkForProtectedSOAPHeaders(HashMap hashMap, String string) {
        if (hashMap == null) {
            return;
        }
        Iterator iterator = this.getProtectedSOAPHeaderQNames();
        while (iterator.hasNext()) {
            QName qName = (QName)iterator.next();
            if (!hashMap.containsKey(qName)) continue;
            throw new IllegalArgumentException(Messages.getMessage("protSoapHdr", new String[]{qName.toString()}));
        }
    }

    public void setInvokingTarget(boolean bl) {
        if (log.isDebugEnabled()) {
            log.debug("setInvokingTarget(" + bl + ")");
        }
        this.invokingTarget = bl;
    }

    public boolean isInvokingTarget() {
        return this.invokingTarget;
    }

    static {
        systemTempDirName = WebServicesProperties.getProperty("webservices.attachments.Directory");
        if (systemTempDirName == null) {
            systemTempDirName = WebServicesProperties.getProperty("java.io.tmpdir");
        }
        if (systemTempDirName != null) {
            MessageContext.createDir(systemTempDirName);
        }
        TRANS_URL = "transport.url";
        TRANS_URL_HTTP_REDIRECTED = "transport.url.http.redirected";
        QUIT_REQUESTED = "quit.requested";
        AUTHUSER = "authenticatedUser";
        ATTACHMENTS_DIR = "attachments.directory";
        HTTP_TRANSPORT_VERSION = "webservices.transport.version";
        SAAJ_TRANSFORMATION = "webservices.not.optimal.saaj.transformation";
        FAULT_ON_SAAJ_TRANSFORMATION = "webservices.fault.on.saaj.transformation";
    }

    public static interface OneWayListener {
        public void oneWay(MessageContext var1);
    }

    private class BagCache {
        private ArrayList cache = new ArrayList();

        private BagCache() {
        }

        void storeBag(LockableHashtable lockableHashtable) {
            lockableHashtable.clear();
            lockableHashtable.setParent(null);
            this.cache.add(lockableHashtable);
        }

        LockableHashtable getBag() {
            return this.cache.size() == 0 ? new LockableHashtable() : (LockableHashtable)this.cache.remove(0);
        }
    }
}

