/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.ClosureHandler;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.PreHandler;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.handlers.BasicHandler;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFault;
import com.ibm.ws.webservices.trace.UserExceptionTrace;
import java.rmi.RemoteException;
import java.util.MissingResourceException;
import org.apache.commons.logging.Log;

public class PivotHandlerWrapper
extends BasicHandler
implements PreHandler {
    protected static Log log = LogFactory.getLog(PivotHandlerWrapper.class.getName());
    private Handler _requestHandler;
    private Handler _pivotHandler;
    private Handler _responseHandler;
    private static final String ROOT_HANDLER_CHAIN = "com.ibm.ws.webservices.engine.PivotHandlerWrapper.ROOT_HANDLER_CHAIN";

    public static Handler factory(Handler handler2, Handler handler3) {
        if (handler2 instanceof PivotHandlerWrapper) {
            PivotHandlerWrapper pivotHandlerWrapper = (PivotHandlerWrapper)handler2;
            return pivotHandlerWrapper == null ? handler3 : PivotHandlerWrapper.factory(pivotHandlerWrapper.getRequestHandler(), handler3, pivotHandlerWrapper.getResponseHandler());
        }
        return handler3;
    }

    public static Handler factory(Handler handler2, Handler handler3, Handler handler4) {
        return handler2 == null && handler4 == null ? handler3 : new PivotHandlerWrapper(handler2, handler3, handler4);
    }

    public PivotHandlerWrapper() {
    }

    public PivotHandlerWrapper(Handler handler2) {
        this(null, handler2, null);
    }

    public PivotHandlerWrapper(Handler handler2, Handler handler3, Handler handler4) {
        this(handler2, handler3, handler4, null);
    }

    public PivotHandlerWrapper(Handler handler2, Handler handler3, Handler handler4, Handler handler5) {
        this.setRequestHandler(handler2);
        this.setPivotHandler(handler3);
        this.setResponseHandler(handler4);
    }

    protected void setRequestHandler(Handler handler2) {
        this._requestHandler = handler2;
    }

    public Handler getRequestHandler() {
        return this._requestHandler;
    }

    protected void setPivotHandler(Handler handler2) {
        this._pivotHandler = handler2;
    }

    public Handler getPivotHandler() {
        return this._pivotHandler;
    }

    protected void setResponseHandler(Handler handler2) {
        this._responseHandler = handler2;
    }

    public Handler getResponseHandler() {
        return this._responseHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(MessageContext messageContext) throws WebServicesFault {
        block45: {
            if (messageContext.getMessagePath() == 0) {
                messageContext.setProperty(ROOT_HANDLER_CHAIN, this);
                this.preHandleIncoming(messageContext);
                messageContext.setMessagePath(1);
            }
            try {
                Handler handler2 = this.getRequestHandler();
                if (handler2 != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("PivotHandlerWrapper.getRequestHandler().invoke()");
                    }
                    handler2.invoke(messageContext);
                } else if (log.isDebugEnabled()) {
                    log.debug("PivotHandlerWrapper.getRequestHandler() == null");
                }
                if (messageContext.getMessagePath() == 3 && messageContext.getResponseMessage() != null && !messageContext.getResponseMessage().equals(messageContext.getRequestMessage())) {
                    if (!messageContext.isOneWay()) {
                        messageContext.setMessagePath(2);
                    } else {
                        messageContext.setMessagePath(5);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("PivotHandlerWrapper request handler returned false.  Changed MESSAGE_PATH to " + messageContext.getMessagePath());
                    }
                }
                if (messageContext.getMessagePath() != 1) break block45;
                Handler handler3 = this.getResponseHandler();
                Handler handler4 = this.getPivotHandler();
                try {
                    try {
                        if (handler4 != null) {
                            if (log.isDebugEnabled()) {
                                log.debug("Calling PivotHandlerWrapper.getPivotHandler().invoke() :  Invoking: " + (handler4.getClass() == null ? "null" : handler4.getClass().getName()));
                            }
                            handler4.invoke(messageContext);
                            if (log.isDebugEnabled()) {
                                log.debug("Returning from PivotHandlerWrapper.getPivotHandler().invoke()  : " + (handler4.getClass() == null ? "null" : handler4.getClass().getName()));
                            }
                        } else if (log.isDebugEnabled()) {
                            log.debug("PivotHandlerWrapper.getPivotHandler() == null");
                        }
                    }
                    finally {
                        messageContext.setPastPivot(true);
                        if (messageContext.isClient() && !messageContext.isOneWay() && messageContext.getMessagePath() == 1) {
                            PreHandler preHandler = (PreHandler)messageContext.getProperty(ROOT_HANDLER_CHAIN);
                            preHandler.preHandleIncoming(messageContext);
                        }
                    }
                    if (messageContext.getMessagePath() == 1) {
                        if (messageContext.isOneWay()) {
                            messageContext.setMessagePath(5);
                        } else {
                            messageContext.setMessagePath(2);
                        }
                    }
                    if (messageContext.getMessagePath() != 5) {
                        if (messageContext.getResponseMessage() != null) {
                            messageContext.getResponseMessage().ifFaultThrowSelf();
                        } else {
                            log.error(Messages.getMessage("nullResponse00"));
                            if (messageContext.getProperty("SOAPConnection") == null || !((Boolean)messageContext.getProperty("SOAPConnection")).booleanValue()) {
                                throw new RemoteException(Messages.getMessage("nullResponse00"));
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (log.isDebugEnabled()) {
                        log.debug("Caught exception from PivotHandlerWrapper.getPivotHandler().invoke() logic  : " + throwable.toString());
                    }
                    if (!UserExceptionTrace.isUserDefinedException(throwable) && messageContext.getMessagePath() == 1) {
                        log.warn(Messages.getMessage("pivotThrewException00", handler4.getClass() == null ? "null" : handler4.getClass().getName()), throwable);
                    }
                    if (!messageContext.isOneWay()) {
                        messageContext.setMessagePath(4);
                    } else {
                        messageContext.setMessagePath(5);
                    }
                    WebServicesFault webServicesFault = this.bindExceptionToResponse(messageContext, throwable);
                    try {
                        if (!messageContext.isOneWay()) {
                            PivotHandlerWrapper.onFault("invoke", "request", messageContext, this.getRequestHandler());
                        } else if (log.isDebugEnabled()) {
                            log.debug("Application handler handleFault() is not invoked for a one-way operation; see JAX-RPC 12.1.4.");
                        }
                    }
                    catch (Throwable throwable2) {
                        FFDCFilter.processException(throwable2, "com.ibm.ws.webservices.engine.PivotHandlerWrapper.invoke", "249", this);
                        log.error(Messages.getMessage("handlerRewindException00"));
                    }
                    throw webServicesFault;
                }
                if (handler3 != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("PivotHandlerWrapper.invoke(): responseHandler.invoke()");
                    }
                    if (messageContext.getMessagePath() == 2) {
                        handler3.invoke(messageContext);
                    } else if (handler3 instanceof ClosureHandler) {
                        ((ClosureHandler)handler3).handleClosure(messageContext);
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("PivotHandlerWrapper.invoke(): NO responseHandler!");
                }
            }
            catch (Throwable throwable) {
                messageContext.setMessagePath(4);
                WebServicesFault webServicesFault = this.bindExceptionToResponse(messageContext, throwable);
            }
        }
    }

    private WebServicesFault bindExceptionToResponse(MessageContext messageContext, Throwable throwable) throws MissingResourceException {
        WebServicesFault webServicesFault;
        if (throwable instanceof WebServicesFault) {
            webServicesFault = (WebServicesFault)throwable;
            if (!webServicesFault.isUserException()) {
                log.debug("Caught WebServicesFault", webServicesFault);
            } else {
                UserExceptionTrace.log(webServicesFault);
            }
        } else {
            log.error(Messages.getMessage("unexpectedException00"), throwable);
            webServicesFault = new WebServicesFault(Messages.getMessage("unexpectedException00"), throwable);
        }
        if (!messageContext.isPropertyTrue("com.ibm.ws.webservices.engine.SimpleChain.caughtFaultInResponse")) {
            messageContext.setProperty("com.ibm.ws.webservices.engine.SimpleChain.caughtFaultInResponse", Boolean.TRUE);
            if (messageContext.getResponseMessage() == null) {
                Message message = new Message(webServicesFault);
                messageContext.setResponseMessage(message);
            } else {
                boolean bl;
                Message message;
                block14: {
                    message = messageContext.getResponseMessage();
                    bl = false;
                    try {
                        if (message.getFault() != null) {
                            bl = true;
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.PivotHandlerWrapper.invoke", "418", this);
                        if (!log.isDebugEnabled()) break block14;
                        log.debug("PivotHandlerWrapper.bindExceptionToResponse encountered an exception while processing the respMsg.getFault()" + exception.toString());
                    }
                }
                if (!bl) {
                    try {
                        SOAPEnvelope sOAPEnvelope = message.getSOAPEnvelope();
                        SOAPBody sOAPBody = (SOAPBody)sOAPEnvelope.getBody();
                        sOAPBody.removeContents();
                        SOAPFault sOAPFault = (SOAPFault)sOAPBody.addFault();
                        sOAPFault.setFault(webServicesFault);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.PivotHandlerWrapper.invoke", "441", this);
                        if (log.isDebugEnabled()) {
                            log.debug("PivotHandlerWrapper.bindExceptionToResponse encountered an exception while processing the SOAPEnvelope " + exception.toString());
                        }
                        Message message2 = new Message(webServicesFault);
                        messageContext.setResponseMessage(message2);
                    }
                }
            }
        }
        return webServicesFault;
    }

    public void onFault(MessageContext messageContext) {
        if (messageContext.getPastPivot()) {
            PivotHandlerWrapper.onFault("onFault", "response", messageContext, this.getResponseHandler());
        } else {
            PivotHandlerWrapper.onFault("onFault", "request", messageContext, this.getRequestHandler());
        }
    }

    protected static final void onFault(String string, String string2, MessageContext messageContext, Handler handler2) {
        if (handler2 != null) {
            if (log.isDebugEnabled()) {
                log.debug("PivotHandlerWrapper." + string + "(): " + string2 + "Handler.onFault()");
            }
            handler2.onFault(messageContext);
        } else if (log.isDebugEnabled()) {
            log.debug("PivotHandlerWrapper." + string + "(): NO " + string2 + "Handler for onFault!");
        }
    }

    public void preHandleIncoming(MessageContext messageContext) {
        Handler handler2;
        Handler handler3;
        if (messageContext.isServer() && (handler3 = this.getRequestHandler()) instanceof PreHandler) {
            if (log.isDebugEnabled()) {
                log.debug("PivotHandlerWrapper.getRequestHandler().preHandleIncoming()");
            }
            ((PreHandler)handler3).preHandleIncoming(messageContext);
        }
        if ((handler3 = this.getPivotHandler()) instanceof PreHandler) {
            if (log.isDebugEnabled()) {
                log.debug("PivotHandlerWrapper.getPivotHandler().preHandleIncoming()");
            }
            ((PreHandler)handler3).preHandleIncoming(messageContext);
        }
        if (messageContext.isClient() && (handler2 = this.getResponseHandler()) instanceof PreHandler) {
            if (log.isDebugEnabled()) {
                log.debug("PivotHandlerWrapper.getResponseHandler().preHandleIncoming()");
            }
            ((PreHandler)handler2).preHandleIncoming(messageContext);
        }
    }

    public void generateWSDL(MessageContext messageContext) throws WebServicesFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: PivotHandlerWrapper::generateWSDL");
        }
        try {
            if (this.getRequestHandler() != null) {
                if (log.isDebugEnabled()) {
                    log.debug("PivotHandlerWrapper.generateWSDL(): requestHandler.generateWSDL()");
                }
                this.getRequestHandler().generateWSDL(messageContext);
            } else if (log.isDebugEnabled()) {
                log.debug("PivotHandlerWrapper.generateWSDL(): NO requestHandler!");
            }
            if (this.getPivotHandler() != null) {
                if (log.isDebugEnabled()) {
                    log.debug("PivotHandlerWrapper.generateWSDL(): pivotHandler.generateWSDL()");
                }
                this.getPivotHandler().generateWSDL(messageContext);
            } else if (log.isDebugEnabled()) {
                log.debug("PivotHandlerWrapper.generateWSDL(): NO pivotHandler!");
            }
            messageContext.setPastPivot(true);
            if (this.getResponseHandler() != null) {
                if (log.isDebugEnabled()) {
                    log.debug("PivotHandlerWrapper.generateWSDL(): responseHandler.generateWSDL()");
                }
                this.getResponseHandler().generateWSDL(messageContext);
            } else if (log.isDebugEnabled()) {
                log.debug("PivotHandlerWrapper.generateWSDL(): NO responseHandler!");
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.webservices.engine.PivotHandlerWrapper.generateWSDL", "413", this);
            throw this.bindExceptionToResponse(messageContext, throwable);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: PivotHandlerWrapper::generateWSDL");
        }
    }
}

