/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.attachments;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import java.io.File;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;

final class AttachmentCacheMonitor {
    static Log log = LogFactory.getLog(AttachmentCacheMonitor.class.getName());
    private int ATTACHMENT_TIMEOUT_SECONDS = 0;
    private int REFRESH_SECONDS = 0;
    public static final String ATTACHMENT_TIMEOUT_PROPERTY = "com.ibm.websphere.webservices.attachment.tempfile.expiration";
    private HashMap files = new HashMap();
    private Long priorDeleteMillis = this.getTime();
    private Timer timer = null;
    private static AttachmentCacheMonitor _singleton = null;

    public static synchronized AttachmentCacheMonitor getAttachmentCacheMonitor() {
        if (_singleton == null) {
            _singleton = new AttachmentCacheMonitor();
        }
        return _singleton;
    }

    private AttachmentCacheMonitor() {
        try {
            this.ATTACHMENT_TIMEOUT_SECONDS = Integer.valueOf(System.getProperty(ATTACHMENT_TIMEOUT_PROPERTY, "0"));
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.webservices.engine.attachments.AttachmentCacheMonitor", "128", this);
        }
        this.REFRESH_SECONDS = this.ATTACHMENT_TIMEOUT_SECONDS / 2;
        if (log.isDebugEnabled()) {
            log.debug("Custom Property Key=  com.ibm.websphere.webservices.attachment.tempfile.expiration");
            log.debug("   Value = " + this.ATTACHMENT_TIMEOUT_SECONDS);
        }
        if (this.REFRESH_SECONDS > 0) {
            this.timer = new Timer(true);
            this.timer.schedule((TimerTask)new CleanupFilesTask(), this.REFRESH_SECONDS * 1000, (long)(this.REFRESH_SECONDS * 1000));
        }
    }

    public void register(String string) {
        if (this.ATTACHMENT_TIMEOUT_SECONDS > 0) {
            this._register(string);
            this._checkForAgedFiles();
        }
    }

    public void access(String string) {
        if (this.ATTACHMENT_TIMEOUT_SECONDS > 0) {
            this._access(string);
            this._checkForAgedFiles();
        }
    }

    public void checkForAgedFiles() {
        if (this.ATTACHMENT_TIMEOUT_SECONDS > 0) {
            this._checkForAgedFiles();
        }
    }

    private synchronized void _register(String string) {
        Long l = this.getTime();
        if (log.isDebugEnabled()) {
            log.debug("Register file " + string);
            log.debug("Time = " + l);
        }
        this.files.put(string, l);
    }

    private synchronized void _access(String string) {
        Long l = this.getTime();
        Long l2 = (Long)this.files.get(string);
        if (l2 != null) {
            this.files.put(string, l);
            if (log.isDebugEnabled()) {
                log.debug("Access file " + string);
                log.debug("Old Time = " + l2);
                log.debug("New Time = " + l);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("The following file was already deleted and is no longer available: " + string);
            log.debug("The value of com.ibm.websphere.webservices.attachment.tempfile.expiration is " + this.ATTACHMENT_TIMEOUT_SECONDS);
        }
    }

    private synchronized void _checkForAgedFiles() {
        Long l = this.getTime();
        if (this.isExpired(this.priorDeleteMillis, l, this.REFRESH_SECONDS)) {
            Iterator iterator = this.files.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Long l2 = (Long)this.files.get(string);
                if (!this.isExpired(l2, l, this.ATTACHMENT_TIMEOUT_SECONDS)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Expired file " + string);
                    log.debug("Old Time = " + l2);
                    log.debug("New Time = " + l);
                    log.debug("Elapsed Time (ms) = " + (l - l2));
                }
                this.deleteFile(string);
                iterator.remove();
            }
            this.priorDeleteMillis = l;
        }
    }

    private boolean deleteFile(final String string) {
        Boolean bl = (Boolean)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return AttachmentCacheMonitor.this._deleteFile(string);
            }
        });
        return bl;
    }

    private Boolean _deleteFile(String string) {
        boolean bl = false;
        File file = new File(string);
        if (file.exists()) {
            bl = file.delete();
            if (log.isDebugEnabled()) {
                log.debug("Deletion Successful ? " + bl);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("This file no longer exists = " + string);
        }
        return new Boolean(bl);
    }

    private Long getTime() {
        return new Long(System.currentTimeMillis());
    }

    private boolean isExpired(Long l, Long l2, int n) {
        long l3 = l2 - l;
        return l3 > (long)(n * 1000);
    }

    public static void main(String[] stringArray) throws Exception {
        long l = 15000L;
        if (log.isDebugEnabled()) {
            log.debug("AttachmentCacheMonitor Test ");
        }
        Thread thread = Thread.currentThread();
        AttachmentCacheMonitor attachmentCacheMonitor = AttachmentCacheMonitor.getAttachmentCacheMonitor();
        File file = new File("A");
        file.createNewFile();
        String string = file.getCanonicalPath();
        attachmentCacheMonitor.register(string);
        Thread.sleep(l);
        File file2 = new File("B");
        file2.createNewFile();
        String string2 = file2.getCanonicalPath();
        attachmentCacheMonitor.register(string2);
        Thread.sleep(l);
        attachmentCacheMonitor.access(string);
        Thread.sleep(l);
        attachmentCacheMonitor.access(string2);
        Thread.sleep(l);
        File file3 = new File("C");
        file3.createNewFile();
        String string3 = file3.getCanonicalPath();
        attachmentCacheMonitor.register(string3);
        attachmentCacheMonitor.access(string2);
        Thread.sleep(l);
        attachmentCacheMonitor.checkForAgedFiles();
        Thread.sleep(10L * l);
    }

    private class CleanupFilesTask
    extends TimerTask {
        private CleanupFilesTask() {
        }

        public void run() {
            AttachmentCacheMonitor.this.checkForAgedFiles();
        }
    }
}

