/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.attachments;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;
import org.apache.commons.logging.Log;

public final class MimeMultipartWriterUtil {
    private static final Log log = LogFactory.getLog(MimeMultipartWriterUtil.class.getName());
    private static final String UTF8 = "UTF-8";
    private static final byte[] CRLF_UTF8 = new byte[]{13, 10};
    private static final byte[] DASH_DASH_UTF8 = new byte[]{45, 45};
    private static final String BOUNDARY_PARAM = "boundary";
    private static final int MIN_COUNT = 20;

    private MimeMultipartWriterUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToSilent(MimeMultipart mimeMultipart, OutputStream outputStream) {
        if (log.isDebugEnabled()) {
            log.debug("Start writeToSilent");
        }
        try {
            MimeMultipartWriterUtil.writeTo(mimeMultipart, outputStream);
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, "com.ibm.ws.webservices.engine.attachments.MimeMultipartWriterUtil.writeToSilent", "%C");
            if (log.isDebugEnabled()) {
                log.debug("The following exception was caught and ignored:", iOException);
                log.debug(MimeMultipartWriterUtil.dumpString(mimeMultipart));
            }
        }
        catch (MessagingException messagingException) {
            FFDCFilter.processException(messagingException, "com.ibm.ws.webservices.engine.attachments.MimeMultipartWriterUtil.writeToSilent", "%C");
            if (log.isDebugEnabled()) {
                log.debug("The following exception was caught and ignored:", messagingException);
                log.debug(MimeMultipartWriterUtil.dumpString(mimeMultipart));
            }
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException(runtimeException, "com.ibm.ws.webservices.engine.attachments.MimeMultipartWriterUtil.writeToSilent", "%C");
            if (log.isDebugEnabled()) {
                log.debug("The following exception was caught and ignored:", runtimeException);
                log.debug(MimeMultipartWriterUtil.dumpString(mimeMultipart));
            }
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug("End writeToSilent");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTo(MimeMultipart mimeMultipart, OutputStream outputStream) throws IOException, MessagingException {
        if (log.isDebugEnabled()) {
            log.debug("Start writeTo");
        }
        try {
            String string = mimeMultipart.getContentType();
            String string2 = MimeMultipartWriterUtil.getBoundary(string);
            MimeMultipartWriterUtil.writeCRLF(outputStream);
            for (int i = 0; i < mimeMultipart.getCount(); ++i) {
                MimeMultipartWriterUtil.writeBoundary(string2, outputStream, false);
                MimeMultipartWriterUtil.writeMimeBodyPart((MimeBodyPart)mimeMultipart.getBodyPart(i), outputStream);
            }
            MimeMultipartWriterUtil.writeBoundary(string2, outputStream, true);
            MimeMultipartWriterUtil.writeCRLF(outputStream);
            outputStream.flush();
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug("End writeTo");
            }
        }
    }

    public static boolean reset(OutputStream outputStream) {
        if (outputStream instanceof ByteArrayOutputStream) {
            ((ByteArrayOutputStream)outputStream).reset();
            return true;
        }
        return false;
    }

    public static boolean detectWriteToFailure(MimeMultipart mimeMultipart, OutputStream outputStream) {
        Object object;
        if (log.isDebugEnabled()) {
            String string = outputStream == null ? "null" : outputStream.getClass().toString();
            log.debug("Start detectWriteToFailure outputStream=" + string);
        }
        boolean bl = false;
        if (outputStream instanceof ByteArrayOutputStream) {
            object = (ByteArrayOutputStream)outputStream;
            if (log.isDebugEnabled()) {
                log.debug("  bytesWrittten=" + ((ByteArrayOutputStream)object).size());
            }
            if (((ByteArrayOutputStream)object).size() < 20) {
                MimeMultipartWriterUtil.reset(outputStream);
                bl = true;
            }
        }
        if (log.isDebugEnabled()) {
            object = outputStream == null ? "null" : outputStream.getClass().toString();
            log.debug("End detectWriteToFailure=" + bl);
        }
        return bl;
    }

    public static String dumpString(MimeMultipart mimeMultipart) {
        String string = "MIMEMultipart Contents: \n";
        try {
            for (int i = 0; i < mimeMultipart.getCount(); ++i) {
                MimeBodyPart mimeBodyPart = (MimeBodyPart)mimeMultipart.getBodyPart(i);
                string = string + "    MIMEBodyPart cid=" + mimeBodyPart.getContentID() + "\n";
                string = string + "    size=" + mimeBodyPart.getSize() + "\n";
                string = string + "    content=" + mimeBodyPart.getContent() + "\n";
            }
        }
        catch (Exception exception) {
            string = "[Could not get debug trace for MimeMultipart object due to: " + exception.toString() + "]";
        }
        return string;
    }

    private static String getBoundary(String string) throws ParseException {
        ContentType contentType;
        String string2;
        if (log.isDebugEnabled()) {
            log.debug("Start getBoundary contentType=[" + string + "]");
        }
        if ((string2 = (contentType = new ContentType(string)).getParameter(BOUNDARY_PARAM)) != null && string2.startsWith("<") && string2.endsWith(">")) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        if (log.isDebugEnabled()) {
            log.debug("End getBoundary=[" + string2 + "]");
        }
        return string2;
    }

    private static void writeBoundary(String string, OutputStream outputStream, boolean bl) throws IOException {
        outputStream.write(DASH_DASH_UTF8);
        outputStream.write(string.getBytes(UTF8));
        if (bl) {
            outputStream.write(DASH_DASH_UTF8);
        }
    }

    private static void writeCRLF(OutputStream outputStream) throws IOException {
        outputStream.write(CRLF_UTF8);
    }

    private static void writeMimeBodyPart(MimeBodyPart mimeBodyPart, OutputStream outputStream) throws IOException, MessagingException {
        if (log.isDebugEnabled()) {
            String string = mimeBodyPart == null ? "null" : mimeBodyPart.getContentID();
            log.debug("Start writeMimeBodyPart bodyPart id=" + string);
        }
        MimeMultipartWriterUtil.writeCRLF(outputStream);
        mimeBodyPart.writeTo(outputStream);
        MimeMultipartWriterUtil.writeCRLF(outputStream);
        if (log.isDebugEnabled()) {
            log.debug("End writeMimeBodyPart");
        }
    }

    public static void main(String[] stringArray) {
    }
}

