/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.attachments;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Part;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.attachments.AttachmentPart;
import com.ibm.ws.webservices.engine.attachments.DimeDelimitedInputStream;
import com.ibm.ws.webservices.engine.attachments.DimeTypeNameFormat;
import com.ibm.ws.webservices.engine.attachments.ManagedMemoryDataSource;
import com.ibm.ws.webservices.engine.attachments.MultiPartInputStream;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.commons.logging.Log;

public class MultiPartDimeInputStream
extends MultiPartInputStream {
    protected static Log log = LogFactory.getLog(MultiPartDimeInputStream.class.getName());
    protected HashMap parts = new HashMap();
    protected LinkedList orderedParts = new LinkedList();
    protected int rootPartLength = 0;
    protected DimeDelimitedInputStream dimeDelimitedStream = null;
    protected byte[] boundary = null;
    protected ByteArrayInputStream cachedSOAPEnvelope = null;
    protected String contentId = null;
    protected static final String[] READ_ALL = new String[]{" * \u0000 ".intern()};

    public MultiPartDimeInputStream(InputStream inputStream) throws IOException {
        super(null);
        this.dimeDelimitedStream = new DimeDelimitedInputStream(inputStream);
        this.soapStream = this.dimeDelimitedStream;
        this.contentId = this.dimeDelimitedStream.getContentId();
    }

    public Part getAttachmentByReference(String[] stringArray) throws WebServicesFault {
        Part part = null;
        try {
            for (int i = stringArray.length - 1; part == null && i > -1; --i) {
                part = (AttachmentPart)this.parts.get(stringArray[i]);
            }
            if (null == part) {
                part = this.readTillFound(stringArray);
            }
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("return02", "getAttachmentByReference(\"" + stringArray + "\"", part == null ? "null" : part.toString()));
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.webservices.engine.attachments.MultiPartDimeInputStream.getAttachmentByReference", "126", this);
            throw new WebServicesFault(iOException.getClass().getName() + iOException.getMessage());
        }
        return part;
    }

    protected void addPart(String string, String string2, AttachmentPart attachmentPart) {
        if (string != null && string.trim().length() != 0) {
            this.parts.put(string, attachmentPart);
        }
        this.orderedParts.add(attachmentPart);
    }

    protected void readAll() throws WebServicesFault {
        try {
            this.readTillFound(READ_ALL);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.attachments.MultiPartDimeInputStream.readAll", "148", this);
            throw WebServicesFault.makeFault(exception);
        }
    }

    public Collection getAttachments() throws WebServicesFault {
        this.readAll();
        return new LinkedList(this.orderedParts);
    }

    protected Part readTillFound(String[] stringArray) throws IOException {
        if (this.dimeDelimitedStream == null) {
            return null;
        }
        AttachmentPart attachmentPart = null;
        try {
            Object object;
            Object object2;
            if (this.soapStream != null) {
                if (!this.eos) {
                    object2 = new ByteArrayOutputStream(8192);
                    object = new byte[16384];
                    int n = 0;
                    do {
                        if ((n = this.soapStream.read((byte[])object)) <= 0) continue;
                        ((ByteArrayOutputStream)object2).write((byte[])object, 0, n);
                    } while (n > -1);
                    ((ByteArrayOutputStream)object2).close();
                    this.soapStream.close();
                    this.soapStream = new ByteArrayInputStream(((ByteArrayOutputStream)object2).toByteArray());
                }
                this.dimeDelimitedStream = this.dimeDelimitedStream.getNextStream();
            }
            if (null != this.dimeDelimitedStream) {
                do {
                    object2 = this.dimeDelimitedStream.getContentId();
                    object = this.dimeDelimitedStream.getType();
                    if (object != null && !this.dimeDelimitedStream.getDimeTypeNameFormat().equals(DimeTypeNameFormat.MIME)) {
                        object = "application/uri; uri=\"" + (String)object + "\"";
                    }
                    DataHandler dataHandler = new DataHandler((DataSource)new ManagedMemoryDataSource(this.dimeDelimitedStream, (String)object));
                    AttachmentPart attachmentPart2 = new AttachmentPart(dataHandler);
                    if (object2 != null) {
                        attachmentPart2.setMimeHeader("Content-Id", (String)object2);
                    }
                    this.addPart((String)object2, "", attachmentPart2);
                    for (int i = stringArray.length - 1; attachmentPart == null && i > -1; --i) {
                        if (object2 == null || !stringArray[i].equals(object2)) continue;
                        attachmentPart = attachmentPart2;
                    }
                    this.dimeDelimitedStream = this.dimeDelimitedStream.getNextStream();
                } while (null == attachmentPart && null != this.dimeDelimitedStream);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.attachments.MultiPartDimeInputStream.readTillFound", "233", this);
            throw WebServicesFault.makeFault(exception);
        }
        return attachmentPart;
    }

    public String getContentLocation() {
        return null;
    }

    public String getContentId() {
        return this.contentId;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException(Messages.getMessage("streamClosed"));
        }
        if (this.eos) {
            return -1;
        }
        int n3 = this.soapStream.read(byArray, n, n2);
        if (n3 < 0) {
            this.eos = true;
        }
        return n3;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException(Messages.getMessage("streamClosed"));
        }
        if (this.eos) {
            return -1;
        }
        int n = this.soapStream.read();
        if (n < 0) {
            this.eos = true;
        }
        return n;
    }
}

