/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.configuration;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.EngineConfigurationFactory;
import com.ibm.ws.webservices.engine.WebServicesProperties;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.util.HashMap;
import org.apache.commons.discovery.ResourceClass;
import org.apache.commons.discovery.ResourceClassIterator;
import org.apache.commons.discovery.tools.ClassUtils;
import org.apache.commons.logging.Log;

public class EngineConfigurationFactoryFinder {
    protected static Log log = LogFactory.getLog(EngineConfigurationFactoryFinder.class.getName());
    private static final Class mySpi = EngineConfigurationFactory.class;
    private static final Class myFactory = EngineConfigurationFactoryFinder.class;
    private static final Class[] newFactoryParamTypes = new Class[]{Object.class};
    private static ThreadLocal tlsCache = new ThreadLocal();
    private static ThreadLocal tlsCacheSize = new ThreadLocal();
    private static final int CACHE_LIMIT = 10;
    private static final String requiredMethod = "public static EngineConfigurationFactory newFactory(Object)";

    private EngineConfigurationFactoryFinder() {
    }

    public static EngineConfigurationFactory newFactory(Object object) {
        final Object[] objectArray = new Object[]{object};
        return (EngineConfigurationFactory)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                ResourceClassIterator resourceClassIterator = WebServicesProperties.getResourceClassIterator(mySpi);
                Object object = null;
                while (object == null && resourceClassIterator.hasNext()) {
                    ResourceClass resourceClass = resourceClassIterator.nextResourceClass();
                    Class clazz = EngineConfigurationFactoryFinder.loadClass(resourceClass);
                    if (clazz == null) continue;
                    object = EngineConfigurationFactoryFinder.newFactory(clazz, newFactoryParamTypes, objectArray);
                }
                if (object != null) {
                    if (log.isDebugEnabled()) {
                        log.debug(Messages.getMessage("engineFactory", object.getClass().getName()));
                    }
                } else {
                    log.error(Messages.getMessage("engineConfigFactoryMissing"));
                }
                return object;
            }
        });
    }

    public static EngineConfigurationFactory newFactory() {
        return EngineConfigurationFactoryFinder.newFactory(null);
    }

    private static EngineConfigurationFactory newFactory(Class clazz, Class[] classArray, Object[] objectArray) {
        block9: {
            try {
                Method method2 = ClassUtils.findPublicStaticMethod(clazz, EngineConfigurationFactory.class, "newFactory", classArray);
                if (method2 == null) {
                    log.warn(Messages.getMessage("engineConfigMissingNewFactory", clazz.getName(), requiredMethod));
                    break block9;
                }
                try {
                    return (EngineConfigurationFactory)method2.invoke(null, objectArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    FFDCFilter.processException(invocationTargetException, "com.ibm.ws.webservices.engine.configuration.EngineConfigurationFactoryFinder.newFactory", "223");
                    if (invocationTargetException.getTargetException() instanceof NoClassDefFoundError) {
                        if (log.isDebugEnabled()) {
                            log.debug(Messages.getMessage("engineConfigLoadFactory", clazz.getName()));
                        }
                    } else {
                        log.warn(Messages.getMessage("engineConfigInvokeNewFactory", clazz.getName(), requiredMethod), invocationTargetException);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ws.webservices.engine.configuration.EngineConfigurationFactoryFinder.newFactory", "255");
                    log.warn(Messages.getMessage("engineConfigInvokeNewFactory", clazz.getName(), requiredMethod), exception);
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                FFDCFilter.processException(noClassDefFoundError, "com.ibm.ws.webservices.engine.configuration.EngineConfigurationFactoryFinder.newFactory", "262");
                if (!log.isDebugEnabled()) break block9;
                log.debug(Messages.getMessage("engineConfigLoadFactory", clazz.getName()));
            }
        }
        return null;
    }

    private static Class loadClass(ResourceClass resourceClass) {
        ClassLoader classLoader = resourceClass.getClassLoader();
        String string = resourceClass.getName();
        if (classLoader == null || string == null || string.length() == 0) {
            return resourceClass.loadClass();
        }
        String string2 = classLoader.getClass().getName();
        if (string2.equals("sun.reflect.DelegatingClassLoader")) {
            classLoader = classLoader.getParent();
        }
        if (classLoader == null) {
            return resourceClass.loadClass();
        }
        Object var4_4 = null;
        Class clazz = EngineConfigurationFactoryFinder.getClassFromCache(classLoader, string);
        if (clazz != null) {
            if (clazz == Void.class) {
                clazz = null;
            }
            return clazz;
        }
        if (log.isDebugEnabled()) {
            log.debug("Due to cache miss, loadClass is called to load the class");
        }
        clazz = resourceClass.loadClass();
        EngineConfigurationFactoryFinder.putClassIntoCache(classLoader, string, clazz);
        return clazz;
    }

    private static Class getClassFromCache(ClassLoader classLoader, String string) {
        String string2;
        HashMap hashMap;
        HashMap hashMap2 = (HashMap)tlsCache.get();
        if (hashMap2 == null) {
            hashMap2 = new HashMap();
            tlsCache.set(hashMap2);
        }
        if ((hashMap = (HashMap)hashMap2.get(string2 = JavaUtils.getObjectIdentity(classLoader))) == null) {
            if (log.isDebugEnabled()) {
                log.debug("Cache Miss (A) for ClassLoader=" + string2 + " and class " + string);
            }
            return null;
        }
        Class clazz = (Class)hashMap.get(string);
        if (log.isDebugEnabled() && clazz == null) {
            log.debug("Cache Miss (B) for ClassLoader=" + string2 + " and class " + string);
        }
        return clazz;
    }

    private static void putClassIntoCache(ClassLoader classLoader, String string, Class clazz) {
        int n;
        Integer n2;
        String string2 = JavaUtils.getObjectIdentity(classLoader);
        if (clazz == null) {
            Class clazz2 = clazz = Void.class;
        }
        if (log.isDebugEnabled()) {
            log.debug("putClassIntoCache ClassLoader=" + string2 + " ClassName=" + string + " ClassValue=" + clazz);
        }
        if ((n2 = (Integer)tlsCacheSize.get()) == null) {
            n2 = new Integer(0);
        }
        if ((n = n2.intValue()) == 0 || n >= 10) {
            tlsCache.set(new HashMap());
            n = 1;
            if (log.isDebugEnabled()) {
                log.debug("creating a new Cache");
            }
        } else {
            ++n;
        }
        tlsCacheSize.set(new Integer(n));
        HashMap hashMap = (HashMap)tlsCache.get();
        HashMap<String, Class> hashMap2 = (HashMap<String, Class>)hashMap.get(string2);
        if (hashMap2 == null) {
            hashMap2 = new HashMap<String, Class>();
            hashMap.put(string2, hashMap2);
        }
        hashMap2.put(string, clazz);
    }

    static {
        WebServicesProperties.setClassOverrideProperty(EngineConfigurationFactory.class, "webservices.EngineConfigFactory");
        WebServicesProperties.setClassDefaults(EngineConfigurationFactory.class, new String[]{"com.ibm.ws.webservices.engine.configuration.DefaultEngineConfigurationFactory"});
    }
}

