/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.deployment.wsdd;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDConstants;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDException;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDOperation;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDPort;
import com.ibm.ws.webservices.engine.deployment.wsdd.dispatchers.WSDDGenericDispatcher;
import com.ibm.ws.webservices.engine.deployment.wsdd.dispatchers.WSDDJavaEJBDispatcher;
import com.ibm.ws.webservices.engine.deployment.wsdd.dispatchers.WSDDJavaRPCDispatcher;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import java.util.Hashtable;
import javax.xml.namespace.QName;

public abstract class WSDDDispatcher {
    private static Hashtable dispatchers = new Hashtable();

    public static void registerDispatcher(QName qName, WSDDDispatcher wSDDDispatcher) {
        dispatchers.put(qName, wSDDDispatcher);
    }

    public static void registerDispatcher(QName qName, String string) throws WSDDException {
        Class clazz;
        try {
            clazz = ClassUtils.forName(string, true, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDispatcher.registerDispatcher", "143");
            throw WSDDException.makeWSDDException(exception);
        }
        if (WSDDDispatcher.class.isAssignableFrom(clazz)) {
            try {
                WSDDDispatcher.registerDispatcher(qName, (WSDDDispatcher)clazz.newInstance());
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDispatcher.registerDispatcher", "152");
                throw WSDDException.makeWSDDException(exception);
            }
        } else if (Handler.class.isAssignableFrom(clazz)) {
            try {
                WSDDDispatcher.registerDispatcher(qName, new WSDDGenericDispatcher(clazz));
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDispatcher.registerDispatcher", "159");
                throw WSDDException.makeWSDDException(exception);
            }
        } else {
            throw new WSDDException(Messages.getMessage("namedArtifactDidntImplement03", "Dispatcher", string, WSDDDispatcher.class.getName()));
        }
    }

    public WSDDOperation[] getOperations() {
        return null;
    }

    public WSDDOperation getOperation(String string) {
        return null;
    }

    public static Handler getInstance(QName qName, WSDDPort wSDDPort, EngineConfiguration engineConfiguration) throws Exception {
        if (qName == null) {
            throw new WSDDException(Messages.getMessage("nullProvider00"));
        }
        WSDDDispatcher wSDDDispatcher = (WSDDDispatcher)dispatchers.get(qName);
        if (wSDDDispatcher == null) {
            throw new WSDDException(Messages.getMessage("noMatchingProvider00", qName.toString()));
        }
        return wSDDDispatcher.newDispatcherInstance(wSDDPort, engineConfiguration);
    }

    public abstract Handler newDispatcherInstance(WSDDPort var1, EngineConfiguration var2) throws Exception;

    static {
        WSDDDispatcher.registerDispatcher(WSDDConstants.QNAME_JAVARPC_DISPATCHER, new WSDDJavaRPCDispatcher());
        WSDDDispatcher.registerDispatcher(WSDDConstants.QNAME_EJB_DISPATCHER, new WSDDJavaEJBDispatcher());
    }
}

