/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.deployment.wsdd;

import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDElement;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDException;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.tools.WSDLQuery;
import com.ibm.ws.webservices.wsdl.ImportResolver;
import com.ibm.ws.webservices.wsdl.mapping.MappingMetaData;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class WSDDGen
extends WSDDElement {
    protected String wsdlFile = null;
    protected String wsdlContext = null;
    protected InputStream wsdlInputStream = null;
    protected Definition wsdlDefinition = null;
    protected Document wsdlTypesDoc = null;
    protected ImportResolver resolver = null;
    protected String wsdlContent = null;
    protected String wsdlFileName = null;
    private ArrayList namespaces = new ArrayList();
    private ArrayList packages = new ArrayList();
    private HashMap namespaceMap = new HashMap();
    private MappingMetaData inputMapping = null;
    private boolean noDataBinding = false;

    public WSDDGen() {
    }

    public WSDDGen(Element element) throws WSDDException {
        this.wsdlFile = element.getAttribute("wsdl");
        Element[] elementArray = this.getChildElements(element, "pair");
        for (int i = 0; i < elementArray.length; ++i) {
            this.setNamespacePackagePair(elementArray[i].getAttribute("namespace"), elementArray[i].getAttribute("package"));
        }
    }

    public void writeToContext(SerializationContext serializationContext) throws IOException {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "wsdl", "wsdl", "CDATA", this.wsdlFile);
        QName qName = new QName("", "Gen");
        serializationContext.getSerializationWriter().startElement(qName, attributesImpl);
        for (int i = 0; i < this.namespaces.size(); ++i) {
            qName = new QName("", "pair");
            attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "namespace", "namespace", "CDATA", (String)this.namespaces.get(i));
            attributesImpl.addAttribute("", "package", "package", "CDATA", (String)this.packages.get(i));
            serializationContext.getSerializationWriter().startElement(qName, attributesImpl);
            serializationContext.getSerializationWriter().endElement();
        }
        serializationContext.getSerializationWriter().endElement();
    }

    protected QName getElementName() {
        return new QName("", "Gen");
    }

    public void setWSDLFile(String string) {
        this.wsdlFile = string;
    }

    public String getWSDLFile() {
        return this.wsdlFile;
    }

    public void setWSDLContent(String string, String string2) {
        this.wsdlContent = string;
        this.wsdlFileName = string2;
    }

    public String getWSDLContent() {
        return this.wsdlContent;
    }

    public String getWSDLFileName() {
        return this.wsdlFileName;
    }

    public void setWSDLFile(String string, InputStream inputStream) {
        this.wsdlContext = string;
        this.wsdlInputStream = inputStream;
    }

    public void setWSDLFile(String string, Definition definition, Document document) {
        this.wsdlContext = string;
        this.wsdlDefinition = definition;
        this.wsdlTypesDoc = document;
    }

    public void setResolver(ImportResolver importResolver) {
        this.resolver = importResolver;
    }

    public void setNamespacePackagePair(String string, String string2) {
        if (string != null && string2 != null) {
            this.namespaces.add(string);
            this.packages.add(string2);
            this.namespaceMap.put(string, string2);
        }
    }

    public void setInputMapping(MappingMetaData mappingMetaData) {
        this.inputMapping = mappingMetaData;
    }

    public WSDLQuery getWSDLQuery() throws Exception {
        WSDLQuery wSDLQuery = new WSDLQuery(this.namespaceMap);
        wSDLQuery.setNoDataBinding(this.noDataBinding);
        if (this.inputMapping != null) {
            wSDLQuery.setInputMapping(this.inputMapping);
        }
        if (this.resolver != null) {
            wSDLQuery.setResolver(this.resolver);
        }
        if (this.wsdlFile != null) {
            wSDLQuery.parse(this.wsdlFile);
        } else if (this.wsdlInputStream != null) {
            wSDLQuery.parse(this.wsdlContext, this.wsdlInputStream);
        } else {
            wSDLQuery.parse(this.wsdlContext, this.wsdlTypesDoc, this.wsdlDefinition);
        }
        return wSDLQuery;
    }

    public void setNoDataBinding(boolean bl) {
        this.noDataBinding = bl;
    }

    public boolean getNoDataBinding() {
        return this.noDataBinding;
    }
}

