/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.dispatchers.java;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesEngine;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configurable.Configurable;
import com.ibm.ws.webservices.engine.dispatchers.java.JavaDispatcher;
import com.ibm.ws.webservices.engine.enumtype.Scope;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.session.Session;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.server.ServiceLifecycle;
import org.apache.commons.logging.Log;

public abstract class SessionDispatcher
extends JavaDispatcher {
    protected static Log log = LogFactory.getLog(SessionDispatcher.class.getName());
    private static final String D_OPTION_SCOPE = "scope";

    public static final void setScope(Configurable configurable, String string) {
        SessionDispatcher.setScope(configurable, Scope.getScope(string, Scope.DEFAULT));
    }

    public static final void setScope(Configurable configurable, Scope scope) {
        configurable.setOption(D_OPTION_SCOPE, scope);
    }

    public static final Scope getScope(Configurable configurable) {
        return (Scope)configurable.getOption(D_OPTION_SCOPE);
    }

    protected abstract Object createServiceObject(SOAPPort var1) throws WebServicesFault;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(MessageContext messageContext) throws WebServicesFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: SessionDispatcher::invoke (" + this + ")");
        }
        Object object = null;
        Session session = null;
        try {
            session = this.getServiceSession(messageContext);
            if (session != null) {
                SOAPPort sOAPPort = messageContext.getPort();
                String string = SessionDispatcher.getPortName(messageContext);
                Session session2 = session;
                synchronized (session2) {
                    object = session.get(string);
                    if (object == null) {
                        object = this.createAndInitServiceObject(messageContext);
                        session.set(string, object);
                    }
                }
            } else {
                object = this.createAndInitServiceObject(messageContext);
            }
            this.processMessage(messageContext, object);
        }
        catch (WebServicesFault webServicesFault) {
            throw webServicesFault;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.dispatchers.java.Dispatcher.invoke", "246", this);
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("toWebServicesFault00"), exception);
            }
            throw WebServicesFault.makeFault(exception);
        }
        finally {
            if (object != null && session == null && object instanceof ServiceLifecycle) {
                ((ServiceLifecycle)object).destroy();
            }
            if (log.isDebugEnabled()) {
                log.debug("Exit: SessionDispatcher::invoke (" + this + ")");
            }
        }
    }

    private static String getPortName(MessageContext messageContext) {
        String string = messageContext.getPort().getName();
        if (string == null) {
            string = messageContext.getTargetPortName();
        }
        return string;
    }

    private Object createAndInitServiceObject(MessageContext messageContext) throws WebServicesFault, ServiceException {
        Object object = this.createServiceObject(messageContext.getPort());
        if (object != null && object instanceof ServiceLifecycle) {
            Object object2 = messageContext.getProperty("servletEndpointContext");
            ((ServiceLifecycle)object).init(object2);
        }
        return object;
    }

    private Session getServiceSession(MessageContext messageContext) {
        Session session;
        SOAPPort sOAPPort = messageContext.getPort();
        Scope scope = SessionDispatcher.getScope(sOAPPort);
        if (scope == Scope.REQUEST) {
            session = null;
        } else if (scope == Scope.SESSION) {
            session = messageContext.getSession();
        } else if (scope == Scope.APPLICATION) {
            WebServicesEngine webServicesEngine = messageContext.getEngine();
            session = webServicesEngine.getApplicationSession();
        } else {
            session = null;
        }
        return session;
    }
}

