/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.schema.SchemaVersion;
import com.ibm.ws.webservices.engine.utils.Mapping;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.utils.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public final class SerializationWriter {
    protected static Log log = LogFactory.getLog(SerializationWriter.class.getName());
    private Scopes scopes = new Scopes();
    private boolean writingStartTag = false;
    private boolean startOfDocument = true;
    private String charEncoding;
    private int indent = 0;
    private boolean onlyXML = true;
    private boolean pretty = false;
    private Stack stack = new Stack();
    private Mapping xsiMapping = null;
    private static int RESET_XSI = 100000000;
    private int xsiDepth = RESET_XSI;
    private final BufferedWriter writer;
    private char[] workChars = new char[1000];
    private int depth = 0;
    boolean forceRealPrefix = true;

    public SerializationWriter(Writer writer, String string, boolean bl) {
        this(writer, string, bl, null);
    }

    public SerializationWriter(Writer writer, String string, boolean bl, OutputStream outputStream) {
        this.writer = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, outputStream, string);
        this.charEncoding = string;
        this.startOfDocument = bl;
    }

    public boolean getPretty() {
        return this.pretty;
    }

    public void setPretty(boolean bl) {
        this.pretty = bl;
    }

    public void startElement(QName qName, Attributes attributes2, MappingScope mappingScope) throws IOException {
        if (mappingScope != null) {
            this.scopes.replaceMappingScope(mappingScope);
        }
        this._startElement(qName, null, attributes2, true);
    }

    public void startElement(QName qName, String string, Attributes attributes2, MappingScope mappingScope) throws IOException {
        if (mappingScope != null) {
            this.scopes.replaceMappingScope(mappingScope);
        }
        this._startElement(qName, string, attributes2, false);
    }

    public void startElement(QName qName, Attributes attributes2) throws IOException {
        this._startElement(qName, null, attributes2, true);
    }

    public void startElement(QName qName, String string, Attributes attributes2) throws IOException {
        this._startElement(qName, string, attributes2, false);
    }

    public void _startElement(QName qName, String string, Attributes attributes2, boolean bl) throws IOException {
        ++this.depth;
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("startElem00", "[" + qName.getNamespaceURI() + "]:" + qName.getLocalPart()));
        }
        if (this.startOfDocument) {
            this.writer.write("<?xml version=\"1.0\" encoding=\"" + this.charEncoding + "\"?>\n");
            this.startOfDocument = false;
        }
        if (!this.pretty) {
            if (this.writingStartTag) {
                this.writer.write(62);
                ++this.indent;
            }
        } else {
            if (this.writingStartTag) {
                this.writer.write(62, 10);
                ++this.indent;
            }
            for (int i = 0; i < this.indent; ++i) {
                this.writer.write(32);
            }
        }
        MappingScope mappingScope = this.scopes.getMappingScope();
        if (bl) {
            string = !mappingScope.hasMappings() ? this.scopes.getOrCreatePrefix_Fast(qName.getNamespaceURI()) : this.scopes.getOrCreatePrefix(qName.getNamespaceURI(), null, this.forceRealPrefix);
        }
        string = string == null ? "" : string;
        this.stack.push(qName.getLocalPart());
        this.stack.push(string);
        if (string.length() > 0) {
            this.writer.write(60, string);
            this.writer.write(58, qName.getLocalPart());
        } else {
            this.writer.write(60, qName.getLocalPart());
        }
        ArrayList arrayList = null;
        if (attributes2 != null && attributes2.getLength() > 0) {
            arrayList = this.writeAttributes(attributes2, bl);
        }
        if (mappingScope.hasMappings()) {
            this.writePrefixMappings(mappingScope, arrayList);
        }
        this.scopes.push();
        this.writingStartTag = true;
        this.onlyXML = true;
    }

    private ArrayList writeAttributes(Attributes attributes2, boolean bl) throws IOException {
        ArrayList<String> arrayList = null;
        if (attributes2 != null) {
            for (int i = 0; i < attributes2.getLength(); ++i) {
                int n;
                String string = attributes2.getURI(i);
                String string2 = "";
                String string3 = attributes2.getQName(i);
                if (string3.length() == 0) {
                    string3 = attributes2.getLocalName(i);
                }
                if (string == SchemaVersion.SCHEMA_2001.getXsiURI() && string3.startsWith("xsi:") && this.depth > this.xsiDepth) {
                    this.writer.write(32, string3);
                    this.writer.write(61, 34);
                    this.writer.write(attributes2.getValue(i), 34);
                    continue;
                }
                if (bl && string != null && string.length() > 0 && (n = string3.indexOf(58)) > -1) {
                    String string4 = null;
                    string2 = string3.substring(0, n);
                    if (!string2.equals("xmlns")) {
                        string4 = this.scopes.getOrCreatePrefix(string, string2, true);
                    }
                    if (string4 != null && !string4.equals(string2)) {
                        string3 = string4.length() > 0 ? string4 + ':' + attributes2.getLocalName(i) : attributes2.getLocalName(i);
                    }
                }
                if (string3.startsWith("xmlns")) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>();
                    }
                    if (arrayList.indexOf(attributes2.getLocalName(i)) >= 0) continue;
                    arrayList.add(attributes2.getLocalName(i));
                }
                this.writer.write(32, string3);
                this.writer.write(61, 34);
                this.writer.write(this.xmlEncodeString(attributes2.getValue(i)), 34);
            }
        }
        return arrayList;
    }

    private String xmlEncodeString(String string) {
        if (string != null && string.length() >= this.workChars.length) {
            this.workChars = new char[string.length() + 100];
        }
        return XMLUtils.xmlEncodeString(string, this.workChars);
    }

    private void writePrefixMappings(MappingScope mappingScope, ArrayList arrayList) throws IOException {
        for (int i = 0; i < mappingScope.size(); ++i) {
            Mapping mapping = mappingScope.get(i);
            if ("http://www.w3.org/XML/1998/namespace".equals(mapping.getNamespaceURI()) || arrayList != null && arrayList.indexOf(mapping.getPrefix()) >= 0) continue;
            this.writer.write(" xmlns");
            if (mapping.getPrefix().length() > 0) {
                this.writer.write(58, mapping.getPrefix());
            }
            this.writer.write(61, 34);
            this.writer.write(mapping.getNamespaceURI(), 34);
            if (mapping.getNamespaceURI() != SchemaVersion.SCHEMA_2001.getXsiURI() || !mapping.getPrefix().equals("xsi")) continue;
            this.xsiMapping = mapping;
            this.xsiDepth = this.depth;
            if (!log.isDebugEnabled()) continue;
            log.debug("setting xsiDepth to " + this.xsiDepth);
        }
    }

    public void endElement() throws IOException {
        --this.depth;
        if (this.depth < this.xsiDepth && this.xsiDepth != RESET_XSI) {
            this.xsiDepth = RESET_XSI;
            this.xsiMapping = null;
            if (log.isDebugEnabled()) {
                log.debug("reset xsiDepth");
            }
        }
        String string = (String)this.stack.pop();
        String string2 = (String)this.stack.pop();
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("endElem00", "" + string + ":" + string2));
        }
        this.scopes.pop();
        this.scopes.clearTop();
        if (!this.pretty) {
            if (this.writingStartTag) {
                this.writer.write(47, 62);
                this.writingStartTag = false;
            } else {
                this.indent = this.onlyXML ? this.indent - 1 : this.indent;
                this.writer.write(60, 47);
                if (string.length() > 0) {
                    this.writer.write(string, 58);
                }
                this.writer.write(string2, 62);
            }
        } else if (this.writingStartTag) {
            this.writer.write(47, 62);
            this.writer.write(10);
            this.writingStartTag = false;
        } else {
            if (this.onlyXML) {
                --this.indent;
                for (int i = 0; i < this.indent; ++i) {
                    this.writer.write(32);
                }
            }
            this.writer.write(60, 47);
            if (string.length() > 0) {
                this.writer.write(string, 58);
            }
            this.writer.write(string2, 62);
            if (this.indent > 0) {
                this.writer.write(10);
            }
        }
        this.onlyXML = true;
        if (this.depth == 0) {
            this.writer.flushBuffer();
        }
    }

    public void simpleElement(QName qName, Attributes attributes2, MappingScope mappingScope, String string) throws IOException {
        if (mappingScope != null) {
            this.scopes.replaceMappingScope(mappingScope);
        }
        this._simpleElement(qName, null, attributes2, string, true);
    }

    public void simpleElement(QName qName, String string, Attributes attributes2, MappingScope mappingScope, String string2) throws IOException {
        if (mappingScope != null) {
            this.scopes.replaceMappingScope(mappingScope);
        }
        this._simpleElement(qName, string, attributes2, string2, false);
    }

    public void simpleElement(QName qName, Attributes attributes2, String string) throws IOException {
        if (qName == null && attributes2 == null) {
            this._simplestElement(string);
        } else {
            this._simpleElement(qName, null, attributes2, string, true);
        }
    }

    private void _simplestElement(String string) throws IOException {
        if (string != null && string.length() > 0) {
            this.writeSafeString(string);
        }
    }

    public void simpleElement(QName qName, String string, Attributes attributes2, String string2) throws IOException {
        this._simpleElement(qName, string, attributes2, string2, false);
    }

    private void _simpleElement(QName qName, String string, Attributes attributes2, String string2, boolean bl) throws IOException {
        boolean bl2;
        if (this.startOfDocument) {
            this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            this.startOfDocument = false;
        }
        boolean bl3 = bl2 = this.xsiDepth == this.depth;
        if (!this.pretty) {
            if (this.writingStartTag) {
                this.writer.write(62);
                ++this.indent;
            }
        } else {
            if (this.writingStartTag) {
                this.writer.write(62, 10);
                ++this.indent;
            }
            for (int i = 0; i < this.indent; ++i) {
                this.writer.write(32);
            }
        }
        MappingScope mappingScope = this.scopes.getMappingScope();
        if (bl) {
            string = this.scopes.getOrCreatePrefix_Fast(qName.getNamespaceURI());
        }
        String string3 = string = string == null ? "" : string;
        if (string.length() > 0) {
            this.writer.write(60, string);
            this.writer.write(58, qName.getLocalPart());
        } else {
            this.writer.write(60, qName.getLocalPart());
        }
        ArrayList arrayList = null;
        if (attributes2 != null && attributes2.getLength() > 0) {
            arrayList = this.writeAttributes(attributes2, bl);
        }
        if (mappingScope.hasMappings()) {
            this.writePrefixMappings(mappingScope, arrayList);
        }
        this.writingStartTag = true;
        this.onlyXML = true;
        if (string2 != null && string2.length() > 0) {
            this.writeSafeString(string2);
        }
        this.scopes.clearTop();
        if (!this.pretty) {
            if (this.writingStartTag) {
                this.writer.write(47, 62);
                this.writingStartTag = false;
            } else {
                this.indent = this.onlyXML ? this.indent - 1 : this.indent;
                this.writer.write(60, 47);
                if (string.length() > 0) {
                    this.writer.write(string, 58);
                }
                this.writer.write(qName.getLocalPart(), 62);
            }
        } else if (this.writingStartTag) {
            this.writer.write(47, 62);
            this.writer.write(10);
            this.writingStartTag = false;
        } else {
            if (this.onlyXML) {
                --this.indent;
                for (int i = 0; i < this.indent; ++i) {
                    this.writer.write(32);
                }
            }
            this.writer.write(60, 47);
            if (string.length() > 0) {
                this.writer.write(string, 58);
            }
            this.writer.write(qName.getLocalPart(), 62);
            if (this.indent > 0) {
                this.writer.write(10);
            }
        }
        this.onlyXML = true;
        if (this.depth == 0) {
            this.writer.flushBuffer();
        }
        if (!bl2 && this.xsiDepth == this.depth) {
            this.xsiDepth = RESET_XSI;
            this.xsiMapping = null;
            if (log.isDebugEnabled()) {
                log.debug("reset xsiDepth for simple element");
            }
        }
    }

    public void writeChars(char[] cArray, int n, int n2) throws IOException {
        if (this.writingStartTag) {
            this.writer.write(62);
            this.writingStartTag = false;
        }
        this.writeSafeString(String.valueOf(cArray, n, n2));
        this.onlyXML = false;
    }

    public void write(byte[] byArray, int n, int n2, String string) throws IOException {
        if (this.writingStartTag) {
            this.writer.write(62);
            this.writingStartTag = false;
        }
        this.writer.write(byArray, n, n2, string);
        this.onlyXML = false;
        if (this.depth == 0) {
            this.writer.flushBuffer();
        }
    }

    public void write(byte[] byArray, String string) throws IOException {
        this.write(byArray, 0, byArray.length, string);
    }

    public void writeString(String string) throws IOException {
        if (this.writingStartTag) {
            this.writer.write(62, string);
            this.writingStartTag = false;
        } else {
            this.writer.write(string);
        }
        this.onlyXML = false;
        if (this.depth == 0) {
            this.writer.flushBuffer();
        }
    }

    public void writeSnippet(String string, MappingScope mappingScope) throws IOException {
        int n = string.indexOf(">");
        if (mappingScope == null || !mappingScope.hasMappings() || n <= 0) {
            this.writeString(string);
            return;
        }
        if (string.charAt(n - 1) == '/') {
            --n;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n);
        for (int i = 0; i < mappingScope.size(); ++i) {
            Mapping mapping = mappingScope.get(i);
            String string4 = mapping.getPrefix();
            String string5 = string4.length() == 0 ? "xmlns=" : "xmlns:" + string4 + "=";
            int n2 = string2.indexOf(string5);
            if (n2 >= 0) continue;
            string2 = string2 + " " + string5 + "\"" + mapping.getNamespaceURI() + "\"";
        }
        this.writeString(string2 + string3);
    }

    public void writeSafeString(String string) throws IOException {
        if (string.length() > 9 && string.startsWith("<![") && string.substring(0, 9).toUpperCase().equals("<![CDATA[")) {
            this.writeString(string);
        } else {
            this.writeString(this.xmlEncodeString(string));
        }
    }

    public void writeComment(String string) throws IOException {
        this.writeString("<!--");
        this.writeSafeString(string);
        this.writeString("-->");
    }

    public void writeDOMElement(Element element, MappingScope mappingScope, boolean bl) throws IOException {
        this.scopes.push();
        if (mappingScope == null) {
            this.writeDOMElement(element);
            return;
        }
        this.scopes.replaceMappingScope(mappingScope);
        if (bl) {
            this.scopes.push();
        }
        this.writeDOMElement(element);
        if (bl) {
            this.scopes.pop();
        }
        this.scopes.pop();
    }

    public void writeDOMElement(Element element) throws IOException {
        Object object;
        Object object2;
        AttributesImpl attributesImpl = null;
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap.getLength() > 0) {
            attributesImpl = new AttributesImpl();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                object2 = (Attr)namedNodeMap.item(i);
                object = object2.getNamespaceURI() == null ? "" : object2.getNamespaceURI();
                boolean bl = object2.getName().startsWith("xmlns:");
                boolean bl2 = object2.getName().equals("xmlns");
                if (((String)object).equals("http://www.w3.org/2000/xmlns/") || bl || bl2) {
                    String string = object2.getValue();
                    String string2 = null;
                    if (bl) {
                        string2 = object2.getName().substring(object2.getName().indexOf(":") + 1);
                    } else if (bl2) {
                        string2 = "";
                    } else {
                        string2 = object2.getLocalName();
                        if (string2.equals("xmlns")) {
                            string2 = "";
                        }
                    }
                    this.addMapping(string2, string);
                    continue;
                }
                attributesImpl.addAttribute((String)object, object2.getLocalName(), object2.getName(), "CDATA", object2.getValue());
            }
        }
        String string = element.getNamespaceURI();
        object2 = element.getLocalName();
        if (string == null || string.length() == 0) {
            object2 = element.getNodeName();
        }
        object = QNameTable.createQName(string, (String)object2);
        String string3 = element.getPrefix();
        if (log.isDebugEnabled() && string != null && string.length() > 0) {
            String string4;
            String string5 = string4 = string3 == null ? "" : string3;
            if (!string.equals(this.getNamespaceURI(string4))) {
                log.debug("Potential User Problem :Missing namespace/prefix declaration for element:" + ((QName)object).toString() + " with prefix (" + string3 + ")");
            }
        }
        this.startElement((QName)object, string3, attributesImpl);
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof Element) {
                this.writeDOMElement((Element)node);
                continue;
            }
            if (node instanceof CDATASection) {
                this.writeString("<![CDATA[");
                this.writeString(((Text)node).getData());
                this.writeString("]]>");
                continue;
            }
            if (node instanceof Comment) {
                this.writeString("<!--");
                this.writeString(((CharacterData)node).getData());
                this.writeString("-->");
                continue;
            }
            if (!(node instanceof Text)) continue;
            this.writeSafeString(((Text)node).getData());
        }
        this.endElement();
    }

    public String getOrCreatePrefix(String string, String string2, boolean bl) {
        return this.scopes.getOrCreatePrefix(string, string2, bl);
    }

    public String getNamespaceURI(String string) {
        String string2 = null;
        MappingScope mappingScope = this.scopes.getMappingScope();
        Mapping mapping = mappingScope.getMappingForPrefix(string, false);
        if (mapping != null) {
            string2 = mapping.getNamespaceURI();
        }
        return string2;
    }

    public void addMapping(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException(Messages.getMessage("null00", "prefix"));
        }
        if (string2 == null) {
            throw new IllegalArgumentException(Messages.getMessage("null00", "namespaceURI"));
        }
        if (string2.length() == 0 && string.length() > 0) {
            throw new IllegalArgumentException(Messages.getMessage("mapUnqualNamespace00", string));
        }
        this.scopes.getMappingScope().addMapping(string2, string);
    }

    public String qName2String(QName qName) {
        return this.qName2String(qName, true);
    }

    public String qName2String(QName qName, boolean bl) {
        String string = this.scopes.getOrCreatePrefix(qName.getNamespaceURI(), null, bl);
        if (string.length() == 0) {
            return qName.getLocalPart();
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(':');
        stringBuffer.append(qName.getLocalPart());
        return stringBuffer.toString();
    }

    public void setForceRealPrefix(boolean bl) {
        this.forceRealPrefix = bl;
    }

    class Scopes {
        private MappingScope[] mArray = new MappingScope[10];
        int top = -1;
        boolean cacheValid = false;
        boolean uCacheValid = false;
        String cachePrefix = null;
        String cacheNamespaceURI = null;

        public Scopes() {
            this.push();
        }

        public MappingScope getMappingScope() {
            if (this.top < 0) {
                return null;
            }
            MappingScope mappingScope = this.mArray[this.top];
            if (mappingScope == null) {
                mappingScope = new MappingScope();
                if (this.top > 0) {
                    mappingScope.setParent(this.mArray[this.top - 1]);
                }
                this.mArray[this.top] = mappingScope;
            }
            return mappingScope;
        }

        public void replaceMappingScope(MappingScope mappingScope) {
            if (mappingScope != this.mArray[this.top]) {
                if (!mappingScope.hasMappings()) {
                    this.getMappingScope().clear();
                    if (this.top > 0) {
                        this.getMappingScope().setParent(this.mArray[this.top - 1]);
                    }
                } else {
                    this.cacheValid = false;
                    this.uCacheValid = false;
                    this.mArray[this.top] = (MappingScope)mappingScope.clone();
                    if (this.top > 0) {
                        this.getMappingScope().setParent(this.mArray[this.top - 1]);
                    }
                }
            }
        }

        public void push() {
            MappingScope mappingScope = null;
            if (this.top >= 0) {
                mappingScope = this.mArray[this.top];
            }
            boolean bl = mappingScope != null && !mappingScope.hasMappings();
            this.cacheValid = this.cacheValid && bl;
            this.uCacheValid = this.uCacheValid && bl;
            ++this.top;
            if (this.top >= this.mArray.length) {
                MappingScope[] mappingScopeArray = new MappingScope[this.mArray.length * 2];
                System.arraycopy(this.mArray, 0, mappingScopeArray, 0, this.mArray.length);
                this.mArray = mappingScopeArray;
            }
            this.getMappingScope().clear();
        }

        public void pop() {
            MappingScope mappingScope = this.mArray[this.top];
            if (mappingScope != null) {
                boolean bl = !mappingScope.hasMappings();
                this.cacheValid = this.cacheValid && bl;
                this.uCacheValid = this.uCacheValid && bl;
            }
            --this.top;
        }

        public void clearTop() {
            MappingScope mappingScope = this.mArray[this.top];
            if (mappingScope != null) {
                boolean bl = !mappingScope.hasMappings();
                this.cacheValid = this.cacheValid && bl;
                this.uCacheValid = this.uCacheValid && bl;
                mappingScope.clear();
            }
        }

        public String getOrCreatePrefix_Fast(String string) {
            if (string.length() == 0) {
                return this.getOrCreatePrefix_FastU();
            }
            MappingScope mappingScope = this.getMappingScope();
            if (this.cacheValid && string.equals(this.cacheNamespaceURI) && !mappingScope.hasMappings()) {
                return this.cachePrefix;
            }
            this.cacheNamespaceURI = string;
            this.cachePrefix = mappingScope.getOrCreatePrefix(this.cacheNamespaceURI, null, SerializationWriter.this.forceRealPrefix);
            this.cacheValid = !mappingScope.hasMappings();
            return this.cachePrefix;
        }

        private String getOrCreatePrefix_FastU() {
            MappingScope mappingScope = this.getMappingScope();
            if (this.uCacheValid && !mappingScope.hasMappings()) {
                return "";
            }
            if (mappingScope.getMappingForPrefix("", false) == null) {
                this.uCacheValid = !mappingScope.hasMappings();
                return "";
            }
            String string = mappingScope.getOrCreatePrefix("", null, false);
            this.uCacheValid = !mappingScope.hasMappings();
            return string;
        }

        public String getOrCreatePrefix(String string, String string2, boolean bl) {
            Object object;
            if (string == null || string.length() == 0) {
                Mapping mapping = this.getMappingScope().getMappingForPrefix("", false);
                if (mapping != null && mapping.getNamespaceURI().length() != 0) {
                    this.getMappingScope().addMapping("", "");
                }
                return "";
            }
            if (string2 != null && (object = this.getMappingScope().getMappingForPrefix(string2, false)) != null && (((Mapping)object).getNamespaceURI() == string || ((Mapping)object).getNamespaceURI().equals(string))) {
                return ((Mapping)object).getPrefix();
            }
            object = this.getMappingScope().getOrCreatePrefix(string, string2, bl);
            return object;
        }
    }
}

