/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.custom;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.custom.CustomProvider;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;

public class CustomRegistry {
    private static Log log = LogFactory.getLog(CustomRegistry.class.getName());
    private CustomRegistry parent;
    private List providers = new ArrayList();

    public CustomRegistry() {
    }

    protected CustomRegistry(CustomRegistry customRegistry) {
        this.parent = customRegistry;
    }

    public void populate(List list) {
        CustomProvider[] customProviderArray = list.toArray(new CustomProvider[0]);
        LinkedList<CustomProvider> linkedList = new LinkedList<CustomProvider>();
        LinkedList<CustomProvider> linkedList2 = new LinkedList<CustomProvider>();
        LinkedList<CustomProvider> linkedList3 = new LinkedList<CustomProvider>();
        for (int i = 0; i < customProviderArray.length; ++i) {
            CustomProvider customProvider = customProviderArray[i];
            short s = customProvider.getScope();
            if (s == 1) {
                linkedList3.add(customProvider);
                continue;
            }
            if (s == 2) {
                linkedList2.add(customProvider);
                continue;
            }
            if (s != 3) continue;
            linkedList.add(customProvider);
        }
        CustomRegistry customRegistry = null;
        if (!linkedList3.isEmpty()) {
            customRegistry = new CustomRegistry();
            for (int i = 0; i < linkedList3.size(); ++i) {
                customRegistry.addProvider((CustomProvider)linkedList3.get(i));
            }
        }
        if (!linkedList2.isEmpty()) {
            customRegistry = new CustomRegistry(customRegistry);
            for (int i = 0; i < linkedList2.size(); ++i) {
                customRegistry.addProvider((CustomProvider)linkedList2.get(i));
            }
        }
        this.parent = customRegistry;
        for (int i = 0; i < linkedList.size(); ++i) {
            this.addProvider((CustomProvider)linkedList.get(i));
        }
    }

    public void addProvider(CustomProvider customProvider) {
        if (this.pathExists(customProvider.getPath())) {
            if (log.isDebugEnabled()) {
                log.debug("The provider is not added because its path already exists: " + customProvider.getPath());
            }
        } else {
            this.providers.add(customProvider);
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("addCustomProvider00", customProvider.getPath()));
            }
        }
    }

    public QName[] getQNames() {
        int n;
        Object[] objectArray;
        HashSet<Object> hashSet = new HashSet<Object>();
        if (this.parent != null) {
            objectArray = this.parent.getQNames();
            for (n = 0; n < objectArray.length; ++n) {
                hashSet.add(objectArray[n]);
            }
        }
        objectArray = this.providers.toArray(new CustomProvider[0]);
        for (n = 0; n < objectArray.length; ++n) {
            QName[] qNameArray = ((CustomProvider)objectArray[n]).getQNames();
            for (int i = 0; i < qNameArray.length; ++i) {
                hashSet.add(qNameArray[i]);
            }
        }
        return hashSet.toArray(new QName[0]);
    }

    public String getJavaName(QName qName, String string) {
        String string2;
        if (string.equals("element") && !(string2 = qName.getLocalPart()).startsWith(">")) {
            string2 = ">" + string2;
            qName = QNameTable.createQName(qName.getNamespaceURI(), string2);
        }
        return this.getJavaName(qName);
    }

    public String getJavaName(QName qName) {
        String string = null;
        CustomProvider[] customProviderArray = this.providers.toArray(new CustomProvider[0]);
        for (int i = 0; i < customProviderArray.length && (string = customProviderArray[i].getJavaName(qName)) == null; ++i) {
        }
        if (string == null && this.parent != null) {
            string = this.parent.getJavaName(qName);
        }
        return string;
    }

    public QName getQName(String string) {
        QName qName = null;
        CustomProvider[] customProviderArray = this.providers.toArray(new CustomProvider[0]);
        for (int i = 0; i < customProviderArray.length && (qName = customProviderArray[i].getQName(string)) == null; ++i) {
        }
        if (qName == null && this.parent != null) {
            qName = this.parent.getQName(string);
        }
        return qName;
    }

    public String getBinderName(QName qName, String string, String string2) {
        String string3;
        if (string2.equals("element") && !(string3 = qName.getLocalPart()).startsWith(">")) {
            string3 = ">" + string3;
            qName = QNameTable.createQName(qName.getNamespaceURI(), string3);
        }
        return this.getBinderName(qName, string);
    }

    public String getBinderName(QName qName, String string) {
        String string2 = null;
        CustomProvider[] customProviderArray = this.providers.toArray(new CustomProvider[0]);
        for (int i = 0; i < customProviderArray.length && (string2 = customProviderArray[i].getBinderName(qName, string)) == null; ++i) {
        }
        if (string2 == null && this.parent != null) {
            string2 = this.parent.getBinderName(qName, string);
        }
        return string2;
    }

    public Properties getMappingInitParams(QName qName, String string) {
        Properties properties = null;
        CustomProvider[] customProviderArray = this.providers.toArray(new CustomProvider[0]);
        for (int i = 0; i < customProviderArray.length && (properties = customProviderArray[i].getMappingInitParams(qName, string)) == null; ++i) {
        }
        if (properties == null && this.parent != null) {
            properties = this.parent.getMappingInitParams(qName, string);
        }
        return properties;
    }

    private boolean pathExists(String string) {
        boolean bl = false;
        CustomProvider[] customProviderArray = this.providers.toArray(new CustomProvider[0]);
        for (int i = 0; i < customProviderArray.length; ++i) {
            String string2 = customProviderArray[i].getPath();
            if (!string2.equals(string)) continue;
            bl = true;
            break;
        }
        if (bl && log.isDebugEnabled()) {
            log.debug("The path is found at the current registry: " + string);
        }
        if (!bl && this.parent != null && (bl = this.parent.pathExists(string)) && log.isDebugEnabled()) {
            log.debug("The path is found at its parent registry: " + string);
        }
        return bl;
    }
}

