/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.custom;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.SerializerFactory;
import com.ibm.ws.webservices.engine.encoding.custom.CustomProvider;
import com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.TypeMapping;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Utils {
    public static final String PROVIDER_NAMESPACE = "http://www.ibm.com/webservices/customdatabinding/2004/06";
    public static final String ATTRIBUTE_SCOPE = "scope";
    public static final String ATTRIBUTE_SCOPE_SERVER = "server";
    public static final String ATTRIBUTE_SCOPE_APPLICATION = "application";
    public static final String ATTRIBUTE_SCOPE_MODULE = "module";
    public static final String ELEM_MAPPING = "mapping";
    public static final String ELEM_XML_QNAME = "xmlQName";
    public static final String ELEM_QNAME_SCOPE = "qnameScope";
    public static final String ELEM_JAVA_NAME = "javaName";
    public static final String ELEM_BINDER = "binder";
    public static final String ELEM_DESCRIPTION = "description";
    public static final String ELEM_PROPERTY = "initParam";
    public static final String ELEM_PROPERTY_NAME = "name";
    public static final String ELEM_PROPERTY_VALUE = "value";
    public static final String CUSTOM_BINDING_PROVIDER_XML = "META-INF/services/CustomBindingProvider.xml";
    private static Log log = LogFactory.getLog(Utils.class.getName());
    static final WeakHashMap providerCache = new WeakHashMap();
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$encoding$ser$CustomSerializerFactory;
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$encoding$ser$CustomDeserializerFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final synchronized List loadCustomProviders(ClassLoader classLoader) {
        ArrayList<CustomProvider> arrayList;
        Integer n = new Integer(System.identityHashCode(classLoader));
        if (log.isDebugEnabled()) {
            log.debug("Entered loadCustomProviders with classloader: " + n.toString());
        }
        if ((arrayList = (ArrayList<CustomProvider>)providerCache.get(n)) != null) {
            if (log.isDebugEnabled()) {
                log.debug("Found cached custom binding providers...");
            }
            return arrayList;
        }
        arrayList = new ArrayList<CustomProvider>();
        try {
            Object object;
            Document document;
            IExtension[] iExtensionArray;
            Serializable serializable;
            IExtensionPoint iExtensionPoint;
            HashSet<URL> hashSet = new HashSet<URL>();
            Enumeration enumeration = classLoader.getResources(CUSTOM_BINDING_PROVIDER_XML);
            while (enumeration != null && enumeration.hasMoreElements()) {
                hashSet.add(enumeration.nextElement());
            }
            IExtensionRegistry iExtensionRegistry = ExtensionRegistryFactory.instance().getExtensionRegistry();
            String string = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".customBindingProvider";
            String string2 = CUSTOM_BINDING_PROVIDER_XML;
            if (iExtensionRegistry != null && (iExtensionPoint = iExtensionRegistry.getExtensionPoint(string)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Processing extension point " + string);
                }
                serializable = new HashSet();
                iExtensionArray = iExtensionPoint.getExtensions();
                for (int i = 0; i < iExtensionArray.length; ++i) {
                    if (log.isDebugEnabled()) {
                        log.debug("Processing extension " + iExtensionArray[i].getUniqueIdentifier());
                    }
                    if ((document = Platform.getBundle((String)iExtensionArray[i].getNamespace())) == null || serializable.contains(object = document.getSymbolicName())) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("processing bundle " + (String)object);
                    }
                    serializable.add(object);
                    enumeration = null;
                    try {
                        enumeration = document.getResources(string2);
                    }
                    catch (IOException iOException) {
                        log.error("Exception trying to get bundle resources", iOException);
                    }
                    while (enumeration != null && enumeration.hasMoreElements()) {
                        hashSet.add((URL)enumeration.nextElement());
                    }
                }
            }
            iExtensionPoint = hashSet.iterator();
            while (iExtensionPoint.hasNext()) {
                serializable = (URL)iExtensionPoint.next();
                iExtensionArray = ((URL)serializable).toString();
                if (log.isDebugEnabled()) {
                    log.debug("Loading custom bindings from file: " + (String)iExtensionArray);
                }
                InputStream inputStream = null;
                try {
                    inputStream = ((URL)serializable).openStream();
                    document = XMLUtils.newDocument(inputStream);
                    object = document.getDocumentElement();
                    String string3 = object.getAttributeNS(PROVIDER_NAMESPACE, ATTRIBUTE_SCOPE);
                    if (string3 == null || string3.length() == 0) {
                        string3 = ATTRIBUTE_SCOPE_MODULE;
                    }
                    CustomProvider customProvider = new CustomProvider((String)iExtensionArray, string3);
                    for (Node node = object.getFirstChild(); node != null; node = node.getNextSibling()) {
                        String string4 = node.getLocalName();
                        if (string4 == null || !string4.equals(ELEM_MAPPING)) continue;
                        String string5 = null;
                        String string6 = null;
                        String string7 = null;
                        String string8 = null;
                        String string9 = null;
                        Properties properties = new Properties();
                        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                            string4 = node2.getLocalName();
                            if (string4 == null) continue;
                            if (string4.equals(ELEM_XML_QNAME)) {
                                String string10 = node2.getFirstChild().getNodeValue();
                                int n2 = string10.indexOf(58);
                                String string11 = string10.substring(0, n2);
                                string6 = string10.substring(n2 + 1);
                                Element element = (Element)node2;
                                while (string5 == null) {
                                    string5 = element.getAttribute("xmlns:" + string11);
                                    if (string5 == null || string5.length() != 0) continue;
                                    string5 = null;
                                    if ((element = element.getParentNode() instanceof Document ? null : (Element)element.getParentNode()) != null) continue;
                                }
                                if (string5 != null) continue;
                                log.warn(Messages.getMessage("noNamespaceForMapping", (String)iExtensionArray));
                                continue;
                            }
                            if (string4.equals(ELEM_JAVA_NAME)) {
                                string7 = node2.getFirstChild().getNodeValue();
                                continue;
                            }
                            if (string4.equals(ELEM_QNAME_SCOPE)) {
                                string8 = node2.getFirstChild().getNodeValue();
                                continue;
                            }
                            if (!string4.equals(ELEM_BINDER)) continue;
                            string9 = node2.getFirstChild().getNodeValue();
                        }
                        if (string8.equals("element") && !string6.startsWith(">")) {
                            string6 = ">" + string6;
                        }
                        customProvider.addMapping(QNameTable.createQName(string5, string6), string7, string8, string9, properties);
                    }
                    arrayList.add(customProvider);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.webservices.engine.encoding.custom.Utils.loadCustomProviders", "220");
            log.error(Messages.getMessage("loadCustomProviderError"), exception);
        }
        providerCache.put(n, arrayList);
        if (log.isDebugEnabled()) {
            log.debug("Cached custom binding providers with classloader: " + n.toString());
        }
        if (log.isDebugEnabled()) {
            log.debug("Exiting loadCustomProviders.  There are " + providerCache.size() + " map pairs in the HashMap.");
        }
        return arrayList;
    }

    public static void populateTypeMapping(List list, TypeMapping typeMapping) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CustomProvider customProvider = (CustomProvider)iterator.next();
            QName[] qNameArray = customProvider.getQNames();
            for (int i = 0; i < qNameArray.length; ++i) {
                String string = customProvider.getJavaName(qNameArray[i]);
                String string2 = customProvider.getBinderName(qNameArray[i], string);
                try {
                    Class clazz = ClassUtils.forName(string);
                    SerializerFactory serializerFactory = BaseSerializerFactory.createFactory(class$com$ibm$ws$webservices$engine$encoding$ser$CustomSerializerFactory == null ? Utils.class$("com.ibm.ws.webservices.engine.encoding.ser.CustomSerializerFactory") : class$com$ibm$ws$webservices$engine$encoding$ser$CustomSerializerFactory, clazz, qNameArray[i], string2);
                    DeserializerFactory deserializerFactory = BaseDeserializerFactory.createFactory(class$com$ibm$ws$webservices$engine$encoding$ser$CustomDeserializerFactory == null ? Utils.class$("com.ibm.ws.webservices.engine.encoding.ser.CustomDeserializerFactory") : class$com$ibm$ws$webservices$engine$encoding$ser$CustomDeserializerFactory, clazz, qNameArray[i], string2);
                    typeMapping.register(clazz, qNameArray[i], (javax.xml.rpc.encoding.SerializerFactory)serializerFactory, (javax.xml.rpc.encoding.DeserializerFactory)deserializerFactory);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    FFDCFilter.processException(classNotFoundException, "com.ibm.ws.webservices.engine.encoding.custom.Utils.populateTypeMapping", "251");
                    new RuntimeException(classNotFoundException);
                }
            }
        }
    }
}

