/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.custom.CustomPropertyProviderFactory;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.TypeDesc;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.encoding.ser.ArrayDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.AttributeDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.BeanDeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.SOAPElementDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer;
import com.ibm.ws.webservices.engine.encoding.utils.BeanDesc;
import com.ibm.ws.webservices.engine.encoding.utils.BeanPropertyTarget;
import com.ibm.ws.webservices.engine.encoding.utils.FieldDesc;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.events.NOOPProcessor;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.AttributeUtils;
import com.ibm.ws.webservices.engine.utils.BeanPropertyDescriptor;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BeanDeserializer
extends AttributeDeserializer
implements Serializable {
    protected static Log log = LogFactory.getLog(BeanDeserializer.class.getName());
    protected boolean isLiteral = false;
    FieldDesc childFieldDesc = null;
    BeanPropertyDescriptor childPropDesc = null;
    protected FieldDesc childCollectionFieldDesc;
    protected int childIndex = 0;
    Deserializer childDSer = null;
    protected ArrayList childList = new ArrayList();
    protected boolean childIsNil = false;
    private DEventProcessor noopProcessor = null;
    protected Class proxy;
    private static boolean ignoreUnknownElement = (Boolean)CustomPropertyProviderFactory.getProvider().getValue("com.ibm.ws.webservices.ignoreUnknownElements");

    public BeanDeserializer(Class clazz, QName qName) {
        this(clazz, qName, BeanDesc.getBeanDescForClass(clazz));
    }

    public BeanDeserializer(Class clazz, QName qName, TypeDesc typeDesc) {
        super(clazz, qName);
    }

    public BeanDeserializer(Class clazz, QName qName, BeanDesc beanDesc) {
        this(clazz, qName, beanDesc, BeanDeserializerFactory.getProperties(clazz, beanDesc));
    }

    public BeanDeserializer(Class clazz, QName qName, BeanDesc beanDesc, Map map) {
        super(clazz, qName, beanDesc, map);
    }

    public final void startElement(String string, String string2, String string3, Attributes attributes2, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("begin startElement");
        }
        String string4 = attributes2.getValue("href");
        if (this.value == null && string4 == null) {
            this.createValue();
        }
        boolean bl = this.isLiteral = deserializationContext.getEncodingStyle() == null || deserializationContext.getEncodingStyle().length() == 0;
        if (log.isDebugEnabled()) {
            log.debug(" is literal deserialization=" + this.isLiteral);
        }
        super.startElement(string, string2, string3, attributes2, mappingScope, deserializationContext, this.isLiteral ? Boolean.TRUE : null);
        if (log.isDebugEnabled()) {
            log.debug("end startElement");
        }
    }

    public final void onStartElement(String string, String string2, String string3, Attributes attributes2, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
        if (log.isDebugEnabled() && this.beanDesc == null) {
            log.debug("onStartElement beanDesc is NULL, EAR file may not be WSDeployed: localPart= " + string2);
        }
        if (this.beanDesc != null && this.beanDesc.hasAttributes()) {
            this.processAttributes(attributes2, mappingScope, deserializationContext, false);
        }
    }

    public final DEventProcessor onStartChild(String string, String string2, String string3, Attributes attributes2, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
        Object object;
        if (log.isDebugEnabled()) {
            log.debug("begin onStartChild for " + string2);
        }
        this.childDSer = null;
        this.childIsNil = false;
        this.childFieldDesc = this.beanDesc.getFieldDesc(string, string2);
        if (this.childFieldDesc == null && string3.length() == string2.length() && string != null && string.equals(this.xmlType.getNamespaceURI())) {
            this.childFieldDesc = this.beanDesc.getFieldDesc("", string2);
        }
        if (this.childFieldDesc == null && BeanDeserializer.isTolerateIncorrectNamespace(deserializationContext.getMessageContext()) && this.beanDesc.getFieldByName("_any") == null) {
            if (log.isDebugEnabled()) {
                log.debug("Attempting to find match with loose tolerance algorithm");
            }
            this.childFieldDesc = this.beanDesc.getFieldDesc(string2);
            object = Messages.getMessage("badElem00", this.javaType.getName(), string2, string);
            if (log.isDebugEnabled()) {
                log.debug("Field Descriptor from loose tolerance lookup: " + this.childFieldDesc);
                if (this.childFieldDesc != null) {
                    log.debug("The following message is suppressed due to the loose tolerance: " + (String)object);
                }
            }
        }
        object = null;
        if (this.childFieldDesc == null) {
            this.childFieldDesc = this.beanDesc.getFieldByName("_any");
            if (this.childFieldDesc != null) {
                object = this.childFieldDesc.getXmlType();
            } else {
                Deserializer deserializer = this.anyProcessing(string, string2, string3, attributes2, mappingScope, deserializationContext);
                if (deserializer != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("end onStartChild for " + string3 + " (due to anyContent processing)");
                    }
                    return deserializer;
                }
                if (log.isDebugEnabled()) {
                    log.debug("com.ibm.ws.webservices.ignoreUnknownElements: " + ignoreUnknownElement);
                }
                if (ignoreUnknownElement) {
                    if (log.isDebugEnabled()) {
                        log.debug("Will ignore unknown element " + string2);
                    }
                    return this.getNilProcessor();
                }
                throw new SAXException(Messages.getMessage("badElem00", this.javaType.getName(), string2, string));
            }
        }
        if (AttributeUtils.isNil(attributes2)) {
            this.childIsNil = true;
            if (!this.isLiteral && this.childFieldDesc.isMaxOccurs()) {
                if (this.childFieldDesc != this.childCollectionFieldDesc) {
                    this.childIndex = 0;
                }
                this.childCollectionFieldDesc = this.childFieldDesc;
                ++this.childIndex;
            }
            if (log.isDebugEnabled()) {
                log.debug("end onStartChild for " + string2 + " (due to isNil processing)");
            }
            return this.getNilProcessor();
        }
        object = object == null ? AttributeUtils.getTypeFromXSITypeAttr(attributes2, mappingScope) : object;
        Object object2 = object = object == null ? this.childFieldDesc.getXmlType() : object;
        if (log.isDebugEnabled()) {
            log.debug("childXMLType= " + object);
        }
        String string4 = this.isLiteral ? null : attributes2.getValue("href");
        Deserializer deserializer = this.childDSer = object == this.childFieldDesc.getXmlType() && string4 == null ? this.getCachedDeserializer(this.childFieldDesc, deserializationContext) : null;
        if (log.isDebugEnabled() && this.childDSer != null) {
            log.debug("using cached deserializer");
        }
        Deserializer deserializer2 = this.childDSer = this.childDSer != null ? this.childDSer : this.getDeserializer((QName)object, this.childFieldDesc.getJavaType(), string4, deserializationContext);
        if (log.isDebugEnabled() && this.childDSer != null) {
            log.debug("child deserializer= " + this.childDSer.getClass());
        }
        if (this.childDSer == null) {
            throw new SAXException(Messages.getMessage("noDeser00", ((QName)object).toString() + " javaType=" + this.childFieldDesc.getJavaType()));
        }
        if (!this.isLiteral) {
            this.childPropDesc = this.childFieldDesc.getPropertyDescriptor();
            if (this.childFieldDesc.isMaxOccurs() && !(this.childDSer instanceof ArrayDeserializer)) {
                if (log.isDebugEnabled()) {
                    log.debug("maxOccurs encoded processing");
                }
                if (this.childFieldDesc != this.childCollectionFieldDesc) {
                    this.childIndex = 0;
                }
                this.childCollectionFieldDesc = this.childFieldDesc;
                this.childDSer.registerValueTarget(new BeanPropertyTarget(this.value, this.childPropDesc, this.childIndex));
                ++this.childIndex;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("non-maxOccurs encoded processing");
                }
                this.childDSer.registerValueTarget(new BeanPropertyTarget(this.value, this.childPropDesc));
            }
            this.addChildDeserializer(this.childDSer, string4);
        }
        if (log.isDebugEnabled()) {
            log.debug("end onStartChild for " + string2);
        }
        return this.childDSer;
    }

    public final void onEndChild(String string, String string2, DeserializationContext deserializationContext) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("begin onEndChild:" + string2);
        }
        if (this.isLiteral && this.childFieldDesc != null) {
            Object object;
            Object object2 = object = this.childIsNil || this.childDSer == null ? null : this.childDSer.getValue();
            if (this.childFieldDesc.isMaxOccurs()) {
                if (log.isDebugEnabled()) {
                    log.debug("literal maxOccurs processing");
                }
                this.setIndexedProperty(object);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("literal non-maxOccurs processing");
                }
                if (!this._tryElementSetFromObject(this.childFieldDesc.getXmlName(), object)) {
                    if (log.isDebugEnabled()) {
                        log.debug("generated set did not succeed.");
                    }
                    this.childPropDesc = this.childFieldDesc.getPropertyDescriptor();
                    if (log.isDebugEnabled() && this.childPropDesc == null) {
                        if (this.beanDesc == null) {
                            log.debug("beanDesc is null");
                        } else {
                            log.debug(this.beanDesc.dumpString(""));
                        }
                    }
                    this.setIt(this.childPropDesc, object);
                }
            }
            if (this.childDSer != null) {
                this.childDSer.relinquish();
            }
        }
        this.containsChild = true;
        if (log.isDebugEnabled()) {
            log.debug("end onEndChild:" + string2);
        }
    }

    public final void onSimpleChild(String string, String string2, String string3, Attributes attributes2, MappingScope mappingScope, DeserializationContext deserializationContext, String string4) throws SAXException {
        String string5;
        this.childDSer = null;
        this.childIsNil = false;
        this.childFieldDesc = this.beanDesc.getFieldDesc(string, string2);
        if (this.childFieldDesc == null && string3.length() == string2.length() && string != null && (string == this.xmlType.getNamespaceURI() || string.equals(this.xmlType.getNamespaceURI()))) {
            this.childFieldDesc = this.beanDesc.getFieldDesc("", string2);
        }
        if (this.childFieldDesc == null) {
            if (log.isDebugEnabled()) {
                log.debug("leave onSimpleChild due to no fieldDesc");
            }
            super.onSimpleChild(string, string2, string3, attributes2, mappingScope, deserializationContext, string4);
            return;
        }
        if (this.tryElementSetFromString(this.childFieldDesc.getXmlName(), string4)) {
            if (log.isDebugEnabled()) {
                log.debug("leave onSimpleChild.. generated set did not succeed");
            }
            return;
        }
        this.childPropDesc = this.childFieldDesc.getPropertyDescriptor();
        Class clazz = this.childFieldDesc.getJavaType();
        if (this.childPropDesc == null || clazz != String.class && !clazz.isPrimitive()) {
            if (log.isDebugEnabled()) {
                log.debug("leave onSimpleChild because type is not simple:" + clazz);
            }
            super.onSimpleChild(string, string2, string3, attributes2, mappingScope, deserializationContext, string4);
            return;
        }
        String string6 = string5 = clazz == String.class ? string4 : SimpleDeserializer.convert(string4, clazz);
        if (this.childFieldDesc.isMaxOccurs()) {
            this.setIndexedProperty(string5);
        } else {
            this.setIt(this.childPropDesc, string5);
        }
        this.containsChild = true;
    }

    public final void onEndElement(String string, String string2, DeserializationContext deserializationContext) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("begin onEndElement:" + string2);
        }
        if (this.childCollectionFieldDesc != null) {
            if (log.isDebugEnabled()) {
                log.debug("complete indexed property assignment");
            }
            this.assignChildListToIndexedProperty();
        }
        if (log.isDebugEnabled()) {
            log.debug("end onEndElement:" + string2);
        }
    }

    protected final void setIndexedProperty(Object object) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("begin setIndexedProperty");
        }
        if (this.isLiteral) {
            if (log.isDebugEnabled()) {
                log.debug("literal processing");
            }
            if (this.childFieldDesc != this.childCollectionFieldDesc) {
                if (this.childCollectionFieldDesc != null) {
                    this.assignChildListToIndexedProperty();
                }
                this.childCollectionFieldDesc = this.childFieldDesc;
            }
            this.childList.add(object);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("encoded processing");
            }
            if (this.childFieldDesc != this.childCollectionFieldDesc) {
                this.childIndex = 0;
                this.childCollectionFieldDesc = this.childFieldDesc;
            }
            this.setIt(this.childFieldDesc.getPropertyDescriptor(), object, this.childIndex);
        }
        ++this.childIndex;
        if (log.isDebugEnabled()) {
            log.debug("end setIndexedProperty");
        }
    }

    private final void assignChildListToIndexedProperty() throws SAXException {
        if (!this.isLiteral) {
            return;
        }
        if (!this.tryElementSetFromList(this.childCollectionFieldDesc.getXmlName(), this.childList)) {
            this.childPropDesc = this.childCollectionFieldDesc.getPropertyDescriptor();
            for (int i = this.childList.size() - 1; i >= 0; --i) {
                this.setIt(this.childPropDesc, this.childList.get(i), i);
            }
        }
        this.childList.clear();
        this.childIndex = 0;
        this.childCollectionFieldDesc = null;
    }

    private BeanPropertyDescriptor getAnyPropertyDesc() {
        if (this.beanDesc == null) {
            return null;
        }
        return this.beanDesc.getAnyDesc();
    }

    public final boolean recycle() {
        boolean bl = super.recycle();
        if (bl) {
            this.value = null;
            this.isLiteral = false;
            this.childIsNil = false;
            this.childCollectionFieldDesc = null;
            this.childIndex = 0;
            this.childList.clear();
            this.proxy = null;
        }
        return bl;
    }

    private final void setIt(BeanPropertyDescriptor beanPropertyDescriptor, Object object) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("setIt(" + beanPropertyDescriptor.getName() + " , " + JavaUtils.getObjectIdentity(object) + ")");
        }
        try {
            beanPropertyDescriptor.set(this.getValue(), object);
        }
        catch (Exception exception) {
            try {
                Class clazz = beanPropertyDescriptor.getType();
                if (!JavaUtils.isConvertable(object, clazz)) {
                    throw exception;
                }
                object = JavaUtils.convert(object, clazz);
                beanPropertyDescriptor.set(this.getValue(), object);
            }
            catch (Exception exception2) {
                Object object2;
                FFDCFilter.processException((Throwable)exception2, "com.ibm.ws.webservices.engine.encoding.ser.BeanDeserializer.setIt", "528", this);
                String string = beanPropertyDescriptor.getName();
                if (log.isErrorEnabled()) {
                    object2 = "null";
                    if (object != null) {
                        object2 = object.getClass().getName();
                    }
                    log.error(Messages.getMessage("cantConvert02", new String[]{object2, string, beanPropertyDescriptor.getType().getName()}));
                }
                if (exception2 instanceof InvocationTargetException && (object2 = ((InvocationTargetException)exception2).getTargetException()) != null) {
                    throw new SAXException(((Throwable)object2).getMessage());
                }
                throw new SAXException(exception2);
            }
        }
    }

    private final void setIt(BeanPropertyDescriptor beanPropertyDescriptor, Object object, int n) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("setIt(" + beanPropertyDescriptor.getName() + " , " + JavaUtils.getObjectIdentity(object) + " , " + n + ")");
        }
        try {
            beanPropertyDescriptor.set(this.getValue(), n, object);
        }
        catch (Exception exception) {
            try {
                Class clazz = beanPropertyDescriptor.getType();
                if (JavaUtils.isConvertable(object, clazz)) {
                    object = JavaUtils.convert(object, clazz);
                    beanPropertyDescriptor.set(this.getValue(), n, object);
                }
                if (n == 0 && object.getClass().isArray() && !clazz.getClass().isArray()) {
                    for (int i = 0; i < Array.getLength(object); ++i) {
                        Object object2 = JavaUtils.convert(Array.get(object, i), clazz);
                        beanPropertyDescriptor.set(this.getValue(), i, object2);
                    }
                }
                throw exception;
            }
            catch (Exception exception2) {
                Object object3;
                FFDCFilter.processException((Throwable)exception2, "com.ibm.ws.webservices.engine.encoding.ser.BeanDeserializer.setIt", "595", this);
                String string = beanPropertyDescriptor.getName();
                string = string + "[" + n + "]";
                if (log.isErrorEnabled()) {
                    object3 = "null";
                    if (object != null) {
                        object3 = object.getClass().getName();
                    }
                    log.error(Messages.getMessage("cantConvert02", new String[]{object3, string, beanPropertyDescriptor.getType().getName()}));
                }
                if (exception2 instanceof InvocationTargetException && (object3 = ((InvocationTargetException)exception2).getTargetException()) != null) {
                    throw new SAXException(((Throwable)object3).getMessage());
                }
                throw new SAXException(exception2);
            }
        }
    }

    public final void valueComplete() throws SAXException {
        if (this.proxy != null && this.componentsReady()) {
            try {
                Method method2 = null;
                try {
                    method2 = (Method)AccessController.doPrivileged((PrivilegedExceptionAction)new getMethodPRIV(this.proxy, "convert"));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw privilegedActionException.getException();
                }
                this.value = method2.invoke(this.value, null);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.encoding.ser.BeanDeserializer.valueComplete", "662", this);
                throw new SAXException(exception);
            }
        }
        super.valueComplete();
    }

    private final DEventProcessor getNilProcessor() {
        if (this.noopProcessor == null || !this.noopProcessor.recycle()) {
            this.noopProcessor = new NOOPProcessor();
        }
        return this.noopProcessor;
    }

    private final Deserializer anyProcessing(String string, String string2, String string3, Attributes attributes2, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
        BeanPropertyDescriptor beanPropertyDescriptor = this.getAnyPropertyDesc();
        if (beanPropertyDescriptor != null) {
            try {
                javax.xml.soap.SOAPElement[] sOAPElementArray = (javax.xml.soap.SOAPElement[])beanPropertyDescriptor.get(this.value);
                int n = 0;
                if (sOAPElementArray != null) {
                    n = sOAPElementArray.length;
                }
                javax.xml.soap.SOAPElement[] sOAPElementArray2 = new javax.xml.soap.SOAPElement[n + 1];
                if (sOAPElementArray != null) {
                    System.arraycopy(sOAPElementArray, 0, sOAPElementArray2, 0, n);
                }
                SOAPElementDeserializer sOAPElementDeserializer = new SOAPElementDeserializer(SOAPElement.class, Constants.WEBSERVICES_SOAPELEMENT);
                SOAPFactory sOAPFactory = null;
                sOAPFactory = n > 0 ? ((SOAPElement)sOAPElementArray2[0]).getSOAPFactory() : new SOAPFactory();
                SOAPElement sOAPElement = sOAPFactory.createSOAPElement(string, string2, string3, attributes2, mappingScope.flatten(), deserializationContext, null);
                sOAPElementDeserializer.setMyElement(sOAPElement);
                sOAPElementArray2[n] = sOAPElement;
                beanPropertyDescriptor.set(this.value, sOAPElementArray2);
                return sOAPElementDeserializer;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.encoding.ser.BeanDeserializer.onStartChild", "273", this);
                throw new SAXException(exception);
            }
        }
        return null;
    }

    protected void createValue() throws SAXException {
        this.value = null;
        Exception exception = null;
        try {
            if (!Throwable.class.isAssignableFrom(this.javaType)) {
                this.value = this.javaType.newInstance();
            }
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if (this.value == null) {
            try {
                Class clazz = null;
                Object object = AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                    public Object run() {
                        try {
                            return BeanDeserializer.this.javaType.getClassLoader();
                        }
                        catch (Throwable throwable) {
                            return throwable;
                        }
                    }
                });
                ClassLoader classLoader = null;
                if (object instanceof ClassLoader) {
                    classLoader = (ClassLoader)object;
                }
                if (classLoader == null) {
                    clazz = ClassUtils.forName(this.javaType.getName() + "_Helper");
                } else {
                    try {
                        clazz = ClassUtils.forName(this.javaType.getName() + "_Helper", true, classLoader);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        clazz = ClassUtils.forName(this.javaType.getName() + "_Helper");
                    }
                }
                Method method2 = null;
                try {
                    method2 = (Method)AccessController.doPrivileged((PrivilegedExceptionAction)new getMethodPRIV(clazz, "createProxy"));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw privilegedActionException.getException();
                }
                this.value = method2.invoke(null, null);
                this.proxy = this.value.getClass();
                this.beanDesc.setBeanPropertyDescriptors(this.proxy);
                this.propertyMap = this.beanDesc.getPropertyDescriptorMap();
            }
            catch (Exception exception3) {
                FFDCFilter.processException((Throwable)exception3, "com.ibm.ws.webservices.engine.encoding.ser.BeanDeserializer.createValue", "644", this);
                Exception exception4 = exception != null ? exception : exception3;
                throw new SAXException(Messages.getMessage("cantCreateBean00", this.javaType.getName(), exception4.toString()));
            }
        }
    }

    protected boolean tryElementSetFromString(QName qName, String string) {
        return false;
    }

    protected boolean tryElementSetFromObject(QName qName, Object object) {
        if (object instanceof String) {
            return this.tryElementSetFromString(qName, (String)object);
        }
        return false;
    }

    protected boolean _tryElementSetFromObject(QName qName, Object object) {
        if (object == null) {
            try {
                boolean bl = this.tryElementSetFromObject(qName, object);
                if (!bl && log.isDebugEnabled()) {
                    log.debug("tryElementSetFromObject returned unsuccessfully for QName= " + qName + " and a null value." + "Processing continues without exception.");
                }
                return true;
            }
            catch (Throwable throwable) {
                if (log.isDebugEnabled()) {
                    log.debug("tryElementSetFromObject threw an exception for QName= " + qName + " and a null value." + "Processing continues, and the following exception is ignored " + throwable);
                }
                return true;
            }
        }
        return this.tryElementSetFromObject(qName, object);
    }

    protected boolean tryElementSetFromList(QName qName, List list) {
        return false;
    }

    public String getBuildNumber() {
        return this.beanDesc == null ? null : this.beanDesc.getBuildNumber();
    }

    private class getMethodPRIV
    implements PrivilegedExceptionAction {
        private Class clazz;
        private String methodName;

        getMethodPRIV(Class clazz, String string) {
            this.clazz = clazz;
            this.methodName = string;
        }

        public Object run() throws Exception {
            return this.clazz.getMethod(this.methodName, null);
        }
    }
}

