/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleValueSerializer;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;

public class CalendarSerializer
implements SimpleValueSerializer {
    protected static Log log = LogFactory.getLog(CalendarSerializer.class.getName());
    private static ThreadLocal tlZuluDateTime = new ThreadLocal(){

        protected synchronized Object initialValue() {
            if (log.isDebugEnabled()) {
                log.debug("Creating new zulu datetime SimpleDateFormat object");
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            return simpleDateFormat;
        }
    };
    private static ThreadLocal tlZuluDate = new ThreadLocal(){

        protected synchronized Object initialValue() {
            if (log.isDebugEnabled()) {
                log.debug("Creating new zulu date SimpleDateFormat object");
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            return simpleDateFormat;
        }
    };
    private static ThreadLocal tlZuluTime = new ThreadLocal(){

        protected synchronized Object initialValue() {
            if (log.isDebugEnabled()) {
                log.debug("Creating new zulu time SimpleDateFormat object");
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss.SSS'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            return simpleDateFormat;
        }
    };
    protected QName xmlType;
    protected Class javaType;
    private QName componentTypeQName;

    public CalendarSerializer(Class clazz, QName qName, QName qName2, QName qName3) {
        this.xmlType = qName;
        this.javaType = clazz;
        this.componentTypeQName = qName3 == null ? qName : qName3;
    }

    public void serialize(QName qName, Attributes attributes2, Object object, SerializationContext serializationContext) throws IOException {
        serializationContext.getSerializationWriter().simpleElement(qName, attributes2, this.getValueAsString(object, serializationContext));
    }

    public String getValueAsString(Object object, SerializationContext serializationContext) {
        if (Constants.equals(Constants.XSD_DATE, this.componentTypeQName)) {
            return CalendarSerializer.getDateValueAsString(object);
        }
        if (Constants.equals(Constants.XSD_TIME, this.componentTypeQName)) {
            return CalendarSerializer.getTimeValueAsString(object);
        }
        return CalendarSerializer.getDateTimeValueAsString(object);
    }

    public static String getDateValueAsString(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        if (((Calendar)object).get(0) == 0) {
            stringBuffer.append("-");
            ((Calendar)object).set(0, 1);
        }
        Date date = ((Calendar)object).getTime();
        SimpleDateFormat simpleDateFormat = CalendarSerializer.getZuluDateFormatter();
        stringBuffer.append(simpleDateFormat.format(date));
        return stringBuffer.toString();
    }

    public static String getTimeValueAsString(Object object) {
        SimpleDateFormat simpleDateFormat = CalendarSerializer.getZuluTimeFormatter();
        return simpleDateFormat.format(((Calendar)object).getTime());
    }

    public static String getDateTimeValueAsString(Object object) {
        Date date = object instanceof Date ? (Date)object : ((Calendar)object).getTime();
        SimpleDateFormat simpleDateFormat = CalendarSerializer.getZuluDateTimeFormatter();
        return simpleDateFormat.format(date);
    }

    public String getMechanismType() {
        return "WebServices SAX Mechanism";
    }

    public String getBuildNumber() {
        return null;
    }

    private static SimpleDateFormat getZuluDateTimeFormatter() {
        return (SimpleDateFormat)tlZuluDateTime.get();
    }

    private static SimpleDateFormat getZuluDateFormatter() {
        return (SimpleDateFormat)tlZuluDate.get();
    }

    private static SimpleDateFormat getZuluTimeFormatter() {
        return (SimpleDateFormat)tlZuluTime.get();
    }
}

