/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DefaultDeserializer;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.encoding.utils.DeserializerTarget;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.AttributeUtils;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MapDeserializer
extends Deserializer {
    protected static Log log = LogFactory.getLog(MapDeserializer.class.getName());
    public static final Object KEYHINT = new Object();
    public static final Object VALHINT = new Object();
    public static final Object NILHINT = new Object();

    public MapDeserializer(Class clazz, QName qName) {
        super(clazz, qName);
    }

    public void onStartElement(String string, String string2, String string3, Attributes attributes2, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("Enter MapDeserializer::startElement()");
        }
        if (AttributeUtils.isNil(attributes2)) {
            return;
        }
        this.setValue(new HashMap());
        if (log.isDebugEnabled()) {
            log.debug("Exit: MapDeserializer::startElement()");
        }
    }

    public DEventProcessor onStartChild(String string, String string2, String string3, Attributes attributes2, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: MapDeserializer::onStartChild()");
        }
        ItemDeserializer itemDeserializer = new ItemDeserializer(this);
        this.addChildDeserializer(itemDeserializer, attributes2.getValue("href"));
        if (log.isDebugEnabled()) {
            log.debug("Exit: MapDeserializer::onStartChild()");
        }
        return itemDeserializer;
    }

    public void setValue(Object object, Object object2) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("gotValue00", "MapDeserializer", "" + object));
        }
        if (object2 instanceof Deserializer) {
            super.setValue(object, object2);
        } else {
            ((Map)this.value).put(object2, object);
        }
    }

    class ItemDeserializer
    extends Deserializer {
        Object key;
        Object myValue;
        int numSet;
        MapDeserializer md;

        ItemDeserializer(MapDeserializer mapDeserializer2) {
            super(null, null);
            this.numSet = 0;
            this.md = null;
            this.md = mapDeserializer2;
        }

        public void setValue(Object object, Object object2) throws SAXException {
            if (object2 instanceof Deserializer) {
                super.setValue(this.value, object2);
            } else {
                if (object2 == KEYHINT) {
                    this.key = object;
                } else if (object2 == VALHINT) {
                    this.myValue = object;
                } else if (object2 != NILHINT) {
                    return;
                }
                ++this.numSet;
                if (this.numSet == 2) {
                    this.md.setValue(this.myValue, this.key);
                }
            }
        }

        public DEventProcessor onStartChild(String string, String string2, String string3, Attributes attributes2, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
            QName qName = AttributeUtils.getTypeFromAttributes(string, string2, attributes2, mappingScope);
            Deserializer deserializer = deserializationContext.getDeserializer(null, qName);
            if (deserializer == null) {
                deserializer = new DefaultDeserializer();
            }
            DeserializerTarget deserializerTarget = null;
            if (AttributeUtils.isNil(attributes2)) {
                deserializerTarget = new DeserializerTarget(this, NILHINT);
            } else if (string2.equals("key")) {
                deserializerTarget = new DeserializerTarget(this, KEYHINT);
            } else if (string2.equals("value")) {
                deserializerTarget = new DeserializerTarget(this, VALHINT);
            }
            if (deserializerTarget != null) {
                deserializer.registerValueTarget(deserializerTarget);
            }
            this.addChildDeserializer(deserializer, attributes2.getValue("href"));
            return deserializer;
        }
    }
}

