/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.description.TypeDesc;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.ser.AttributeDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.CalendarDeserializer;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SimpleDeserializer
extends AttributeDeserializer {
    String valString = null;
    StringBuffer valBuffer = null;
    private Constructor constructor = null;

    public SimpleDeserializer(Class clazz, QName qName) {
        super(clazz, qName);
    }

    public SimpleDeserializer(Class clazz, QName qName, TypeDesc typeDesc) {
        super(clazz, qName);
    }

    public boolean recycle() {
        boolean bl = super.recycle();
        if (bl) {
            this.valString = null;
            this.valBuffer = null;
        }
        return bl;
    }

    public void removeValueTargets() {
        if (this.targets != null) {
            this.targets.clear();
        }
    }

    public void setConstructor(Constructor constructor) {
        this.constructor = constructor;
    }

    public DEventProcessor onStartChild(String string, String string2, String string3, Attributes attributes2, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
        throw new SAXException(Messages.getMessage("cantHandle00", "SimpleDeserializer"));
    }

    public void characters(String string) throws SAXException {
        if (this.valString != null) {
            if (this.valBuffer == null) {
                this.valBuffer = new StringBuffer();
                this.valBuffer.append(this.valString);
            }
            this.valBuffer.append(string);
        } else {
            this.valString = string;
        }
    }

    public void onEndElement(String string, String string2, DeserializationContext deserializationContext) throws SAXException {
        if (this.isNil) {
            this.value = null;
            return;
        }
        try {
            if (this.valBuffer != null) {
                this.value = this.makeValue(this.valBuffer.toString());
            } else {
                if (this.valString == null) {
                    this.valString = "";
                }
                this.value = this.makeValue(this.valString);
            }
        }
        catch (SAXException sAXException) {
            FFDCFilter.processException((Throwable)sAXException, "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.onEndElement", "225", this);
            throw sAXException;
        }
        catch (InvocationTargetException invocationTargetException) {
            FFDCFilter.processException((Throwable)invocationTargetException, "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.onEndElement", "211", this);
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof Exception) {
                throw new SAXException((Exception)throwable);
            }
            throw new SAXException(invocationTargetException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.onEndElement", "218", this);
            throw new SAXException(exception);
        }
        super.onEndElement(string, string2, deserializationContext);
    }

    public static Object convert(String string, Class clazz) throws SAXException {
        if (clazz == String.class) {
            return string;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return SimpleDeserializer.parseInteger(string);
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            try {
                return SimpleDeserializer.parseBoolean(string);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.convert", "265");
                throw new SAXException(Messages.getMessage("badBool00", string));
            }
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return SimpleDeserializer.parseFloat(string);
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return SimpleDeserializer.parseDouble(string);
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return SimpleDeserializer.parseShort(string);
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return SimpleDeserializer.parseLong(string);
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return SimpleDeserializer.parseByte(string);
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return SimpleDeserializer.parseCharacter(string);
        }
        return null;
    }

    protected Object makeValue(String string) throws Exception {
        Object object = SimpleDeserializer.convert(string, this.javaType);
        if (object == null) {
            return this.constructor.newInstance(string);
        }
        return object;
    }

    public void onStartElement(String string, String string2, String string3, Attributes attributes2, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
        this.processAttributes(attributes2, mappingScope, deserializationContext, true);
    }

    public static boolean parseboolean(String string) {
        if (string == "1" || string == "true") {
            return true;
        }
        if (string == "0" || string == "false") {
            return false;
        }
        String string2 = string.trim();
        if (string2.length() == 1) {
            switch (string2.charAt(0)) {
                case '0': {
                    return false;
                }
                case '1': {
                    return true;
                }
            }
        } else {
            if (string2.equalsIgnoreCase("true")) {
                return true;
            }
            if (string2.equalsIgnoreCase("false")) {
                return false;
            }
        }
        throw new NumberFormatException("invalid boolean");
    }

    public static Boolean parseBoolean(String string) {
        if (string == "1" || string == "true") {
            return Boolean.TRUE;
        }
        if (string == "0" || string == "false") {
            return Boolean.FALSE;
        }
        String string2 = string.trim();
        if (string2.length() == 1) {
            switch (string2.charAt(0)) {
                case '0': {
                    return Boolean.FALSE;
                }
                case '1': {
                    return Boolean.TRUE;
                }
            }
        } else {
            if (string2.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (string2.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
        }
        throw new NumberFormatException("invalid boolean");
    }

    public static byte parsebyte(String string) {
        return Byte.parseByte(string.trim());
    }

    public static Byte parseByte(String string) {
        return new Byte(string.trim());
    }

    public static char parsechar(String string) {
        if (string.length() > 0) {
            return string.charAt(0);
        }
        return '\u0000';
    }

    public static Character parseCharacter(String string) {
        if (string.length() > 0) {
            return new Character(string.charAt(0));
        }
        return new Character('\u0000');
    }

    public static short parseshort(String string) {
        return Short.parseShort(string.trim());
    }

    public static Short parseShort(String string) {
        return new Short(string.trim());
    }

    public static int parseint(String string) {
        return Integer.parseInt(string.trim());
    }

    public static Integer parseInteger(String string) {
        return new Integer(string.trim());
    }

    public static long parselong(String string) {
        return Long.parseLong(string.trim());
    }

    public static Long parseLong(String string) {
        return new Long(string.trim());
    }

    public static float parsefloat(String string) {
        if ((string = string.trim()).equals("NaN")) {
            return Float.NaN;
        }
        if (string.equals("INF")) {
            return Float.POSITIVE_INFINITY;
        }
        if (string.equals("-INF")) {
            return Float.NEGATIVE_INFINITY;
        }
        return Float.parseFloat(string);
    }

    public static Float parseFloat(String string) {
        if ((string = string.trim()).equals("NaN")) {
            return new Float(Float.NaN);
        }
        if (string.equals("INF")) {
            return new Float(Float.POSITIVE_INFINITY);
        }
        if (string.equals("-INF")) {
            return new Float(Float.NEGATIVE_INFINITY);
        }
        return new Float(Float.parseFloat(string));
    }

    public static double parsedouble(String string) {
        if ((string = string.trim()).equals("NaN")) {
            return Double.NaN;
        }
        if (string.equals("INF")) {
            return Double.POSITIVE_INFINITY;
        }
        if (string.equals("-INF")) {
            return Double.NEGATIVE_INFINITY;
        }
        return Double.parseDouble(string);
    }

    public static Double parseDouble(String string) {
        if ((string = string.trim()).equals("NaN")) {
            return new Double(Double.NaN);
        }
        if (string.equals("INF")) {
            return new Double(Double.POSITIVE_INFINITY);
        }
        if (string.equals("-INF")) {
            return new Double(Double.NEGATIVE_INFINITY);
        }
        return new Double(string);
    }

    public static Date parseDateTimeToDate(String string) {
        return SimpleDeserializer.parseDateTimeToCalendar(string).getTime();
    }

    public static Calendar parseDateTimeToCalendar(String string) {
        return (Calendar)CalendarDeserializer.makeDateTimeValue(string);
    }

    public static Calendar parseDateToCalendar(String string) {
        return (Calendar)CalendarDeserializer.makeDateValue(string);
    }

    public static Calendar parseTimeToCalendar(String string) {
        return (Calendar)CalendarDeserializer.makeTimeValue(string);
    }

    public static BigInteger parseBigInteger(String string) {
        return new BigInteger(string);
    }

    public static BigDecimal parseBigDecimal(String string) {
        return new BigDecimal(string);
    }

    public String getBuildNumber() {
        return this.beanDesc == null ? null : this.beanDesc.getBuildNumber();
    }

    public void relinquish() {
        this.valString = null;
        this.valBuffer = null;
        super.relinquish();
    }
}

