/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.Version;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.TypeDesc;
import com.ibm.ws.webservices.engine.encoding.utils.FieldDesc;
import com.ibm.ws.webservices.engine.utils.BeanPropertyDescriptor;
import com.ibm.ws.webservices.engine.utils.BeanUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;

public class BeanDesc {
    private static Log log = LogFactory.getLog(BeanDesc.class.getName());
    protected Class javaClass = null;
    protected ArrayList fields = new ArrayList();
    protected HashMap fieldDescMap = new HashMap();
    protected HashMap fieldNameMap = new HashMap();
    protected BeanPropertyDescriptor[] propertyDescriptors = null;
    protected Map propertyMap = null;
    protected boolean _hasAttributes = false;
    protected String buildNumber = null;

    protected BeanDesc() {
    }

    public static BeanDesc getBeanDescForClass(Class clazz) {
        TypeDesc typeDesc;
        if (log.isDebugEnabled()) {
            log.debug("Enter getBeanDescForClass class= " + clazz);
        }
        if ((typeDesc = TypeDesc.getTypeDescForClass(clazz)) == null) {
            if (log.isDebugEnabled()) {
                log.debug("Exit getBeanDescForClass BeanDesc=null");
            }
            return null;
        }
        BeanDesc beanDesc = new BeanDesc();
        beanDesc.javaClass = clazz;
        beanDesc.buildNumber = (String)typeDesc.getOption("buildNum");
        if (beanDesc.buildNumber == null) {
            beanDesc.buildNumber = "pre-WAS 6.0 build";
        } else if (beanDesc.buildNumber.equals(Version.getRawBuildNum())) {
            beanDesc.buildNumber = null;
        }
        com.ibm.ws.webservices.engine.description.FieldDesc[] fieldDescArray = typeDesc.getFields();
        if (fieldDescArray != null) {
            for (int i = 0; i < fieldDescArray.length; ++i) {
                FieldDesc fieldDesc = new FieldDesc(fieldDescArray[i]);
                beanDesc.addFieldDesc(fieldDesc);
                beanDesc.fields.add(fieldDesc);
            }
        }
        beanDesc._prime();
        if (log.isDebugEnabled()) {
            log.debug(beanDesc.dumpString(""));
            log.debug("Exit getBeanDescForClass");
        }
        return beanDesc;
    }

    public final BeanPropertyDescriptor getAnyDesc() {
        return (BeanPropertyDescriptor)this.propertyMap.get("_any");
    }

    public final ArrayList getFields() {
        return this.fields;
    }

    public final FieldDesc getFieldByName(String string) {
        return (FieldDesc)this.fieldNameMap.get(string);
    }

    public final boolean hasAttributes() {
        return this._hasAttributes;
    }

    public final BeanPropertyDescriptor[] getPropertyDescriptors() {
        if (this.propertyDescriptors == null) {
            this.propertyDescriptors = BeanUtils.getPd(this.javaClass, this);
            this.propertyMap = null;
            this.getPropertyDescriptorMap();
        }
        return this.propertyDescriptors;
    }

    public final synchronized BeanPropertyDescriptor[] setBeanPropertyDescriptors(Class clazz) {
        if (log.isDebugEnabled()) {
            log.debug("Start setBeanPropertyDescriptors for proxy=" + clazz);
        }
        this.propertyDescriptors = BeanUtils.getPd(clazz, this);
        this.propertyMap = null;
        this.getPropertyDescriptorMap();
        if (log.isDebugEnabled()) {
            log.debug("BeanDesc is updated.");
            log.debug(this.dumpString(""));
            log.debug("End setBeanPropertyDescriptors for proxy=" + clazz);
        }
        return this.propertyDescriptors;
    }

    public final Map getPropertyDescriptorMap() {
        if (this.propertyMap != null) {
            return this.propertyMap;
        }
        if (this.propertyDescriptors == null) {
            this.getPropertyDescriptors();
        }
        this.propertyMap = new HashMap();
        for (int i = 0; i < this.propertyDescriptors.length; ++i) {
            BeanPropertyDescriptor beanPropertyDescriptor = this.propertyDescriptors[i];
            this.propertyMap.put(beanPropertyDescriptor.getName(), beanPropertyDescriptor);
            FieldDesc fieldDesc = this.getFieldByName(beanPropertyDescriptor.getName());
            if (fieldDesc != null) {
                this.setJavaType(fieldDesc, beanPropertyDescriptor);
                fieldDesc.setPropertyDescriptor(beanPropertyDescriptor);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("FieldDesc not found for BeanPropertyDescriptor " + beanPropertyDescriptor + " name=" + beanPropertyDescriptor.getName());
            log.debug(this.dumpString(""));
        }
        return this.propertyMap;
    }

    protected void setJavaType(FieldDesc fieldDesc, BeanPropertyDescriptor beanPropertyDescriptor) {
        Class clazz = beanPropertyDescriptor.getFullType();
        if (!clazz.isArray()) {
            fieldDesc.setJavaType(clazz);
        } else {
            if (!fieldDesc.isMaxOccurs() && ("pre-WAS 6.0 build".equals(this.buildNumber) || Constants.equals(Constants.XSD_ANY, fieldDesc.getXmlType())) && beanPropertyDescriptor.isIndexed()) {
                fieldDesc.setMaxOccurs(true);
            }
            if (!fieldDesc.isMaxOccurs()) {
                fieldDesc.setJavaType(clazz);
            } else {
                fieldDesc.setJavaType(clazz.getComponentType());
            }
        }
    }

    public final synchronized void addFieldDesc(FieldDesc fieldDesc) {
        Object object;
        String string = fieldDesc.getXmlName().getLocalPart();
        String string2 = fieldDesc.getXmlName().getNamespaceURI();
        Object v = this.fieldDescMap.get(string);
        if (v == null) {
            this.fieldDescMap.put(string, fieldDesc);
        } else if (v instanceof FieldDesc) {
            object = (FieldDesc)v;
            if (!((com.ibm.ws.webservices.engine.description.FieldDesc)object).getXmlName().getNamespaceURI().equals(string2)) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                this.fieldDescMap.put(string, hashMap);
                hashMap.put(string2, fieldDesc);
                hashMap.put(((com.ibm.ws.webservices.engine.description.FieldDesc)object).getXmlName().getNamespaceURI(), object);
            }
        } else {
            object = (HashMap)v;
            FieldDesc fieldDesc2 = (FieldDesc)((HashMap)object).get(string2);
            if (fieldDesc2 == null) {
                ((HashMap)object).put(string2, fieldDesc);
            }
        }
        this.fieldNameMap.put(fieldDesc.getFieldName(), fieldDesc);
        if (!fieldDesc.isElement()) {
            this._hasAttributes = true;
        }
        if (this.propertyMap != null) {
            object = (BeanPropertyDescriptor)this.propertyMap.get(fieldDesc.getFieldName());
            if (object != null) {
                this.setJavaType(fieldDesc, (BeanPropertyDescriptor)object);
                fieldDesc.setPropertyDescriptor((BeanPropertyDescriptor)object);
            } else if (log.isDebugEnabled() && fieldDesc.getPropertyDescriptor() == null) {
                log.debug("BeanPropertyDescriptor not found for FieldDesc " + fieldDesc + " fieldName=" + fieldDesc.getFieldName());
                log.debug(this.dumpString(""));
            }
        }
    }

    public final FieldDesc getFieldDesc(String string, String string2) {
        Object v;
        if (string == null) {
            string = "";
        }
        if ((v = this.fieldDescMap.get(string2)) == null) {
            return null;
        }
        if (v.getClass() == FieldDesc.class) {
            String string3 = ((FieldDesc)v).getXmlName().getNamespaceURI();
            if (string3 == string || string3.equals(string)) {
                return (FieldDesc)v;
            }
            return null;
        }
        return (FieldDesc)((HashMap)v).get(string);
    }

    public final FieldDesc getFieldDesc(String string) {
        Object v;
        if (log.isDebugEnabled()) {
            log.debug("enter getFieldDesc(localPart) with " + string);
        }
        if ((v = this.fieldDescMap.get(string)) == null) {
            if (log.isDebugEnabled()) {
                log.debug("No matching FieldDesc found.");
            }
            return null;
        }
        if (v.getClass() == FieldDesc.class) {
            if (log.isDebugEnabled()) {
                log.debug("Found FieldDesc " + ((FieldDesc)v).getXmlName());
            }
            return (FieldDesc)v;
        }
        if (log.isDebugEnabled()) {
            log.debug("Found multiple fields with the same local name.  Returning null for this ambibuous case");
        }
        return null;
    }

    protected void _prime() {
        BeanDesc beanDesc;
        if (log.isDebugEnabled()) {
            log.debug("Start _prime");
        }
        this.getPropertyDescriptorMap();
        Class clazz = this.javaClass.getSuperclass();
        if (clazz != null && !clazz.getName().startsWith("java.") && (beanDesc = BeanDesc.getBeanDescForClass(clazz)) != null) {
            if (log.isDebugEnabled()) {
                log.debug("Collecting information from super class " + clazz);
            }
            this.fields.addAll(0, beanDesc.fields);
            beanDesc.getFieldDesc("", "");
            Iterator iterator = beanDesc.fieldDescMap.values().iterator();
            while (iterator.hasNext()) {
                Object v = iterator.next();
                if (v instanceof FieldDesc) {
                    this.addFieldDesc((FieldDesc)v);
                    continue;
                }
                Map map = (Map)v;
                Iterator iterator2 = map.values().iterator();
                while (iterator2.hasNext()) {
                    FieldDesc fieldDesc = (FieldDesc)iterator2.next();
                    this.addFieldDesc(fieldDesc);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("End _prime");
        }
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public String dumpString(String string) {
        String string2 = "";
        try {
            int n;
            string2 = string2 + string + "BeanDesc Start for " + JavaUtils.getObjectIdentity(this) + "\n";
            string2 = string2 + string + " javaClass =      " + this.javaClass + "\n";
            string2 = string2 + string + " buildNumber =    " + this.buildNumber + "\n";
            string2 = string2 + string + " _hasAttributes = " + this._hasAttributes + "\n";
            if (this.fields != null) {
                for (n = 0; n < this.fields.size(); ++n) {
                    string2 = string2 + string + " FieldDesc " + n + "\n";
                    string2 = string2 + string + ((FieldDesc)this.fields.get(n)).dumpString(string + "  ") + "\n";
                }
            }
            if (this.propertyDescriptors != null) {
                for (n = 0; n < this.propertyDescriptors.length; ++n) {
                    string2 = string2 + string + " BeanPropertyDescriptor " + n + "\n";
                    string2 = string2 + string + this.propertyDescriptors[n].dumpString(string + "  ") + "\n";
                }
            }
            if (this.fieldDescMap != null) {
                string2 = string2 + string + " FieldDescMap Start" + "\n";
                string2 = string2 + this.fieldDescMap.toString();
                string2 = string2 + "\n";
                string2 = string2 + string + " FieldDescMap End" + "\n";
            }
            if (this.fieldNameMap != null) {
                string2 = string2 + string + " FieldNameMap Start" + "\n";
                string2 = string2 + this.fieldNameMap.toString();
                string2 = string2 + "\n";
                string2 = string2 + string + " FieldNameMap End" + "\n";
            }
            if (this.propertyMap != null) {
                string2 = string2 + string + " PropertyMap Start" + "\n";
                string2 = string2 + this.propertyMap.toString();
                string2 = string2 + "\n";
                string2 = string2 + string + " PropertyMap End" + "\n";
            }
            string2 = string2 + string + "BeanDesc End for " + JavaUtils.getObjectIdentity(this) + "\n";
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.webservices.engine.encoding.ser.utils.BeanDesc.dumpString", "%C", this);
            string2 = "An exception occurred while creating the BeanDesc String for " + JavaUtils.getObjectIdentity(this) + " exception=" + throwable;
        }
        return string2;
    }
}

