/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.events;

import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesProperties;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class DEventProcessor {
    protected static Log log = LogFactory.getLog(DEventProcessor.class.getName());
    protected boolean containsChild = false;
    protected boolean inUse = true;
    private static final String TOLERATE_INVALID_NAMESPACE_KEY = "com.ibm.ws.webservices.jaxrpc.parse.tolerate.invalid.namespace";
    private static boolean JVM_TOLERATE_INVALID_NAMESPACE = DEventProcessor.getTolerateInvalidNamespaceJVM();

    public boolean recycle() {
        if (!this.inUse) {
            this.inUse = true;
            return true;
        }
        return false;
    }

    public void relinquish() {
        this.inUse = false;
    }

    public void elementEvent(SOAPElement sOAPElement) {
    }

    public void childElementEvent(SOAPElement sOAPElement) {
    }

    public abstract void startElement(String var1, String var2, String var3, Attributes var4, MappingScope var5, DeserializationContext var6) throws SAXException;

    public abstract void endElement(String var1, String var2, DeserializationContext var3) throws SAXException;

    public void characters(String string) throws SAXException {
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
    }

    public abstract DEventProcessor onStartChild(String var1, String var2, String var3, Attributes var4, MappingScope var5, DeserializationContext var6) throws SAXException;

    public void onEndChild(String string, String string2, DeserializationContext deserializationContext) throws SAXException {
        this.containsChild = true;
    }

    public void onSimpleChild(String string, String string2, String string3, Attributes attributes2, MappingScope mappingScope, DeserializationContext deserializationContext, String string4) throws SAXException {
        DEventProcessor dEventProcessor = this.onStartChild(string, string2, string3, attributes2, mappingScope, deserializationContext);
        deserializationContext.getEventConverter().pushDEventProcessor(dEventProcessor);
        dEventProcessor.startElement(string, string2, string3, attributes2, mappingScope, deserializationContext);
        if (string4 != null && string4.length() > 0) {
            dEventProcessor = deserializationContext.getEventConverter().popDEventProcessor();
            deserializationContext.getEventConverter().pushDEventProcessor(dEventProcessor);
            dEventProcessor.characters(string4);
        }
        dEventProcessor = deserializationContext.getEventConverter().popDEventProcessor();
        dEventProcessor.endElement(string, string2, deserializationContext);
        this.onEndChild(string, string2, deserializationContext);
    }

    public static boolean isTolerateIncorrectNamespace(MessageContext messageContext) {
        Object object = null;
        if (messageContext != null && (object = messageContext.getProperty(TOLERATE_INVALID_NAMESPACE_KEY)) != null && log.isDebugEnabled()) {
            log.debug("MessageContext used for isTolerateIncorrectNamespace setting: " + object);
        }
        if (object == null && (object = WebServicesProperties.getProperty(TOLERATE_INVALID_NAMESPACE_KEY)) != null && log.isDebugEnabled()) {
            log.debug("WebServicesProperties used for isTolerateIncorrectNamespace setting: " + object);
        }
        boolean bl = false;
        if (object != null) {
            bl = JavaUtils.isTrueExplicitly(object);
        } else {
            bl = JVM_TOLERATE_INVALID_NAMESPACE;
            if (object != null && log.isDebugEnabled()) {
                log.debug("System Property used for isTolerateIncorrectNamespace setting: " + object);
            }
        }
        return bl;
    }

    private static boolean getTolerateInvalidNamespaceJVM() {
        String string = System.getProperty(TOLERATE_INVALID_NAMESPACE_KEY);
        boolean bl = JavaUtils.isTrueExplicitly(string, false);
        if (log.isDebugEnabled()) {
            log.debug("System Property Key: com.ibm.ws.webservices.jaxrpc.parse.tolerate.invalid.namespace");
            log.debug("System Property Raw Value: " + string);
            log.debug("System Property Value: " + bl);
        }
        return bl;
    }
}

