/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.handlers;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesEngine;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.handlers.BasicHandler;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.session.Session;
import com.ibm.ws.webservices.engine.session.SimpleSession;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.SessionUtils;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeader;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeaderElement;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.server.ServiceLifecycle;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;

public class SimpleSessionHandler
extends BasicHandler {
    protected static Log log = LogFactory.getLog(SimpleSessionHandler.class.getName());
    public static final String SESSION_ID = "SimpleSession.id";
    public static final String SESSION_NS = "http://websphere.ibm.com/webservices/session";
    public static final String SESSION_LOCALPART = "sessionID";
    public static final QName sessionHeaderName = QNameTable.createQName("http://websphere.ibm.com/webservices/session", "sessionID");
    private Hashtable activeSessions = new Hashtable();
    private long reapPeriodicity = 30L;
    private long lastReapTime = 0L;
    private int defaultSessionTimeout = 60;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(MessageContext messageContext) throws WebServicesFault {
        long l = System.currentTimeMillis();
        boolean bl = false;
        Object object = this;
        synchronized (object) {
            if (l > this.lastReapTime + this.reapPeriodicity * 1000L) {
                bl = true;
                this.lastReapTime = l;
            }
        }
        if (bl) {
            Object object2;
            Object object3;
            Object object4;
            object = this.activeSessions.entrySet();
            HashSet<Object> hashSet = new HashSet<Object>();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                object4 = (Map.Entry)iterator.next();
                object3 = object4.getKey();
                object2 = (SimpleSession)object4.getValue();
                if (l - ((SimpleSession)object2).getLastAccessTime() <= (long)(((SimpleSession)object2).getTimeout() * 1000)) continue;
                log.debug(Messages.getMessage("timeout00", object3.toString()));
                hashSet.add(object3);
            }
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                object3 = iterator.next();
                object4 = (SimpleSession)this.activeSessions.get(object3);
                this.activeSessions.remove(object3);
                object2 = ((SimpleSession)object4).getKeys();
                while (object2 != null && object2.hasMoreElements()) {
                    String string = (String)object2.nextElement();
                    Object object5 = ((SimpleSession)object4).get(string);
                    if (object5 == null || !(object5 instanceof ServiceLifecycle)) continue;
                    ((ServiceLifecycle)object5).destroy();
                }
            }
        }
        if (messageContext.isClient()) {
            this.doClient(messageContext);
        } else {
            this.doServer(messageContext);
        }
    }

    public void doClient(MessageContext messageContext) throws WebServicesFault {
        if (messageContext.getPastPivot()) {
            try {
                Message message = messageContext.getResponseMessage();
                if (message == null) {
                    return;
                }
                SOAPEnvelope sOAPEnvelope = message.getSOAPEnvelope();
                SOAPHeader sOAPHeader = (SOAPHeader)sOAPEnvelope.getHeader();
                Iterator iterator = sOAPHeader.getChildElements(SESSION_NS, SESSION_LOCALPART);
                SOAPHeaderElement sOAPHeaderElement = null;
                if (iterator.hasNext()) {
                    sOAPHeaderElement = (SOAPHeaderElement)iterator.next();
                }
                if (sOAPHeaderElement == null) {
                    return;
                }
                Long l = (Long)sOAPHeaderElement.asObject(Constants.XSD_LONG);
                WebServicesEngine webServicesEngine = messageContext.getEngine();
                webServicesEngine.setOption(SESSION_ID, l);
                sOAPHeaderElement.setProcessed(true);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.handlers.SimpleSessionHandler.doClient", "258", this);
                throw WebServicesFault.makeFault(exception);
            }
        }
        WebServicesEngine webServicesEngine = messageContext.getEngine();
        Long l = (Long)webServicesEngine.getOption(SESSION_ID);
        if (l == null) {
            return;
        }
        Message message = messageContext.getRequestMessage();
        if (message == null) {
            throw new WebServicesFault(Messages.getMessage("noRequest00"));
        }
        SOAPEnvelope sOAPEnvelope = message.getSOAPEnvelope();
        try {
            SOAPHeaderElement sOAPHeaderElement = sOAPEnvelope.getSOAPFactory().createSOAPHeaderElement(SESSION_NS, SESSION_LOCALPART);
            sOAPHeaderElement.setAlternateContent(l);
            sOAPEnvelope.getHeader().addChildElement((SOAPElement)sOAPHeaderElement);
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.webservices.engine.handlers.SimpleSessionHandler.doClient", "281", this);
            throw WebServicesFault.makeFault(sOAPException);
        }
    }

    public void doServer(MessageContext messageContext) throws WebServicesFault {
        Object object;
        Serializable serializable;
        if (messageContext.getPastPivot()) {
            Long l = (Long)messageContext.getProperty(SESSION_ID);
            if (l == null) {
                return;
            }
            Message message = messageContext.getResponseMessage();
            if (message == null) {
                return;
            }
            SOAPEnvelope sOAPEnvelope = message.getSOAPEnvelope();
            try {
                SOAPHeaderElement sOAPHeaderElement = sOAPEnvelope.getSOAPFactory().createSOAPHeaderElement(SESSION_NS, SESSION_LOCALPART);
                sOAPHeaderElement.setAlternateContent(l);
                sOAPEnvelope.getHeader().addChildElement((SOAPElement)sOAPHeaderElement);
            }
            catch (SOAPException sOAPException) {
                FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.webservices.engine.handlers.SimpleSessionHandler.doServer", "311", this);
                throw WebServicesFault.makeFault(sOAPException);
            }
        }
        Message message = messageContext.getRequestMessage();
        if (message == null) {
            throw new WebServicesFault(Messages.getMessage("noRequest00"));
        }
        SOAPHeaderElement sOAPHeaderElement = null;
        SOAPEnvelope sOAPEnvelope = message.getSOAPEnvelope();
        try {
            serializable = (SOAPHeader)sOAPEnvelope.getHeader();
            object = serializable.getChildElements(SESSION_NS, SESSION_LOCALPART);
            if (object.hasNext()) {
                sOAPHeaderElement = (SOAPHeaderElement)object.next();
            }
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.webservices.engine.handlers.SimpleSessionHandler.doServer", "329", this);
            throw WebServicesFault.makeFault(sOAPException);
        }
        if (sOAPHeaderElement != null) {
            try {
                serializable = (Long)sOAPHeaderElement.asObject(Constants.XSD_LONG);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.handlers.SimpleSessionHandler.doServer", "341", this);
                throw WebServicesFault.makeFault(exception);
            }
        } else {
            serializable = this.getNewSession();
        }
        object = (SimpleSession)this.activeSessions.get(serializable);
        if (object == null) {
            serializable = this.getNewSession();
            object = (SimpleSession)this.activeSessions.get(serializable);
        }
        ((SimpleSession)object).touch();
        messageContext.setSession((Session)object);
        messageContext.setProperty(SESSION_ID, serializable);
    }

    private synchronized Long getNewSession() {
        Long l = SessionUtils.generateSession();
        SimpleSession simpleSession = new SimpleSession();
        simpleSession.setTimeout(this.defaultSessionTimeout);
        this.activeSessions.put(l, simpleSession);
        return l;
    }

    public void setReapPeriodicity(long l) {
        this.reapPeriodicity = l;
    }

    public void setDefaultSessionTimeout(int n) {
        this.defaultSessionTimeout = n;
    }
}

