/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.handlers.jaxrpc;

import com.ibm.websphere.csi.PooledObject;
import com.ibm.websphere.csi.PooledObjectMaster;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.HandlerPool;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.wsspi.webservices.rpc.handler.Handler;
import com.ibm.wsspi.webservices.rpc.handler.SystemHandler;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import org.apache.commons.logging.Log;

public class HandlerProxy
implements PooledObjectMaster,
SystemHandler {
    protected static Log log = LogFactory.getLog(HandlerProxy.class.getName());
    private HandlerPool _owningPool;
    private javax.xml.rpc.handler.Handler _handler;

    public HandlerProxy(HandlerPool handlerPool) throws IllegalAccessException, InstantiationException {
        this._owningPool = handlerPool;
        this._handler = (javax.xml.rpc.handler.Handler)this._owningPool.getHandlerClass().newInstance();
        this._handler.init(handlerPool.getHandlerInfo());
    }

    public String getHandlerClassName() {
        return this._owningPool.getHandlerClassName();
    }

    public PooledObject newInstance() {
        try {
            return new HandlerProxy(this._owningPool);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.handlers.jaxrpc.HandlerProxy.newInstance", "95", this);
            log.error(Messages.getMessage("jaxRpcHandlerUnexpectedClassLoadFailure00", this.getHandlerClassName()), exception);
            throw new JAXRPCException(Messages.getMessage("jaxRpcHandlerUnexpectedClassLoadFailure00", this.getHandlerClassName()), (Throwable)exception);
        }
    }

    public void discard() {
        this._handler.destroy();
    }

    public void reset() {
    }

    public void init(HandlerInfo handlerInfo) {
    }

    public void destroy() {
        this._handler.destroy();
    }

    public boolean handleRequest(MessageContext messageContext) {
        return this._handler.handleRequest(messageContext);
    }

    public boolean handleResponse(MessageContext messageContext) {
        return this._handler.handleResponse(messageContext);
    }

    public boolean handleFault(MessageContext messageContext) {
        return this._handler.handleFault(messageContext);
    }

    public void handleClosure(MessageContext messageContext) {
        if (this._handler instanceof Handler) {
            ((Handler)this._handler).handleClosure(messageContext);
        }
    }

    public void preHandleIncoming(MessageContext messageContext) {
        if (this._handler instanceof SystemHandler) {
            ((SystemHandler)this._handler).preHandleIncoming(messageContext);
        }
    }

    public QName[] getHeaders() {
        return this._handler.getHeaders();
    }
}

