/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.handlers.jaxrpc;

import com.ibm.websphere.csi.Pool;
import com.ibm.websphere.csi.PoolManager;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;

class PoolManagerProxy {
    protected static Log log = LogFactory.getLog(PoolManagerProxy.class.getName());
    private PoolManager poolManager;
    private List queue;
    private int poolLimit;
    private String lock = "lock";

    static PoolManagerProxy newInstance() {
        return new PoolManagerProxy(100);
    }

    private PoolManagerProxy(int n) {
        PoolManagerProxy poolManagerProxy = this;
        this.poolManager = poolManagerProxy.poolManager.newInstance();
        this.queue = new ArrayList();
        this.poolLimit = n;
    }

    PoolProxy createThreadSafePool(Object object, int n, int n2) {
        return new PoolProxy(object, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dump() {
        PoolManager poolManager = this.poolManager;
        synchronized (poolManager) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = "\n";
            stringBuffer.append("PoolManagerProxy");
            stringBuffer.append(string);
            stringBuffer.append("poolLimit    = " + this.poolLimit);
            stringBuffer.append(string);
            stringBuffer.append("poolMangager = " + this.poolManager.toString());
            stringBuffer.append(string);
            stringBuffer.append("queue size   = " + this.queue.size());
            stringBuffer.append(string);
            return stringBuffer.toString();
        }
    }

    public static void main(String[] stringArray) {
        PoolManagerProxy poolManagerProxy = PoolManagerProxy.newInstance();
        for (int i = 0; i < 1000; ++i) {
            PoolProxy poolProxy = poolManagerProxy.createThreadSafePool(new Integer(i), 1, 5);
            poolProxy.put(new String("MyValue" + i));
        }
    }

    class PoolProxy {
        int min;
        int max;
        Object owner;
        Pool _pool;

        PoolProxy(Object object, int n, int n2) {
            this.owner = object;
            this.min = n;
            this.max = n2;
        }

        public synchronized Object get() {
            return this.getPool().get();
        }

        public synchronized void put(Object object) {
            this.getPool().put(object);
        }

        private synchronized Pool getPool() {
            if (this._pool == null) {
                this.createPool();
            }
            return this._pool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void destroy() {
            if (this._pool != null) {
                String string = PoolManagerProxy.this.lock;
                synchronized (string) {
                    int n = PoolManagerProxy.this.queue.indexOf(this);
                    if (n >= 0) {
                        PoolManagerProxy.this.queue.remove(n);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Destroying: " + this.dumpPoolProxy(" "));
                        log.debug("New Pool is : " + PoolManagerProxy.this.dump());
                    }
                    this._pool.destroy();
                    this._pool = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void createPool() {
            PoolProxy poolProxy = null;
            String string = PoolManagerProxy.this.lock;
            synchronized (string) {
                this._pool = PoolManagerProxy.this.poolManager.createThreadSafePool(this.min, this.max);
                PoolManagerProxy.this.queue.add(this);
                poolProxy = null;
                if (PoolManagerProxy.this.queue.size() > PoolManagerProxy.this.poolLimit) {
                    poolProxy = (PoolProxy)PoolManagerProxy.this.queue.get(0);
                }
            }
            if (poolProxy != null) {
                poolProxy.destroy();
            }
        }

        public synchronized String dumpPoolProxy(String string) {
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = "\n";
            stringBuffer.append(string + "pool  = " + this._pool);
            stringBuffer.append(string2);
            stringBuffer.append(string + "min   = " + this.min);
            stringBuffer.append(string2);
            stringBuffer.append(string + "max   = " + this.max);
            stringBuffer.append(string2);
            stringBuffer.append(string + "owner = " + this.owner);
            stringBuffer.append(string2);
            return stringBuffer.toString();
        }
    }
}

