/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.soap;

import com.ibm.websphere.webservices.soap.IBMSOAPConnection;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.client.Connection;
import com.ibm.ws.webservices.engine.client.Service;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;

public class SOAPConnectionImpl
extends IBMSOAPConnection {
    protected static Log log = LogFactory.getLog(SOAPConnectionImpl.class.getName());
    boolean closed = false;

    public SOAPMessage call(SOAPMessage sOAPMessage, Object object) throws SOAPException {
        if (this.closed) {
            throw new SOAPException(Messages.getMessage("connectionClosed00"));
        }
        try {
            MessageContext messageContext;
            block7: {
                Service service = new Service();
                messageContext = new MessageContext(service.getEngine());
                messageContext.setRequestMessage((Message)sOAPMessage);
                messageContext.setProperty("javax.xml.rpc.session.maintain", new Boolean(service.getMaintainSession()));
                messageContext.setProperty("SOAPConnection", new Boolean(true));
                URL uRL = new URL(object.toString());
                Connection connection = service.getConnection(uRL);
                messageContext.protectProperties();
                String[] stringArray = sOAPMessage.getMimeHeaders().getHeader("SOAPAction");
                if (stringArray != null && stringArray[0] != null) {
                    String string = stringArray[0];
                    messageContext.setUseSOAPAction(true);
                    messageContext.setSOAPActionURI(string);
                }
                try {
                    connection.invoke(messageContext);
                }
                catch (WebServicesFault webServicesFault) {
                    FFDCFilter.processException((Throwable)webServicesFault, "com.ibm.ws.webservices.engine.soap.SOAPConnectionImpl.call", "145", (Object)this);
                    if (webServicesFault.isSOAPPartFault()) break block7;
                    throw webServicesFault;
                }
            }
            messageContext.resetProperties();
            return messageContext.getResponseMessage();
        }
        catch (MalformedURLException malformedURLException) {
            FFDCFilter.processException((Throwable)malformedURLException, "com.ibm.ws.webservices.engine.soap.SOAPConnectionImpl.call", "111", (Object)this);
            throw new SOAPException((Throwable)malformedURLException);
        }
        catch (WebServicesFault webServicesFault) {
            FFDCFilter.processException((Throwable)webServicesFault, "com.ibm.ws.webservices.engine.soap.SOAPConnectionImpl.call", "114", (Object)this);
            throw new SOAPException((Throwable)webServicesFault);
        }
    }

    public void close() throws SOAPException {
        if (this.closed) {
            throw new SOAPException(Messages.getMessage("connectionClosed00"));
        }
        this.closed = true;
    }
}

