/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.engine.transport.Connection;
import com.ibm.ws.webservices.engine.transport.channel.WSOutboundConnection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

public final class OneWayConnectionMap {
    private static final TraceComponent _tc = Tr.register(OneWayConnectionMap.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private static ConcurrentHashMap hmap = null;
    private static OneWayConnectionMap onewayConnMap = null;

    private OneWayConnectionMap() {
        hmap = new ConcurrentHashMap(131, 0.75f, 16);
    }

    public static final synchronized OneWayConnectionMap getInstance() {
        if (onewayConnMap == null) {
            onewayConnMap = new OneWayConnectionMap();
        }
        return onewayConnMap;
    }

    public synchronized void putConnection(String string, Connection connection) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OneWayConnectionMap.putConnection()...");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Related objects: " + connection.getConnection());
        }
        if (!hmap.containsKey(string)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Puting " + connection + " in map with key: " + string);
            }
            hmap.put(string, connection);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...OneWayConnectionMap.putConnection()");
        }
    }

    public boolean containsKey(String string) {
        boolean bl = false;
        if (hmap.containsKey(string)) {
            bl = true;
        }
        return bl;
    }

    public synchronized void cleanupConnections() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OneWayConnectionMap.cleanupConnections()...");
        }
        if (hmap != null && !hmap.isEmpty()) {
            WSOutboundConnection wSOutboundConnection = null;
            Iterator iterator = hmap.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Connection connection = (Connection)hmap.get(string);
                if (connection == null) continue;
                wSOutboundConnection = connection.getConnection();
                long l = connection.getRecycleTime();
                long l2 = wSOutboundConnection.timeFromLastAccess();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Connection last access elapsed time in ms : " + l2 + " Recycle time in ms : " + l);
                }
                if (l2 < l) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "One way connection time limit exceeded. Resetting the connection and removing key: " + string);
                }
                connection.resetConnection();
                hmap.remove(string);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...OneWayConnectionMap.cleanupConnections()");
        }
    }
}

