/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.transport.OneWayConnectionMap;
import com.ibm.ws.webservices.engine.transport.channel.Monitor;
import com.ibm.ws.webservices.engine.transport.channel.OutboundConnectionGroup;
import com.ibm.ws.webservices.engine.transport.channel.WSAddress;
import com.ibm.ws.webservices.engine.transport.channel.WSOutboundConnection;
import com.ibm.ws.webservices.engine.transport.http.HTTPConstants;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.TimerTask;

public final class OutboundConnectionCache {
    private static final TraceNLS nls;
    private static final TraceComponent _tc;
    private static final TraceComponent _tc2;
    private static final TraceComponent _tc3;
    private static int REFRESHTIME;
    private static int CONN_TIMEOUT;
    private static int MAX_CONN;
    private static int EIGHTY_PERCENT;
    private static int WAITING_THREADS_THRESHOLD;
    private HashMap chainlist = null;
    private Monitor monitor = Monitor.getMonitor();
    private boolean alreadyWaited = false;
    private LinkedList tempPool = null;
    private int waitingThreads = 0;
    private static int reqCounter;
    private static OutboundConnectionCache cache;
    private static Timer _timer;
    private static Timer _onewaytimer;
    private OneWayConnectionMap onewayConnMap = null;
    private static long oneWayRecycleTime;
    private static int ONEWAYREFRESHTIME;

    private OutboundConnectionCache() {
        _timer = new Timer(true);
        _timer.schedule((TimerTask)new CleanupTask(), REFRESHTIME, (long)REFRESHTIME);
        this.startOneWayTimer(oneWayRecycleTime);
        this.chainlist = new HashMap();
        this.tempPool = new LinkedList();
        EIGHTY_PERCENT = Math.round(MAX_CONN * 4 / 5);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "com.ibm.websphere.webservices.http.connectionTimeout: " + CONN_TIMEOUT + " ms, " + "com.ibm.websphere.webservices.http.connectionPoolCleanUpTime" + ": " + REFRESHTIME + " ms, " + "com.ibm.websphere.webservices.http.maxConnection" + ": " + MAX_CONN);
        }
    }

    public static int maxConnection() {
        return MAX_CONN;
    }

    public static int connTimeout() {
        return CONN_TIMEOUT;
    }

    public long getOneWayRecycleTime() {
        return oneWayRecycleTime;
    }

    public synchronized void startOneWayTimer(long l) {
        if (_onewaytimer == null && (oneWayRecycleTime = l) > 0L) {
            if ((int)(oneWayRecycleTime / 2L) > ONEWAYREFRESHTIME) {
                ONEWAYREFRESHTIME = (int)(oneWayRecycleTime / 2L);
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "com.ibm.websphere.webservices.http.ConnectionResetDelay: " + oneWayRecycleTime + " ms, " + "oneWayConnectionCleanupTime" + ": " + ONEWAYREFRESHTIME + " ms, ");
            }
            _onewaytimer = new Timer(true);
            _onewaytimer.schedule((TimerTask)new OneWayConnectionCleanupTask(), ONEWAYREFRESHTIME, (long)ONEWAYREFRESHTIME);
            this.onewayConnMap = OneWayConnectionMap.getInstance();
        }
    }

    public static synchronized OutboundConnectionCache getInstance() {
        if (cache == null) {
            cache = new OutboundConnectionCache();
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WSOutboundConnection findConnectionAndInvalidate(WSAddress wSAddress) throws WebServicesFault, InterruptedException, Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionCache.findConnectionAndInvalidate()");
        }
        WSOutboundConnection wSOutboundConnection = null;
        OutboundConnectionGroup outboundConnectionGroup = null;
        String string = wSAddress.keyValueforPool();
        HashMap hashMap = this.chainlist;
        synchronized (hashMap) {
            outboundConnectionGroup = (OutboundConnectionGroup)this.chainlist.get(string);
            if (outboundConnectionGroup != null) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("connTableKeyFound", string, "true"));
                }
                wSOutboundConnection = outboundConnectionGroup.invalidateConnection(wSAddress);
            }
            WSOutboundConnection wSOutboundConnection2 = null;
            ListIterator listIterator = this.tempPool.listIterator(0);
            if (listIterator != null) {
                while (listIterator.hasNext()) {
                    wSOutboundConnection2 = (WSOutboundConnection)listIterator.next();
                    if (!wSOutboundConnection2.groupID().equals(string)) continue;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, Messages.getMessage("invalidatedConnObject01", wSAddress.toString(), wSOutboundConnection2.toString()));
                    }
                    wSOutboundConnection2.release(null);
                    listIterator.remove();
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "OutboundConnectionCache.findConnectionAndInvalidate()");
        }
        return wSOutboundConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WSOutboundConnection findGroupAndGetConnection(WSAddress wSAddress) throws WebServicesFault, InterruptedException, Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionCache.findGroupAndGetConnection() WAITING_THREADS_THRESHOLD is " + WAITING_THREADS_THRESHOLD);
        }
        WSOutboundConnection wSOutboundConnection = null;
        OutboundConnectionGroup outboundConnectionGroup = null;
        String string = wSAddress.keyValueforPool();
        int n = 0;
        int n2 = 0;
        this.attemptNotify();
        HashMap hashMap = this.chainlist;
        synchronized (hashMap) {
            if (!this.chainlist.containsKey(string)) {
                outboundConnectionGroup = new OutboundConnectionGroup();
                this.chainlist.put(string, outboundConnectionGroup);
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("outConnGroupCreated", string));
                }
            } else {
                outboundConnectionGroup = (OutboundConnectionGroup)this.chainlist.get(string);
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("connTableKeyFound", string, "true"));
                }
            }
        }
        hashMap = this.chainlist;
        synchronized (hashMap) {
            this.alreadyWaited = false;
            while (wSOutboundConnection == null) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "alreadyWaited at top of loop: " + this.alreadyWaited);
                }
                n = this.poolSize() + this.tempPool.size();
                n2 = this.connectionsInUse();
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("enter00", Messages.getMessage("connPoolStatus00", String.valueOf(n), String.valueOf(n2), String.valueOf(MAX_CONN))));
                }
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Unused objects in findGroupAndGetConnection::tempPool: " + this.tempPool.size());
                }
                if (n < MAX_CONN) {
                    if (outboundConnectionGroup.currPoolSize() > outboundConnectionGroup.totalInUse()) {
                        wSOutboundConnection = outboundConnectionGroup.getConnection(wSAddress);
                    }
                    if (wSOutboundConnection != null) break;
                    wSOutboundConnection = outboundConnectionGroup.createConnection(wSAddress);
                    break;
                }
                if (n == MAX_CONN) {
                    long l;
                    long l2 = CONN_TIMEOUT;
                    long l3 = 0L;
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "Unused objects in findGroupAndGetConnection::tempPool: " + this.tempPool.size());
                    }
                    if (this.tempPool.size() > 0) {
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, "Local pool is available for faster access.");
                        }
                        try {
                            wSOutboundConnection = (WSOutboundConnection)this.tempPool.removeFirst();
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            wSOutboundConnection = null;
                        }
                        if (wSOutboundConnection != null) {
                            wSOutboundConnection = outboundConnectionGroup.addConnection(wSAddress, wSOutboundConnection, string);
                            break;
                        }
                    } else {
                        int n3;
                        int n4 = outboundConnectionGroup.currPoolSize();
                        if (n4 > (n3 = outboundConnectionGroup.totalInUse())) {
                            wSOutboundConnection = outboundConnectionGroup.getConnection(wSAddress);
                        } else if (n4 == n3) {
                            if (this.purgeUnused()) {
                                wSOutboundConnection = outboundConnectionGroup.createConnection(wSAddress);
                            }
                            if (wSOutboundConnection == null && WAITING_THREADS_THRESHOLD >= 0 && this.waitingThreads >= WAITING_THREADS_THRESHOLD) {
                                if (_tc.isEventEnabled()) {
                                    Tr.event(_tc, "The waiting threads threshold (" + WAITING_THREADS_THRESHOLD + ") is exceeded." + "Attempting to remove a soft reference.");
                                }
                                if (this.purgeSoftReference()) {
                                    wSOutboundConnection = outboundConnectionGroup.createConnection(wSAddress);
                                }
                            }
                            if (wSOutboundConnection == null && this.alreadyWaited) {
                                if (this.purgeSoftReference()) {
                                    wSOutboundConnection = outboundConnectionGroup.createConnection(wSAddress);
                                }
                                this.purgeSoftReference();
                                if (_tc2.isDebugEnabled()) {
                                    Tr.debug(_tc2, "alreadyWaited logic invoked, wsOC=" + wSOutboundConnection);
                                }
                            }
                        } else {
                            throw new WebServicesFault(Messages.getMessage("connectionPoolIntegrity00"));
                        }
                        if (wSOutboundConnection != null) break;
                    }
                    if (CONN_TIMEOUT == 0) {
                        ++this.waitingThreads;
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, Messages.getMessage("connectionWait00", Thread.currentThread().toString()));
                            Tr.event(_tc, "The total number of waiting threads is " + this.waitingThreads);
                        }
                        l = System.currentTimeMillis();
                        this.monitor.enterWait(this, this.waitingThreads, n, n2, Thread.currentThread().toString());
                        this.chainlist.wait();
                        --this.waitingThreads;
                        this.alreadyWaited = true;
                        l3 = System.currentTimeMillis() - l;
                        this.monitor.leaveWait(this, this.waitingThreads, n, n2, Thread.currentThread().toString(), l3);
                        if (!_tc.isEventEnabled()) continue;
                        Tr.event(_tc, Messages.getMessage("connectionNotify01", Thread.currentThread().toString()));
                        Tr.event(_tc, "The total number of waiting threads is " + this.waitingThreads);
                        continue;
                    }
                    ++this.waitingThreads;
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, Messages.getMessage("connectionWait01", Thread.currentThread().toString(), String.valueOf(l2)));
                        Tr.event(_tc, "The total number of waiting threads is " + this.waitingThreads);
                    }
                    l = System.currentTimeMillis();
                    this.monitor.enterWait(this, this.waitingThreads, n, n2, Thread.currentThread().toString());
                    this.chainlist.wait(l2);
                    --this.waitingThreads;
                    this.alreadyWaited = true;
                    l3 = System.currentTimeMillis() - l;
                    this.monitor.leaveWait(this, this.waitingThreads, n, n2, Thread.currentThread().toString(), l3);
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, Messages.getMessage("connectionNotify01", Thread.currentThread().toString()));
                        Tr.event(_tc, "The actual wait time in milliseconds for this thread is " + l3);
                        Tr.event(_tc, "The total number of waiting threads is " + this.waitingThreads);
                    }
                    if (l2 - l3 > 0L) continue;
                    throw new WebServicesFault(Messages.getMessage("connectionTimedOut"));
                }
                throw new WebServicesFault(Messages.getMessage("connectionPoolIntegrity00"));
            }
        }
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "Unused objects in findGroupAndGetConnection::tempPool: " + this.tempPool.size());
        }
        this.attemptNotify();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "OutboundConnectionCache.findGroupAndGetConnection()");
        }
        return wSOutboundConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attemptNotify() {
        block7: {
            try {
                HashMap hashMap = this.chainlist;
                synchronized (hashMap) {
                    int n;
                    if (this.waitingThreads > 0 && (n = this.poolSize() + this.tempPool.size()) < MAX_CONN) {
                        this.chainlist.notify();
                        if (_tc.isEventEnabled()) {
                            int n2 = this.connectionsInUse();
                            Tr.event(_tc, "Notify thread event triggered by attemptNotify.  Number of waiting threads is " + this.waitingThreads);
                            Tr.event(_tc, Messages.getMessage("enter00", Messages.getMessage("connPoolStatus00", String.valueOf(n), String.valueOf(n2), String.valueOf(MAX_CONN))));
                            Tr.event(_tc, Messages.getMessage("connectionNotify00"));
                        }
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.transport.channel.OutboundConnectionCache", "585", this);
                if (!_tc2.isEventEnabled()) break block7;
                Tr.event(_tc, Messages.getMessage("exception01", JavaUtils.stackToString(exception)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findGroupAndReturnConnection(WSOutboundConnection wSOutboundConnection) throws ChainException, ChannelException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionCache.findGroupAndReturnConnection()");
        }
        String string = wSOutboundConnection.getTargetAddress().keyValueforPool();
        OutboundConnectionGroup outboundConnectionGroup = null;
        outboundConnectionGroup = (OutboundConnectionGroup)this.chainlist.get(string);
        if (outboundConnectionGroup == null) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("connTableKeyFound", string, "false"));
            }
            return;
        }
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, Messages.getMessage("connTableKeyFound", string, "true"));
        }
        HashMap hashMap = this.chainlist;
        synchronized (hashMap) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Unused objects in findGroupAndReturnConnection::tempPool size: " + this.tempPool.size());
            }
            int n = this.poolSize() + this.tempPool.size();
            int n2 = this.connectionsInUse();
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("enter00", "findGroupAndReturnConnection() - " + Messages.getMessage("connPoolStatus00", String.valueOf(n), String.valueOf(n2), String.valueOf(MAX_CONN))));
            }
            if (n == MAX_CONN && n2 > EIGHTY_PERCENT) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "The default object pool is close to be full. Place the object in a local pool for faster access.");
                }
                outboundConnectionGroup.returnConnection(wSOutboundConnection, true);
                this.tempPool.add(wSOutboundConnection);
            } else {
                outboundConnectionGroup.returnConnection(wSOutboundConnection, false);
            }
            this.chainlist.notify();
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("connectionNotify00"));
            }
            if (_tc.isEventEnabled()) {
                n = this.poolSize() + this.tempPool.size();
                n2 = this.connectionsInUse();
                Tr.event(_tc, Messages.getMessage("exit00", "findGroupAndReturnConnection() - " + Messages.getMessage("connPoolStatus00", String.valueOf(n), String.valueOf(n2), String.valueOf(MAX_CONN))));
            }
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Unused objects in findGroupAndReturnConnection::tempPool: " + this.tempPool.size());
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "OutboundConnectionCache.findGroupAndReturnConnection()");
        }
    }

    private boolean purgeUnused() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "purgeUnused()");
        }
        boolean bl = false;
        Iterator iterator = this.chainlist.keySet().iterator();
        OutboundConnectionGroup outboundConnectionGroup = null;
        while (iterator.hasNext()) {
            outboundConnectionGroup = (OutboundConnectionGroup)this.chainlist.get(iterator.next());
            if (outboundConnectionGroup.currPoolSize() > outboundConnectionGroup.totalInUse()) {
                bl = outboundConnectionGroup.findUnused();
            }
            if (!bl) continue;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "purgeUnused() = " + bl);
        }
        return bl;
    }

    private boolean purgeSoftReference() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "purgeSoftReference()");
        }
        boolean bl = false;
        Iterator iterator = this.chainlist.keySet().iterator();
        OutboundConnectionGroup outboundConnectionGroup = null;
        while (iterator.hasNext()) {
            outboundConnectionGroup = (OutboundConnectionGroup)this.chainlist.get(iterator.next());
            if (outboundConnectionGroup.currPoolSize() > outboundConnectionGroup.totalInUse()) {
                bl = outboundConnectionGroup.findSoftReference();
            }
            if (!bl) continue;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "purgeSoftReference() = " + bl);
        }
        return bl;
    }

    protected int poolSize() {
        int n = 0;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "poolSize()");
        }
        Iterator iterator = this.chainlist.keySet().iterator();
        OutboundConnectionGroup outboundConnectionGroup = null;
        while (iterator.hasNext()) {
            outboundConnectionGroup = (OutboundConnectionGroup)this.chainlist.get(iterator.next());
            n += outboundConnectionGroup.currPoolSize();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "poolSize() = " + n);
        }
        return n;
    }

    protected int connectionsInUse() {
        int n = 0;
        OutboundConnectionGroup outboundConnectionGroup = null;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "connectionsInUse()");
        }
        Iterator iterator = this.chainlist.keySet().iterator();
        while (iterator.hasNext()) {
            outboundConnectionGroup = (OutboundConnectionGroup)this.chainlist.get(iterator.next());
            n += outboundConnectionGroup.totalInUse();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "connectionsInUse() = " + n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dump(String string) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = "\n";
            stringBuffer.append(string);
            stringBuffer.append("===========================");
            stringBuffer.append(string2);
            stringBuffer.append(string + " Connection Timeout (sec) = " + CONN_TIMEOUT);
            stringBuffer.append(string2);
            stringBuffer.append(string + " Refresh Time (sec)       = " + REFRESHTIME);
            stringBuffer.append(string2);
            stringBuffer.append(string + " Max Connections          = " + MAX_CONN);
            stringBuffer.append(string2);
            stringBuffer.append(string + " WaitingThreadThreshold   = " + WAITING_THREADS_THRESHOLD);
            stringBuffer.append(string2);
            stringBuffer.append(string + " Pool Size                = " + this.poolSize());
            stringBuffer.append(string2);
            stringBuffer.append(string + " Connections In Use       = " + this.connectionsInUse());
            stringBuffer.append(string2);
            stringBuffer.append(string);
            stringBuffer.append("===========================");
            stringBuffer.append(string2);
            HashMap hashMap = this.chainlist;
            synchronized (hashMap) {
                Iterator iterator = this.chainlist.keySet().iterator();
                while (iterator.hasNext()) {
                    Object k = iterator.next();
                    OutboundConnectionGroup outboundConnectionGroup = (OutboundConnectionGroup)this.chainlist.get(k);
                    stringBuffer.append(string + "  Key = " + k);
                    stringBuffer.append(string2);
                    stringBuffer.append(string + "  OutboundConnectionGroup = " + outboundConnectionGroup.toString());
                    stringBuffer.append(string2);
                    stringBuffer.append(outboundConnectionGroup.dump(string + "    "));
                    stringBuffer.append(string2);
                }
            }
            stringBuffer.append(string);
            stringBuffer.append("===========================");
            stringBuffer.append(string2);
            return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.webservices.engine.transport.channel.OutboundConnectionCache.dump", "1103", this);
            return "OutboundConnectionGroup Dump is Not Available";
        }
    }

    static {
        String string;
        nls = TraceNLS.getTraceNLS("com.ibm.ws.webservices.resources.webservicesMessages");
        _tc = Tr.register(OutboundConnectionCache.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
        _tc2 = Tr.register(CleanupTask.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
        _tc3 = Tr.register(OneWayConnectionCleanupTask.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
        REFRESHTIME = 0;
        CONN_TIMEOUT = 0;
        MAX_CONN = 0;
        EIGHTY_PERCENT = 0;
        reqCounter = 0;
        cache = null;
        _timer = null;
        _onewaytimer = null;
        oneWayRecycleTime = HTTPConstants.DEFAULT_ONEWAY_RECYECLETIME;
        ONEWAYREFRESHTIME = 10000;
        CONN_TIMEOUT = Integer.valueOf(System.getProperty("com.ibm.websphere.webservices.http.connectionTimeout", "300")) * 1000;
        REFRESHTIME = Integer.valueOf(System.getProperty("com.ibm.websphere.webservices.http.connectionPoolCleanUpTime", "180")) * 1000;
        MAX_CONN = Integer.valueOf(System.getProperty("com.ibm.websphere.webservices.http.maxConnection", "25"));
        if (MAX_CONN < 5) {
            MAX_CONN = 5;
        }
        if (JavaUtils.hasValue(string = System.getProperty("com.ibm.websphere.webservices.http.ConnectionResetDelay"))) {
            oneWayRecycleTime = Long.parseLong(string) * 1000L;
        }
        if (oneWayRecycleTime < HTTPConstants.DEFAULT_ONEWAY_RECYECLETIME) {
            oneWayRecycleTime = HTTPConstants.DEFAULT_ONEWAY_RECYECLETIME;
        }
        String string2 = "com.ibm.websphere.webservices.http.waitingThreadsThreshold";
        WAITING_THREADS_THRESHOLD = Integer.valueOf(System.getProperty(string2, "5"));
    }

    private class OneWayConnectionCleanupTask
    extends TimerTask {
        private OneWayConnectionCleanupTask() {
        }

        public void run() {
            if (_tc3.isEntryEnabled()) {
                Tr.entry(_tc3, "OneWayConnectionCleanupTask.run()");
            }
            OutboundConnectionCache.this.onewayConnMap.cleanupConnections();
            if (_tc3.isEntryEnabled()) {
                Tr.exit(_tc3, "OneWayConnectionCleanupTask.run()");
            }
        }
    }

    private class CleanupTask
    extends TimerTask {
        private CleanupTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block10: {
                OutboundConnectionGroup outboundConnectionGroup = null;
                try {
                    if (_tc2.isEntryEnabled()) {
                        Tr.entry(_tc2, "CleanupTask.run()");
                    }
                    HashMap hashMap = OutboundConnectionCache.this.chainlist;
                    synchronized (hashMap) {
                        if (OutboundConnectionCache.this.chainlist.size() > 0) {
                            Iterator iterator = OutboundConnectionCache.this.chainlist.keySet().iterator();
                            Object var4_5 = null;
                            while (iterator.hasNext()) {
                                var4_5 = iterator.next();
                                outboundConnectionGroup = (OutboundConnectionGroup)OutboundConnectionCache.this.chainlist.get(var4_5);
                                outboundConnectionGroup.cleanup();
                                if (!outboundConnectionGroup.isEmpty()) continue;
                                if (_tc2.isDebugEnabled()) {
                                    Tr.debug(_tc2, "OutboundConnectionGroup.isEmpty(): true");
                                }
                                outboundConnectionGroup.release();
                            }
                        }
                        if (WAITING_THREADS_THRESHOLD >= 0 && OutboundConnectionCache.this.waitingThreads >= WAITING_THREADS_THRESHOLD) {
                            OutboundConnectionCache.this.attemptNotify();
                        }
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.transport.channel.OutboundConnectionCache", "163", this);
                    if (!_tc2.isEventEnabled()) break block10;
                    Tr.event(_tc2, Messages.getMessage("exception01", JavaUtils.stackToString(exception)));
                }
            }
        }
    }
}

