/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.transport.channel.OutboundConnectionCache;
import com.ibm.ws.webservices.engine.transport.channel.WSAddress;
import com.ibm.ws.webservices.engine.transport.channel.WSOutboundConnection;
import com.ibm.ws.webservices.engine.transport.http.HTTPConstants;
import com.ibm.ws.webservices.engine.transport.http.HTTPCookieManager;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.trace.MessageTrace;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.channel.InterChannelCallback;
import com.ibm.wsspi.channel.framework.OutboundVirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.outbound.HttpOutboundServiceContext;
import java.security.PrivilegedAction;
import java.util.Vector;

public class WSOutboundCFCallbackImpl
implements InterChannelCallback {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.webservices.resources.webservicesMessages");
    private static final TraceComponent _tc = Tr.register(WSOutboundCFCallbackImpl.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private WSOutboundConnection _wsOC = null;
    private WSAddress _wsa = null;
    private OutboundConnectionCache oCache = null;
    private static boolean UseNewCookieHandling = false;

    public WSOutboundCFCallbackImpl(WSOutboundConnection wSOutboundConnection, WSAddress wSAddress) {
        this._wsOC = wSOutboundConnection;
        this._wsa = wSAddress;
        this.oCache = (OutboundConnectionCache)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return OutboundConnectionCache.getInstance();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(VirtualConnection virtualConnection) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "Enter WSOutboundCFCallbackImpl.complete() for " + (OutboundVirtualConnection)virtualConnection);
        }
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, Messages.getMessage("receiveForAsyncDelivery", this._wsa.toString(), this._wsOC.toString()));
        }
        OutboundVirtualConnection outboundVirtualConnection = (OutboundVirtualConnection)virtualConnection;
        this.printResponse(outboundVirtualConnection);
        try {
            this._wsOC.reset();
            this.oCache.findGroupAndReturnConnection(this._wsOC);
        }
        catch (ChainException chainException) {
            FFDCFilter.processException((Throwable)chainException, "com.ibm.ws.webservices.engine.transport.http.channel.WSOutboundCFCallbackImpl.complete", "110", this);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("exception01", JavaUtils.stackToString(chainException)));
            }
        }
        catch (ChannelException channelException) {
            FFDCFilter.processException((Throwable)channelException, "com.ibm.ws.webservices.engine.transport.http.channel.WSOutboundCFCallbackImpl.complete", "117", this);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("exception01", JavaUtils.stackToString(channelException)));
            }
        }
        finally {
            this._wsOC = null;
            this._wsa = null;
            this.oCache = null;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "Exit WSOutboundCFCallbackImpl.complete() for " + (OutboundVirtualConnection)virtualConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(VirtualConnection virtualConnection, Throwable throwable) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "Enter WSOutboundCFCallbackImpl.error() for " + (OutboundVirtualConnection)virtualConnection);
        }
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, Messages.getMessage("errorForAsyncDelivery", this._wsa.toString(), this._wsOC.toString()));
            Tr.event(_tc, Messages.getMessage("exception01", JavaUtils.stackToString(throwable)));
        }
        OutboundVirtualConnection outboundVirtualConnection = (OutboundVirtualConnection)virtualConnection;
        this.printResponse(outboundVirtualConnection);
        try {
            this._wsOC.reset();
            this.oCache.findGroupAndReturnConnection(this._wsOC);
        }
        catch (ChainException chainException) {
            FFDCFilter.processException((Throwable)chainException, "com.ibm.ws.webservices.engine.transport.http.channel.WSOutboundCFCallbackImpl.complete", "161", this);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("exception01", JavaUtils.stackToString(chainException)));
            }
        }
        catch (ChannelException channelException) {
            FFDCFilter.processException((Throwable)channelException, "com.ibm.ws.webservices.engine.transport.http.channel.WSOutboundCFCallbackImpl.complete", "168", this);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("exception01", JavaUtils.stackToString(channelException)));
            }
        }
        finally {
            this._wsOC = null;
            this._wsa = null;
            this.oCache = null;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "Exit WSOutboundCFCallbackImpl.error() for " + (OutboundVirtualConnection)virtualConnection);
        }
    }

    private void printResponse(OutboundVirtualConnection outboundVirtualConnection) {
        block25: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, Messages.getMessage("enter00", "WSOutboundCFCallbackImpl.printResponse() for " + outboundVirtualConnection));
            }
            try {
                Object[] objectArray;
                Object object;
                Object object2;
                HttpOutboundServiceContext httpOutboundServiceContext = (HttpOutboundServiceContext)outboundVirtualConnection.getChannelAccessor();
                HttpResponseMessage httpResponseMessage = httpOutboundServiceContext.getResponse();
                String string = "iso-8859-1";
                byte[] byArray = httpResponseMessage.getReasonPhraseBytes();
                String string2 = new String(byArray, string);
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("httpStatusInResponse00", httpResponseMessage.getStatusCode().toString(), string2));
                }
                StringBuffer stringBuffer = new StringBuffer(32);
                Vector vector = httpResponseMessage.getHeaderByteArrayValues("Content-Type");
                if (vector != null) {
                    object2 = vector.iterator();
                    while (object2.hasNext()) {
                        object = (byte[])object2.next();
                        stringBuffer.append(new String((byte[])object, string));
                    }
                }
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Content-Type: " + stringBuffer.toString());
                }
                object2 = stringBuffer;
                byArray = httpResponseMessage.getHeaderAsByteArray("Content-Location");
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Content-Location: " + (byArray == null ? "" : new String(byArray, string)));
                }
                byArray = httpResponseMessage.getHeaderAsByteArray(HTTPConstants.HEADER_TRANSFER_ENCODING);
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, HTTPConstants.HEADER_TRANSFER_ENCODING + ": " + (byArray == null ? "" : new String(byArray, string)));
                }
                vector = httpResponseMessage.getHeaderByteArrayValues(HTTPConstants.HEADER_SET_COOKIE);
                stringBuffer = new StringBuffer();
                UseNewCookieHandling = HTTPCookieManager.newCookieHandling();
                if (vector != null && !vector.isEmpty()) {
                    object = vector.iterator();
                    while (object.hasNext()) {
                        objectArray = (byte[])object.next();
                        if (object.hasNext()) {
                            if (UseNewCookieHandling) {
                                stringBuffer.append(new String((byte[])objectArray, string)).append(HTTPConstants.HEADER_TOKEN_SEPARATOR);
                                continue;
                            }
                            stringBuffer.append(new String((byte[])objectArray, string)).append(HTTPConstants.ATTR_TOKEN_SEPARATOR);
                            continue;
                        }
                        stringBuffer.append(new String((byte[])objectArray, string));
                    }
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, Messages.getMessage("cookieReceived", HTTPConstants.HEADER_SET_COOKIE + ": " + stringBuffer.toString(), this._wsa.toString()));
                    }
                }
                stringBuffer = new StringBuffer();
                vector = httpResponseMessage.getHeaderByteArrayValues(HTTPConstants.HEADER_SET_COOKIE2);
                if (vector != null && !vector.isEmpty()) {
                    object = vector.iterator();
                    while (object.hasNext()) {
                        objectArray = (byte[])object.next();
                        if (object.hasNext()) {
                            if (UseNewCookieHandling) {
                                stringBuffer.append(new String((byte[])objectArray, string)).append(HTTPConstants.HEADER_TOKEN_SEPARATOR);
                                continue;
                            }
                            stringBuffer.append(new String((byte[])objectArray, string)).append(HTTPConstants.ATTR_TOKEN_SEPARATOR);
                            continue;
                        }
                        stringBuffer.append(new String((byte[])objectArray, string));
                    }
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, Messages.getMessage("cookieReceived", HTTPConstants.HEADER_SET_COOKIE2 + ": " + stringBuffer.toString(), this._wsa.toString()));
                    }
                }
                object = null;
                if (httpResponseMessage.getContentLength() > 0) {
                    object = String.valueOf(httpResponseMessage.getContentLength());
                }
                objectArray = httpOutboundServiceContext.getResponseBodyBuffers();
                byte[] byArray2 = null;
                if (objectArray != null) {
                    byArray2 = WsByteBufferUtils.asByteArray((WsByteBuffer[])objectArray);
                }
                if (byArray2 != null && byArray2.length != 0) {
                    MessageTrace.log(MessageTrace.INBOUND_HTTP_RESPONSE, ((StringBuffer)object2).toString(), byArray2);
                }
                if (objectArray != null) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (objectArray[i] == null) continue;
                        objectArray[i].release();
                    }
                    byArray2 = null;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.transport.http.channel.WSOutboundCFCallbackImpl.printResponse", "326", this);
                if (!_tc.isEventEnabled()) break block25;
                Tr.event(_tc, Messages.getMessage("exception01", JavaUtils.stackToString(exception)));
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, Messages.getMessage("exit00", "WSOutboundCFCallbackImpl.printResponse() for " + outboundVirtualConnection));
        }
    }
}

