/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.session.SessionContext;
import com.ibm.ws.webservices.engine.transport.http.CookieValueList;
import com.ibm.ws.webservices.engine.transport.http.HTTPConstants;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class HTTPCookieManager
implements SessionContext {
    private static final TraceComponent _tc = Tr.register(HTTPCookieManager.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private HashMap chM = null;
    private CookieValueList cvs = null;

    public HTTPCookieManager() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HTTPCookieManager ctor()");
        }
        this.chM = new HashMap();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "HTTPCookieManager ctor() this : " + this);
        }
    }

    public HTTPCookieManager(String string, String string2) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HTTPCookieManager ctor()");
        }
        this.chM = new HashMap();
        this.setCookies(string, string2);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "HTTPCookieManager ctor() this : " + this);
        }
    }

    public static boolean newCookieHandling() {
        boolean bl = false;
        String string = System.getProperty("UseNewCookieHandling");
        if (string != null) {
            bl = Boolean.valueOf(string);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "System property value of UseNewCookieHandling: " + string);
            }
        }
        return bl;
    }

    public void setCookies(String string, String string2, String string3) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setCookies this : " + this);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, HTTPConstants.HEADER_SET_COOKIE + " : " + string + "  " + HTTPConstants.HEADER_SET_COOKIE2 + " : " + string2);
            Tr.debug(_tc, "ReqPath = " + string3);
        }
        if (JavaUtils.hasValue(string)) {
            this.parseCookieAndStore(HTTPConstants.HEADER_SET_COOKIE, string3, string);
        }
        if (JavaUtils.hasValue(string2)) {
            this.parseCookieAndStore(HTTPConstants.HEADER_SET_COOKIE2, string3, string2);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Stored cookie LIST " + this.printCookieSet());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setCookies");
        }
    }

    public void setCookies(String string, String string2) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "start deprecated setCookies this : " + this);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, HTTPConstants.HEADER_SET_COOKIE + " : " + string + "  " + HTTPConstants.HEADER_SET_COOKIE2 + " : " + string2);
        }
        if (JavaUtils.hasValue(string)) {
            this.parseCookieAndStore(HTTPConstants.HEADER_SET_COOKIE, null, string);
        }
        if (JavaUtils.hasValue(string2)) {
            this.parseCookieAndStore(HTTPConstants.HEADER_SET_COOKIE2, null, string2);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Stored cookie LIST " + this.printCookieSet());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "end deprecated set Cookies");
        }
    }

    public String getCookie(String string, String string2, int n, boolean bl) {
        String string3;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getCookie() this : " + this);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Stored cookie LIST " + this.printCookieSet());
        }
        StringBuffer stringBuffer = new StringBuffer();
        Set set = this.chM.keySet();
        Iterator iterator = set.iterator();
        stringBuffer.append("$Version=\"1\";");
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            CookieValueList cookieValueList = (CookieValueList)this.chM.get(string3);
            stringBuffer.append(cookieValueList.getList(string, string2, n, bl));
        }
        string3 = stringBuffer.toString().substring(0, stringBuffer.length() - 1);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getCookie() : " + string3);
        }
        return string3;
    }

    public String printCookieSet() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("");
        Set set = this.chM.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            CookieValueList cookieValueList = (CookieValueList)this.chM.get(string);
            stringBuffer.append("{property=" + string + " cookieValueList={[");
            stringBuffer.append(cookieValueList.printList());
            stringBuffer.append("]} ");
        }
        return stringBuffer.toString();
    }

    protected List splitMultipleCookies(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                ++n;
            }
            if (c != ',' || n % 2 != 0) continue;
            arrayList.add(string.substring(n2, i));
            n2 = i + 1;
        }
        arrayList.add(string.substring(n2));
        return arrayList;
    }

    private void parseCookieAndStore(String string, String string2, String string3) {
        block23: {
            try {
                if (_tc.isEntryEnabled()) {
                    Tr.entry(_tc, "parseCookieAndStore() this : " + this);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "cookieHTTPName= " + string);
                    Tr.debug(_tc, "requestpath= " + string2);
                    Tr.debug(_tc, "cookie= " + string3);
                }
                if (string3 != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "cookie Received : " + string3);
                    }
                    List list = this.splitMultipleCookies(string3);
                    for (int i = 0; i < list.size(); ++i) {
                        String string4 = (String)list.get(i);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, " Cookie " + i + " is: " + string4);
                        }
                        String string5 = null;
                        String string6 = null;
                        String string7 = null;
                        String string8 = null;
                        int n = string4.indexOf(HTTPConstants.ATTR_TOKEN_SEPARATOR);
                        if (n < 0) {
                            string5 = string4.trim();
                        } else {
                            string5 = string4.substring(0, n).trim();
                            if (n + 1 < string4.length() && (string6 = string4.substring(n + 1).trim()).length() == 0) {
                                string6 = null;
                            }
                        }
                        if (string5 != null) {
                            int n2 = string5.indexOf(HTTPConstants.ATTR_VALUE_SEPARATOR);
                            if (n2 < 0) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "  The Cookie's PropertyValue is not correct.  It is missing a " + HTTPConstants.ATTR_VALUE_SEPARATOR);
                                    Tr.debug(_tc, "  The Cookie is ignored. ");
                                }
                            } else {
                                string7 = string5.substring(0, n2).trim();
                                string8 = string5.substring(n2 + 1).trim();
                            }
                        } else if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "  The Cookie's PropertyValue is null. The Cookie is ignored. ");
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "  The PropertyValue is: " + string5);
                            Tr.debug(_tc, "  The Property is:      " + string7);
                            Tr.debug(_tc, "  The Value is:         " + string8);
                            Tr.debug(_tc, "  The Attributes are:   " + string6);
                        }
                        if (string7 == null) continue;
                        this.cvs = null;
                        if (this.chM != null) {
                            Set set = this.chM.keySet();
                            Iterator iterator = set.iterator();
                            while (iterator.hasNext()) {
                                String string9 = (String)iterator.next();
                                if (string7.compareTo(string9) != 0) continue;
                                this.cvs = (CookieValueList)this.chM.get(string9);
                                if (!_tc.isDebugEnabled()) break;
                                Tr.debug(_tc, "   Found an existing CookieValueList with the same name as " + string7 + " : " + this.cvs);
                                break;
                            }
                        }
                        if (this.cvs == null) {
                            this.cvs = new CookieValueList(string);
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "   Created a " + string + " CookieValueList for " + string7 + " : " + this.cvs);
                            }
                        }
                        this.cvs.setCookieNameValuePath(string7, string8, string2);
                        this.cvs.setCookie(string6);
                        this.chM.put(string7, this.cvs);
                        if (!_tc.isDebugEnabled()) continue;
                        Tr.debug(_tc, "Stored cookie");
                    }
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.webservices.engine.transport.http.HTTPCookieManager.parseCookieAndStore", "368", this);
                if (!_tc.isDebugEnabled()) break block23;
                Tr.debug(_tc, "Exception occurred during parseCookieAndStore.  Processing continues without this cookie information. ", throwable);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "parseCookieAndStore()");
        }
    }
}

