/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.components.net.DefaultHTTPTransportClientProperties;
import com.ibm.ws.webservices.engine.components.net.TransportClientProperties;
import com.ibm.ws.webservices.engine.components.net.TransportClientPropertiesFactory;
import com.ibm.ws.webservices.engine.handlers.BasicHandler;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.transport.Config;
import com.ibm.ws.webservices.engine.transport.OneWayConnectionMap;
import com.ibm.ws.webservices.engine.transport.channel.OutboundConnectionCache;
import com.ibm.ws.webservices.engine.transport.channel.OutboundOutputStream;
import com.ibm.ws.webservices.engine.transport.channel.WSAddress;
import com.ibm.ws.webservices.engine.transport.channel.WSCFEndPointCriteriaImpl;
import com.ibm.ws.webservices.engine.transport.channel.WSChannelManager;
import com.ibm.ws.webservices.engine.transport.channel.WSOutboundConnection;
import com.ibm.ws.webservices.engine.transport.http.HTTPConstants;
import com.ibm.ws.webservices.engine.transport.http.HTTPCookieManager;
import com.ibm.ws.webservices.engine.transport.http.HTTPSessionContext;
import com.ibm.ws.webservices.engine.transport.http.HttpChannelAddress;
import com.ibm.ws.webservices.engine.transport.http.HttpOutboundChannelConnection;
import com.ibm.ws.webservices.engine.transport.http.OneWayConnection;
import com.ibm.ws.webservices.engine.transport.security.ConfigSSL;
import com.ibm.ws.webservices.engine.transport.security.ConfigSSLProvider;
import com.ibm.ws.webservices.engine.transport.security.SecurityDataPrompt;
import com.ibm.ws.webservices.engine.transport.security.SecurityDataPromptFactory;
import com.ibm.ws.webservices.engine.transport.security.WSConfigSSLChangeListener;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.trace.MessageTrace;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.selection.SelectionRule;
import com.ibm.wsspi.cluster.selection.rule.AttributeRule;
import com.ibm.wsspi.cluster.selection.rule.DefaultRule;
import com.ibm.wsspi.http.channel.HttpConstants;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;

public class HTTPSender
extends BasicHandler {
    protected static Log log = LogFactory.getLog(HTTPSender.class.getName());
    private static final TraceComponent _tc = Tr.register(HTTPSender.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private static boolean UseNewCookieHandling = false;
    private static String IN_PROCESS_ENABLED = null;
    private long oneWayRecycleTime = 0L;
    private StringBuffer hashKeyCode = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invoke(MessageContext messageContext) throws WebServicesFault {
        block135: {
            OutboundConnectionCache outboundConnectionCache;
            WSOutboundConnection wSOutboundConnection;
            block136: {
                Object object;
                Object object2;
                Object object3;
                MessageContext messageContext2;
                block126: {
                    block133: {
                        block134: {
                            block125: {
                                if (_tc.isEntryEnabled()) {
                                    Tr.entry(_tc, "HTTPSender::invoke");
                                }
                                wSOutboundConnection = null;
                                boolean bl = false;
                                outboundConnectionCache = (OutboundConnectionCache)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                                    public Object run() {
                                        return OutboundConnectionCache.getInstance();
                                    }
                                });
                                WSChannelManager wSChannelManager = WSChannelManager.getInstance();
                                Object object4 = null;
                                messageContext2 = MessageContext.getCurrentThreadsContext();
                                object3 = messageContext2.getProperty("com.ibm.ws.wsaddressing.RedirectRequired");
                                object2 = messageContext2.getProperty(HTTPConstants.MC_HTTP_OUTBOUND_ASYNC_RESPONSE);
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "com.ibm.ws.wsaddressing.RedirectRequired: " + (object3 == null ? "" : object3));
                                }
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, HTTPConstants.MC_HTTP_OUTBOUND_ASYNC_RESPONSE + ": " + (object2 == null ? "" : object2));
                                }
                                object = null;
                                try {
                                    try {
                                        Object object5;
                                        int n;
                                        Object object6;
                                        Serializable serializable;
                                        Object object7;
                                        HashMap<String, SelectionRule[]> hashMap;
                                        Object object8;
                                        block132: {
                                            block130: {
                                                Identity identity;
                                                block131: {
                                                    Object object9;
                                                    WSCFEndPointCriteriaImpl wSCFEndPointCriteriaImpl;
                                                    URL uRL;
                                                    block129: {
                                                        block128: {
                                                            block123: {
                                                                uRL = messageContext.getTargetEndpointAddressAsURL();
                                                                wSCFEndPointCriteriaImpl = null;
                                                                wSCFEndPointCriteriaImpl = uRL.getProtocol().equalsIgnoreCase("http") ? new WSCFEndPointCriteriaImpl(1) : new WSCFEndPointCriteriaImpl(2);
                                                                if (_tc.isDebugEnabled()) {
                                                                    Tr.debug(_tc, "javax.xml.rpc.service.endpoint.address: " + uRL.toString());
                                                                }
                                                                object4 = WSAddress.getAddress(uRL);
                                                                identity = wSChannelManager.clusterIdenFromEPR(wSCFEndPointCriteriaImpl);
                                                                if (identity != null) break block128;
                                                                if (_tc.isDebugEnabled()) {
                                                                    Tr.debug(_tc, Messages.getMessage("clusterFromWsAddr", String.valueOf(identity)));
                                                                }
                                                                object8 = TransportClientPropertiesFactory.create(uRL.getProtocol());
                                                                if (_tc.isDebugEnabled()) {
                                                                    Tr.debug(_tc, "Original " + uRL.getProtocol() + " transport client properties:\n" + object8.toString());
                                                                }
                                                                if ((object4 = HttpChannelAddress.getProxyAddress(uRL, (TransportClientProperties)object8)) == null) {
                                                                    object4 = WSAddress.getAddress(uRL);
                                                                } else if (_tc.isDebugEnabled()) {
                                                                    Tr.debug(_tc, Messages.getMessage("targetAddress01", object4.toString()));
                                                                }
                                                                if (_tc.isDebugEnabled()) {
                                                                    Tr.debug(_tc, "Updated " + uRL.getProtocol() + " transport client properties:\n" + object8.toString());
                                                                }
                                                                if (wSChannelManager.getRuntime() == 3 || wSChannelManager.isEPRFragile()) break block129;
                                                                if (IN_PROCESS_ENABLED == null) {
                                                                    try {
                                                                        hashMap = log;
                                                                        synchronized (hashMap) {
                                                                            if (IN_PROCESS_ENABLED == null) {
                                                                                if (_tc.isDebugEnabled()) {
                                                                                    Tr.debug(_tc, Messages.getMessage("j2wLoadClass00", "com.ibm.wsspi.webcontainer.WebContainer"));
                                                                                }
                                                                                if ((object7 = ClassUtils.forName("com.ibm.wsspi.webcontainer.WebContainer")) != null) {
                                                                                    if (_tc.isDebugEnabled()) {
                                                                                        Tr.debug(_tc, Messages.getMessage("invokeMethod00", "getWebContainerProperties", "com.ibm.wsspi.webcontainer.WebContainer"));
                                                                                    }
                                                                                    if ((serializable = (Properties)((Method)(object9 = ((Class)object7).getMethod("getWebContainerProperties", null))).invoke(null, null)) != null) {
                                                                                        IN_PROCESS_ENABLED = ((Properties)serializable).getProperty("enableinprocessconnections");
                                                                                    }
                                                                                }
                                                                                if (IN_PROCESS_ENABLED == null) {
                                                                                    IN_PROCESS_ENABLED = "null";
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                    catch (Exception exception) {
                                                                        if (IN_PROCESS_ENABLED == null) {
                                                                            IN_PROCESS_ENABLED = "null";
                                                                        }
                                                                        if (!_tc.isDebugEnabled()) break block123;
                                                                        Tr.debug(_tc, exception.toString() + " is caught. Failed to read WebContainer properties. Proceed with HTTP in-process connection disabled.");
                                                                    }
                                                                }
                                                            }
                                                            if (_tc.isDebugEnabled()) {
                                                                Tr.debug(_tc, "enableInProcessConnections : " + IN_PROCESS_ENABLED);
                                                            }
                                                            hashMap = MessageContext.getCurrentThreadsContext().getStrProp("com.ibm.ws.webservices.rrdEnabled");
                                                            if (_tc.isDebugEnabled()) {
                                                                Tr.debug(_tc, "com.ibm.ws.webservices.rrdEnabled: " + (String)(hashMap == null ? "" : hashMap));
                                                            }
                                                            if (IN_PROCESS_ENABLED != null && IN_PROCESS_ENABLED.equalsIgnoreCase("true") || Boolean.valueOf((String)((Object)hashMap)).booleanValue()) {
                                                                identity = wSChannelManager.clusterIdenFromDWLMClient((WSAddress)object4, wSCFEndPointCriteriaImpl);
                                                                if (_tc.isDebugEnabled()) {
                                                                    Tr.debug(_tc, Messages.getMessage("clusterFromRequestMapper", String.valueOf(identity), object4.toString()));
                                                                }
                                                            }
                                                            break block129;
                                                        }
                                                        if (_tc.isDebugEnabled()) {
                                                            Tr.debug(_tc, Messages.getMessage("clusterFromWsAddr", String.valueOf(identity)));
                                                        }
                                                        if (messageContext.isPropertyTrue("com.ibm.ws.wsaddressing.UCFCallback.disable")) {
                                                            bl = true;
                                                        }
                                                    }
                                                    if (identity == null) break block130;
                                                    object8 = null;
                                                    hashMap = (Map)messageContext.getProperty("com.ibm.ws.webservices.wlmselectioncriteria");
                                                    if (_tc.isDebugEnabled()) {
                                                        Tr.debug(_tc, "com.ibm.ws.webservices.wlmselectioncriteria: " + (hashMap == null ? "" : ((Object)hashMap).toString()));
                                                    }
                                                    if (wSCFEndPointCriteriaImpl.getEPRtype() == 1) {
                                                        if (_tc.isDebugEnabled()) {
                                                            Tr.debug(_tc, "Encountered WLM EPR. Check for session affinity information.");
                                                        }
                                                        if ((object7 = this.getCookieValue("SSLJSESSION", messageContext2, (WSAddress)object4)) == null) {
                                                            object7 = this.getCookieValue("JSESSIONID", messageContext2, (WSAddress)object4);
                                                            if (object7 != null && _tc.isDebugEnabled()) {
                                                                Tr.debug(_tc, "JSESSIONID=" + (String)object7);
                                                            }
                                                        } else if (_tc.isDebugEnabled()) {
                                                            Tr.debug(_tc, "SSLJSESSION=" + (String)object7);
                                                        }
                                                        if (object7 != null && (object9 = ((String)object7).split(":")) != null && ((String[])object9).length > 1) {
                                                            int n2 = ((String[])object9).length;
                                                            object6 = new SelectionRule[n2];
                                                            for (n = 1; n < n2; ++n) {
                                                                object5 = new HashSet();
                                                                object5.add(object9[n]);
                                                                object6[n2 - n - 1] = new AttributeRule((Set)object5);
                                                            }
                                                            object6[n2 - 1] = new DefaultRule();
                                                            if (hashMap == null) {
                                                                hashMap = new HashMap<String, SelectionRule[]>();
                                                            }
                                                            if (_tc.isDebugEnabled()) {
                                                                Tr.debug(_tc, "Setting rules.precedence");
                                                            }
                                                            hashMap.put("rules.precedence", (SelectionRule[])object6);
                                                        }
                                                    }
                                                    if ((object8 = wSChannelManager.identityToCFEndPoint(identity, wSCFEndPointCriteriaImpl, hashMap, bl)) == null) break block131;
                                                    object7 = uRL.getProtocol() + "://";
                                                    object7 = object8.isLocal() ? (String)object7 + object8.getAddress().getHostAddress() : (String)object7 + object8.getAddress().getHostName();
                                                    object7 = (String)object7 + ":" + object8.getPort() + uRL.getFile();
                                                    object4 = WSAddress.getAddress(new URL((String)object7));
                                                    ((WSAddress)object4).setCFEndPoint((CFEndPoint)object8);
                                                    if (object8.isLocal()) {
                                                        if (_tc.isDebugEnabled()) {
                                                            Tr.debug(_tc, Messages.getMessage("usedHttpChannelType", "In-process"));
                                                        }
                                                        break block132;
                                                    } else if (_tc.isDebugEnabled()) {
                                                        Tr.debug(_tc, Messages.getMessage("usedHttpChannelType", "Network"));
                                                    }
                                                    break block132;
                                                }
                                                if (_tc.isDebugEnabled()) {
                                                    Tr.debug(_tc, Messages.getMessage("cannotConvertCFEndPt", String.valueOf(identity)));
                                                }
                                                break block132;
                                            }
                                            if (_tc.isDebugEnabled()) {
                                                Tr.debug(_tc, Messages.getMessage("usedHttpChannelType", "Network"));
                                            }
                                        }
                                        if (_tc.isDebugEnabled()) {
                                            Tr.debug(_tc, Messages.getMessage("targetAddress00", object4.toString()));
                                        }
                                        if (((WSAddress)object4).getSchema() == 2) {
                                            this.setupEffectiveSSLConfiguration((WSAddress)object4);
                                        }
                                        object8 = messageContext2.getRequestMessage();
                                        hashMap = ((Message)object8).getContentType(messageContext2.getSOAPConstants());
                                        if (_tc.isDebugEnabled()) {
                                            Tr.debug(_tc, "HTTP Content-Type: " + (String)((Object)hashMap));
                                        }
                                        object7 = new OutboundOutputStream((String)((Object)hashMap));
                                        ((Message)object8).writeTo((OutputStream)object7);
                                        ((Message)object8).removeAllAttachments();
                                        int n3 = 0;
                                        serializable = null;
                                        object6 = null;
                                        n = 0;
                                        while (n == 0) {
                                            boolean bl2;
                                            wSOutboundConnection = outboundConnectionCache.findGroupAndGetConnection((WSAddress)object4);
                                            try {
                                                if (wSOutboundConnection == null) throw new WebServicesFault("No WSOutboundConnection object returned from outbound connection pool.");
                                                if (MessageTrace.isTraceEnabled() && hashMap != null && object7 != null) {
                                                    MessageTrace.log(MessageTrace.OUTBOUND_HTTP_REQUEST, (String)((Object)hashMap), ((OutboundOutputStream)object7).toByteArray());
                                                }
                                                wSOutboundConnection.connect();
                                                if (object3 != null && object2 != null) {
                                                    if (_tc.isDebugEnabled()) {
                                                        Tr.debug(_tc, Messages.getMessage("redirectedAsyncDelivery", wSOutboundConnection.toString()));
                                                    }
                                                    object = wSOutboundConnection.sendSOAPRequestAsync((OutboundOutputStream)object7);
                                                } else {
                                                    wSOutboundConnection.sendSOAPRequest((OutboundOutputStream)object7);
                                                }
                                            }
                                            catch (SocketTimeoutException socketTimeoutException) {
                                                FFDCFilter.processException((Throwable)socketTimeoutException, "com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", "610", this);
                                                TransportClientProperties transportClientProperties = TransportClientPropertiesFactory.create(((WSAddress)object4).getSchemaInString());
                                                bl2 = false;
                                                bl2 = ((DefaultHTTPTransportClientProperties)transportClientProperties).isResendEnabled();
                                                outboundConnectionCache.startOneWayTimer(5000L);
                                                if (!wSOutboundConnection.hasbeenUsed()) throw WebServicesFault.makeFault(socketTimeoutException);
                                                if (wSOutboundConnection.isMessageSent()) throw WebServicesFault.makeFault(socketTimeoutException);
                                                if (bl2) throw WebServicesFault.makeFault(socketTimeoutException);
                                                if (_tc.isDebugEnabled()) {
                                                    Tr.debug(_tc, "SOAP message has not been sent and messageResend is disabled. Use another connection object.");
                                                }
                                                wSOutboundConnection.disconnect(socketTimeoutException);
                                                outboundConnectionCache.findGroupAndReturnConnection(wSOutboundConnection);
                                                continue;
                                            }
                                            catch (SocketException socketException) {
                                                FFDCFilter.processException((Throwable)socketException, "com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", "642", this);
                                                TransportClientProperties transportClientProperties = TransportClientPropertiesFactory.create(((WSAddress)object4).getSchemaInString());
                                                bl2 = false;
                                                bl2 = ((DefaultHTTPTransportClientProperties)transportClientProperties).isResendEnabled();
                                                if (!wSOutboundConnection.hasbeenUsed()) throw WebServicesFault.makeFault(socketException);
                                                if (wSOutboundConnection.isMessageSent()) throw WebServicesFault.makeFault(socketException);
                                                if (bl2) throw WebServicesFault.makeFault(socketException);
                                                if (_tc.isDebugEnabled()) {
                                                    Tr.debug(_tc, "SOAP message has not been sent and messageResend is disabled. Use another connection object.");
                                                }
                                                wSOutboundConnection.disconnect(socketException);
                                                outboundConnectionCache.findGroupAndReturnConnection(wSOutboundConnection);
                                                continue;
                                            }
                                            if (object3 != null && object2 != null) {
                                                n = 1;
                                                continue;
                                            }
                                            wSOutboundConnection.receiveSOAPResponse();
                                            serializable = (Integer)messageContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
                                            object6 = messageContext.getStrProp(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
                                            if (serializable != null) {
                                                if (_tc.isDebugEnabled()) {
                                                    Tr.debug(_tc, Messages.getMessage("httpStatusInResponse00", ((Integer)serializable).toString(), (String)object6));
                                                }
                                                if ((n3 = ((Integer)serializable).intValue()) == HttpConstants.STATUS_FOUND.getIntCode() || n3 == HttpConstants.STATUS_MOVED_PERM.getIntCode() || n3 == HttpConstants.STATUS_TEMP_REDIRECT.getIntCode()) {
                                                    if (!HTTPSender.isHttpRedirectEnabled()) {
                                                        n = 1;
                                                        throw new WebServicesFault(Messages.getMessage("http302StatusCode", object4.toString()));
                                                    }
                                                    object6 = messageContext.getStrProp(MessageContext.TRANS_URL_HTTP_REDIRECTED);
                                                    if (_tc.isDebugEnabled()) {
                                                        Tr.debug(_tc, "HTTP redirected URL property value is: " + (String)(object6 == null ? "null" : object6));
                                                    }
                                                    if (JavaUtils.hasValue((String)object6)) {
                                                        object4 = WSAddress.getAddress(new URL((String)object6));
                                                        if (_tc.isDebugEnabled()) {
                                                            Tr.debug(_tc, Messages.getMessage("http302StatusCode", object4.toString()));
                                                        }
                                                        if (wSOutboundConnection.getTargetAddress().getSchema() == 2) {
                                                            this.restoreSSLConfiguration(wSOutboundConnection);
                                                        }
                                                        wSOutboundConnection.disconnect(null);
                                                        outboundConnectionCache.findGroupAndReturnConnection(wSOutboundConnection);
                                                        wSOutboundConnection = null;
                                                        if (((WSAddress)object4).getSchema() == 2) {
                                                            this.setupEffectiveSSLConfiguration((WSAddress)object4);
                                                        }
                                                    } else {
                                                        if (_tc.isDebugEnabled()) {
                                                            Tr.debug(_tc, Messages.getMessage("http302StatusCode", ""));
                                                        }
                                                        if (_tc.isDebugEnabled()) {
                                                            Tr.debug(_tc, "No new redirection location provided, continuing");
                                                        }
                                                        n = 1;
                                                    }
                                                    messageContext.removeProperty(MessageContext.TRANS_URL_HTTP_REDIRECTED);
                                                    continue;
                                                }
                                                if (n3 == HttpConstants.STATUS_UNAUTHORIZED.getIntCode()) {
                                                    if (wSChannelManager.getRuntime() != 1) {
                                                        object5 = messageContext.getStrProp("WWW-Authenticate");
                                                        boolean bl3 = (Boolean)messageContext.getProperty("com.ibm.ws.webservices.spnegoUsed");
                                                        if (bl3 && object5 != null && ((String)object5).indexOf("Negotiate") == 0) {
                                                            Tr.debug(_tc, "WWW-Authenticate: " + (String)object5);
                                                            n = 1;
                                                            continue;
                                                        }
                                                        if (this.receivedHTTPBasicAuth()) {
                                                            Tr.debug(_tc, Messages.getMessage("challengeStatus01"));
                                                            wSOutboundConnection.reset();
                                                            outboundConnectionCache.findGroupAndReturnConnection(wSOutboundConnection);
                                                            wSOutboundConnection = null;
                                                            continue;
                                                        }
                                                        Tr.debug(_tc, Messages.getMessage("challengeStatus02"));
                                                        n = 1;
                                                        continue;
                                                    }
                                                    n = 1;
                                                    continue;
                                                }
                                                n = 1;
                                                continue;
                                            }
                                            n = 1;
                                        }
                                        ((OutboundOutputStream)object7).reset();
                                        if (object3 != null && object2 != null) {
                                            Object var25_32 = null;
                                            break block125;
                                        }
                                        if (n3 == 0) throw new WebServicesFault(Messages.getMessage("httpStatusInResponse01"));
                                        object5 = ((HttpOutboundChannelConnection)wSOutboundConnection).getHeaderFromResponse(HttpConstants.HDR_CONTENT_TYPE);
                                        this.processStatusCode(n3, (String)object5, (WSAddress)object4);
                                        break block126;
                                    }
                                    catch (Exception exception) {
                                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", "826", this);
                                        if (_tc.isDebugEnabled()) {
                                            Tr.debug(_tc, Messages.getMessage("exception01", exception.toString()));
                                            if (JavaUtils.hasValue(object4.toString())) {
                                                Tr.debug(_tc, "URL = " + object4.toString());
                                            } else {
                                                Tr.debug(_tc, "URL = " + messageContext.getTargetEndpointAddress());
                                            }
                                        }
                                        if (wSOutboundConnection == null) throw WebServicesFault.makeFault(exception);
                                        wSOutboundConnection.disconnect(exception);
                                        throw WebServicesFault.makeFault(exception);
                                    }
                                }
                                catch (Throwable throwable) {
                                    block127: {
                                        Object var25_34 = null;
                                        try {
                                            if (wSOutboundConnection == null) break block127;
                                            if (wSOutboundConnection.getTargetAddress().getSchema() == 2) {
                                                this.restoreSSLConfiguration(wSOutboundConnection);
                                            }
                                            if (object3 != null && object2 != null && _tc.isDebugEnabled()) {
                                                Tr.debug(_tc, Messages.getMessage("returnOCforAsyncDelivery", wSOutboundConnection.toString(), object.toString()));
                                            }
                                            if (messageContext2.isOneWay()) {
                                                if (log.isDebugEnabled()) {
                                                    log.debug("One-way ? " + messageContext2.isOneWay());
                                                }
                                                this.oneWayRecycleTime = outboundConnectionCache.getOneWayRecycleTime();
                                                if (log.isDebugEnabled()) {
                                                    log.debug("One way connection recycle time : " + this.oneWayRecycleTime + " ms.");
                                                    if (messageContext.isServer()) {
                                                        log.debug("Server side");
                                                    }
                                                    if (messageContext.isClient()) {
                                                        log.debug("Client side");
                                                    }
                                                    if (messageContext.getResponseMessage() == null) {
                                                        log.debug("No response message");
                                                    }
                                                }
                                                if (this.oneWayRecycleTime > 0L) {
                                                    if (log.isDebugEnabled()) {
                                                        log.debug("Creating hash key");
                                                    }
                                                    this.hashKeyCode = new StringBuffer(String.valueOf(wSOutboundConnection.hashCode()));
                                                    this.hashKeyCode.append(String.valueOf(System.currentTimeMillis()));
                                                    if (!this.saveOneWayConnectionToMap(wSOutboundConnection)) {
                                                        if (log.isDebugEnabled()) {
                                                            log.debug("Could not save connection. Resetting the connection");
                                                        }
                                                        wSOutboundConnection.reset();
                                                        outboundConnectionCache.findGroupAndReturnConnection(wSOutboundConnection);
                                                        wSOutboundConnection = null;
                                                    }
                                                    break block127;
                                                }
                                                wSOutboundConnection.reset();
                                                outboundConnectionCache.findGroupAndReturnConnection(wSOutboundConnection);
                                                wSOutboundConnection = null;
                                                break block127;
                                            }
                                            wSOutboundConnection.reset();
                                            outboundConnectionCache.findGroupAndReturnConnection(wSOutboundConnection);
                                            wSOutboundConnection = null;
                                        }
                                        catch (Exception exception) {
                                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", "924", this);
                                            if (!_tc.isDebugEnabled()) throw WebServicesFault.makeFault(exception);
                                            Tr.debug(_tc, Messages.getMessage("exception01", exception.toString()));
                                            throw WebServicesFault.makeFault(exception);
                                        }
                                    }
                                    if (!_tc.isEntryEnabled()) throw throwable;
                                    Tr.exit(_tc, "HTTPSender::invoke");
                                    throw throwable;
                                }
                            }
                            try {}
                            catch (Exception exception) {
                                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", "924", this);
                                if (!_tc.isDebugEnabled()) throw WebServicesFault.makeFault(exception);
                                Tr.debug(_tc, Messages.getMessage("exception01", exception.toString()));
                                throw WebServicesFault.makeFault(exception);
                            }
                            if (wSOutboundConnection == null) break block133;
                            if (wSOutboundConnection.getTargetAddress().getSchema() == 2) {
                                this.restoreSSLConfiguration(wSOutboundConnection);
                            }
                            if (object3 != null && object2 != null && _tc.isDebugEnabled()) {
                                Tr.debug(_tc, Messages.getMessage("returnOCforAsyncDelivery", wSOutboundConnection.toString(), object.toString()));
                            }
                            if (!messageContext2.isOneWay()) break block134;
                            if (log.isDebugEnabled()) {
                                log.debug("One-way ? " + messageContext2.isOneWay());
                            }
                            this.oneWayRecycleTime = outboundConnectionCache.getOneWayRecycleTime();
                            if (log.isDebugEnabled()) {
                                log.debug("One way connection recycle time : " + this.oneWayRecycleTime + " ms.");
                                if (messageContext.isServer()) {
                                    log.debug("Server side");
                                }
                                if (messageContext.isClient()) {
                                    log.debug("Client side");
                                }
                                if (messageContext.getResponseMessage() == null) {
                                    log.debug("No response message");
                                }
                            }
                            if (this.oneWayRecycleTime > 0L) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Creating hash key");
                                }
                                this.hashKeyCode = new StringBuffer(String.valueOf(wSOutboundConnection.hashCode()));
                                this.hashKeyCode.append(String.valueOf(System.currentTimeMillis()));
                                if (!this.saveOneWayConnectionToMap(wSOutboundConnection)) {
                                    if (log.isDebugEnabled()) {
                                        log.debug("Could not save connection. Resetting the connection");
                                    }
                                    wSOutboundConnection.reset();
                                    outboundConnectionCache.findGroupAndReturnConnection(wSOutboundConnection);
                                    wSOutboundConnection = null;
                                }
                                break block133;
                            } else {
                                wSOutboundConnection.reset();
                                outboundConnectionCache.findGroupAndReturnConnection(wSOutboundConnection);
                                wSOutboundConnection = null;
                            }
                            break block133;
                        }
                        wSOutboundConnection.reset();
                        outboundConnectionCache.findGroupAndReturnConnection(wSOutboundConnection);
                        wSOutboundConnection = null;
                    }
                    if (!_tc.isEntryEnabled()) return;
                    Tr.exit(_tc, "HTTPSender::invoke");
                    return;
                }
                Object var25_33 = null;
                try {}
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", "924", this);
                    if (!_tc.isDebugEnabled()) throw WebServicesFault.makeFault(exception);
                    Tr.debug(_tc, Messages.getMessage("exception01", exception.toString()));
                    throw WebServicesFault.makeFault(exception);
                }
                if (wSOutboundConnection == null) break block135;
                if (wSOutboundConnection.getTargetAddress().getSchema() == 2) {
                    this.restoreSSLConfiguration(wSOutboundConnection);
                }
                if (object3 != null && object2 != null && _tc.isDebugEnabled()) {
                    Tr.debug(_tc, Messages.getMessage("returnOCforAsyncDelivery", wSOutboundConnection.toString(), object.toString()));
                }
                if (!messageContext2.isOneWay()) break block136;
                if (log.isDebugEnabled()) {
                    log.debug("One-way ? " + messageContext2.isOneWay());
                }
                this.oneWayRecycleTime = outboundConnectionCache.getOneWayRecycleTime();
                if (log.isDebugEnabled()) {
                    log.debug("One way connection recycle time : " + this.oneWayRecycleTime + " ms.");
                    if (messageContext.isServer()) {
                        log.debug("Server side");
                    }
                    if (messageContext.isClient()) {
                        log.debug("Client side");
                    }
                    if (messageContext.getResponseMessage() == null) {
                        log.debug("No response message");
                    }
                }
                if (this.oneWayRecycleTime > 0L) {
                    if (log.isDebugEnabled()) {
                        log.debug("Creating hash key");
                    }
                    this.hashKeyCode = new StringBuffer(String.valueOf(wSOutboundConnection.hashCode()));
                    this.hashKeyCode.append(String.valueOf(System.currentTimeMillis()));
                    if (!this.saveOneWayConnectionToMap(wSOutboundConnection)) {
                        if (log.isDebugEnabled()) {
                            log.debug("Could not save connection. Resetting the connection");
                        }
                        wSOutboundConnection.reset();
                        outboundConnectionCache.findGroupAndReturnConnection(wSOutboundConnection);
                        wSOutboundConnection = null;
                    }
                    break block135;
                } else {
                    wSOutboundConnection.reset();
                    outboundConnectionCache.findGroupAndReturnConnection(wSOutboundConnection);
                    wSOutboundConnection = null;
                }
                break block135;
            }
            wSOutboundConnection.reset();
            outboundConnectionCache.findGroupAndReturnConnection(wSOutboundConnection);
            wSOutboundConnection = null;
        }
        if (!_tc.isEntryEnabled()) return;
        Tr.exit(_tc, "HTTPSender::invoke");
    }

    public boolean saveOneWayConnectionToMap(WSOutboundConnection wSOutboundConnection) {
        if (log.isDebugEnabled()) {
            log.debug("HTTPSender.saveOneWayConnectionToMap()...");
        }
        boolean bl = false;
        String string = null;
        string = this.hashKeyCode.toString();
        OneWayConnectionMap oneWayConnectionMap = OneWayConnectionMap.getInstance();
        OneWayConnection oneWayConnection = new OneWayConnection(wSOutboundConnection, this.oneWayRecycleTime);
        if (!oneWayConnectionMap.containsKey(string)) {
            oneWayConnectionMap.putConnection(string, oneWayConnection);
            if (log.isDebugEnabled()) {
                log.debug("Creating and adding one way connection " + oneWayConnection + " to cache with key: " + string);
            }
            bl = true;
        }
        if (log.isDebugEnabled()) {
            log.debug("HTTPSender.saveOneWayConnectionToMap() : " + bl);
        }
        return bl;
    }

    private String getCookieValue(String string, MessageContext messageContext, WSAddress wSAddress) {
        Object object;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HTTPSender::getCookieValue(" + string + ")");
        }
        String string2 = null;
        String string3 = null;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Get value of cookie: " + string);
        }
        if (messageContext.getMaintainSession()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "javax.xml.rpc.session.maintain:  TRUE");
            }
            if ((object = messageContext.getProperty("com.ibm.ws.webservices.engine.session.context")) != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "HttpOutboundChannelConnection.prepareHttpRequestHeaders() : msgContext = " + messageContext.toString() + " SessionContext = " + object);
                }
                if (UseNewCookieHandling = HTTPCookieManager.newCookieHandling()) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "New Cookie Management Handling HTTPCookieManager object: " + object);
                    }
                    URL uRL = messageContext.getTargetEndpointAddressAsURL();
                    String string4 = uRL.getPath();
                    String string5 = uRL.getHost();
                    int n = uRL.getPort();
                    boolean bl = false;
                    if (wSAddress.getSchema() == 2) {
                        bl = true;
                    }
                    if ((string3 = ((HTTPCookieManager)object).getCookie(string4, string5, n, bl)) != null) {
                        string2 = this.parseCookieString(string3, string);
                    }
                } else {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Old Cookie Management Handling HTTPSessionContext object: " + object);
                    }
                    if ((string3 = ((HTTPSessionContext)object).getCookie()) != null) {
                        string2 = this.parseCookieString(string3, string);
                    }
                    if ((string3 == null || string2 == null) && (string3 = ((HTTPSessionContext)object).getCookie2()) != null) {
                        string2 = this.parseCookieString(string3, string);
                    }
                }
            }
        }
        if (string2 == null) {
            object = (HashMap)messageContext.getProperty("com.ibm.websphere.webservices.requestTransportProperties");
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "com.ibm.websphere.webservices.requestTransportProperties: " + object);
            }
            if (object != null) {
                string3 = (String)((HashMap)object).get("Cookie");
                if (string3 != null) {
                    string2 = this.parseCookieString(string3, string);
                }
                if ((string3 == null || string2 == null) && (string3 = (String)((HashMap)object).get("Cookie2")) != null) {
                    string2 = this.parseCookieString(string3, string);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "HTTPSender::getCookieValue");
        }
        return string2;
    }

    private String parseCookieString(String string, String string2) {
        String[] stringArray = null;
        stringArray = string.split(";");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length - 1; ++i) {
                if (stringArray[i].indexOf(string2) != 0) continue;
                return stringArray[i].split("=")[1];
            }
        }
        return null;
    }

    private void setupEffectiveSSLConfiguration(final WSAddress wSAddress) throws WebServicesFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HTTPSender::setupEffectiveSSLConfiguration");
        }
        Config config2 = null;
        final MessageContext messageContext = MessageContext.getCurrentThreadsContext();
        try {
            config2 = (Config)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws WebServicesFault {
                    return ConfigSSLProvider.getInstance().getConfig(messageContext, wSAddress);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", "%C", this);
            Tr.debug(_tc, privilegedActionException.toString());
            throw (WebServicesFault)privilegedActionException.getException();
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Effective SSL configuration: " + (config2 == null ? null : config2.toString()));
        }
        if (config2 == null) {
            throw new WebServicesFault(Messages.getMessage("sslConfigResolveFailed01", wSAddress.toString()));
        }
        wSAddress.setTransportConfiguration(config2);
        config2.addTargetAddress(wSAddress);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "HTTPSender::setupEffectiveSSLConfiguration");
        }
    }

    private void restoreSSLConfiguration(final WSOutboundConnection wSOutboundConnection) throws WebServicesFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HTTPSender::restoreSSLConfiguration");
        }
        final Log log = HTTPSender.log;
        try {
            AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws WebServicesFault {
                    JSSEHelper jSSEHelper = JSSEHelper.getInstance();
                    ConfigSSL configSSL = (ConfigSSL)wSOutboundConnection.getTargetAddress().transportConfiguration();
                    if (configSSL != null) {
                        WSConfigSSLChangeListener wSConfigSSLChangeListener = configSSL.getlistener();
                        if (wSConfigSSLChangeListener != null) {
                            if (log.isDebugEnabled()) {
                                log.debug("De-registering WSConfigSSLChangeListener: " + wSConfigSSLChangeListener);
                            }
                            wSConfigSSLChangeListener.deRegister();
                        }
                        Properties properties = configSSL.getPreCfg();
                        if (log.isDebugEnabled()) {
                            if (properties != null) {
                                log.debug("Restoring previously saved SSL configuration: " + properties);
                            } else {
                                log.debug("No previously saved SSL configuration to be restored.");
                            }
                        }
                        jSSEHelper.setSSLPropertiesOnThread(properties);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.webservices.engine.transport.http.HTTPSender.restoreSSLConfiguration", "1255", this);
            if (log.isDebugEnabled()) {
                Tr.debug(_tc, privilegedActionException.toString());
            }
            throw WebServicesFault.makeFault(privilegedActionException.getException());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "HTTPSender::restoreSSLConfiguration");
        }
    }

    private void processStatusCode(int n, String string, WSAddress wSAddress) throws WebServicesFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HTTPSender::processStatusCode");
        }
        MessageContext messageContext = MessageContext.getCurrentThreadsContext();
        String string2 = string = null == string ? null : string.trim();
        if (!(n > 199 && n < 300 || string != null && !string.startsWith("text/html") && n > 499 && n < 600)) {
            String string3 = messageContext.getStrProp(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
            String string4 = wSAddress.getSchemaInString().toLowerCase() + "://" + wSAddress.getHostname() + ":" + wSAddress.getPort();
            WebServicesFault webServicesFault = new WebServicesFault("HTTP", "( " + n + " ) " + string3, string4, null);
            String string5 = messageContext.getResponseMessage() == null ? "" : messageContext.getResponseMessage().getSOAPPartAsString();
            webServicesFault.setFaultDetailString(Messages.getMessage("return01", "( " + n + " ) " + string3, string5));
            throw webServicesFault;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "HTTPSender::processStatusCode");
        }
    }

    public String getCookieFromHeaders(String string, String string2, Hashtable hashtable) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HTTPSender::getCookieFromHeaders(" + string + ", " + string2 + ", headers)");
        }
        String string3 = null;
        if (hashtable.containsKey(string2.toLowerCase())) {
            string3 = (String)hashtable.get(string2.toLowerCase());
            int n = (string3 = string3.trim()).indexOf(59);
            if (n != -1) {
                string3 = string3.substring(0, n);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "HTTPSender::getCookieFromHeaders");
        }
        return string3;
    }

    public static boolean isHttpRedirectEnabled() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HTTPSender::isHttpRedirectEnabled()");
        }
        boolean bl = false;
        MessageContext messageContext = MessageContext.getCurrentThreadsContext();
        Boolean bl2 = (Boolean)messageContext.getProperty("http.redirect.enabled");
        if (bl2 != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Programmatic value of http.redirect.enabled: " + bl2);
            }
            return bl2;
        }
        bl2 = (Boolean)messageContext.getProperty("com.ibm.ws.webservices.HttpRedirectEnabled");
        if (bl2 != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Programmatic value of com.ibm.ws.webservices.HttpRedirectEnabled: " + bl2);
            }
            return bl2;
        }
        String string = System.getProperty("http.redirect.enabled");
        if (string != null) {
            bl = Boolean.valueOf(string);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "System property value of http.redirect.enabled: " + string);
            }
            return bl;
        }
        string = System.getProperty("com.ibm.ws.webservices.HttpRedirectEnabled");
        if (string != null) {
            bl = Boolean.valueOf(string);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "System property value of com.ibm.ws.webservices.HttpRedirectEnabled: " + string);
            }
            return bl;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "http.redirect.enabled: " + bl2);
            Tr.debug(_tc, "com.ibm.ws.webservices.HttpRedirectEnabled: " + string);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "HTTPSender::isHttpRedirectEnabled=" + bl);
        }
        return bl;
    }

    private boolean receivedHTTPBasicAuth() {
        MessageContext messageContext;
        boolean bl;
        block10: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "HTTPSender::receivedHTTPBasicAuth()");
            }
            bl = false;
            messageContext = MessageContext.getCurrentThreadsContext();
            if (!JavaUtils.hasValue(messageContext.getUsername()) && !JavaUtils.hasValue(messageContext.getPassword())) {
                String string = System.getProperty("com.ibm.ws.webservices.loginSource");
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "com.ibm.ws.webservices.loginSource: " + string);
                }
                try {
                    if (!JavaUtils.hasValue(string) || "prompt".compareToIgnoreCase(string) != 0 && "stdin".compareToIgnoreCase(string) != 0) break block10;
                    SecurityDataPrompt securityDataPrompt = SecurityDataPromptFactory.getPrompt(string);
                    String[] stringArray = null;
                    try {
                        final String string2 = messageContext.getStrProp("WWW-Authenticate");
                        final SecurityDataPrompt securityDataPrompt2 = securityDataPrompt;
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, Messages.getMessage("challengeRealmInfo", string2));
                        }
                        stringArray = (String[])AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return securityDataPrompt2.launch(string2 == null ? "" : string2);
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.webservices.engine.transport.http.HTTPSender.receivedHTTPBasicAuth", "1479", this);
                        Tr.debug(_tc, privilegedActionException.toString());
                        throw privilegedActionException.getException();
                    }
                    if (stringArray != null && JavaUtils.hasValue(stringArray[0]) && JavaUtils.hasValue(stringArray[1])) {
                        messageContext.setUsername(stringArray[0]);
                        messageContext.setPassword(stringArray[1]);
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.transport.http.HTTPSender.receivedHTTPBasicAuth", "1494", this);
                    if (!_tc.isDebugEnabled()) break block10;
                    Tr.debug(_tc, Messages.getMessage("exception01", exception.toString()));
                }
            }
        }
        messageContext.removeProperty("WWW-Authenticate");
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "HTTPSender::receivedHTTPBasicAuth()");
        }
        return bl;
    }
}

