/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.mq.jms.MQDestination;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.SimpleTargetedChain;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.configuration.EngineConfigurationFactoryFinder;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.server.ServerEngine;
import com.ibm.ws.webservices.engine.transport.TransactionSuspender;
import com.ibm.ws.webservices.engine.transport.http.HTTPConstants;
import com.ibm.ws.webservices.engine.transport.http.HTTPSender;
import com.ibm.ws.webservices.engine.transport.jms.JMSSender;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.trace.MessageTrace;
import com.ibm.ws.webservices.trace.UserExceptionTrace;
import com.ibm.ws.webservices.utils.WebServicesInputSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.soap.SOAPException;

public class JMSListenerMDB
implements MessageDrivenBean,
MessageListener {
    private static final TraceComponent _tc = Tr.register(JMSListenerMDB.class, "WebServices", "com.ibm.ws.webservices.engine.resources.engineMessages");
    private MessageDrivenContext fMessageDrivenCtx = null;
    private ServerEngine serverEngine = null;
    private InitialContext initialContext = null;
    private QueueConnectionFactory replyQCF = null;
    static boolean propagateOneWaySystemExceptions = false;
    static final String propagateOneWaySystemExceptionsProp = "com.ibm.ws.webservices.engine.transport.jms.propagateOneWaySystemExceptions";

    public MessageDrivenContext getMessageDrivenContext() {
        return this.fMessageDrivenCtx;
    }

    public void setMessageDrivenContext(MessageDrivenContext messageDrivenContext) {
        this.fMessageDrivenCtx = messageDrivenContext;
    }

    private InitialContext getInitialContext() throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getInitialContext");
        }
        try {
            if (this.initialContext == null) {
                this.initialContext = new InitialContext();
            }
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB.getInitialContext", "171", this);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Failed to create initial context!");
            }
            throw namingException;
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getInitialContext");
            }
        }
        return this.initialContext;
    }

    private synchronized QueueConnectionFactory getReplyQCF() throws Exception {
        try {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "getReplyQCF");
            }
            if (this.replyQCF == null) {
                InitialContext initialContext = this.getInitialContext();
                String string = "java:comp/env/jms/WebServicesReplyQCF";
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "About to look up QCF: " + string);
                }
                this.replyQCF = (QueueConnectionFactory)initialContext.lookup(string);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found the QCF!");
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB.getReplyQCF", "222", this);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Failed to locate my reply QCF, exception = " + exception.toString());
            }
            throw exception;
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getReplyQCF");
            }
        }
        return this.replyQCF;
    }

    public void ejbCreate() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ejbCreate");
        }
        try {
            HashMap hashMap = new HashMap();
            this.serverEngine = ServerEngine.getServer(null, hashMap);
            if (this.serverEngine == null) {
                throw new WebServicesFault(Messages.getMessage("JMS.ServerEngine"));
            }
        }
        catch (WebServicesFault webServicesFault) {
            FFDCFilter.processException((Throwable)webServicesFault, "com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB.ejbCreate", "265", this);
            Tr.error(_tc, "JMS.Fault01", webServicesFault.toString());
            throw new EJBException(webServicesFault.toString());
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "ejbCreate");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(javax.jms.Message message) {
        block80: {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            String string;
            String string2;
            Object object6;
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "onMessage");
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Received JMS Message: " + message.toString());
            }
            MessageContext messageContext = new MessageContext(this.serverEngine);
            Message message2 = null;
            Message message3 = null;
            Queue queue = null;
            String string3 = null;
            boolean bl = false;
            boolean bl2 = true;
            TransactionSuspender transactionSuspender = null;
            try {
                object6 = message.getStringProperty("enableTransaction");
                bl2 = JavaUtils.isFalse((String)object6);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (bl2) {
                transactionSuspender = new TransactionSuspender();
            }
            try {
                if (bl2) {
                    transactionSuspender.suspendTransaction();
                }
                string3 = message.getJMSMessageID();
                queue = (Queue)message.getJMSReplyTo();
                object6 = message.getStringProperty("targetService");
                if (object6 == null || ((String)object6).length() == 0) {
                    Tr.error(_tc, "JMS.NoTargetService", "targetService");
                    throw new WebServicesFault("JMS", Messages.getMessage("JMS.NoTargetService", "targetService"), null, null);
                }
                messageContext.setTargetPort((String)object6);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Set target port on message context to: " + (String)object6);
                }
                if ((string2 = message.getStringProperty("endpointURL")) != null && string2.length() > 0) {
                    messageContext.setProperty("inbound.url", string2);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Set inbound.url property on MessageContext to: " + string2);
                    }
                }
                string = (string = message.getStringProperty("contentType")) == null ? null : string.trim();
                object5 = null;
                if (message instanceof BytesMessage) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Got BytesMessage, contentType=" + string);
                    }
                    object4 = (BytesMessage)message;
                    bl = true;
                    object3 = new ByteArrayOutputStream();
                    object2 = new byte[4096];
                    int n = 1;
                    while (n > 0) {
                        n = object4.readBytes((byte[])object2);
                        if (n <= 0) continue;
                        ((ByteArrayOutputStream)object3).write((byte[])object2, 0, n);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Extracted the following SOAP message from the JMS request message:\n" + ((ByteArrayOutputStream)object3).toString());
                    }
                    object5 = ((ByteArrayOutputStream)object3).toByteArray();
                    object = new ByteArrayInputStream((byte[])object5);
                    message2 = new Message(object, string, null);
                } else if (message instanceof TextMessage) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Got TextMessage, contentType=" + string);
                    }
                    object4 = ((TextMessage)message).getText();
                    object3 = Charset.defaultCharset().name();
                    object2 = JMSListenerMDB.getCharacterEncoding(string);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "getText() default encoding = " + (String)object3);
                        Tr.debug(_tc, "getText() charset encoding = " + (String)object2);
                    }
                    object = ((String)object4).getBytes((String)object2);
                    WebServicesInputSource webServicesInputSource = WebServicesInputSource.create(object);
                    webServicesInputSource.setEncoding((String)object2);
                    message2 = new Message(webServicesInputSource, string, null);
                    if (MessageTrace.isTraceEnabled()) {
                        object5 = object;
                    }
                } else {
                    Tr.error(_tc, "JMS.BadMsgType");
                    throw new WebServicesFault("JMS", Messages.getMessage("JMS.BadMsgType"), null, null);
                }
                messageContext.setRequestMessage(message2);
                messageContext.setTransportName("jms");
                messageContext.setProperty("transport.jms.requestMessage", message);
                this.handleSoapAction(message, messageContext);
                if (MessageTrace.isTraceEnabled() && object5 != null) {
                    MessageTrace.log(MessageTrace.INBOUND_JMS_REQUEST, string, (byte[])object5);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Calling ServerEngine.invoke()...");
                }
                this.serverEngine.invoke(messageContext);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Returned from ServerEngine.invoke()...");
                }
            }
            catch (Exception exception) {
                boolean bl3 = false;
                if (UserExceptionTrace.isUserDefinedException(exception)) {
                    UserExceptionTrace.log(exception);
                    bl3 = true;
                }
                object6 = WebServicesFault.makeFault(exception);
                if (!bl3) {
                    FFDCFilter.processException((Throwable)object6, "com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB.onMessage", "512", this);
                    Tr.error(_tc, "JMS.JMSError03", ((Throwable)object6).toString());
                }
                if (queue != null || messageContext.getProperty("com.ibm.ws.wsaddressing.RedirectRequired") != null) {
                    message3 = new Message(object6);
                    messageContext.setResponseMessage(message3);
                }
                if (queue == null && !bl3) {
                    throw new RuntimeException(((Throwable)object6).getMessage());
                }
            }
            finally {
                if (bl2) {
                    transactionSuspender.resumeTransaction();
                }
            }
            if (queue == null && propagateOneWaySystemExceptions) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Finished processing one-way request, replyQueue is null.");
                }
                this.processOneWayFault(messageContext);
            }
            try {
                if (messageContext.getProperty("com.ibm.ws.wsaddressing.RedirectRequired") != null) {
                    object6 = messageContext.getTargetEndpointAddress();
                    boolean bl4 = false;
                    boolean bl5 = false;
                    boolean bl6 = _tc.isDebugEnabled();
                    if (object6 != null && ((String)object6).toLowerCase().startsWith("jms")) {
                        bl4 = true;
                        if (bl6) {
                            Tr.debug(_tc, "Redirect directive to JMS found.");
                        }
                    }
                    if (object6 != null && ((String)object6).toLowerCase().startsWith("http")) {
                        bl5 = true;
                        if (bl6) {
                            Tr.debug(_tc, "Redirect directive to http/https found.");
                        }
                    }
                    if (messageContext.isOneWay()) {
                        Tr.error(_tc, Messages.getMessage("servlet.unexpected.oneway.response00"));
                        if (bl6) {
                            Tr.debug(_tc, "No Response Sent");
                        }
                        break block80;
                    }
                    if (messageContext.getProperty("com.ibm.ws.wsaddressing.NoneURI") != null) {
                        if (bl6) {
                            Tr.debug(_tc, "Discard Response : WSAddressing NoneURI specified.");
                        }
                        if (bl6) {
                            Tr.debug(_tc, "No Response Sent");
                        }
                        break block80;
                    }
                    if (bl4) {
                        object4 = EngineConfigurationFactoryFinder.newFactory("NONE").getClientEngineConfig();
                        if (object4 != null && (object3 = (SimpleTargetedChain)object4.getTransport(QNameTable.createQName(null, "jms"))) != null) {
                            object2 = (JMSSender)((SimpleTargetedChain)object3).getPivotHandler();
                            MessageContext.setCurrentThreadsContext(messageContext);
                            if (object2 != null) {
                                object = messageContext.getTargetEndpointAddressAsURL();
                                if (bl6) {
                                    Tr.debug(_tc, "Attempting to redirect to JMS to " + object);
                                }
                                ((JMSSender)object2).invoke(messageContext);
                            }
                        }
                        break block80;
                    }
                    if (!bl5) break block80;
                    try {
                        object4 = EngineConfigurationFactoryFinder.newFactory("NONE").getClientEngineConfig();
                        if (object4 != null) {
                            object3 = (SimpleTargetedChain)object4.getTransport(QNameTable.createQName(null, "http"));
                            object2 = (HTTPSender)((SimpleTargetedChain)object3).getPivotHandler();
                            MessageContext.setCurrentThreadsContext(messageContext);
                            messageContext.setProperty(HTTPConstants.MC_HTTP_OUTBOUND_ASYNC_RESPONSE, "yes".intern());
                            ((HTTPSender)object2).invoke(messageContext);
                        }
                        break block80;
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB.onMessage", "1:620:1.38.1.2", this);
                        throw new SOAPException((Throwable)exception);
                    }
                }
                if (queue == null || (message3 = messageContext.getResponseMessage()) == null) break block80;
                object6 = this.getReplyQCF();
                string2 = object6.createQueueConnection();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Created the queue connection.");
                }
                try {
                    long l;
                    string = string2.createQueueSession(false, 1);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Created the queue session.");
                    }
                    if (message.getJMSDestination() == null) {
                        try {
                            if (queue instanceof MQDestination) {
                                ((MQDestination)queue).setTargetClient(1);
                            }
                        }
                        catch (NoClassDefFoundError noClassDefFoundError) {
                            // empty catch block
                        }
                    }
                    object5 = string.createSender(queue);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Created the queue sender.");
                    }
                    object4 = null;
                    object3 = message3.getContentType(messageContext.getSOAPConstants());
                    if (bl || message3.countAttachments() > 0) {
                        object4 = string.createBytesMessage();
                        object2 = new ByteArrayOutputStream();
                        message3.writeTo((OutputStream)object2, (String)object3);
                        message3.removeAllAttachments();
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "About to write the following reply message into the JMS response message:\n" + ((ByteArrayOutputStream)object2).toString());
                        }
                        ((BytesMessage)object4).writeBytes(((ByteArrayOutputStream)object2).toByteArray());
                        if (MessageTrace.isTraceEnabled()) {
                            MessageTrace.log(MessageTrace.OUTBOUND_JMS_RESPONSE, (String)object3, ((ByteArrayOutputStream)object2).toByteArray());
                        }
                    } else {
                        object4 = string.createTextMessage();
                        object2 = message3.getSOAPPartAsString();
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "About to write the following reply message into the JMS response message:\n" + (String)object2);
                        }
                        ((TextMessage)object4).setText((String)object2);
                        if (MessageTrace.isTraceEnabled()) {
                            MessageTrace.log(MessageTrace.OUTBOUND_JMS_RESPONSE, (String)object3, (String)object2);
                        }
                    }
                    object4.setStringProperty("contentType", (String)object3);
                    object4.setStringProperty("transportVersion", "1");
                    object2 = null;
                    object2 = (HashMap)messageContext.getProperty("com.ibm.websphere.webservices.responseTransportProperties");
                    if (object2 != null) {
                        this.setResponseHandlerTransportProperties((javax.jms.Message)object4, (HashMap)object2);
                    }
                    object4.setJMSCorrelationID(string3);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "About to send the following reply message:\n" + object4.toString());
                    }
                    if ((l = message.getJMSExpiration() - message.getJMSTimestamp()) < 0L) {
                        l = 0L;
                    }
                    object5.send((javax.jms.Message)object4, message.getJMSDeliveryMode(), message.getJMSPriority(), l);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Sent the reply message with a time-to-live of " + l);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Sent the reply message.");
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB.onMessage", "792", this);
                    WebServicesFault webServicesFault = WebServicesFault.makeFault(exception);
                    Tr.error(_tc, "JMS.unexpected", ((Throwable)webServicesFault).toString());
                }
                finally {
                    string2.close();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Closed the queue connection.");
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB.onMessage", "810", this);
                WebServicesFault webServicesFault = WebServicesFault.makeFault(exception);
                Tr.error(_tc, "JMS.unexpected", ((Throwable)webServicesFault).toString());
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "onMessage");
        }
    }

    private void handleSoapAction(javax.jms.Message message, MessageContext messageContext) throws JMSException {
        String string = message.getStringProperty("soapAction");
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Retrieve soapAction property from JMS message: " + (string == null ? "<null>" : string));
        }
        if (string == null || string.length() == 0) {
            messageContext.setUseSOAPAction(false);
            messageContext.setSOAPActionURI(null);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Disabling soapAction on MessageContext...");
            }
        } else {
            messageContext.setUseSOAPAction(true);
            if (string.startsWith("\"") && string.endsWith("\"")) {
                string = string.substring(1, string.length() - 1);
            }
            messageContext.setSOAPActionURI(string);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Setting soapAction on MessageContext to: " + string);
            }
        }
    }

    public void ejbRemove() {
    }

    private void setResponseHandlerTransportProperties(javax.jms.Message message, HashMap hashMap) throws WebServicesFault {
        try {
            if (hashMap != null) {
                Iterator iterator = hashMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (entry.getKey() == null || !(entry.getKey() instanceof String)) {
                        Tr.warning(_tc, "invalid.transportheader.key");
                        continue;
                    }
                    String string = ((String)entry.getKey()).trim();
                    if (!JavaUtils.hasValue(string)) {
                        Tr.warning(_tc, "invalid.transportheader.key");
                        continue;
                    }
                    if (entry.getValue() == null || !(entry.getValue() instanceof String)) {
                        Tr.warning(_tc, "invalid.transportheader.value", new Object[]{entry.getValue()});
                        continue;
                    }
                    String string2 = ((String)entry.getValue()).trim();
                    if (!JavaUtils.hasValue(string2)) {
                        Tr.warning(_tc, "invalid.transportheader.value", new Object[]{string2});
                        continue;
                    }
                    if (message.propertyExists(string)) continue;
                    message.setStringProperty(string, string2);
                }
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB.setResponseHandlerTransportProperties", "922", this);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Messages.getMessage("JMS.JMSError01", jMSException.toString()));
            Exception exception = jMSException.getLinkedException();
            while (exception != null) {
                stringBuffer.append("\n");
                stringBuffer.append(Messages.getMessage("JMS.JMSError02", exception.toString()));
                if (exception instanceof JMSException) {
                    exception = ((JMSException)((Object)exception)).getLinkedException();
                    continue;
                }
                exception = null;
            }
            Tr.error(_tc, stringBuffer.toString());
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, stringBuffer.toString());
            }
            throw new WebServicesFault("JMS", stringBuffer.toString(), null, null);
        }
    }

    private void processOneWayFault(MessageContext messageContext) {
        Message message;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "processOneWayFault");
        }
        if ((message = messageContext.getResponseMessage()) != null) {
            WebServicesFault webServicesFault = null;
            try {
                webServicesFault = message.getFault();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, this.getClass().getName() + ".processOneWayFault", "1119", this);
                Tr.error(_tc, "JMS.JMSError03", throwable.toString());
            }
            if (webServicesFault != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Detected WebServicesFault in the response: " + webServicesFault.toString());
                }
                boolean bl = false;
                for (Throwable throwable = webServicesFault; !bl && throwable != null; throwable = throwable.getCause()) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "exception in response: " + throwable.getMessage());
                    }
                    if (!UserExceptionTrace.isUserDefinedException(throwable)) continue;
                    bl = true;
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "isUserException[" + bl + "]");
                }
                if (!bl) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "It's not a user-defined exception, so wrapping in a RuntimeException...");
                    }
                    throw new RuntimeException(webServicesFault);
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "No WebServicesFault in the response, wf is null");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "processOneWayFault");
        }
    }

    public static String getCharacterEncoding(String string) {
        int n;
        String string2 = "UTF-8";
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getCharacterEncoding contentType=" + string);
        }
        if (string != null && (n = string.indexOf("charset=")) > 0) {
            String string3 = string.substring(n + "charset=".length());
            int n2 = string3.indexOf(";");
            if (n2 > 0) {
                string3 = string3.substring(0, n2);
            }
            string3 = JavaUtils.replace(string3, "\"", "");
            string2 = string3 = string3.trim();
        }
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getCharacterEncoding charset=" + string2);
        }
        return string2;
    }

    static {
        propagateOneWaySystemExceptions = Boolean.getBoolean(propagateOneWaySystemExceptionsProp);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "com.ibm.ws.webservices.engine.transport.jms.propagateOneWaySystemExceptions = " + System.getProperty(propagateOneWaySystemExceptionsProp));
            Tr.debug(_tc, "propagateOneWaySystemExceptions  = " + propagateOneWaySystemExceptions);
        }
    }
}

