/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

public class LockableHashtable
extends Hashtable {
    protected static Log log = LogFactory.getLog(LockableHashtable.class.getName());
    Set lockedEntries = null;
    private String kind = null;
    private Map parent = null;

    public LockableHashtable() {
    }

    public LockableHashtable(int n, float f) {
        super(n, f);
    }

    public LockableHashtable(Map map) {
        this.putAll(map);
    }

    public LockableHashtable(int n) {
        super(n);
    }

    public synchronized void setParent(Map map) {
        this.parent = map;
    }

    public synchronized Map getParent() {
        return this.parent;
    }

    public synchronized Object get(Object object) {
        Object v = super.get(object);
        if (v == null && this.parent != null && this.parent != this) {
            v = this.parent.get(object);
        }
        return v;
    }

    public synchronized Object put(Object object, Object object2, boolean bl) {
        if (this.isKeyLocked(object)) {
            return null;
        }
        if (bl) {
            if (this.lockedEntries == null) {
                this.lockedEntries = new HashSet();
            }
            this.lockedEntries.add(object);
        }
        return super.put(object, object2);
    }

    public synchronized Object put(Object object, Object object2) {
        return this.put(object, object2, false);
    }

    public synchronized Object remove(Object object) {
        if (this.isKeyLocked(object)) {
            return null;
        }
        return super.remove(object);
    }

    public synchronized void clear() {
        super.clear();
        this.lockedEntries = null;
    }

    public synchronized boolean isKeyLocked(Object object) {
        return this.lockedEntries != null && this.lockedEntries.contains(object);
    }

    public synchronized void setKind(String string) {
        this.kind = string;
    }

    public synchronized String getKind() {
        return this.kind;
    }

    public synchronized String dumpChain() {
        int n = 100;
        String string = "LockableHashtable chain\n";
        Map map = this;
        for (int i = 0; map != null && i < n; ++i) {
            if (map instanceof LockableHashtable) {
                LockableHashtable lockableHashtable = map;
                string = string + i + ":" + JavaUtils.getObjectIdentity(lockableHashtable) + " (" + lockableHashtable.getKind() + ") size=" + this.size() + "\n";
                map = lockableHashtable.getParent();
                continue;
            }
            string = string + i + ":" + JavaUtils.getObjectIdentity(map) + " size=" + this.size() + "\n";
            map = null;
        }
        return string;
    }
}

