/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.Version;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesProperties;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.xml.sax.SAXException;

public class MCUtils {
    protected static Log log = LogFactory.getLog(MCUtils.class.getName());
    public static final String PRE_60_BUILD_NUMBER = "pre-WAS 6.0 build";
    static int DUMP_MSGCONTEXT_MASK = 1;
    static int DUMP_WEBSERVICES_MASK = 2;
    static int DUMP_SYSTEM_MASK = 4;
    static int DUMP_ALL = DUMP_MSGCONTEXT_MASK + DUMP_WEBSERVICES_MASK + DUMP_SYSTEM_MASK;

    public static List getLazyParseQNames(MessageContext messageContext) {
        ArrayList arrayList = null;
        List list = (List)messageContext.getProperty("lazyParseQNames");
        SOAPPort sOAPPort = messageContext.getPort();
        List list2 = null;
        if (sOAPPort != null) {
            list2 = (List)sOAPPort.getOption("lazyParseQNames");
        }
        if (list != null && list.size() > 0 || list2 != null && list2.size() > 0) {
            arrayList = new ArrayList();
            if (list != null && list.size() > 0) {
                arrayList.addAll(list);
            }
            if (list2 != null && list2.size() > 0) {
                arrayList.addAll(list2);
            }
        }
        return arrayList;
    }

    public static void setLazyParseQNames(MessageContext messageContext, List list) {
        messageContext.setProperty("lazyParseQNames", list);
    }

    public static final Exception interceptSerializationException(Exception exception, SerializationContext serializationContext) {
        if (log.isDebugEnabled()) {
            log.debug("interceptSerializationException: " + exception.toString() + " " + JavaUtils.stackToString(exception));
        }
        FFDCFilter.processException(exception, "com.ibm.ws.webservices.engine.utils.MCUtils.interceptSerializationException", "%C");
        serializationContext.logBuildNumber(MCUtils.getOperationBuildNumber(serializationContext.getMessageContext()));
        List list = serializationContext.getBuildNumbers();
        if (list.size() == 0) {
            return exception;
        }
        String string = "Debug deploy artifact build numbers=";
        for (int i = 0; i < list.size(); ++i) {
            string = string + "{" + (String)list.get(i) + "} ";
        }
        String string2 = Messages.getMessage("migrationErr00", exception.toString(), string);
        return new IOException(string2);
    }

    public static final SAXException interceptDeserializationException(Exception exception, DeserializationContext deserializationContext) {
        if (log.isDebugEnabled()) {
            log.debug("interceptDeserializationException: " + exception.toString() + " " + JavaUtils.stackToString(exception));
        }
        FFDCFilter.processException(exception, "com.ibm.ws.webservices.engine.utils.MCUtils.interceptDeserializationException", "%C");
        deserializationContext.logBuildNumber(MCUtils.getOperationBuildNumber(deserializationContext.getMessageContext()));
        List list = deserializationContext.getBuildNumbers();
        if (list.size() == 0) {
            if (exception instanceof SAXException) {
                return (SAXException)exception;
            }
            return new SAXException(exception);
        }
        String string = "Debug deploy artifact build numbers=";
        for (int i = 0; i < list.size(); ++i) {
            string = string + "{" + (String)list.get(i) + "} ";
        }
        String string2 = Messages.getMessage("migrationErr00", exception.toString(), string);
        return new SAXException(string2, exception);
    }

    private static String getOperationBuildNumber(MessageContext messageContext) {
        OperationDesc operationDesc;
        String string = null;
        if (messageContext != null && (operationDesc = messageContext.getOperation()) != null) {
            string = (String)operationDesc.getOption("buildNum");
            if (string == null) {
                string = PRE_60_BUILD_NUMBER;
            } else if (string.equals(Version.getRawBuildNum())) {
                string = null;
            }
        }
        return string;
    }

    public static String getProperty(String string) {
        return MCUtils.getProperty(MessageContext.getCurrentThreadsContext(), string, null);
    }

    public static String getProperty(String string, String string2) {
        return MCUtils.getProperty(MessageContext.getCurrentThreadsContext(), string, string2);
    }

    public static String getProperty(MessageContext messageContext, String string) {
        return MCUtils.getProperty(messageContext, string, null);
    }

    public static String getProperty(MessageContext messageContext, String string, String string2) {
        String string3 = null;
        if (messageContext != null) {
            string3 = (String)messageContext.getProperty(string);
        }
        if (!JavaUtils.hasValue(string3)) {
            string3 = WebServicesProperties.getProperty(string);
        }
        return JavaUtils.hasValue(string3) ? string3 : string2;
    }

    public static boolean isPropertyTrue(String string) {
        return MCUtils.isPropertyTrue(MessageContext.getCurrentThreadsContext(), string);
    }

    public static boolean isPropertyTrue(MessageContext messageContext, String string) {
        return JavaUtils.isTrueExplicitly(MCUtils.getProperty(messageContext, string, null));
    }

    public static boolean isPropertyEnabled(String string) {
        return MCUtils.isPropertyEnabled(MessageContext.getCurrentThreadsContext(), string);
    }

    public static boolean isPropertyEnabled(MessageContext messageContext, String string) {
        boolean bl = false;
        bl = MCUtils.isPropertySet(messageContext, string) ? JavaUtils.isTrueExplicitly(MCUtils.getProperty(messageContext, string, null)) : JavaUtils.isTrueExplicitly(MCUtils.getProperty(messageContext, "com.ibm.websphere.webservices.enableAllApars", null));
        return bl;
    }

    public static boolean isPropertySet(String string) {
        return MCUtils.isPropertySet(MessageContext.getCurrentThreadsContext(), string);
    }

    public static boolean isPropertySet(MessageContext messageContext, String string) {
        String string2 = MCUtils.getProperty(messageContext, string, null);
        return JavaUtils.hasValue(string2);
    }

    public static String getSettingMsg(String string, boolean bl) {
        String string2 = bl ? "enabled" : "disabled";
        return string + " is " + string2;
    }

    public static void dumpProperties() {
        MCUtils.dumpProperties(DUMP_ALL);
    }

    public static void dumpContextProperties() {
        MCUtils.dumpProperties(DUMP_MSGCONTEXT_MASK);
    }

    public static void dumpProperties(int n) {
        if (log.isDebugEnabled()) {
            final int n2 = n;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Cloneable cloneable;
                    if ((n2 & DUMP_MSGCONTEXT_MASK) > 0) {
                        cloneable = MessageContext.getCurrentThreadsContext();
                        if (cloneable != null) {
                            StringBuffer stringBuffer = new StringBuffer("Message Context Properties:\n{");
                            Iterator iterator = ((MessageContext)cloneable).getPropertyNames();
                            while (iterator.hasNext()) {
                                String string = (String)iterator.next();
                                Object object = ((MessageContext)cloneable).getProperty(string);
                                if (object instanceof String) {
                                    stringBuffer.append(string + "=" + object + ", ");
                                    continue;
                                }
                                stringBuffer.append(string + "=(non-String), ");
                            }
                            stringBuffer.append("}");
                            log.debug(stringBuffer);
                        } else {
                            log.debug("No message context found.");
                        }
                    }
                    if ((n2 & DUMP_WEBSERVICES_MASK) > 0) {
                        cloneable = WebServicesProperties.getProperties();
                        log.debug("WebServicesProperties:\n" + cloneable);
                    }
                    if ((n2 & DUMP_SYSTEM_MASK) > 0) {
                        cloneable = System.getProperties();
                        log.debug("System Properties:\n" + cloneable);
                    }
                    return null;
                }
            });
        }
    }
}

