/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.Version;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class tcpmon
extends JFrame {
    private static String binaryCopyright = Version.getBinaryCopyright();
    private JTabbedPane notebook = new JTabbedPane();
    private static int STATE_COLUMN = 0;
    private static int TIME_COLUMN = 1;
    private static int INHOST_COLUMN = 2;
    private static int OUTHOST_COLUMN = 3;
    private static int REQ_COLUMN = 4;
    private static ResourceBundle messages = null;

    public tcpmon(int n, String string, int n2) {
        super(tcpmon.getMessage("tcpmon00", "TCPMonitor"));
        this.getContentPane().add(this.notebook);
        new AdminPage(this.notebook, tcpmon.getMessage("admin00", "Admin"));
        if (n != 0) {
            Listener listener = null;
            listener = string == null ? new Listener(this.notebook, null, n, string, n2, true) : new Listener(this.notebook, null, n, string, n2, false);
            this.notebook.setSelectedIndex(1);
            listener.HTTPProxyHost = System.getProperty("http.proxyHost");
            if (listener.HTTPProxyHost != null && listener.HTTPProxyHost.equals("")) {
                listener.HTTPProxyHost = null;
            }
            if (listener.HTTPProxyHost != null) {
                String string2 = System.getProperty("http.proxyPort");
                if (string2 != null && string2.equals("")) {
                    string2 = null;
                }
                listener.HTTPProxyPort = string2 == null ? 80 : Integer.parseInt(string2);
            }
        }
        this.pack();
        this.setSize(600, 600);
        this.setVisible(true);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        switch (windowEvent.getID()) {
            case 201: {
                this.exit();
                break;
            }
            default: {
                super.processWindowEvent(windowEvent);
            }
        }
    }

    private void exit() {
        System.exit(0);
    }

    public void setInputPort(int n) {
    }

    public void setOutputHostPort(char c, int n) {
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 3) {
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[2]);
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                new tcpmon(n, stringArray[1], n2);
            } else if (stringArray.length == 1) {
                int n = Integer.parseInt(stringArray[0]);
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                new tcpmon(n, null, 0);
            } else if (stringArray.length != 0) {
                System.err.println(tcpmon.getMessage("usage00", "Usage:") + " tcpmon <listenPort> <targetHost> <targetPort>\n");
            } else {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                new tcpmon(0, null, 0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println(tcpmon.getMessage("usage00", "Usage:") + " tcpmon <listenPort> <targetHost> <targetPort>\n");
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.webservices.engine.utils.tcpmon.main", "1578");
            throwable.printStackTrace();
        }
    }

    public static String getMessage(String string, String string2) {
        try {
            if (messages == null) {
                tcpmon.initializeMessages();
            }
            return messages.getString(string);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.webservices.engine.utils.tcpmon.getMessage", "1599");
            return string2;
        }
    }

    private static void initializeMessages() {
        messages = ResourceBundle.getBundle("com.ibm.ws.webservices.engine.utils.tcpmon");
    }

    class Listener
    extends JPanel {
        public Socket inputSocket = null;
        public Socket outputSocket = null;
        public JTextField portField = null;
        public JTextField hostField = null;
        public JTextField tPortField = null;
        public JCheckBox isProxyBox = null;
        public JButton stopButton = null;
        public JButton removeButton = null;
        public JButton removeAllButton = null;
        public JCheckBox xmlFormatBox = null;
        public JButton saveButton = null;
        public JButton loadButton = null;
        public JButton resendButton = null;
        public JButton findButton = null;
        public JButton switchButton = null;
        public JButton closeButton = null;
        public JTable connectionTable = null;
        public DefaultTableModel tableModel = null;
        public JSplitPane outPane = null;
        public ServerSocket sSocket = null;
        public SocketWaiter sw = null;
        public JPanel leftPanel = null;
        public JPanel rightPanel = null;
        public JTabbedPane notebook = null;
        public String HTTPProxyHost = null;
        public int HTTPProxyPort = 80;
        public final Vector connections = new Vector();
        private final String POST_START = "POST http://";
        private final String POST_START_NPM = "POST /";
        private final String GET_START = "GET http://";
        private final String GET_START_NPM = "GET /";
        private final String HEADER_END1 = "\n\n";
        private final String HEADER_END2 = "\r\n\r\n";
        private final String CONTENT_LENGTH = "Content-Length:";
        private final String CL_END = "\n";

        public Listener(JTabbedPane jTabbedPane, String string, int n, String string2, int n2, boolean bl) {
            this.notebook = jTabbedPane;
            if (string == null) {
                string = tcpmon.getMessage("port01", "Port") + " " + n;
            }
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            final String string3 = tcpmon.getMessage("start00", "Start");
            this.stopButton = new JButton(string3);
            jPanel.add(this.stopButton);
            jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            jPanel.add(new JLabel("  " + tcpmon.getMessage("listenPort01", "Listen Port:") + " ", 4));
            this.portField = new JTextField("" + n, 4);
            jPanel.add(this.portField);
            jPanel.add(new JLabel("  " + tcpmon.getMessage("host00", "Host:"), 4));
            this.hostField = new JTextField(string2, 30);
            jPanel.add(this.hostField);
            jPanel.add(new JLabel("  " + tcpmon.getMessage("port02", "Port:") + " ", 4));
            this.tPortField = new JTextField("" + n2, 4);
            jPanel.add(this.tPortField);
            jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            this.isProxyBox = new JCheckBox(tcpmon.getMessage("proxy00", "Proxy"));
            jPanel.add(this.isProxyBox);
            this.isProxyBox.addChangeListener(new BasicButtonListener(this.isProxyBox){

                public void stateChanged(ChangeEvent changeEvent) {
                    JCheckBox jCheckBox = (JCheckBox)changeEvent.getSource();
                    boolean bl = jCheckBox.isSelected();
                    Listener.this.tPortField.setEnabled(!bl);
                    Listener.this.hostField.setEnabled(!bl);
                }
            });
            this.isProxyBox.setSelected(bl);
            this.portField.setEditable(false);
            this.portField.setMaximumSize(new Dimension(50, Short.MAX_VALUE));
            this.hostField.setEditable(false);
            this.hostField.setMaximumSize(new Dimension(85, Short.MAX_VALUE));
            this.tPortField.setEditable(false);
            this.tPortField.setMaximumSize(new Dimension(50, Short.MAX_VALUE));
            this.stopButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (tcpmon.getMessage("stop00", "Stop").equals(actionEvent.getActionCommand())) {
                        Listener.this.stop();
                    }
                    if (string3.equals(actionEvent.getActionCommand())) {
                        Listener.this.start();
                    }
                }
            });
            this.add((Component)jPanel, "North");
            this.tableModel = new DefaultTableModel(new String[]{tcpmon.getMessage("state00", "State"), tcpmon.getMessage("time00", "Time"), tcpmon.getMessage("requestHost00", "Request Host"), tcpmon.getMessage("targetHost", "Target Host"), tcpmon.getMessage("request00", "Request...")}, 0);
            this.connectionTable = new JTable(1, 2);
            this.connectionTable.setModel(this.tableModel);
            this.connectionTable.setSelectionMode(2);
            TableColumn tableColumn = this.connectionTable.getColumnModel().getColumn(STATE_COLUMN);
            tableColumn.setMaxWidth(tableColumn.getPreferredWidth() / 2);
            tableColumn = this.connectionTable.getColumnModel().getColumn(REQ_COLUMN);
            tableColumn.setPreferredWidth(tableColumn.getPreferredWidth() * 2);
            this.tableModel.addRow(new Object[]{"---", tcpmon.getMessage("mostRecent00", "Most Recent"), "---", "---", "---"});
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            JScrollPane jScrollPane = new JScrollPane(this.connectionTable);
            jPanel2.add((Component)jScrollPane, "Center");
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 0));
            jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            final String string4 = tcpmon.getMessage("removeSelected00", "Remove Selected");
            this.removeButton = new JButton(string4);
            jPanel3.add(this.removeButton);
            jPanel3.add(Box.createRigidArea(new Dimension(5, 0)));
            final String string5 = tcpmon.getMessage("removeAll00", "Remove All");
            this.removeAllButton = new JButton(string5);
            jPanel3.add(this.removeAllButton);
            jPanel2.add((Component)jPanel3, "South");
            this.removeButton.setEnabled(false);
            this.removeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (string4.equals(actionEvent.getActionCommand())) {
                        Listener.this.remove();
                    }
                }
            });
            this.removeAllButton.setEnabled(false);
            this.removeAllButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (string5.equals(actionEvent.getActionCommand())) {
                        Listener.this.removeAll();
                    }
                }
            });
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BorderLayout());
            this.leftPanel = new JPanel();
            this.leftPanel.setAlignmentX(0.0f);
            this.leftPanel.setLayout(new BoxLayout(this.leftPanel, 1));
            this.leftPanel.add(new JLabel("  " + tcpmon.getMessage("request01", "Request")));
            this.leftPanel.add(new JLabel(" " + tcpmon.getMessage("wait01", "Waiting for connection")));
            this.rightPanel = new JPanel();
            this.rightPanel.setLayout(new BoxLayout(this.rightPanel, 1));
            this.rightPanel.add(new JLabel("  " + tcpmon.getMessage("response00", "Response")));
            this.rightPanel.add(new JLabel(""));
            this.outPane = new JSplitPane(0, this.leftPanel, this.rightPanel);
            this.outPane.setDividerSize(4);
            jPanel4.add((Component)this.outPane, "Center");
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout(new BoxLayout(jPanel5, 0));
            jPanel5.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.xmlFormatBox = new JCheckBox(tcpmon.getMessage("xmlFormat00", "XML Format"), true);
            jPanel5.add(this.xmlFormatBox);
            jPanel5.add(Box.createRigidArea(new Dimension(5, 0)));
            final String string6 = tcpmon.getMessage("save00", "Save");
            this.saveButton = new JButton(string6);
            jPanel5.add(this.saveButton);
            jPanel5.add(Box.createRigidArea(new Dimension(5, 0)));
            final String string7 = tcpmon.getMessage("resend00", "Resend");
            this.resendButton = new JButton(string7);
            jPanel5.add(this.resendButton);
            jPanel5.add(Box.createRigidArea(new Dimension(5, 0)));
            final String string8 = tcpmon.getMessage("load00", "Load / Resend");
            this.loadButton = new JButton(string8);
            jPanel5.add(this.loadButton);
            jPanel5.add(Box.createRigidArea(new Dimension(5, 0)));
            final String string9 = tcpmon.getMessage("find00", "Find");
            this.findButton = new JButton(string9);
            jPanel5.add(this.findButton);
            jPanel5.add(Box.createRigidArea(new Dimension(5, 0)));
            final String string10 = tcpmon.getMessage("switch00", "Switch Layout");
            this.switchButton = new JButton(string10);
            jPanel5.add(this.switchButton);
            jPanel5.add(Box.createHorizontalGlue());
            final String string11 = tcpmon.getMessage("close00", "Close");
            this.closeButton = new JButton(string11);
            jPanel5.add(this.closeButton);
            jPanel4.add((Component)jPanel5, "South");
            this.saveButton.setEnabled(false);
            this.saveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (string6.equals(actionEvent.getActionCommand())) {
                        Listener.this.save();
                    }
                }
            });
            this.loadButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (string8.equals(actionEvent.getActionCommand())) {
                        Listener.this.load();
                    }
                }
            });
            this.resendButton.setEnabled(false);
            this.resendButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (string7.equals(actionEvent.getActionCommand())) {
                        Listener.this.resend();
                    }
                }
            });
            this.findButton.setEnabled(false);
            this.findButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (string9.equals(actionEvent.getActionCommand())) {
                        Listener.this.find();
                    }
                }
            });
            this.switchButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (string10.equals(actionEvent.getActionCommand())) {
                        int n = Listener.this.outPane.getOrientation();
                        if (n == 0) {
                            Listener.this.outPane.setOrientation(1);
                        } else {
                            Listener.this.outPane.setOrientation(0);
                        }
                        Listener.this.outPane.setDividerLocation(0.5);
                    }
                }
            });
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (string11.equals(actionEvent.getActionCommand())) {
                        Listener.this.close();
                    }
                }
            });
            JSplitPane jSplitPane = new JSplitPane(0);
            jSplitPane.setDividerSize(4);
            jSplitPane.setTopComponent(jPanel2);
            jSplitPane.setBottomComponent(jPanel4);
            jSplitPane.setDividerLocation(150);
            this.add((Component)jSplitPane, "Center");
            ListSelectionModel listSelectionModel = this.connectionTable.getSelectionModel();
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    int n = Listener.this.outPane.getDividerLocation();
                    if (listSelectionModel.isSelectionEmpty()) {
                        Listener.this.setLeft(new JLabel(" " + tcpmon.getMessage("wait00", "Waiting for Connection...")));
                        Listener.this.setRight(new JLabel(""));
                        Listener.this.removeButton.setEnabled(false);
                        Listener.this.removeAllButton.setEnabled(false);
                        Listener.this.saveButton.setEnabled(false);
                        Listener.this.findButton.setEnabled(false);
                        Listener.this.resendButton.setEnabled(false);
                    } else {
                        int n2 = listSelectionModel.getLeadSelectionIndex();
                        if (n2 == 0) {
                            if (Listener.this.connections.size() == 0) {
                                Listener.this.setLeft(new JLabel(" " + tcpmon.getMessage("wait00", "Waiting for connection...")));
                                Listener.this.setRight(new JLabel(""));
                                Listener.this.removeButton.setEnabled(false);
                                Listener.this.removeAllButton.setEnabled(false);
                                Listener.this.saveButton.setEnabled(false);
                                Listener.this.findButton.setEnabled(false);
                                Listener.this.resendButton.setEnabled(false);
                            } else {
                                Connection connection = (Connection)Listener.this.connections.lastElement();
                                Listener.this.setLeft(connection.inputScroll);
                                Listener.this.setRight(connection.outputScroll);
                                Listener.this.removeButton.setEnabled(false);
                                Listener.this.removeAllButton.setEnabled(true);
                                Listener.this.saveButton.setEnabled(true);
                                Listener.this.findButton.setEnabled(true);
                                Listener.this.loadButton.setEnabled(true);
                                Listener.this.resendButton.setEnabled(true);
                            }
                        } else {
                            Connection connection = (Connection)Listener.this.connections.get(n2 - 1);
                            Listener.this.setLeft(connection.inputScroll);
                            Listener.this.setRight(connection.outputScroll);
                            Listener.this.removeButton.setEnabled(true);
                            Listener.this.removeAllButton.setEnabled(true);
                            Listener.this.saveButton.setEnabled(true);
                            Listener.this.findButton.setEnabled(true);
                            Listener.this.loadButton.setEnabled(true);
                            Listener.this.resendButton.setEnabled(true);
                        }
                    }
                    Listener.this.outPane.setDividerLocation(n);
                }
            });
            listSelectionModel.setSelectionInterval(0, 0);
            this.outPane.setDividerLocation(150);
            this.notebook.addTab(string, this);
            this.start();
        }

        public void setLeft(Component component2) {
            this.leftPanel.removeAll();
            this.leftPanel.add(component2);
        }

        public void setRight(Component component2) {
            this.rightPanel.removeAll();
            this.rightPanel.add(component2);
        }

        public void start() {
            int n = Integer.parseInt(this.portField.getText());
            this.portField.setText("" + n);
            int n2 = this.notebook.indexOfComponent(this);
            this.notebook.setTitleAt(n2, tcpmon.getMessage("port01", "Port") + " " + n);
            int n3 = Integer.parseInt(this.tPortField.getText());
            this.tPortField.setText("" + n3);
            this.sw = new SocketWaiter(this, n);
            this.stopButton.setText(tcpmon.getMessage("stop00", "Stop"));
            this.portField.setEditable(false);
            this.hostField.setEditable(false);
            this.tPortField.setEditable(false);
            this.isProxyBox.setEnabled(false);
        }

        public void close() {
            this.stop();
            this.notebook.remove(this);
        }

        public void stop() {
            try {
                for (int i = 0; i < this.connections.size(); ++i) {
                    Connection connection = (Connection)this.connections.get(i);
                    connection.halt();
                }
                this.sw.halt();
                this.stopButton.setText(tcpmon.getMessage("start00", "Start"));
                this.portField.setEditable(true);
                this.hostField.setEditable(true);
                this.tPortField.setEditable(true);
                this.isProxyBox.setEnabled(true);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.utils.tcpmon.stop", "1367", this);
                exception.printStackTrace();
            }
        }

        public void remove() {
            int n;
            ListSelectionModel listSelectionModel = this.connectionTable.getSelectionModel();
            int n2 = listSelectionModel.getMinSelectionIndex();
            for (int i = n = listSelectionModel.getMaxSelectionIndex(); i >= n2; --i) {
                ((Connection)this.connections.get(i - 1)).remove();
            }
            if (n2 > this.connections.size()) {
                n2 = this.connections.size();
            }
            listSelectionModel.setSelectionInterval(n2, n2);
        }

        public void removeAll() {
            ListSelectionModel listSelectionModel = this.connectionTable.getSelectionModel();
            listSelectionModel.clearSelection();
            while (this.connections.size() > 0) {
                ((Connection)this.connections.get(0)).remove();
            }
            listSelectionModel.setSelectionInterval(0, 0);
        }

        public void save() {
            JFileChooser jFileChooser = new JFileChooser(".");
            int n = jFileChooser.showSaveDialog(this);
            if (n == 0) {
                try {
                    File file = jFileChooser.getSelectedFile();
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    ListSelectionModel listSelectionModel = this.connectionTable.getSelectionModel();
                    n = listSelectionModel.getLeadSelectionIndex();
                    if (n == 0) {
                        n = this.connections.size();
                    }
                    Connection connection = (Connection)this.connections.get(n - 1);
                    n = Integer.parseInt(this.portField.getText());
                    fileOutputStream.write(new String(tcpmon.getMessage("listenPort01", "Listen Port:") + " " + n + "\r").getBytes());
                    fileOutputStream.write(new String(tcpmon.getMessage("targetHost01", "Target Host:") + " " + this.hostField.getText() + "\r").getBytes());
                    n = Integer.parseInt(this.tPortField.getText());
                    fileOutputStream.write(new String(tcpmon.getMessage("targetPort01", "Target Port:") + " " + n + "\r").getBytes());
                    fileOutputStream.write(new String("==== " + tcpmon.getMessage("request01", "Request") + " ====\r").getBytes());
                    fileOutputStream.write(connection.inputText.getText().getBytes());
                    fileOutputStream.write(new String("\r==== " + tcpmon.getMessage("response00", "Response") + " ====\r").getBytes());
                    fileOutputStream.write(connection.outputText.getText().getBytes());
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.utils.tcpmon.save", "1424", this);
                    exception.printStackTrace();
                }
            }
        }

        public void load() {
            FileInputStream fileInputStream = null;
            BufferedReader bufferedReader = null;
            String string = "";
            int n = 0;
            JFileChooser jFileChooser = new JFileChooser(".");
            int n2 = jFileChooser.showOpenDialog(this);
            if (n2 == 0) {
                try {
                    Object object;
                    File file = jFileChooser.getSelectedFile();
                    ListSelectionModel listSelectionModel = this.connectionTable.getSelectionModel();
                    try {
                        object = "";
                        fileInputStream = new FileInputStream(file.getPath());
                        bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                        while ((object = bufferedReader.readLine()) != null && ((String)object).indexOf("==== Response ====") == -1) {
                            if (n > 1) {
                                string = string + "\r\n";
                            }
                            if (n > 0) {
                                string = string + (String)object;
                            }
                            if (((String)object).indexOf("==== Request ====") != -1) {
                                ++n;
                                continue;
                            }
                            if (n <= 0) continue;
                            ++n;
                        }
                        bufferedReader.close();
                    }
                    catch (EOFException eOFException) {
                        // empty catch block
                    }
                    object = this.fixMessagesForResend(string);
                    for (int i = 0; i < object.size(); ++i) {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((String)object.get(i)).getBytes());
                        new Connection(this, byteArrayInputStream);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.utils.tcpmon.load_resend", "1488", this);
                    exception.printStackTrace();
                }
            }
        }

        public void resend() {
            try {
                ListSelectionModel listSelectionModel = this.connectionTable.getSelectionModel();
                int n = listSelectionModel.getLeadSelectionIndex();
                if (n == 0) {
                    n = this.connections.size();
                }
                Connection connection = (Connection)this.connections.get(n - 1);
                if (n > 0) {
                    listSelectionModel.clearSelection();
                    listSelectionModel.setSelectionInterval(0, 0);
                }
                String string = connection.inputText.getText();
                List list = this.fixMessagesForResend(string);
                for (int i = 0; i < list.size(); ++i) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((String)list.get(i)).getBytes());
                    new Connection(this, byteArrayInputStream);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.utils.tcpmon.resend", "1488", this);
                exception.printStackTrace();
            }
        }

        public void find() {
            String string = "Find";
            JTextField jTextField = new JTextField("");
            JCheckBox jCheckBox = new JCheckBox("Case sensitive", true);
            JComboBox<String> jComboBox = new JComboBox<String>(new String[]{"Incoming SOAP Message", "Outgoing SOAP Message"});
            try {
                ListSelectionModel listSelectionModel = this.connectionTable.getSelectionModel();
                int n = listSelectionModel.getLeadSelectionIndex();
                if (n == 0) {
                    n = this.connections.size();
                }
                Connection connection = (Connection)this.connections.get(n - 1);
                if (n > 0) {
                    listSelectionModel.clearSelection();
                    listSelectionModel.setSelectionInterval(0, 0);
                }
                Object[] objectArray = new Object[]{"Text Field:", jComboBox, Box.createVerticalStrut(10), "Search:", jTextField, Box.createVerticalStrut(10), jCheckBox, Box.createVerticalStrut(5)};
                int n2 = JOptionPane.showConfirmDialog(null, objectArray, string, 2, 3);
                if (0 == n2) {
                    if (jTextField.getText().equals("")) {
                        if (jComboBox.getSelectedIndex() == 0) {
                            connection.removeHighlights(connection.getInput());
                        } else {
                            connection.removeHighlights(connection.getOutput());
                        }
                    } else if (jComboBox.getSelectedIndex() == 0) {
                        connection.highlight(true, jTextField.getText(), jCheckBox.isSelected());
                    } else {
                        connection.highlight(false, jTextField.getText(), jCheckBox.isSelected());
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.utils.tcpmon.find", "1488", this);
                exception.printStackTrace();
            }
        }

        private List fixMessagesForResend(String string) throws IOException {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (string.startsWith("POST http://") || string.startsWith("GET http://") || string.startsWith("POST /") || string.startsWith("GET /")) {
                List list = null;
                list = string.startsWith("POST http://") || string.startsWith("GET http://") ? this.splitMessages(string, true) : this.splitMessages(string, false);
                for (int i = 0; i < list.size(); ++i) {
                    String string2 = this.fixMessage((String)list.get(i));
                    arrayList.add(string2);
                }
            } else {
                arrayList.add(string);
            }
            return arrayList;
        }

        private List splitMessages(String string, boolean bl) {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string2 = null;
            String string3 = null;
            if (bl) {
                string2 = "POST http://";
                string3 = "GET http://";
            } else {
                string2 = "POST /";
                string3 = "GET /";
            }
            int n = string.indexOf(string2);
            int n2 = n = n == -1 ? string.indexOf(string3) : n;
            while (n >= 0 && n < string.length()) {
                int n3 = string.indexOf(string2, n + 1);
                n3 = n3 == -1 ? string.indexOf(string3, n + 1) : n3;
                n3 = n3 == -1 ? string.length() : n3;
                String string4 = string.substring(n, n3);
                System.err.println("msg:{" + string4 + "}");
                arrayList.add(string4);
                n = n3;
            }
            return arrayList;
        }

        private String fixMessage(String string) throws IOException {
            String string2;
            String string3 = string;
            int n = string.indexOf("\n\n");
            if (n != -1) {
                n += "\n\n".length();
            } else {
                n = string.indexOf("\r\n\r\n");
                if (n != -1) {
                    n += "\r\n\r\n".length();
                }
            }
            String string4 = string.substring(0, n);
            String string5 = string.substring(n);
            String string6 = "";
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string5));
            while ((string2 = bufferedReader.readLine()) != null) {
                string6 = string6 + string2.trim();
            }
            string5 = string6;
            int n2 = string4.indexOf("Content-Length:");
            if (n2 != -1) {
                int n3 = string4.indexOf("\n", n2);
                string3 = string4.substring(0, n2) + "Content-Length:" + string5.length() + string4.substring(n3) + string5;
            }
            return string3;
        }
    }

    class Connection
    extends Thread {
        Listener listener;
        boolean active;
        String fromHost;
        String time;
        JTextArea inputText = null;
        JScrollPane inputScroll = null;
        JTextArea outputText = null;
        JScrollPane outputScroll = null;
        Socket inSocket = null;
        Socket outSocket = null;
        Thread clientThread = null;
        Thread serverThread = null;
        SocketRR rr1 = null;
        SocketRR rr2 = null;
        InputStream inputStream = null;
        String HTTPProxyHost = null;
        int HTTPProxyPort = 80;

        public Connection(Listener listener) {
            this.listener = listener;
            this.HTTPProxyHost = listener.HTTPProxyHost;
            this.HTTPProxyPort = listener.HTTPProxyPort;
        }

        public Connection(Listener listener, Socket socket) {
            this(listener);
            this.inSocket = socket;
            this.start();
        }

        public Connection(Listener listener, InputStream inputStream) {
            this(listener);
            this.inputStream = inputStream;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String string;
                int n;
                Object object;
                byte[] byArray;
                Object object2;
                this.active = true;
                this.HTTPProxyHost = System.getProperty("http.proxyHost");
                if (this.HTTPProxyHost != null && this.HTTPProxyHost.equals("")) {
                    this.HTTPProxyHost = null;
                }
                if (this.HTTPProxyHost != null) {
                    object2 = System.getProperty("http.proxyPort");
                    if (object2 != null && ((String)object2).equals("")) {
                        object2 = null;
                    }
                    this.HTTPProxyPort = object2 == null ? 80 : Integer.parseInt((String)object2);
                }
                this.fromHost = this.inSocket != null ? this.inSocket.getInetAddress().getHostName() : "resend";
                object2 = new SimpleDateFormat("MM/dd/yy hh:mm:ss aa");
                this.time = ((DateFormat)object2).format(new Date());
                int n2 = this.listener.connections.size();
                this.listener.tableModel.insertRow(n2 + 1, new Object[]{tcpmon.getMessage("active00", "Active"), this.time, this.fromHost, this.listener.hostField.getText(), ""});
                this.listener.connections.add(this);
                this.inputText = new JTextArea(null, null, 20, 80);
                this.inputScroll = new JScrollPane(this.inputText);
                this.outputText = new JTextArea(null, null, 20, 80);
                this.outputScroll = new JScrollPane(this.outputText);
                ListSelectionModel listSelectionModel = this.listener.connectionTable.getSelectionModel();
                if (n2 == 0 || listSelectionModel.getLeadSelectionIndex() == 0) {
                    this.listener.outPane.setVisible(false);
                    int n3 = this.listener.outPane.getDividerLocation();
                    this.listener.setLeft(this.inputScroll);
                    this.listener.setRight(this.outputScroll);
                    this.listener.removeButton.setEnabled(false);
                    this.listener.removeAllButton.setEnabled(true);
                    this.listener.saveButton.setEnabled(true);
                    this.listener.findButton.setEnabled(true);
                    this.listener.resendButton.setEnabled(true);
                    this.listener.outPane.setDividerLocation(n3);
                    this.listener.outPane.setVisible(true);
                }
                String string2 = this.listener.hostField.getText();
                int n4 = Integer.parseInt(this.listener.tPortField.getText());
                InputStream inputStream = this.inputStream;
                OutputStream outputStream = null;
                InputStream inputStream2 = null;
                OutputStream outputStream2 = null;
                if (inputStream == null) {
                    inputStream = this.inSocket.getInputStream();
                }
                if (this.inSocket != null) {
                    outputStream = this.inSocket.getOutputStream();
                }
                String string3 = null;
                StringBuffer stringBuffer = null;
                int n5 = this.listener.connections.indexOf(this);
                if (this.listener.isProxyBox.isSelected() || this.HTTPProxyHost != null) {
                    int n6;
                    byArray = new byte[1];
                    stringBuffer = new StringBuffer();
                    while ((n6 = inputStream.read(byArray, 0, 1)) != -1) {
                        object = new String(byArray);
                        stringBuffer.append((String)object);
                        if (byArray[0] != 10) continue;
                    }
                    string3 = stringBuffer.toString();
                    this.inputText.append(string3);
                    if (string3.startsWith("GET ") || string3.startsWith("POST ")) {
                        URL uRL;
                        n6 = string3.indexOf(32) + 1;
                        while (string3.charAt(n6) == ' ') {
                            ++n6;
                        }
                        n = string3.indexOf(32, n6);
                        string = string3.substring(n6, n);
                        if (string.charAt(0) == '/') {
                            string = string.substring(1);
                        }
                        if (this.listener.isProxyBox.isSelected()) {
                            uRL = new URL(string);
                            string2 = uRL.getHost();
                            n4 = uRL.getPort();
                            if (n4 == -1) {
                                n4 = 80;
                            }
                            this.listener.tableModel.setValueAt(string2, n5 + 1, OUTHOST_COLUMN);
                            string3 = string3.substring(0, n6) + uRL.getFile() + string3.substring(n);
                        } else {
                            uRL = new URL("http://" + string2 + ":" + n4 + "/" + string);
                            this.listener.tableModel.setValueAt(string2, n5 + 1, OUTHOST_COLUMN);
                            string3 = string3.substring(0, n6) + uRL.toExternalForm() + string3.substring(n);
                            string2 = this.HTTPProxyHost;
                            n4 = this.HTTPProxyPort;
                        }
                    }
                } else {
                    byArray = new byte[1];
                    stringBuffer = new StringBuffer();
                    String string4 = null;
                    while ((n = inputStream.read(byArray, 0, 1)) != -1) {
                        object = new String(byArray);
                        stringBuffer.append((String)object);
                        if (byArray[0] != 10) continue;
                        String string5 = stringBuffer.toString();
                        stringBuffer.setLength(0);
                        if (string5.startsWith("Host: ")) {
                            string = "Host: " + string2 + "\r\n";
                            string3 = string3.concat(string);
                            break;
                        }
                        string3 = string3 == null ? string5 : string3.concat(string5);
                        if (string5.equals("\r\n") || "\n".equals(string4) && string5.equals("\n")) break;
                        string4 = string5;
                    }
                    if (string3 != null) {
                        this.inputText.append(string3);
                        n = string3.length() < 50 ? string3.length() : 50;
                        object = string3.substring(0, n);
                        int n7 = ((String)object).indexOf(10);
                        if (n7 > 0) {
                            object = ((String)object).substring(0, n7 - 1);
                        }
                        object = (String)object + "                           " + "                       ";
                        object = ((String)object).substring(0, 51);
                        this.listener.tableModel.setValueAt(object, n5 + 1, REQ_COLUMN);
                    }
                }
                if (n4 == -1) {
                    n4 = 80;
                }
                this.outSocket = new Socket(string2, n4);
                inputStream2 = this.outSocket.getInputStream();
                outputStream2 = this.outSocket.getOutputStream();
                if (string3 != null) {
                    byArray = string3.getBytes();
                    outputStream2.write(byArray);
                }
                boolean bl = this.listener.xmlFormatBox.isSelected();
                this.rr1 = new SocketRR(this, this.inSocket, inputStream, this.outSocket, outputStream2, this.inputText, bl, this.listener.tableModel, n5 + 1, "request:");
                this.rr2 = new SocketRR(this, this.outSocket, inputStream2, this.inSocket, outputStream, this.outputText, bl, null, 0, "response:");
                while (this.rr1 != null || this.rr2 != null) {
                    if (null != this.rr1 && this.rr1.isDone()) {
                        if (n5 >= 0 && this.rr2 != null) {
                            this.listener.tableModel.setValueAt(tcpmon.getMessage("resp00", "Resp"), 1 + n5, STATE_COLUMN);
                        }
                        this.rr1 = null;
                    }
                    if (null != this.rr2 && this.rr2.isDone()) {
                        if (n5 >= 0 && this.rr1 != null) {
                            this.listener.tableModel.setValueAt(tcpmon.getMessage("req00", "Req"), 1 + n5, STATE_COLUMN);
                        }
                        this.rr2 = null;
                    }
                    object = this;
                    synchronized (object) {
                        this.wait(1000L);
                    }
                }
                this.active = false;
                if (n5 >= 0) {
                    this.listener.tableModel.setValueAt(tcpmon.getMessage("done00", "Done"), 1 + n5, STATE_COLUMN);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.utils.tcpmon.run", "962", this);
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                int n = this.listener.connections.indexOf(this);
                if (n >= 0) {
                    this.listener.tableModel.setValueAt(tcpmon.getMessage("error00", "Error"), 1 + n, STATE_COLUMN);
                }
                exception.printStackTrace(printWriter);
                printWriter.close();
                this.outputText.append(stringWriter.toString());
                this.halt();
            }
        }

        synchronized void wakeUp() {
            this.notifyAll();
        }

        public void halt() {
            try {
                if (this.rr1 != null) {
                    this.rr1.halt();
                }
                if (this.rr2 != null) {
                    this.rr2.halt();
                }
                if (this.inSocket != null) {
                    this.inSocket.close();
                }
                this.inSocket = null;
                if (this.outSocket != null) {
                    this.outSocket.close();
                }
                this.outSocket = null;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.utils.tcpmon.halt", "990", this);
                exception.printStackTrace();
            }
        }

        public void remove() {
            int n = -1;
            try {
                this.halt();
                n = this.listener.connections.indexOf(this);
                this.listener.tableModel.removeRow(n + 1);
                this.listener.connections.remove(n);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.utils.tcpmon.remove", "1005", this);
                System.err.println("index:=" + n + this);
                exception.printStackTrace();
            }
        }

        public void highlight(boolean bl, String string, boolean bl2) {
            JTextArea jTextArea = bl ? this.inputText : this.outputText;
            MyHighlightPainter myHighlightPainter = new MyHighlightPainter(Color.yellow);
            try {
                this.removeHighlights(jTextArea);
                Highlighter highlighter = jTextArea.getHighlighter();
                Document document = jTextArea.getDocument();
                String string2 = bl2 ? document.getText(0, document.getLength()) : document.getText(0, document.getLength()).toLowerCase();
                int n = 0;
                if (!bl2) {
                    string = string.toLowerCase();
                }
                while ((n = string2.indexOf(string, n)) >= 0) {
                    highlighter.addHighlight(n, n + string.length(), myHighlightPainter);
                    n += string.length();
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public void removeHighlights(JTextComponent jTextComponent) {
            Highlighter highlighter = jTextComponent.getHighlighter();
            Highlighter.Highlight[] highlightArray = highlighter.getHighlights();
            for (int i = 0; i < highlightArray.length; ++i) {
                if (!(highlightArray[i].getPainter() instanceof MyHighlightPainter)) continue;
                highlighter.removeHighlight(highlightArray[i]);
            }
        }

        public JTextArea getInput() {
            return this.inputText;
        }

        public JTextArea getOutput() {
            return this.outputText;
        }

        class MyHighlightPainter
        extends DefaultHighlighter.DefaultHighlightPainter {
            public MyHighlightPainter(Color color) {
                super(color);
            }
        }
    }

    class SocketRR
    extends Thread {
        Socket inSocket = null;
        Socket outSocket = null;
        JTextArea textArea;
        InputStream in = null;
        OutputStream out = null;
        boolean xmlFormat;
        volatile boolean done = false;
        TableModel tmodel = null;
        int tableIndex = 0;
        String type = null;
        Connection myConnection = null;
        byte[] prettyBuffer = null;

        public SocketRR(Connection connection, Socket socket, InputStream inputStream, Socket socket2, OutputStream outputStream, JTextArea jTextArea, boolean bl, TableModel tableModel, int n, String string) {
            this.inSocket = socket;
            this.in = inputStream;
            this.outSocket = socket2;
            this.out = outputStream;
            this.textArea = jTextArea;
            this.xmlFormat = bl;
            this.tmodel = tableModel;
            this.tableIndex = n;
            this.type = string;
            this.myConnection = connection;
            this.start();
        }

        public boolean isDone() {
            return this.done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block62: {
                String string;
                byte[] byArray = new byte[4096];
                int n = 0;
                int n2 = 0;
                int n3 = 3;
                int n4 = 0;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                this.prettyBuffer = new byte[8192];
                if (this.tmodel != null && !"".equals(string = (String)this.tmodel.getValueAt(this.tableIndex, REQ_COLUMN))) {
                    n2 = string.length();
                }
                block14: while (!this.done) {
                    int n5;
                    int n6 = byArray.length;
                    if (n6 == 0) {
                        n6 = byArray.length;
                    }
                    if (n + n6 > byArray.length) {
                        n6 = byArray.length - n;
                    }
                    int n7 = 0;
                    while (n7 == 0) {
                        try {
                            n7 = this.in.read(byArray, n, n6);
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.utils.tcpmon.run", "508", this);
                            if (this.done && n == 0) break block14;
                            n7 = -1;
                            break;
                        }
                    }
                    if ((n6 = n7) == -1 && n == 0) break;
                    if (n6 == -1) {
                        this.done = true;
                    }
                    if (this.out != null && n6 > 0) {
                        this.out.write(byArray, n, n6);
                    }
                    if (this.tmodel != null && n2 < 50) {
                        String string2 = (String)this.tmodel.getValueAt(this.tableIndex, REQ_COLUMN);
                        if ((string2 = string2 + new String(byArray, n, n6)).length() > 50) {
                            string2 = string2.substring(0, 50);
                        }
                        n2 = string2.length();
                        n5 = string2.indexOf(10);
                        if (n5 > 0) {
                            string2 = string2.substring(0, n5 - 1);
                            n2 = 50;
                        }
                        this.tmodel.setValueAt(string2, this.tableIndex, REQ_COLUMN);
                    }
                    if (this.xmlFormat) {
                        int n8;
                        int n9 = n;
                        n5 = 0;
                        if (n6 != -1) {
                            n9 += n6;
                        }
                        n = 0;
                        for (n8 = 0; n8 < n9; ++n8) {
                            if (n6 != -1 && n8 + 1 == n9) {
                                n = 1;
                                break;
                            }
                            byte by = byArray[n8];
                            int n10 = 32;
                            if (n8 + 1 < n9) {
                                n10 = byArray[n8 + 1];
                            }
                            if (!(bl || by != 60 && by != 62 && by != 10 && by != 13)) {
                                bl = true;
                            }
                            if (!bl) {
                                this.prettyBufferAdd(n5++, by);
                            } else {
                                if (!bl3 && (by == 60 && n10 != 47 && n10 != 33 || by == 60 && n10 == 47 && !bl2)) {
                                    this.prettyBufferAdd(n5++, (byte)10);
                                    int n11 = n3 * n4;
                                    if (by == 60 && n10 == 47) {
                                        n11 -= n3;
                                    }
                                    if (n11 < 0) {
                                        n11 = 0;
                                    }
                                    for (int i = n11; i > 0; --i) {
                                        this.prettyBufferAdd(n5++, (byte)32);
                                    }
                                }
                                this.prettyBufferAdd(n5++, by);
                            }
                            if (by == 60 && n10 != 47 && n10 != 33) {
                                bl2 = true;
                                ++n4;
                            } else if (by == 60 && n10 == 47) {
                                bl2 = false;
                                --n4;
                            } else if (by == 47 && n10 == 62) {
                                bl2 = false;
                                --n4;
                            }
                            bl3 = by == 10 || by == 13 || bl3 && (by == 32 || by == 9);
                        }
                        this.textArea.append(new String(this.prettyBuffer, 0, n5));
                        for (n8 = 0; n8 < n; ++n8) {
                            byArray[n8] = byArray[n9 - n + n8];
                        }
                        if (!bl || n != 1 || byArray[0] != 62) continue;
                        n = 2;
                        byArray[1] = 10;
                        continue;
                    }
                    this.textArea.append(new String(byArray, 0, n6));
                }
                Object var19_22 = null;
                this.done = true;
                try {
                    if (this.out != null) {
                        this.out.flush();
                        if (null != this.outSocket) {
                            this.outSocket.shutdownOutput();
                        } else {
                            this.out.close();
                        }
                        this.out = null;
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.utils.tcpmon.run", "620", this);
                }
                try {
                    if (this.in != null) {
                        if (this.inSocket != null) {
                            this.inSocket.shutdownInput();
                        } else {
                            this.in.close();
                        }
                        this.in = null;
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.utils.tcpmon.run", "631", this);
                }
                this.myConnection.wakeUp();
                {
                    break block62;
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.utils.tcpmon.run", "606", this);
                        exception.printStackTrace();
                        Object var19_23 = null;
                        this.done = true;
                        try {
                            if (this.out != null) {
                                this.out.flush();
                                if (null != this.outSocket) {
                                    this.outSocket.shutdownOutput();
                                } else {
                                    this.out.close();
                                }
                                this.out = null;
                            }
                        }
                        catch (Exception exception2) {
                            FFDCFilter.processException((Throwable)exception2, "com.ibm.ws.webservices.engine.utils.tcpmon.run", "620", this);
                        }
                        try {
                            if (this.in != null) {
                                if (this.inSocket != null) {
                                    this.inSocket.shutdownInput();
                                } else {
                                    this.in.close();
                                }
                                this.in = null;
                            }
                        }
                        catch (Exception exception2) {
                            FFDCFilter.processException((Throwable)exception2, "com.ibm.ws.webservices.engine.utils.tcpmon.run", "631", this);
                        }
                        this.myConnection.wakeUp();
                    }
                }
                catch (Throwable throwable) {
                    Object var19_24 = null;
                    this.done = true;
                    try {
                        if (this.out != null) {
                            this.out.flush();
                            if (null != this.outSocket) {
                                this.outSocket.shutdownOutput();
                            } else {
                                this.out.close();
                            }
                            this.out = null;
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.utils.tcpmon.run", "620", this);
                    }
                    try {
                        if (this.in != null) {
                            if (this.inSocket != null) {
                                this.inSocket.shutdownInput();
                            } else {
                                this.in.close();
                            }
                            this.in = null;
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.utils.tcpmon.run", "631", this);
                    }
                    this.myConnection.wakeUp();
                    throw throwable;
                }
            }
        }

        private void prettyBufferAdd(int n, byte by) {
            if (n >= this.prettyBuffer.length) {
                byte[] byArray = this.prettyBuffer;
                this.prettyBuffer = new byte[this.prettyBuffer.length * 2];
                for (int i = 0; i < byArray.length; ++i) {
                    this.prettyBuffer[i] = byArray[i];
                }
            }
            this.prettyBuffer[n] = by;
        }

        public void halt() {
            try {
                if (this.inSocket != null) {
                    this.inSocket.close();
                }
                if (this.outSocket != null) {
                    this.outSocket.close();
                }
                this.inSocket = null;
                this.outSocket = null;
                if (this.in != null) {
                    this.in.close();
                }
                if (this.out != null) {
                    this.out.close();
                }
                this.in = null;
                this.out = null;
                this.done = true;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.utils.tcpmon.halt", "651", this);
                exception.printStackTrace();
            }
        }
    }

    class SocketWaiter
    extends Thread {
        ServerSocket sSocket = null;
        Listener listener;
        int port;
        boolean pleaseStop = false;

        public SocketWaiter(Listener listener, int n) {
            this.listener = listener;
            this.port = n;
            this.start();
        }

        public void run() {
            block4: {
                try {
                    this.listener.setLeft(new JLabel(tcpmon.getMessage("wait00", " Waiting for Connection...")));
                    this.listener.repaint();
                    this.sSocket = new ServerSocket(this.port);
                    while (true) {
                        Socket socket = this.sSocket.accept();
                        if (!this.pleaseStop) {
                            new Connection(this.listener, socket);
                            socket = null;
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.utils.tcpmon.run", "404", this);
                    if ("socket closed".equals(exception.getMessage())) break block4;
                    JLabel jLabel = new JLabel(exception.toString());
                    jLabel.setForeground(Color.red);
                    this.listener.setLeft(jLabel);
                    this.listener.setRight(new JLabel(""));
                    this.listener.stop();
                }
            }
        }

        public void halt() {
            try {
                this.pleaseStop = true;
                new Socket("127.0.0.1", this.port);
                if (this.sSocket != null) {
                    this.sSocket.close();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.utils.tcpmon.halt", "423", this);
                exception.printStackTrace();
            }
        }
    }

    class AdminPage
    extends JPanel {
        public JRadioButton listenerButton;
        public JRadioButton proxyButton;
        public JLabel hostLabel;
        public JLabel tportLabel;
        public JTextField port;
        public JTextField host;
        public JTextField tport;
        public JTabbedPane noteb;
        public JCheckBox HTTPProxyBox;
        public JTextField HTTPProxyHost;
        public JTextField HTTPProxyPort;
        public JLabel HTTPProxyHostLabel;
        public JLabel HTTPProxyPortLabel;

        public AdminPage(JTabbedPane jTabbedPane, String string) {
            JPanel jPanel = null;
            JButton jButton = null;
            this.setLayout(new BorderLayout());
            this.noteb = jTabbedPane;
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel = new JPanel(gridBagLayout);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            jPanel.add((Component)new JLabel(tcpmon.getMessage("newTCP00", "Create a new TCP/IP Monitor...") + " "), gridBagConstraints);
            jPanel.add(Box.createRigidArea(new Dimension(1, 5)), gridBagConstraints);
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 1;
            jPanel2.add((Component)new JLabel(tcpmon.getMessage("listenPort00", "Listen Port #") + " "), gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            this.port = new JTextField(4);
            jPanel2.add((Component)this.port, gridBagConstraints);
            jPanel.add((Component)jPanel2, gridBagConstraints);
            jPanel.add(Box.createRigidArea(new Dimension(1, 5)), gridBagConstraints);
            ButtonGroup buttonGroup = new ButtonGroup();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            jPanel.add((Component)new JLabel(tcpmon.getMessage("actAs00", "Act as a...")), gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            final String string2 = tcpmon.getMessage("listener00", "Listener");
            this.listenerButton = new JRadioButton(string2);
            jPanel.add((Component)this.listenerButton, gridBagConstraints);
            buttonGroup.add(this.listenerButton);
            this.listenerButton.setSelected(true);
            this.listenerButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (string2.equals(actionEvent.getActionCommand())) {
                        boolean bl = AdminPage.this.listenerButton.isSelected();
                        AdminPage.this.tport.setEnabled(bl);
                        AdminPage.this.host.setEnabled(bl);
                        AdminPage.this.hostLabel.setForeground(bl ? Color.black : Color.gray);
                        AdminPage.this.tportLabel.setForeground(bl ? Color.black : Color.gray);
                    }
                }
            });
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 1;
            jPanel.add(Box.createRigidArea(new Dimension(25, 0)));
            this.hostLabel = new JLabel(tcpmon.getMessage("targetHostname00", "Target Hostname") + " ");
            jPanel.add((Component)this.hostLabel, gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            this.host = new JTextField(30);
            jPanel.add((Component)this.host, gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 1;
            jPanel.add(Box.createRigidArea(new Dimension(25, 0)));
            this.tportLabel = new JLabel(tcpmon.getMessage("targetPort00", "Target Port #") + " ");
            jPanel.add((Component)this.tportLabel, gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            this.tport = new JTextField(4);
            jPanel.add((Component)this.tport, gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            final String string3 = tcpmon.getMessage("proxy00", "Proxy");
            this.proxyButton = new JRadioButton(string3);
            jPanel.add((Component)this.proxyButton, gridBagConstraints);
            buttonGroup.add(this.proxyButton);
            this.proxyButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (string3.equals(actionEvent.getActionCommand())) {
                        boolean bl = AdminPage.this.proxyButton.isSelected();
                        AdminPage.this.tport.setEnabled(!bl);
                        AdminPage.this.host.setEnabled(!bl);
                        AdminPage.this.hostLabel.setForeground(bl ? Color.gray : Color.black);
                        AdminPage.this.tportLabel.setForeground(bl ? Color.gray : Color.black);
                    }
                }
            });
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            jPanel.add(Box.createRigidArea(new Dimension(1, 10)), gridBagConstraints);
            JPanel jPanel3 = new JPanel(new GridBagLayout());
            jPanel3.setBorder(new TitledBorder(tcpmon.getMessage("options00", "Options")));
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            jPanel.add((Component)jPanel3, gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            final String string4 = tcpmon.getMessage("proxySupport00", "HTTP Proxy Support");
            this.HTTPProxyBox = new JCheckBox(string4);
            jPanel3.add((Component)this.HTTPProxyBox, gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 1;
            this.HTTPProxyHostLabel = new JLabel(tcpmon.getMessage("hostname00", "Hostname") + " ");
            jPanel3.add((Component)this.HTTPProxyHostLabel, gridBagConstraints);
            this.HTTPProxyHostLabel.setForeground(Color.gray);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            this.HTTPProxyHost = new JTextField(30);
            jPanel3.add((Component)this.HTTPProxyHost, gridBagConstraints);
            this.HTTPProxyHost.setEnabled(false);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 1;
            this.HTTPProxyPortLabel = new JLabel(tcpmon.getMessage("port00", "Port #") + " ");
            jPanel3.add((Component)this.HTTPProxyPortLabel, gridBagConstraints);
            this.HTTPProxyPortLabel.setForeground(Color.gray);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            this.HTTPProxyPort = new JTextField(4);
            jPanel3.add((Component)this.HTTPProxyPort, gridBagConstraints);
            this.HTTPProxyPort.setEnabled(false);
            this.HTTPProxyBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (string4.equals(actionEvent.getActionCommand())) {
                        boolean bl = AdminPage.this.HTTPProxyBox.isSelected();
                        Color color = bl ? Color.black : Color.gray;
                        AdminPage.this.HTTPProxyHost.setEnabled(bl);
                        AdminPage.this.HTTPProxyPort.setEnabled(bl);
                        AdminPage.this.HTTPProxyHostLabel.setForeground(color);
                        AdminPage.this.HTTPProxyPortLabel.setForeground(color);
                    }
                }
            });
            String string5 = System.getProperty("http.proxyHost");
            if (string5 != null && string5.equals("")) {
                string5 = null;
            }
            this.HTTPProxyBox.setSelected(string5 != null);
            this.HTTPProxyHost.setEnabled(string5 != null);
            this.HTTPProxyPort.setEnabled(string5 != null);
            this.HTTPProxyHostLabel.setForeground(string5 != null ? Color.black : Color.gray);
            this.HTTPProxyPortLabel.setForeground(string5 != null ? Color.black : Color.gray);
            if (string5 != null) {
                this.HTTPProxyBox.setSelected(true);
                this.HTTPProxyHost.setText(string5);
                string5 = System.getProperty("http.proxyPort");
                if (string5 != null && string5.equals("")) {
                    string5 = null;
                }
                if (string5 == null) {
                    string5 = "80";
                }
                this.HTTPProxyPort.setText(string5);
            }
            jPanel.add(Box.createRigidArea(new Dimension(1, 10)), gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            final String string6 = tcpmon.getMessage("add00", "Add");
            jButton = new JButton(string6);
            jPanel.add((Component)jButton, gridBagConstraints);
            this.add((Component)new JScrollPane(jPanel), "Center");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (string6.equals(actionEvent.getActionCommand())) {
                        Listener listener = null;
                        int n = Integer.parseInt(AdminPage.this.port.getText());
                        String string = AdminPage.this.host.getText();
                        int n2 = 0;
                        String string2 = AdminPage.this.tport.getText();
                        if (string2 != null && !string2.equals("")) {
                            n2 = Integer.parseInt(string2);
                        }
                        listener = new Listener(AdminPage.this.noteb, null, n, string, n2, AdminPage.this.proxyButton.isSelected());
                        string2 = AdminPage.this.HTTPProxyHost.getText();
                        if ("".equals(string2)) {
                            string2 = null;
                        }
                        listener.HTTPProxyHost = string2;
                        string2 = AdminPage.this.HTTPProxyPort.getText();
                        if ("".equals(string2)) {
                            string2 = null;
                        }
                        if (string2 != null) {
                            listener.HTTPProxyPort = Integer.parseInt(string2);
                        }
                        AdminPage.this.port.setText(null);
                        AdminPage.this.host.setText(null);
                        AdminPage.this.tport.setText(null);
                    }
                }
            });
            jTabbedPane.addTab(string, this);
            jTabbedPane.repaint();
            jTabbedPane.setSelectedIndex(jTabbedPane.getTabCount() - 1);
        }
    }
}

