/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap;

import com.ibm.websphere.webservices.soap.IBMSOAPFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.client.ClientEngine;
import com.ibm.ws.webservices.engine.client.ClientEngineFactory;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configuration.NullEngineConfigurationProvider;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.DeserializationContextImpl;
import com.ibm.ws.webservices.engine.enumtype.MessageType;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.xmlsoap.Detail;
import com.ibm.ws.webservices.engine.xmlsoap.DetailEntry;
import com.ibm.ws.webservices.engine.xmlsoap.Name;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBodyElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPDocument;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFault;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeader;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeaderElement;
import com.ibm.ws.webservices.engine.xmlsoap.ext.ElementAlternateContent;
import com.ibm.ws.webservices.engine.xmlsoap.ext.XMLInputSourceAlternateContent;
import com.ibm.ws.webservices.engine.xmlsoap.ext.XMLStringAlternateContent;
import java.io.InputStream;
import java.io.Serializable;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class SOAPFactory
extends IBMSOAPFactory
implements Serializable {
    protected static Log log = LogFactory.getLog(SOAPFactory.class.getName());
    protected SOAPEnvelope envelope;
    protected SOAPConstants soapConstants;
    protected MessageType messageType;
    protected boolean protectState;
    protected boolean protectionViolation = false;
    private transient DeserializationContext context = null;
    private transient MessageContext msgContext = null;
    private SOAPDocument ownerDocument = new SOAPDocument();
    private static EngineConfiguration nullEngineConfig = null;

    public SOAPFactory(SOAPConstants sOAPConstants) {
        this.soapConstants = sOAPConstants;
    }

    public SOAPFactory() {
        this.soapConstants = SOAPConstants.SOAP11_CONSTANTS;
    }

    public SOAPConstants getSOAPConstants() {
        return this.soapConstants;
    }

    public void setSOAPConstants(SOAPConstants sOAPConstants) {
        this.soapConstants = sOAPConstants;
    }

    public SOAPDocument getOwnerDocument() {
        return this.ownerDocument;
    }

    public javax.xml.soap.SOAPElement createElement(javax.xml.soap.Name name2) throws SOAPException {
        return this.createElement(name2.getLocalName(), name2.getPrefix(), name2.getURI());
    }

    public javax.xml.soap.SOAPElement createElement(String string) throws SOAPException {
        return this.createElement(string, "", "");
    }

    public javax.xml.soap.SOAPElement createElement(String string, String string2, String string3) throws SOAPException {
        SOAPElement sOAPElement = this.createSOAPElement(string3, string);
        sOAPElement.setPrefix(string2);
        return sOAPElement;
    }

    public javax.xml.soap.SOAPElement createElementFromXMLString(String string) throws SOAPException {
        SOAPElement sOAPElement = this.createSOAPElement("", "elem");
        sOAPElement.setAlternateContent(XMLStringAlternateContent.create(string));
        return sOAPElement;
    }

    public javax.xml.soap.SOAPElement createElementFromXMLString(String string, Class clazz) throws SOAPException {
        SOAPElement sOAPElement = (SOAPElement)this.createElement("", "elem", clazz);
        if (sOAPElement != null) {
            sOAPElement.removeContents();
            sOAPElement.setAlternateContent(XMLStringAlternateContent.create(string));
        }
        return sOAPElement;
    }

    public javax.xml.soap.SOAPElement createElementFromInputSource(InputSource inputSource) throws SOAPException {
        SOAPElement sOAPElement = this.createSOAPElement("", "elem");
        sOAPElement.setAlternateContent(XMLInputSourceAlternateContent.create(inputSource));
        return sOAPElement;
    }

    public javax.xml.soap.SOAPElement createElementFromInputSource(InputSource inputSource, Class clazz) throws SOAPException {
        SOAPElement sOAPElement = (SOAPElement)this.createElement("", "elem", clazz);
        if (sOAPElement != null) {
            sOAPElement.removeContents();
            sOAPElement.setAlternateContent(XMLInputSourceAlternateContent.create(inputSource));
        }
        return sOAPElement;
    }

    public javax.xml.soap.SOAPElement createElementFromDOMElement(Element element, Class clazz) throws SOAPException {
        String string;
        String string2 = element.getNamespaceURI();
        SOAPElement sOAPElement = (SOAPElement)this.createElement(string2, string = (string = element.getLocalName()) == null || string.length() == 0 ? element.getNodeName() : string, clazz);
        if (sOAPElement != null) {
            sOAPElement.removeContents();
            sOAPElement.setPrefix(element.getPrefix());
            sOAPElement.setAlternateContent(ElementAlternateContent.create(element));
        }
        return sOAPElement;
    }

    javax.xml.soap.SOAPElement createElement(String string, String string2, Class clazz) throws SOAPException {
        if (clazz.equals(javax.xml.soap.SOAPEnvelope.class) || clazz.equals(SOAPEnvelope.class)) {
            if (this.envelope != null) {
                throw new SOAPException(Messages.getMessage("oneEnvelopePerFactory00"));
            }
            this.envelope = new SOAPEnvelope(false, this);
            return this.envelope;
        }
        if (clazz.equals(javax.xml.soap.SOAPBody.class) || clazz.equals(SOAPBody.class)) {
            return new SOAPBody(this);
        }
        if (clazz.equals(javax.xml.soap.SOAPHeader.class) || clazz.equals(SOAPHeader.class)) {
            return new SOAPHeader(this);
        }
        if (clazz.equals(javax.xml.soap.SOAPFault.class) || clazz.equals(SOAPFault.class)) {
            return new SOAPFault(this);
        }
        if (clazz.equals(javax.xml.soap.Detail.class) || clazz.equals(Detail.class)) {
            return new Detail(this);
        }
        if (clazz.equals(javax.xml.soap.SOAPBodyElement.class) || clazz.equals(SOAPBodyElement.class)) {
            return new SOAPBodyElement(string, string2, this);
        }
        if (clazz.equals(javax.xml.soap.SOAPHeaderElement.class) || clazz.equals(SOAPHeaderElement.class)) {
            return new SOAPHeaderElement(string, string2, this);
        }
        if (clazz.equals(javax.xml.soap.DetailEntry.class) || clazz.equals(DetailEntry.class)) {
            return new DetailEntry(string, string2, this);
        }
        if (clazz.equals(javax.xml.soap.SOAPElement.class) || clazz.equals(SOAPElement.class)) {
            return new SOAPElement(string, string2, this);
        }
        return null;
    }

    public javax.xml.soap.Detail createDetail() throws SOAPException {
        return new Detail(this);
    }

    public javax.xml.soap.Name createName(String string, String string2, String string3) throws SOAPException {
        return new Name(string3, string, string2);
    }

    public javax.xml.soap.Name createName(String string) throws SOAPException {
        return new Name("", string, "");
    }

    public SOAPEnvelope createSOAPEnvelope() throws SOAPException {
        return this.createSOAPEnvelope(false);
    }

    public SOAPEnvelope createSOAPEnvelope(boolean bl) throws SOAPException {
        if (this.envelope != null) {
            throw new SOAPException(Messages.getMessage("oneEnvelopePerFactory00"));
        }
        this.envelope = new SOAPEnvelope(bl, this);
        return this.envelope;
    }

    public SOAPEnvelope createSOAPEnvelope(InputStream inputStream) throws SOAPException {
        if (this.envelope != null) {
            throw new SOAPException(Messages.getMessage("oneEnvelopePerFactory00"));
        }
        this.envelope = new SOAPEnvelope(false, this);
        InputSource inputSource = new InputSource(inputStream);
        ClientEngine clientEngine = ClientEngineFactory.getEngine(SOAPFactory.getNullEngineConfig());
        MessageContext messageContext = new MessageContext(clientEngine);
        this.setMessageContext(messageContext);
        DeserializationContextImpl deserializationContextImpl = new DeserializationContextImpl(inputSource, messageContext, MessageType.REQUEST, this.envelope);
        try {
            deserializationContextImpl.parse();
        }
        catch (SAXException sAXException) {
            FFDCFilter.processException((Throwable)sAXException, "com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory.createSOAPEnvelope", "214", this);
            throw new SOAPException(Messages.getMessage("parseError00", sAXException.toString()));
        }
        return this.envelope;
    }

    SOAPEnvelope getSOAPEnvelope() {
        return this.envelope;
    }

    public SOAPElement createSOAPElement(String string, String string2) throws SOAPException {
        SOAPElement sOAPElement = string == null || string.length() == 0 ? new SOAPElement(null, string2, this) : new SOAPElement(string, string2, this);
        return sOAPElement;
    }

    public SOAPElement createSOAPElement(String string, String string2, String string3, Attributes attributes2, MappingScope mappingScope, DeserializationContext deserializationContext, SOAPElement sOAPElement) throws SOAPException {
        string = string == null ? "" : string;
        SOAPElement sOAPElement2 = this.createSOAPElement(string, string2);
        this.elementInit(sOAPElement2, string3, attributes2, mappingScope, deserializationContext, sOAPElement);
        return sOAPElement2;
    }

    public SOAPBody createSOAPBody(String string, Attributes attributes2, MappingScope mappingScope, DeserializationContext deserializationContext, SOAPEnvelope sOAPEnvelope) throws SOAPException {
        SOAPBody sOAPBody = new SOAPBody(this);
        this.elementInit(sOAPBody, string, attributes2, mappingScope, deserializationContext, sOAPEnvelope);
        return sOAPBody;
    }

    public SOAPBodyElement createSOAPBodyElement(String string, String string2) throws SOAPException {
        return new SOAPBodyElement(string, string2, this);
    }

    public SOAPBodyElement createSOAPBodyElement(String string, String string2, String string3, Attributes attributes2, MappingScope mappingScope, DeserializationContext deserializationContext, SOAPBody sOAPBody) throws SOAPException {
        string = string == null ? "" : string;
        SOAPBodyElement sOAPBodyElement = new SOAPBodyElement(string, string2, this);
        this.elementInit(sOAPBodyElement, string3, attributes2, mappingScope, deserializationContext, sOAPBody);
        return sOAPBodyElement;
    }

    public SOAPHeader createSOAPHeader(String string, Attributes attributes2, MappingScope mappingScope, DeserializationContext deserializationContext, SOAPEnvelope sOAPEnvelope) throws SOAPException {
        SOAPHeader sOAPHeader = new SOAPHeader(this);
        this.elementInit(sOAPHeader, string, attributes2, mappingScope, deserializationContext, sOAPEnvelope);
        return sOAPHeader;
    }

    public SOAPHeaderElement createSOAPHeaderElement(String string, String string2) throws SOAPException {
        return new SOAPHeaderElement(string, string2, this);
    }

    public SOAPHeaderElement createSOAPHeaderElement(String string, String string2, String string3, Attributes attributes2, MappingScope mappingScope, DeserializationContext deserializationContext, SOAPHeader sOAPHeader) throws SOAPException {
        string = string == null ? "" : string;
        SOAPHeaderElement sOAPHeaderElement = new SOAPHeaderElement(string, string2, this);
        this.elementInit(sOAPHeaderElement, string3, attributes2, mappingScope, deserializationContext, sOAPHeader);
        return sOAPHeaderElement;
    }

    public SOAPFault createSOAPFault() throws SOAPException {
        SOAPFault sOAPFault = new SOAPFault(this);
        if (this.envelope != null) {
            sOAPFault.setPrefix(this.envelope.getPrefix());
        } else {
            sOAPFault.setPrefix("soapenv");
        }
        return sOAPFault;
    }

    public SOAPFault createSOAPFault(String string, Attributes attributes2, MappingScope mappingScope, DeserializationContext deserializationContext, SOAPBody sOAPBody) throws SOAPException {
        SOAPFault sOAPFault = new SOAPFault(this);
        this.elementInit(sOAPFault, string, attributes2, mappingScope, deserializationContext, sOAPBody);
        return sOAPFault;
    }

    public DetailEntry createDetailEntry(String string, String string2) throws SOAPException {
        return new DetailEntry(string, string2, this);
    }

    public DetailEntry createDetailEntry(String string, String string2, String string3, Attributes attributes2, MappingScope mappingScope, DeserializationContext deserializationContext, SOAPElement sOAPElement) throws SOAPException {
        string = string == null ? "" : string;
        DetailEntry detailEntry = new DetailEntry(string, string2, this);
        this.elementInit(detailEntry, string3, attributes2, mappingScope, deserializationContext, sOAPElement);
        return detailEntry;
    }

    public Detail createDetail(Attributes attributes2, MappingScope mappingScope, DeserializationContext deserializationContext, SOAPElement sOAPElement) throws SOAPException {
        Detail detail = new Detail(this);
        this.elementInit(detail, "", attributes2, mappingScope, deserializationContext, sOAPElement);
        return detail;
    }

    private void elementInit(SOAPElement sOAPElement, String string, Attributes attributes2, MappingScope mappingScope, DeserializationContext deserializationContext, SOAPElement sOAPElement2) throws SOAPException {
        sOAPElement.setMappingScope(mappingScope);
        String string2 = "";
        int n = string.indexOf(58);
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        sOAPElement.setPrefix(string2);
        if (sOAPElement2 != null) {
            sOAPElement.setParentElement(sOAPElement2);
        }
        if (attributes2 != null && attributes2.getLength() > 0) {
            sOAPElement.setAttributes(attributes2);
        }
        this.context = deserializationContext;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public boolean getProtectState() {
        return this.protectState;
    }

    public void setProtectState(boolean bl) {
        this.protectState = bl;
    }

    void setProtectionViolation(boolean bl) {
        this.protectionViolation = bl;
    }

    public boolean getProtectionViolation() {
        return this.protectionViolation;
    }

    DeserializationContext getDeserializationContext() {
        if (this.context == null) {
            SOAPEnvelope sOAPEnvelope = this.envelope;
            if (sOAPEnvelope == null) {
                try {
                    sOAPEnvelope = new SOAPEnvelope(this);
                }
                catch (SOAPException sOAPException) {
                    FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory.getDeserializationContext", "593", this);
                    throw new InternalException((Exception)((Object)sOAPException));
                }
            }
            this.context = new DeserializationContextImpl(null, this.getMessageContext(), this.getMessageType(), sOAPEnvelope);
        }
        return this.context;
    }

    public void setMessageContext(MessageContext messageContext) {
        this.msgContext = messageContext;
    }

    public MessageContext getMessageContext() {
        if (this.msgContext == null) {
            if (this.context != null) {
                this.setMessageContext(this.context.getMessageContext());
            } else {
                this.setMessageContext(MessageContext.getCurrentThreadsContext());
            }
        }
        return this.msgContext;
    }

    private static EngineConfiguration getNullEngineConfig() {
        if (nullEngineConfig == null) {
            nullEngineConfig = new NullEngineConfigurationProvider();
        }
        return nullEngineConfig;
    }
}

