/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap;

import com.ibm.websphere.webservices.soap.IBMAttr;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.utils.Mapping;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.dom.DOM3AttrDelta;
import com.ibm.ws.webservices.engine.xmlsoap.dom.DOMAttr;
import com.ibm.ws.webservices.engine.xmlsoap.dom.impl.DOMAttrImpl;
import com.ibm.ws.webservices.engine.xmlsoap.dom.impl.DOMAttrNSImpl;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Utils {
    private static Log log = LogFactory.getLog(Utils.class.getName());
    private static final String XMLNS = "xmlns";
    private static final String XMLNS_COLON = "xmlns:";
    private static final String EMPTY_STRING = "";

    static void addImplicitNamespaceDeclarations(SOAPElement sOAPElement) {
        SOAPElement sOAPElement2;
        Node node = sOAPElement.getParentNode();
        if (node instanceof SOAPElement && (sOAPElement2 = (SOAPElement)((Object)node)).getParentNode() == null && sOAPElement == sOAPElement2.getFirstChild() && sOAPElement == sOAPElement2.getLastChild()) {
            Utils._addImplicitNamespaces(sOAPElement2);
            Utils._addImplicitNamespacesForAttrs(sOAPElement2);
        }
        Utils._addImplicitNamespaces(sOAPElement);
        Utils._addImplicitNamespacesForAttrs(sOAPElement);
    }

    private static void _addImplicitNamespaces(SOAPElement sOAPElement) {
        String string;
        String string2;
        MappingScope mappingScope = sOAPElement._getMappingScope();
        boolean bl = Utils.needsNamespaceDeclaration(mappingScope, string2 = sOAPElement.getNamespaceURI(), string = sOAPElement.getPrefix(), false);
        if (bl) {
            if (log.isDebugEnabled()) {
                log.debug("adding implicit xmlns declaration for prefix = {" + string + "} and " + "namespace = {" + string2 + "}");
            }
            Utils.addXMLNSAttribute((Element)((Object)sOAPElement), string, string2);
        }
    }

    private static void _addImplicitNamespacesForAttrs(SOAPElement sOAPElement) {
        MappingScope mappingScope = sOAPElement._getMappingScope();
        NamedNodeMap namedNodeMap = sOAPElement.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            int n;
            Attr attr = (Attr)namedNodeMap.item(i);
            String string = attr.getNamespaceURI();
            if ("http://www.w3.org/2000/xmlns/" == string || "http://www.w3.org/2000/xmlns/".equals(string)) continue;
            String string2 = attr.getPrefix();
            if (string2 == null || string2.length() == 0) {
                n = attr.getName().indexOf(58);
                if (n >= 0) {
                    string2 = attr.getName().substring(0, n);
                }
                if (string2 == null) {
                    string2 = EMPTY_STRING;
                }
            }
            if ((n = (int)(Utils.needsNamespaceDeclaration(mappingScope, string, string2, true) ? 1 : 0)) == 0) continue;
            if (log.isDebugEnabled()) {
                log.debug("adding implicit xmlns declaration for prefix = {" + string2 + "} and " + "namespace = {" + string + "} due to attr reference");
            }
            Utils.addXMLNSAttribute((Element)((Object)sOAPElement), string2, string);
        }
    }

    private static boolean needsNamespaceDeclaration(MappingScope mappingScope, String string, String string2, boolean bl) {
        Mapping mapping;
        Mapping mapping2;
        Mapping mapping3;
        boolean bl2 = false;
        bl2 = string == null || string.length() == 0 ? (bl ? false : (mapping3 = mappingScope.getMappingForPrefix(EMPTY_STRING, false)) != null && (mapping3.getPrefix().length() != 0 || mapping3.getNamespaceURI().length() != 0)) : (string2 == null || string2.length() == 0 ? (mapping2 = mappingScope.getMappingForPrefix(EMPTY_STRING, false)) == null || mapping2.getPrefix().length() != 0 || mapping2.getNamespaceURI() != string && !mapping2.getNamespaceURI().equals(string) : (mapping = mappingScope.getMappingForPrefix(string2, false)) == null || !mapping.getPrefix().equals(string2) || mapping.getNamespaceURI() != string && !mapping.getNamespaceURI().equals(string));
        return bl2;
    }

    static void addXMLNSAttribute(Element element, String string, String string2) {
        String string3 = XMLNS;
        if (string != null && string.length() != 0) {
            string3 = string3 + ":" + string;
        }
        if (string2 == null) {
            string2 = EMPTY_STRING;
        }
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", string3, string2);
    }

    static boolean removeXMLNSAttribute(Element element, String string) {
        boolean bl;
        String string2 = XMLNS;
        if (string != null && string.length() > 0) {
            string2 = string2 + ":" + string;
        }
        if (bl = element.hasAttribute(string2)) {
            element.removeAttribute(string2);
        }
        return bl;
    }

    public static DOMAttr create(Attr attr, Document document) {
        if (!(attr instanceof DOMAttr)) {
            DOM3AttrDelta dOM3AttrDelta = null;
            dOM3AttrDelta = attr.getNamespaceURI() == null ? DOMAttrImpl.create(attr, document) : DOMAttrNSImpl.create(attr, document);
            attr = dOM3AttrDelta;
        }
        return (DOMAttr)attr;
    }

    static List getNamespaceDeclarations(SOAPElement sOAPElement, boolean bl, boolean bl2, boolean bl3) {
        ArrayList arrayList = new ArrayList();
        if (bl) {
            Utils._getNamespaceDeclarationsAbove(sOAPElement, arrayList);
        }
        if (bl2) {
            Utils._getNamespaceDeclarationsOn(sOAPElement, arrayList);
        }
        if (bl3) {
            Utils._getNamespaceDeclarationsBelow(sOAPElement, arrayList);
        }
        return arrayList;
    }

    private static void _getNamespaceDeclarationsAbove(SOAPElement sOAPElement, List list) {
        for (SOAPElement sOAPElement2 = (SOAPElement)sOAPElement.getParentElement(); sOAPElement2 != null; sOAPElement2 = (SOAPElement)sOAPElement2.getParentElement()) {
            MappingScope mappingScope = sOAPElement2._getMappingScope();
            if (mappingScope.size() <= 0) continue;
            NamedNodeMap namedNodeMap = sOAPElement2.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                IBMAttr iBMAttr = (IBMAttr)namedNodeMap.item(i);
                if (!iBMAttr.isNamespaceDeclaration()) continue;
                list.add(0, iBMAttr);
            }
        }
    }

    private static void _getNamespaceDeclarationsOn(SOAPElement sOAPElement, List list) {
        MappingScope mappingScope = sOAPElement._getMappingScope();
        if (mappingScope.size() > 0) {
            NamedNodeMap namedNodeMap = sOAPElement.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                IBMAttr iBMAttr = (IBMAttr)namedNodeMap.item(i);
                if (!iBMAttr.isNamespaceDeclaration()) continue;
                list.add(iBMAttr);
            }
        }
    }

    private static void _getNamespaceDeclarationsBelow(SOAPElement sOAPElement, List list) {
        for (Node node = sOAPElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof SOAPElement)) continue;
            Utils._getNamespaceDeclarationsOn((SOAPElement)((Object)node), list);
            Utils._getNamespaceDeclarationsBelow((SOAPElement)((Object)node), list);
        }
    }

    public static List getAttributes(SOAPElement sOAPElement, boolean bl, boolean bl2, boolean bl3) {
        ArrayList arrayList = new ArrayList();
        if (bl) {
            Utils._getAttributesAbove(sOAPElement, arrayList);
        }
        if (bl2) {
            Utils._getAttributesOn(sOAPElement, arrayList);
        }
        if (bl3) {
            Utils._getAttributesBelow(sOAPElement, arrayList);
        }
        return arrayList;
    }

    private static void _getAttributesAbove(SOAPElement sOAPElement, List list) {
        for (SOAPElement sOAPElement2 = (SOAPElement)sOAPElement.getParentElement(); sOAPElement2 != null; sOAPElement2 = (SOAPElement)sOAPElement2.getParentElement()) {
            NamedNodeMap namedNodeMap = sOAPElement2.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                IBMAttr iBMAttr = (IBMAttr)namedNodeMap.item(i);
                list.add(0, iBMAttr);
            }
        }
    }

    private static void _getAttributesOn(SOAPElement sOAPElement, List list) {
        NamedNodeMap namedNodeMap = sOAPElement.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            IBMAttr iBMAttr = (IBMAttr)namedNodeMap.item(i);
            list.add(iBMAttr);
        }
    }

    private static void _getAttributesBelow(SOAPElement sOAPElement, List list) {
        for (Node node = sOAPElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof SOAPElement)) continue;
            Utils._getAttributesOn((SOAPElement)((Object)node), list);
            Utils._getAttributesBelow((SOAPElement)((Object)node), list);
        }
    }
}

