/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap.ext;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.events.P2DConverter;
import com.ibm.ws.webservices.engine.events.PEventProcessor;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.Mapping;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.NullAttributes;
import com.ibm.ws.webservices.engine.xmlsoap.AlternateContentBase;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import org.apache.commons.logging.Log;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class ElementAlternateContent
extends AlternateContentBase {
    private static final String XMLNS = "xmlns";
    private static final String XMLNS_COLON = "xmlns:";
    private static int implicitNamespaceFix = 999;
    protected static Log log = LogFactory.getLog(ElementAlternateContent.class.getName());

    public static ElementAlternateContent create(Element element) {
        return new ElementAlternateContent(element, AlternateContentBase.CONTENT_PLUS_TAG);
    }

    ElementAlternateContent(Element element, short s) {
        super(element, s);
        if (implicitNamespaceFix > 1) {
            implicitNamespaceFix = 1;
            String string = "com.ibm.websphere.webservices.alternateContent.implicitNamespaces";
            String string2 = System.getProperty(string);
            boolean bl = JavaUtils.isTrue(string2, true);
            if (!bl) {
                implicitNamespaceFix = 0;
            }
            if (log.isDebugEnabled() && string2 != null && string2 != "") {
                String string3 = bl ? "enabled" : "disabled";
                log.debug(string + " is " + string3);
            }
        }
    }

    protected Element getDOMElement() {
        return (Element)this.content;
    }

    protected void serialize(SerializationContext serializationContext, boolean bl) throws Exception {
        MappingScope mappingScope = null;
        if (this.owner.getParentElement() != null) {
            mappingScope = this._getMappingScope((SOAPElement)this.owner.getParentElement()).flatten();
        }
        boolean bl2 = serializationContext.getSerializationWriter().getPretty();
        serializationContext.getSerializationWriter().setPretty(false);
        serializationContext.getSerializationWriter().writeDOMElement((Element)this.content, mappingScope, !bl);
        serializationContext.getSerializationWriter().setPretty(bl2);
    }

    public boolean hasToEvents() {
        return true;
    }

    public void toEvents(PEventProcessor pEventProcessor) throws SAXException {
        Object object;
        Object object2;
        String string;
        Object object3;
        MappingScope mappingScope = null;
        AttributesImpl attributesImpl = new AttributesImpl();
        if (this.owner.getParentElement() != null) {
            mappingScope = this._getMappingScope((SOAPElement)this.owner.getParentElement()).flatten();
        }
        MappingScope mappingScope2 = new MappingScope();
        mappingScope2.setParent(mappingScope);
        NamedNodeMap namedNodeMap = ((Element)this.content).getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            object3 = (Attr)namedNodeMap.item(i);
            string = object3.getNamespaceURI() == null ? "" : object3.getNamespaceURI();
            object2 = object3.getLocalName();
            String string2 = object3.getNodeName();
            object = object3.getNodeValue();
            if (string2.startsWith(XMLNS)) {
                if (XMLNS == string2 || XMLNS.equals(string2)) {
                    mappingScope2.addMapping((String)object, "");
                    continue;
                }
                if (!string2.startsWith(XMLNS_COLON)) continue;
                String string3 = string2.substring(6);
                mappingScope2.addMapping((String)object, string3);
                continue;
            }
            attributesImpl.addAttribute(string, (String)object2, string2, "CDATA", (String)object);
        }
        if (implicitNamespaceFix == 1) {
            Element element = (Element)this.content;
            object3 = element.getPrefix() == null ? "" : element.getPrefix();
            String string4 = string = element.getNamespaceURI() == null ? "" : element.getNamespaceURI();
            if (!("".equals(object3) && "".equals(string) || (object2 = mappingScope2.getMappingForPrefix((String)object3, false)) != null)) {
                if (log.isDebugEnabled()) {
                    log.debug("Adding mapping for Element: prefix = {" + (String)object3 + "} and namespace = {" + string + "}");
                }
                mappingScope2.addMapping(string, (String)object3);
            }
            for (int i = 0; i < attributesImpl.getLength(); ++i) {
                int n;
                object3 = null;
                string = attributesImpl.getURI(i);
                object2 = attributesImpl.getQName(i);
                int n2 = n = object2 == null ? -1 : ((String)object2).indexOf(58);
                if (n <= -1 || (object = mappingScope2.getMappingForPrefix((String)(object3 = ((String)object2).substring(0, n)), false)) != null) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Adding mapping for Attribute: prefix = {" + (String)object3 + "} and namespace = {" + string + "}");
                }
                mappingScope2.addMapping(string, (String)object3);
            }
        }
        this.toEvents(pEventProcessor, (Element)this.content, mappingScope2, attributesImpl, this.owner);
    }

    private void toEvents(PEventProcessor pEventProcessor, Element element, MappingScope mappingScope, Attributes attributes2, SOAPElement sOAPElement) throws SAXException {
        String string = element.getLocalName();
        if (string == null || string.length() == 0) {
            string = element.getNodeName();
        }
        String string2 = element.getPrefix();
        String string3 = string;
        if (string2 != null && string2.length() != 0) {
            string3 = string2 + ":" + string;
        }
        String string4 = element.getNamespaceURI() == null ? "" : element.getNamespaceURI();
        pEventProcessor.startElement(string4, string, string3, attributes2, mappingScope, sOAPElement);
        this.toContainedEvents(pEventProcessor, element, mappingScope);
        pEventProcessor.endElement(string4, string, string3);
    }

    private void toContainedEvents(PEventProcessor pEventProcessor, Element element, MappingScope mappingScope) throws SAXException {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Object object;
            if (node instanceof Element) {
                object = (Element)node;
                String string = object.getLocalName();
                if (string == null || string.length() == 0) {
                    string = object.getNodeName();
                }
                String string2 = object.getPrefix();
                String string3 = string;
                if (string2 != null && string2.length() != 0) {
                    string3 = string2 + ":" + string;
                }
                String string4 = object.getNamespaceURI() == null ? "" : object.getNamespaceURI();
                Attributes attributes2 = this.toPrefixEvents(pEventProcessor, (Element)object, mappingScope);
                pEventProcessor.startElement(string4, string, string3, attributes2);
                this.toContainedEvents(pEventProcessor, (Element)object, mappingScope);
                pEventProcessor.endElement(string4, string, string3);
                continue;
            }
            if (node instanceof Comment) {
                object = ((CharacterData)node).getData();
                if (object == null) continue;
                pEventProcessor.comment(((String)object).toCharArray(), 0, ((String)object).length());
                continue;
            }
            if (node instanceof Text) {
                object = ((Text)node).getData();
                if (object == null) continue;
                pEventProcessor.characters((String)object);
                continue;
            }
            if (!(node instanceof CDATASection) || (object = "<![CDATA[" + ((Text)node).getData() + "]]>") == null) continue;
            pEventProcessor.characters((String)object);
        }
    }

    private Attributes toPrefixEvents(PEventProcessor pEventProcessor, Element element, MappingScope mappingScope) throws SAXException {
        String string;
        String string2;
        String string3;
        int n;
        AttributesImpl attributesImpl = null;
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (n = 0; n < namedNodeMap.getLength(); ++n) {
            Node node;
            if (attributesImpl == null) {
                attributesImpl = new AttributesImpl();
            }
            string3 = (node = namedNodeMap.item(n)).getNamespaceURI() == null ? "" : node.getNamespaceURI();
            string2 = node.getLocalName();
            string = node.getNodeValue();
            String string4 = ((Attr)node).getName();
            if (XMLNS.equals(string4) || string4.startsWith(XMLNS_COLON)) {
                String string5 = "";
                if (string4.startsWith(XMLNS_COLON)) {
                    string5 = string4.substring(string4.indexOf(":") + 1);
                }
                pEventProcessor.startPrefixMapping(string5, string);
                continue;
            }
            attributesImpl.addAttribute(string3, string2, string4, "CDATA", string);
        }
        if (attributesImpl != null && implicitNamespaceFix == 1) {
            n = attributesImpl.getLength();
            for (int i = 0; i < n; ++i) {
                Object object;
                int n2;
                string3 = null;
                string2 = attributesImpl.getURI(i);
                string = attributesImpl.getQName(i);
                int n3 = n2 = string == null ? -1 : string.indexOf(58);
                if (n2 <= -1) continue;
                boolean bl = true;
                string3 = string.substring(0, n2);
                Mapping mapping = mappingScope.getMappingForPrefix(string3, false);
                if (mapping != null) {
                    object = mapping.getNamespaceURI();
                    boolean bl2 = object == null ? true : (bl = !((String)object).equals(string2));
                }
                if (!bl || !(pEventProcessor instanceof P2DConverter)) continue;
                object = (P2DConverter)pEventProcessor;
                ((P2DConverter)object).startPrefixMappingNS(string3, string2);
            }
        }
        if (attributesImpl != null) {
            return attributesImpl;
        }
        return NullAttributes.singleton;
    }
}

