/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.WebServicesException;
import com.ibm.ws.webservices.metadata.ClientEntityMetaData;
import com.ibm.wsspi.webservices.models.WSModels;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.webservice.wsclient.ComponentScopedRefs;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.jst.j2ee.webservice.wsclient.WebServicesClient;

public class ClientModuleMetaData {
    private static final TraceComponent _tc = Tr.register(ClientModuleMetaData.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.webservices.resources.webservicesMessages");
    private static final String MODULE_REF = null;
    private Map clientMetaDatas = new HashMap();
    private LoadStrategy loadStrategy = null;
    private ClassLoader classLoader = null;
    private boolean boundAndExtended = false;
    private static final String SERVICE_AND_PORTNAME_SEPARATOR = "/";

    public void destroy() {
        if (this.clientMetaDatas != null) {
            Iterator iterator = this.clientMetaDatas.values().iterator();
            while (iterator.hasNext()) {
                ClientEntityMetaData clientEntityMetaData = (ClientEntityMetaData)iterator.next();
                if (clientEntityMetaData == null) continue;
                clientEntityMetaData.destroy();
            }
            this.clientMetaDatas.clear();
            this.clientMetaDatas = null;
        }
        this.loadStrategy = null;
        this.classLoader = null;
    }

    protected LoadStrategy getLoadStrategy() {
        return this.loadStrategy;
    }

    public void setLoadStrategy(LoadStrategy loadStrategy) {
        this.loadStrategy = loadStrategy;
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClientEntityMetaData createComponentScopedMetaData(String string) {
        ClientEntityMetaData clientEntityMetaData = (ClientEntityMetaData)this.clientMetaDatas.get(string);
        if (clientEntityMetaData == null) {
            clientEntityMetaData = new ClientEntityMetaData(string, this);
            this.clientMetaDatas.put(string, clientEntityMetaData);
        }
        return clientEntityMetaData;
    }

    public ClientEntityMetaData createModuleScopedMetaData() {
        ClientEntityMetaData clientEntityMetaData = (ClientEntityMetaData)this.clientMetaDatas.get(MODULE_REF);
        if (clientEntityMetaData == null) {
            clientEntityMetaData = new ClientEntityMetaData(MODULE_REF, this);
            this.clientMetaDatas.put(MODULE_REF, clientEntityMetaData);
        }
        return clientEntityMetaData;
    }

    public ClientEntityMetaData getComponentScopedMetaData(String string) {
        return (ClientEntityMetaData)this.clientMetaDatas.get(string);
    }

    public ClientEntityMetaData getModuleScopedMetaData() {
        return this.getComponentScopedMetaData(MODULE_REF);
    }

    public Iterator getMetaData() {
        return this.clientMetaDatas.values().iterator();
    }

    public void bindServiceRefs(String string, List list) throws RuntimeError {
        if (list != null && list.size() > 0) {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "bindServiceRefs(componentName=" + string + ")");
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Binding " + list.size() + " service-refs to " + (string == null ? "module" : "component " + string));
            }
            ClientEntityMetaData clientEntityMetaData = this.createComponentScopedMetaData(string);
            for (int i = 0; i < list.size(); ++i) {
                ServiceRef serviceRef = (ServiceRef)list.get(i);
                clientEntityMetaData.newService(serviceRef);
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "bindServiceRefs");
            }
        }
    }

    public void bindServiceRefs(String string, Context context) throws RuntimeError {
        ClientEntityMetaData clientEntityMetaData = this.getComponentScopedMetaData(string);
        if (clientEntityMetaData != null) {
            clientEntityMetaData.bindServiceRefs(context);
        }
    }

    public void bindBindingsAndExtensions(String string, String string2, String string3) throws RuntimeError {
        ClientEntityMetaData clientEntityMetaData = this.getComponentScopedMetaData(string);
        if (clientEntityMetaData != null) {
            clientEntityMetaData.bindBindingsAndExtensions(string2, string3);
            clientEntityMetaData.loadNow();
        }
    }

    public boolean hasBinding(String string) {
        return this.getComponentScopedMetaData(string) != null;
    }

    public WebServicesClient getJ2EEWebServicesClient(String string) throws RuntimeError {
        WebServicesClient webServicesClient = null;
        if (this.loadStrategy.getContainer().containsFile(string)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Processing J2EE 1.3 Web Services Client XML file: " + string);
            }
            try {
                webServicesClient = WSModels.getWebServicesClient(this.loadStrategy, string);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.client.ClientModuleMetaData.getJ2EEWebServicesClient", "211", this);
                throw new RuntimeError(exception);
            }
        }
        return webServicesClient;
    }

    public boolean bindJ2EE13ComponentServiceRefs(String string, String string2, WebServicesClient webServicesClient) throws RuntimeError, WebServicesException {
        boolean bl = false;
        if (webServicesClient != null) {
            int n = webServicesClient.getComponentScopedRefs().size();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "ComponentScopedRefs count is " + n);
            }
            if (n != 0) {
                for (int i = 0; i < n; ++i) {
                    ComponentScopedRefs componentScopedRefs = (ComponentScopedRefs)webServicesClient.getComponentScopedRefs().get(i);
                    if (!string.equals(componentScopedRefs.getComponentName())) continue;
                    this.bindServiceRefs(string, (List)componentScopedRefs.getServiceRefs());
                    bl = true;
                }
            } else {
                String string3 = "j2ee13.webservicesclient.missing.component.scoped.ref";
                Object[] objectArray = new Object[]{string2};
                Tr.error(_tc, string3, objectArray);
                throw new RuntimeError(nls.getFormattedMessage(string3, objectArray, null));
            }
        }
        return bl;
    }

    public boolean bindJ2EE13ModuleServiceRefs(String string, WebServicesClient webServicesClient) throws RuntimeError, WebServicesException {
        if (webServicesClient != null) {
            int n = webServicesClient.getComponentScopedRefs().size();
            if (n == 0) {
                this.bindServiceRefs(null, (List)webServicesClient.getServiceRefs());
                return true;
            }
            String string2 = "j2ee13.webservicesclient.unexpected.component.scoped.ref";
            Object[] objectArray = new Object[]{string};
            Tr.error(_tc, string2, objectArray);
            throw new RuntimeError(nls.getFormattedMessage(string2, objectArray, null));
        }
        return false;
    }

    public static String clientConfigurationPortName(String string, String string2) {
        String string3 = null;
        if (string != null && string2 != null) {
            string3 = string + SERVICE_AND_PORTNAME_SEPARATOR + string2;
        } else if (string != null) {
            string3 = string;
        } else if (string2 != null) {
            string3 = string2;
        } else {
            Tr.error(_tc, "internal.error", "Port name and service ref name are both null");
        }
        return string3;
    }

    public static String unravelPortName(String string) {
        if (string != null) {
            int n = string.lastIndexOf(SERVICE_AND_PORTNAME_SEPARATOR);
            if (n >= 0) {
                return string.substring(n + 1);
            }
            return string;
        }
        return null;
    }

    public static String unravelServiceRefName(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(SERVICE_AND_PORTNAME_SEPARATOR)) >= 0) {
            return string.substring(0, n);
        }
        return null;
    }
}

