/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.base;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDJAXRPCHandlerInfo;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDJAXRPCHandlerInfoChain;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDPort;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.ExtendedHandlerInfo;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.metadata.ClientPortMetaData;
import com.ibm.ws.webservices.metadata.ClientServiceMetaData;
import com.ibm.ws.webservices.multiprotocol.InvocationContext;
import com.ibm.ws.webservices.multiprotocol.ServiceContext;
import com.ibm.ws.webservices.multiprotocol.base.DefaultCall;
import com.ibm.ws.webservices.multiprotocol.handlers.AgnosticHandlerRegistry;
import com.ibm.ws.webservices.multiprotocol.models.ModelService;
import com.ibm.ws.webservices.multiprotocol.provider.Transport;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.handler.HandlerRegistry;

public class DefaultService
extends ModelService {
    AgnosticHandlerRegistry handlerRegistry;

    public DefaultService(ServiceContext serviceContext, Transport transport2) {
        super(serviceContext);
        this.transport = transport2;
    }

    protected Transport makeTransport() {
        return this.transport;
    }

    protected Call doCreateCall(String string, QName qName, String string2, InvocationContext invocationContext) throws ServiceException {
        InvocationContext invocationContext2 = null;
        invocationContext2 = invocationContext != null ? invocationContext : new InvocationContext(this.context);
        invocationContext2.setPortName(string);
        DefaultCall defaultCall = new DefaultCall(invocationContext2, this.transport, qName, string2);
        return defaultCall;
    }

    public HandlerRegistry getHandlerRegistry() {
        if (this.handlerRegistry == null) {
            this.handlerRegistry = new AgnosticHandlerRegistry();
            if (this.context.isManagedEnvironment()) {
                this.initHandlerRegistry(this.handlerRegistry);
            }
        }
        return this.handlerRegistry;
    }

    protected void initHandlerRegistry(HandlerRegistry handlerRegistry) {
        String string = this.context.getServiceRefName();
        ClientServiceMetaData clientServiceMetaData = this.context.getClientServiceMetaData();
        Collection collection = null;
        if (clientServiceMetaData != null) {
            collection = clientServiceMetaData.getPorts();
        }
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                QName qName;
                boolean bl;
                List list;
                ClientPortMetaData clientPortMetaData = (ClientPortMetaData)iterator.next();
                WSDDPort wSDDPort = clientPortMetaData.getWsddPort();
                WSDDJAXRPCHandlerInfoChain wSDDJAXRPCHandlerInfoChain = wSDDPort.getHandlerInfoChain();
                if (wSDDJAXRPCHandlerInfoChain == null || (list = wSDDJAXRPCHandlerInfoChain.getHandlerInfoList()) == null || list.size() <= 0 || !(bl = !this.context.isProtocolOverridden(qName = this.makePortQName(string, wSDDPort)) || this.context.isNonBoundWSDL())) continue;
                this.addHandlerInfos(handlerRegistry, list, qName);
            }
        }
    }

    protected void addHandlerInfos(HandlerRegistry handlerRegistry, List list, QName qName) {
        List list2 = handlerRegistry.getHandlerChain(qName);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ExtendedHandlerInfo extendedHandlerInfo;
            WSDDJAXRPCHandlerInfo wSDDJAXRPCHandlerInfo = (WSDDJAXRPCHandlerInfo)iterator.next();
            try {
                extendedHandlerInfo = wSDDJAXRPCHandlerInfo.getHandlerInfo();
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ws.webservices.multiprotocol.base.DefaultService.addHandlerInfos", "159", this);
                throw new JAXRPCException("exception getting HandlerInfo: " + classNotFoundException, (Throwable)classNotFoundException);
            }
            list2.add(extendedHandlerInfo);
        }
        handlerRegistry.setHandlerChain(qName, list2);
    }

    protected QName makePortQName(String string, WSDDPort wSDDPort) {
        QName qName = wSDDPort.getQName();
        String string2 = qName.getLocalPart().substring(string.length() + 1);
        QName qName2 = QNameTable.createQName(this.context.getServiceNamespace(), string2);
        return qName2;
    }
}

